package org.tip.puck.spacetime;

import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainFinder;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.partitions.Partition;
import org.tip.puck.util.NumberablesHashMap;

/**
 * 
 * @author Klaus Hamberger
 *
 */
public class Sequences extends NumberablesHashMap<Sequence> {
	
	String label;
	
	public Sequences(){
	}
	
/*	public Sequences (Segmentation segmentation, SpaceTimeCriteria criteria){
		
		label = criteria.getSequencesLabel();
		
		Relations relations = segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName());
		
		for (Relation relation : relations){
			
			Sequence sequence = null;
			
			String sequenceId = relation.getAttributeValue(label);
			
			if (StringUtils.isNumeric(sequenceId)){
				sequence = getById(Integer.parseInt(sequenceId));
				if (sequence == null){
					sequence = new Sequence(Integer.parseInt(sequenceId));
					sequence.setDateLabel(criteria.getDateLabel());
					put(sequence);
				}
			}
			
			sequence.putInOrder(relation);
		}
		
	}*/
	
	public String getLabel() {
		return label;
	}

	public Sequence getByEgo(Individual ego){
		Sequence result;
		
		result = null;
		
		for (Sequence sequence : this){
			if (sequence.getEgo()==ego){
				result = sequence;
				break;
			}
		}
		//
		return result;
	}
	
	public Individuals egos(){
		Individuals result;
		
		result = new Individuals();
		
		for (Sequence sequence : this){
			result.put(sequence.getEgo());
		}
		//
		return result;
	}
	
	public Sequence getByEgoId(int egoId){
		Sequence result;
		
		result = null;
		
		for (Sequence sequence : this){
			if (sequence.getEgo()!=null && sequence.getEgo().getId()==egoId){
				result = sequence;
				break;
			}
		}
		//
		return result;
	}
	
	public Partition<Chain> getChildHostKinshipChains (int maxDepth, int maxOrder, String chainClassification){
		Partition<Chain> result;
		
		result = new Partition<Chain>();
		
		for (Sequence sequence : this){
			for (Relation event : sequence.childMigrationsWithoutParents()){
				for (Individual host : event.getIndividuals("HOST")){
					Partition<Chain> chains = ChainFinder.findChains(sequence.getEgo(), host, maxDepth, maxOrder, chainClassification);
					if (chains.size()==0){
						result.put(new Chain (sequence.getEgo(),host), null);
					} else {
						result.add(chains);
					}
				}
			}
		}
		//
		return result;
	}
	
	public void addRenumbered(Sequence sequence){
		sequence.setId(size());
		add(sequence);
	}
	
	public int getNrEvents(){
		int result;
		
		result = 0;
		for (Sequence sequence : this){
			result += sequence.getEvents().size();
		}
		
		//
		return result;
	}
	

	

}
