package org.tip.puck.net.workers;

import java.util.ArrayList;
import java.util.Collections;

import org.tip.puck.net.workers.NetNodeTypeComparator.Sorting;

/**
 * 
 * @author TIP
 */
public class NetNodeTypes extends ArrayList<NetNodeType> {

	private static final long serialVersionUID = -3364060526230305991L;

	/**
	 * 
	 */
	public NetNodeTypes() {
		super();
	}

	/**
	 * 
	 */
	public NetNodeTypes(final NetNodeTypes source) {
		super(source);
	}

	/**
	 * 
	 * @return
	 */
	public void sorted(final Sorting sorting) {
		//
		Collections.sort(this, new NetNodeTypeComparator(sorting));
	}

	/**
	 * 
	 */
	@Override
	public NetNodeType[] toArray() {
		NetNodeType[] result;

		result = new NetNodeType[this.size()];
		int count = 0;
		for (NetNodeType node : this) {
			//
			result[count] = node;
			count += 1;
		}

		//
		return result;
	}
}
