package org.tip.puck.net.workers;

import java.util.Arrays;

import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;

/**
 * @author Klaus Hamberger
 * @since Version 0.6
 * @see Net#getBicomponent(Stack<Edge>, Edge, boolean)
 */
public class KinLink {

	private Individual source;
	private Individual target;
	private KinType type;
	
	/**
	 * The default constructor
	 */
	private KinLink() {};
	
	public KinLink (Individual v, Individual w, KinType kinType, boolean sym){
		if (sym || v.getId() < w.getId()){
			this.source = v;
			this.target = w;
			this.type = kinType;
		} else {
			this.source = w;
			this.target = v;
			this.type = kinType.inverse();
		}
	}

	/**
	 * checks whether two edges are equal
	 * @param o the edge to be compared
	 * @return true if the edges are equal
	 */
	@Override
	public boolean equals (Object o){
		return Arrays.equals(getKey(),((KinLink)o).getKey());
	}
	
	/**
	 * returns the alter Individual
	 * @return the alter Individual
	 */
	public Individual getTarget(){
		return target;
	}
	
	/**
	 * returns the ego Individual
	 * @return the ego Individual
	 */
	public Individual getSource(){
		return source;
	}
	
	/**
	 * returns the ID numbers of ego and alter
	 * @return an array consisting of the ID numbers of ego and alter
	 */
	private int[] getKey (){
		int[] key = {source.getId(),target.getId()};
		return key;
	}

	
	/**
	 * gets a new hashCode
	 * @return the new hashCode
	 */
	@Override
	public int hashCode (){
		return Arrays.hashCode(getKey());
	}
	
	/**
	 * inverts the arc (permutes ego and alter and changes the line value accordingly)
	 * @return the edge in inverse representation
	 */
	private KinLink inverse (){
		KinLink e = new KinLink();
		e.source = target;
		e.target = source;
		e.type = invType();
		return e;
	}

	/**
	 * inverts the arc if alter coincides with a given Individual
	 * @param v the Individual to be checked
	 * @return the inverse arc if v is equal to alter, the same arc else  
	 */
	public KinLink inverse (Individual v){
		if (v==target) return inverse();
		return this;
	}

	/**
	 * returns the (gendered) kin type of the inverse edge
	 * @return the (gendered) kin type of the inverse edge
	 */
	private KinType invType (){
		KinType result;
		
		switch (type){
			case SPOUSE: {
				result = KinType.SPOUSE;
				break;
			}
			case CHILD: {
				result = KinType.PARENT;
				break; //ego.getGender().toInt();
			}
			case PARENT: {
				result = KinType.CHILD;
				break;
			}
			default: {
				result = null;
			}
		}
		//
		return result;
	}

	public KinType getType() {
		return type;
	}

	
}
