package org.tip.puck.net.relations.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.tip.puck.graphs.Graph;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.spacetime.workers.SequenceCensus;
import org.tip.puck.util.ToolBox;

import fr.devinsy.util.StringList;

/**
 * @author Klaus Hamberger
 * @author TIP
 */
public class RelationWorker {

	/**
	 * 
	 * @param net
	 * @param criteria
	 */
	public static void addChildRoles(final Net net, final AddChildRolesCriteria criteria) {
		//
		if ((net != null) && (criteria != null)) {
			//
			RelationModel model = net.relationModels().getByName(criteria.getRelationModelName());
			String egoRoleName = criteria.getEgoRoleName();
			StringList roleNames = criteria.getAlterRoleNames();
			int maxAge = criteria.getMaxAge();
			String dateLabel = criteria.getDateLabel();

			if (model != null) {

				model.roles().add(new Role(egoRoleName + "_CHILD", 0));
				Relations relations = net.relations().getByModel(model);

				for (Relation event : relations) {
					if (!SequenceCensus.isBirth(event) && !SequenceCensus.isDeath(event)) {
						Integer eventYear = IndividualValuator.extractYearAsInt(event.getAttributeValue(dateLabel));
						if (eventYear != null) {
							for (Actor actor : event.actors().toList()) {
								if (actor.getRole().getName().equals(egoRoleName)) {
									Individual ego = actor.getIndividual();
									int age = IndividualValuator.ageAtYear(ego, eventYear);
									if (age > -1 && age < maxAge && event.getRoleNames(ego).contains(egoRoleName) && !SequenceCensus.isBirth(event)
											&& !SequenceCensus.isDeath(event)) {
										for (String alterRoleName : roleNames) {
											if (!event.getIndividuals(alterRoleName).contains(ego.getFather())
													&& !event.getIndividuals(alterRoleName).contains(ego.getMother())) {
												event.actors().add(new Actor(ego, new Role(egoRoleName + "_CHILD")));
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	/**
	 * 
	 * @param ancestorList
	 * @param referent
	 * @param ascendants
	 * @param relation
	 * @param treeType
	 * @param maxDegrees
	 * @return
	 */
	private static Set<List<String>> getLinkChains(final List<String> ancestorList, final Actor referent, final Actors ascendants, final Relation relation,
			final String treeType, final int[] maxDegrees) {
		Set<List<String>> result;

		result = new HashSet<List<String>>();

		Actors dependants = relation.getDependants(referent);
		ascendants.add(referent);

		if (dependants.size() > 0) {
			for (Actor descendant : dependants) {
				if (ascendants.contains(descendant)) {
					System.err.println("Cyclic referent structure : " + referent + " for " + descendant + " " + referent + " in " + relation);
				} else {
					List<String> list = new ArrayList<String>();
					list.addAll(ancestorList);

					Individual individual = descendant.getIndividual();
					if (treeType.equals("GENDER")) {
						list.add(individual.getGender().toChar() + "");
					} else if (treeType.equals("ID")) {
						list.add(individual.getId() + "");
					} else if (treeType.equals("KIN")) {
						list.add(individual.getGender().toChar() + "");
					}

					for (List<String> chain : getLinkChains(list, descendant, ascendants, relation, treeType, maxDegrees)) {
						result.add(chain);
					}
				}
			}
		} else {
			result.add(ancestorList);
		}

		//
		return result;
	}

	/**
	 * 
	 * @param relation
	 * @param treeType
	 * @param pattern
	 * @return
	 */
	public static Set<List<String>> getLinkChains(final Relation relation, final String treeType, final String pattern) {
		Set<List<String>> result;

		result = new HashSet<List<String>>();

		int[] maxDegrees = ToolBox.stringsToInts(pattern);

		for (Actor actor : relation.actors()) {
			Individual referent = actor.getReferent();
			if (referent == null) {
				List<String> ancestorList = new ArrayList<String>();
				Individual individual = actor.getIndividual();
				if (treeType.equals("GENDER")) {
					ancestorList.add(individual.getGender().toChar() + "");
				} else if (treeType.equals("ID")) {
					ancestorList.add(individual.getId() + "");
				} else if (treeType.equals("KIN")) {
					ancestorList.add(individual.getGender().toChar() + "");
				}

				for (List<String> chain : getLinkChains(ancestorList, actor, new Actors(), relation, treeType, maxDegrees)) {
					result.add(chain);
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param relation
	 * @param treeType
	 * @param pattern
	 * @return
	 */
	public static String getLinkChainsAsString(final Relation relation, final String treeType, final String pattern) {
		String result;

		result = "";

		Set<List<String>> chains = getLinkChains(relation, treeType, pattern);
		List<String> chainsAsStrings = new ArrayList<String>();
		for (List<String> chain : chains) {
			chainsAsStrings.add(chain.toString());
		}
		Collections.sort(chainsAsStrings);

		result = chainsAsStrings.toString();
		//
		return result;
	}

	/**
	 * 
	 * @param referent
	 * @param ascendants
	 * @param relation
	 * @param reduced
	 * @param treeType
	 * @param maxDegrees
	 * @return
	 */
	private static String getLinkTree(final Actor referent, final Actors ascendants, final Relation relation, final boolean reduced, final String treeType,
			final int[] maxDegrees) {
		String result;

		result = "";

		Actors dependants = relation.getDependants(referent);
		ascendants.add(referent);

		if (dependants.size() > 0) {
			result = "[";
			List<String> list = new ArrayList<String>();
			for (Actor descendant : dependants) {
				if (ascendants.contains(descendant)) {
					System.err.println("Cyclic referent structure : " + referent + " for " + descendant + " " + referent + " in " + relation);
				} else {
					String item = getLinkTree(descendant, ascendants, relation, reduced, treeType, maxDegrees);
					if (treeType.equals("GENDER")) {
						item = descendant.getIndividual().getGender().toChar() + item;
					} else if (treeType.equals("ID")) {
						item = descendant.getIndividual().getId() + " " + item;
					} else if (treeType.equals("KIN")) {
						item = NetUtils.getAlterRole(descendant.getIndividual(), referent.getIndividual(), maxDegrees, null) + " " + item;
					}
					if (!reduced || !list.contains(item)) {
						list.add(item);
					}
				}
			}
			Collections.sort(list);
			for (String item : list) {
				result += item;
			}
			result += "]";
		}
		//
		return result;
	}

	/**
	 * 
	 * @param relation
	 * @param reduced
	 * @param treeType
	 * @param pattern
	 * @return
	 */
	public static String getLinkTrees(final Relation relation, final boolean reduced, final String treeType, final String pattern) {
		String result;

		result = "";

		int[] maxDegrees = ToolBox.stringsToInts(pattern);

		List<String> list = new ArrayList<String>();
		for (Actor actor : relation.actors()) {
			Individual individual = actor.getIndividual();
			Individual referent = actor.getReferent();
			if (referent == null) {
				String item = getLinkTree(actor, new Actors(), relation, reduced, treeType, maxDegrees);
				if (treeType.equals("GENDER")) {
					item = individual.getGender().toChar() + item;
				} else if (treeType.equals("ID")) {
					item = individual.getId() + " " + item;
				} else if (treeType.equals("KIN")) {
					item = individual.getGender().toChar() + " " + item;
				}
				if (!reduced || !list.contains(item)) {
					list.add(item);
				}
			}
		}
		Collections.sort(list);
		for (String item : list) {
			result += item + " ";
		}

		//
		return result;
	}

	/**
	 * 
	 * @param relation
	 * @return
	 */
	public static Graph<Individual> getReferentGraph(final Relation relation) {
		Graph<Individual> result;

		result = new Graph<Individual>();
		for (Actor actor : relation.actors()) {
			Individual ego = actor.getIndividual();
			Individual alter = actor.getReferent();
			result.addArc(ego, alter);
		}
		//
		return result;
	}

	/*	public static String getLinkTrees (Individuals individuals, String relationModelName, String egoRoleName, String alterRoleName, String attributeLabel, Integer time, boolean reduced){
			String result;

			result = "";
			
			List<String> list = new ArrayList<String>();
			for (Individual individual : individuals){
				Individuals ascendants = individual.getRelated(relationModelName, egoRoleName, alterRoleName, attributeLabel, time);
				if (ascendants.size() == 0){
					String item = individual.getGender().toChar()+getLinkTree(individual, relationModelName, alterRoleName, egoRoleName, attributeLabel, time, reduced);
					if (!reduced || !list.contains(item)){
						list.add(item);
					}
				}
			}
			Collections.sort(list);
			for (String item : list){
				result+=item+" ";
			}
			
			
			//
			return result;
		}
		
		private static String getLinkTree(Individual individual, String relationModelName, String egoRoleName, String alterRoleName, String attributeLabel, Integer time, boolean reduced){
			String result;
			
			result = "";
			
			Individuals descendants = individual.getRelated(relationModelName, egoRoleName, alterRoleName, attributeLabel, time);
			
			if (descendants.size()>0){
				result = "[";
				List<String> list = new ArrayList<String>();
				for (Individual descendant : descendants){
					String item = descendant.getGender().toChar()+getLinkTree(descendant, relationModelName, egoRoleName, alterRoleName, attributeLabel, time, reduced); 
					if (!reduced || !list.contains(item)){
						list.add(item);
					}
				}
				Collections.sort(list);
				for (String item : list){
					result+=item;
				}
				result += "]";
			}
			//
			return result;
		}*/

}
