package org.tip.puck.io.paj;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import oldcore.trash.Partition;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;

/**
 * 
 * @author TIP
 */
public class PAJFileOldcore {

	private enum PartitionType {
		BY_INDEX,
		BY_VALUE,
		AS_VECTOR;
	}

	private static final Logger logger = LoggerFactory.getLogger(PAJFileOldcore.class);

	/**
	 * 
	 * @param out
	 * @param partition
	 * @param type
	 */
	public void writePartition(final PrintWriter out, final Partition<Individual> partition, final PartitionType type) {
		out.println("*Parition " + partition.getLabel());
		out.println("*vertices " + partition.nrItems());

		for (Individual individual : partition.getValues().keySet()) {
			switch (type) {
				case BY_INDEX:
					out.println(partition.getClusterIndex(individual));
				break;
				case BY_VALUE:
					out.println(partition.getVal(individual));
				break;
				case AS_VECTOR:
					// should be a double with 10 decimals.
					out.println(partition.getVal(individual));
				break;
			}
		}

	}

	/**
	 * writes a series of partitions
	 * 
	 * @param part
	 *            the list of partitions
	 * @see gui.screens.StatsScreen#exportPartitions(List,String)
	 */
	public void writePartitions(final PrintWriter out, final List<Partition<Individual>> part, final PartitionType type) throws IOException {

		logger.debug("Write partition data.");
		for (Partition<Individual> p : part) {
			writePartition(out, p, type);
		}
	}

	/**
	 * s
	 * 
	 * @param ego
	 * @param alter
	 * @return
	 */
	private static String arcLine(final Individual ego, final Individual alter) {
		String result;

		result = ego.getId() + " " + alter.getId() + " " + filiationIndex(ego.getGender(), alter.getGender());

		//
		return result;
	}

	/**
	 * 
	 * @param parentGender
	 * @param childGender
	 * @return
	 */
	private static int filiationIndex(final Gender parentGender, final Gender childGender) {
		int result = 0;

		if (parentGender == Gender.MALE) {
			switch (childGender) {
				case MALE:
					result = 5;
				break;
				case FEMALE:
					result = 4;
				break;
				case UNKNOWN:
					result = 7;
				break;
			}
		}
		if (parentGender == Gender.FEMALE) {
			switch (childGender) {
				case MALE:
					result = 3;
				break;
				case FEMALE:
					result = 2;
				break;
				case UNKNOWN:
					result = 6;
				break;
			}
		}
		//
		return result;

	}

	/**
	 * 
	 * @param gender
	 * @return
	 */
	private static String shape(final Gender gender) {
		String result;

		switch (gender) {
			case MALE: {
				result = "triangle";
				break;
			}
			case FEMALE: {
				result = "ellipse";
				break;
			}
			default: {
				result = "diamond";
			}
		}
		//
		return result;

	}

	/**
	 * 
	 * @param individual
	 * @return
	 */
	private static String vertexLine(final Individual individual) {
		String result;

		result = individual.getId() + " '" + individual.getName() + "' " + shape(individual.getGender());

		//
		return result;
	}

	/**
	 * Writes a net in an stream.
	 * 
	 * @param out
	 *            Target.
	 * 
	 * @param net
	 *            Source.
	 */
	public static void write(final PrintWriter out, final Net net) {

		// Write network data.
		logger.debug("Write network data.");
		out.println("*Network " + net.getLabel());

		// Write vertices
		out.println("*vertices " + net.size());
		for (Individual individual : net.individuals().toSortedList()) {
			out.println(vertexLine(individual));
		}

		// Write arcs
		out.println("*arcs");
		for (Family family : net.families()) {
			Individual husband = family.getHusband();
			Individual wife = family.getWife();

			if (husband != null && wife != null && family.hasMarried()) {
				out.println(wife.getId() + " " + husband.getId() + " " + 1);
			}

			if (family.isFertile()) {
				if (husband != null) {
					for (Individual child : family.getChildren()) {
						out.println(arcLine(husband, child));
					}
				}
				if (wife != null) {
					for (Individual child : family.getChildren()) {
						out.println(arcLine(wife, child));
					}
				}
			}
		}
		out.println();
	}

}
