package org.tip.puck.geo2;

import org.apache.commons.lang3.StringUtils;

import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;

/**
 * 
 * The <i>externalId</i> can be GeoNames one.
 * 
 */
public class Place2 {

	private String toponym;
	private Homonyms homonyms;
	private GeoLevel2 geoLevel;
	private Coordinate2 coordinate;
	private String externalId;
	private String comment;
	private String abovePlace;

	/** 
	 * 
	 */
	public Place2(final String toponym) {
		this.toponym = toponym;
		this.externalId = null;
		this.homonyms = new Homonyms();
		this.geoLevel = GeoLevel2.LOCAL;
	}

	public String getAbovePlace() {
		return this.abovePlace;
	}

	public String getComment() {
		return this.comment;
	}

	public Coordinate2 getCoordinate() {
		return this.coordinate;
	}

	/**
	 * 
	 * @return
	 */
	public Double getElevation() {
		Double result;

		if (this.coordinate == null) {

			result = null;

		} else {

			result = this.coordinate.getElevation();
		}

		//
		return result;
	}

	public String getExternalId() {
		return this.externalId;
	}

	public GeoLevel2 getGeoLevel() {
		return this.geoLevel;
	}

	public Homonyms getHomonyms() {
		return this.homonyms;
	}

	/**
	 * 
	 * @return
	 */
	public Double getLatitude() {
		Double result;

		if (this.coordinate == null) {

			result = null;

		} else {

			result = this.coordinate.getLatitude();
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Double getLongitude() {
		Double result;

		if (this.coordinate == null) {

			result = null;

		} else {

			result = this.coordinate.getLongitude();
		}

		//
		return result;
	}

	public String getToponym() {
		return this.toponym;
	}

	/**
	 * 
	 * @return
	 */
	public StringList getToponyms() {
		StringList result;

		result = new StringList();

		result.add(this.toponym);
		result.addAll(this.getHomonyms());

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isGeocoded() {
		boolean result;

		if (this.coordinate == null) {
			result = false;
		} else {
			result = true;
		}

		//
		return result;
	}

	public void setAbovePlace(final String abovePlace) {
		this.abovePlace = abovePlace;
	}

	public void setComment(final String comment) {
		this.comment = comment;
	}

	public void setCoordinate(final Coordinate2 coordinate) {
		this.coordinate = coordinate;
	}

	/**
	 * 
	 * @param value
	 * @return
	 */
	public Place2 setElevation(final Double value) {

		if (value == null) {

			this.coordinate = null;

		} else {

			if (this.coordinate == null) {

				this.coordinate = new Coordinate2();
			}

			this.coordinate.setElevation(value);
		}

		//
		return this;
	}

	/**
	 * 
	 * @param value
	 * @return
	 */
	public Place2 setElevation(final Integer value) {
		Place2 result;

		if (value == null) {

			result = setElevation((Double) null);
		} else {

			result = setElevation(Double.valueOf(value));
		}

		//
		return result;
	}

	public void setExternalId(final String externalId) {
		this.externalId = externalId;
	}

	public void setGeoLevel(final GeoLevel2 geoLevel) {
		this.geoLevel = geoLevel;
	}

	/**
	 * 
	 * @param homonyms
	 */
	public void setHomonyms(final String homonyms) {

		if (StringUtils.isBlank(homonyms)) {

			this.homonyms.clear();

		} else {
			this.homonyms.clear();
			for (String homonym : homonyms.split("[,;]")) {

				this.homonyms.add(homonym);
			}
		}
	}

	/**
	 * 
	 * @param homonyms
	 */
	public void setHomonyms(final StringSet source) {

		if (source == null) {

			this.homonyms.clear();

		} else {

			this.homonyms.clear();
			for (String homonym : source) {

				if (!StringUtils.equals(this.toponym, homonym)) {

					this.homonyms.add(homonym);
				}
			}
		}
	}

	/**
	 * 
	 * @param value
	 * @return
	 */
	public Place2 setLatitude(final Double value) {

		if (value == null) {

			this.coordinate = null;

		} else {

			if (this.coordinate == null) {

				this.coordinate = new Coordinate2();
			}

			this.coordinate.setLatitude(value);
		}

		//
		return this;
	}

	/**
	 * 
	 * @param value
	 * @return
	 */
	public Place2 setLongitude(final Double value) {

		if (value == null) {

			this.coordinate = null;

		} else {

			if (this.coordinate == null) {

				this.coordinate = new Coordinate2();
			}

			this.coordinate.setLongitude(value);
		}

		//
		return this;
	}

	/**
	 * 
	 * @param toponym
	 */
	public void setToponym(final String toponym) {
		this.toponym = toponym;
	}

	/**
	 * 
	 */
	@Override
	public String toString() {
		String result;

		result = this.toponym;

		//
		return result;
	}
}
