/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical.datastructs.chain;

import java.util.EnumSet;
import org.gephi.graph.api.Node;
import org.gephi.graph.spi.LayoutData;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.BorderContainer;

public class NodeLayoutData
implements LayoutData {
    public EnumSet<Color> colors = EnumSet.noneOf(Color.class);
    private BorderContainer container;
    private int level = -1;

    private static void initData(Node node) {
        NodeLayoutData nodeData = (NodeLayoutData)node.getNodeData().getLayoutData();
        if (nodeData == null) {
            nodeData = new NodeLayoutData();
            node.getNodeData().setLayoutData((LayoutData)nodeData);
        }
    }

    private static NodeLayoutData getData(Node node) {
        return (NodeLayoutData)node.getNodeData().getLayoutData();
    }

    private static EnumSet<Color> getColorValues(Node node) {
        EnumSet<Color> result = null;
        NodeLayoutData data = NodeLayoutData.getData(node);
        if (data != null) {
            result = data.colors;
        }
        return result;
    }

    public static int getLevel(Node node) {
        NodeLayoutData.initData(node);
        NodeLayoutData data = NodeLayoutData.getData(node);
        return data.level;
    }

    public static void setLevel(Node node, int level) {
        NodeLayoutData.initData(node);
        NodeLayoutData data = NodeLayoutData.getData(node);
        data.level = level;
    }

    public static boolean hasContainter(Node node) {
        return NodeLayoutData.getData(node) != null && NodeLayoutData.getData((Node)node).container != null;
    }

    public static void setContainer(Node node, BorderContainer container) {
        NodeLayoutData.initData(node);
        NodeLayoutData data = NodeLayoutData.getData(node);
        data.container = container;
    }

    public static BorderContainer getContainer(Node node) {
        NodeLayoutData data = NodeLayoutData.getData(node);
        if (data == null) {
            return null;
        }
        return data.container;
    }

    public static void color(Node node, Color color) {
        NodeLayoutData.initData(node);
        NodeLayoutData nodeData = NodeLayoutData.getData(node);
        nodeData.colors.add(color);
        nodeData.colors.remove((Object)color.negate());
    }

    public static void removeColor(Node node, Color color) {
        NodeLayoutData nodeData = NodeLayoutData.getData(node);
        if (nodeData != null) {
            nodeData.colors.remove((Object)color);
        }
    }

    public static void clean(Node node) {
        NodeLayoutData nodeData = NodeLayoutData.getData(node);
        if (nodeData != null) {
            node.getNodeData().setLayoutData(null);
        }
    }

    public static boolean isColored(Node node) {
        return NodeLayoutData.getData(node) != null && NodeLayoutData.getData((Node)node).colors.isEmpty();
    }

    public static boolean isColored(Node node, Color color) {
        if (NodeLayoutData.getData(node) == null) {
            return false;
        }
        return NodeLayoutData.getData((Node)node).colors.contains((Object)color);
    }

    public static boolean isColored(Node node, EnumSet<? extends Color> colors) {
        return NodeLayoutData.getData(node) != null && NodeLayoutData.getData((Node)node).colors.containsAll(colors);
    }

    public static enum Color {
        RED{

            @Override
            public Color negate() {
                return BLACK;
            }
        }
        ,
        BLACK{

            @Override
            public Color negate() {
                return RED;
            }
        };


        public abstract Color negate();
    }
}

