/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainMaker;
import org.tip.puck.census.chains.Vector;
import org.tip.puck.graphs.Node;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Interval;

public class Value
implements Comparable<Value> {
    private static final Logger logger = LoggerFactory.getLogger(Value.class);
    private Object value;

    public static <E> Value valueOf(E value) {
        Value result = value == null ? null : new Value(value);
        return result;
    }

    public Value(char value) {
        this.value = new Character(value);
    }

    public Value(double value) {
        this.value = new Double(value);
    }

    public Value(Chain value) {
        if (value == null) {
            throw new ClassCastException("Value cannot be null.");
        }
        this.value = value;
    }

    public <E extends Comparable<E>> Value(E value) {
        if (value == null) {
            throw new ClassCastException("Value cannot be null.");
        }
        this.value = value;
    }

    public Value(int value) {
        this.value = new Integer(value);
    }

    public Value(Object value) {
        if (value == null) {
            throw new ClassCastException("Value cannot be null.");
        }
        this.value = value;
    }

    public Value(List<?> value) {
        if (value == null) {
            throw new ClassCastException("Value cannot be null.");
        }
        this.value = value;
    }

    public Value(String value) {
        this.value = new String(value);
    }

    public Chain chainValue() {
        if (!(this.value instanceof Chain)) {
            throw new ClassCastException("Value is not a chain.");
        }
        Chain result = (Chain)this.value;
        return result;
    }

    public char charValue() {
        char result;
        if (this.value == null) {
            result = ' ';
        } else if (this.value instanceof Character) {
            result = ((Character)this.value).charValue();
        } else {
            throw new ClassCastException("Value is not a character.");
        }
        return result;
    }

    @Override
    public int compareTo(Value source) {
        int result = source == null ? 1 : (this.isNumber() && source.isNumber() ? Double.compare(this.doubleValue(), source.doubleValue()) : (this.isVector() && source.isVector() ? this.vectorValue().compareTo(source.vectorValue()) : (this.isChain() && source.isChain() ? this.chainValue().compareTo(source.chainValue()) : (this.isIndividual() && source.isIndividual() ? Integer.valueOf(this.individualValue().getId()).compareTo(source.individualValue().getId()) : (this.isGender() && source.isGender() ? this.genderValue().compareTo(source.genderValue()) : (this.isEnum() && source.isEnum() ? this.enumValue().compareTo(source.enumValue()) : (this.value instanceof Interval && source.getObject() instanceof Interval ? ((Interval)this.getObject()).compareTo((Interval)source.getObject()) : (this.value instanceof Node && source.getObject() instanceof Node ? ((Node)this.getObject()).compareTo((Node)source.getObject()) : this.stringValue().compareTo(source.stringValue())))))))));
        return result;
    }

    public int dimension() {
        int result = this.value instanceof Vector ? ((Vector)this.value).order() : 1;
        return result;
    }

    public double doubleValue() {
        double result;
        if (this.value == null) {
            throw new ClassCastException("Null is not a number.");
        }
        if (this.value instanceof Integer) {
            result = ((Integer)this.value).doubleValue();
        } else if (this.value instanceof Double) {
            result = (Double)this.value;
        } else {
            String stringValue = this.value.toString();
            if (NumberUtils.isNumber((String)stringValue)) {
                result = Double.parseDouble(stringValue);
            } else {
                throw new ClassCastException("Value is not a number.");
            }
        }
        return result;
    }

    public Enum enumValue() {
        if (!(this.value instanceof Enum)) {
            throw new ClassCastException("Value is not an Enum.");
        }
        Enum result = (Enum)this.value;
        return result;
    }

    public List listValue() {
        if (!(this.value instanceof List)) {
            throw new ClassCastException("Value is not a List.");
        }
        List result = (List)this.value;
        return result;
    }

    public Map mapValue() {
        if (!(this.value instanceof Map)) {
            throw new ClassCastException("Value is not a Map.");
        }
        Map result = (Map)this.value;
        return result;
    }

    public boolean equals(Object object) {
        boolean result = object == null || !(object instanceof Value) ? false : (((Value)object).getObject() instanceof String[] ? Arrays.toString((String[])this.getObject()).equals(Arrays.toString((String[])((Value)object).getObject())) : this.stringValue().equals(((Value)object).stringValue()));
        return result;
    }

    public Gender genderValue() {
        if (!(this.value instanceof Gender)) {
            throw new ClassCastException("Value is not a gender.");
        }
        Gender result = (Gender)((Object)this.value);
        return result;
    }

    public Object getObject() {
        Object result = this.value;
        return result;
    }

    public int hashCode() {
        int result = this.getObject() instanceof String[] ? Arrays.toString((String[])this.getObject()).hashCode() : this.stringValue().hashCode();
        return result;
    }

    public Individual individualValue() {
        if (!(this.value instanceof Individual)) {
            throw new ClassCastException("Value is not an individual.");
        }
        Individual result = (Individual)this.value;
        return result;
    }

    public int intValue() {
        int result;
        if (this.value == null) {
            throw new ClassCastException("Null is not a number.");
        }
        if (this.value instanceof Integer) {
            result = (Integer)this.value;
        } else if (this.value instanceof Double) {
            result = ((Double)this.value).intValue();
        } else {
            String stringValue = this.value.toString();
            if (NumberUtils.isNumber((String)stringValue)) {
                result = Integer.parseInt(stringValue);
            } else {
                throw new ClassCastException("Value is not a number.");
            }
        }
        return result;
    }

    public String[] stringArrayValue() {
        if (this.value == null) {
            throw new ClassCastException("Null is not a string array.");
        }
        if (!(this.value instanceof String[])) {
            throw new ClassCastException("Value is not a string array.");
        }
        String[] result = (String[])this.value;
        return result;
    }

    public Double[] doubleArrayValue() {
        if (this.value == null) {
            throw new ClassCastException("Null is not a double array.");
        }
        if (!(this.value instanceof Double[])) {
            throw new ClassCastException("Value is not a double array.");
        }
        Double[] result = (Double[])this.value;
        return result;
    }

    public boolean isChain() {
        boolean result = this.value == null ? false : this.value instanceof Chain;
        return result;
    }

    public boolean isEnum() {
        boolean result = this.value == null ? false : this.value instanceof Enum;
        return result;
    }

    public boolean isGender() {
        boolean result = this.value == null ? false : this.value instanceof Gender;
        return result;
    }

    public boolean isIndividual() {
        boolean result = this.value == null ? false : this.value instanceof Individual;
        return result;
    }

    public boolean isNotNumber() {
        boolean result = !this.isNumber();
        return result;
    }

    public boolean isNotZero() {
        boolean result = this.value == null ? true : (this.isNotNumber() ? true : this.doubleValue() != 0.0);
        return result;
    }

    public boolean isNumber() {
        boolean result = this.value == null ? false : this.value instanceof Integer || this.value instanceof Double || NumberUtils.isNumber((String)this.value.toString());
        return result;
    }

    public boolean isPositiveNumber() {
        boolean result = this.isNumber() && this.doubleValue() > 0.0;
        return result;
    }

    public boolean isString() {
        boolean result = this.value instanceof String;
        return result;
    }

    public boolean isList() {
        boolean result = this.value instanceof List;
        return result;
    }

    public boolean isVector() {
        boolean result = this.value == null ? false : this.value instanceof Vector;
        return result;
    }

    public boolean isZero() {
        boolean result = this.value == null ? false : (this.isNotNumber() ? false : this.doubleValue() == 0.0);
        return result;
    }

    public String stringValue() {
        String result;
        if (this.value == null) {
            result = "null";
        } else if (this.value instanceof String[]) {
            result = Arrays.toString((String[])this.value);
        } else if (this.value instanceof List && this.listValue() != null && this.listValue().size() > 0 && this.listValue().get(0) instanceof String[]) {
            result = "[";
            for (Object[] item : this.listValue()) {
                result = String.valueOf(result) + Arrays.toString(item);
            }
            result = String.valueOf(result) + "]";
        } else {
            result = this.value.toString();
        }
        return result;
    }

    public String toString() {
        String result = this.stringValue();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector vectorValue() {
        if (this.value instanceof Vector) {
            return (Vector)this.value;
        }
        if (!(this.value instanceof String)) throw new ClassCastException("Value is not a vector.");
        Chain chain = ChainMaker.fromString((String)this.value);
        if (chain == null) throw new ClassCastException("Value is not a vector string.");
        return chain.getCharacteristicVector();
    }

    public static int compare(Value value1, Value value2) {
        int result = value1 == null && value2 == null ? 0 : (value1 == null ? -1 : (value2 == null ? 1 : value1.compareTo(value2)));
        return result;
    }

    public static boolean isNumber(Value value) {
        boolean result = value == null ? false : value.isNumber();
        return result;
    }

    public static String stringValue(Value value) {
        String result = value == null ? null : value.stringValue();
        return result;
    }
}

