/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.io.permutation.PermutationTable;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.report.Report;

public class UpdateWorker {
    private static final Logger logger = LoggerFactory.getLogger(UpdateWorker.class);

    public static Net fuse(Net target, Net source, PermutationTable permutations, Report errorReport) throws PuckException {
        int lastId = target.individuals().getLastId();
        int newIdCount = 0;
        for (Individual sourceIndividual : source.individuals().toSortedList()) {
            Integer newId = permutations.getTarget(sourceIndividual.getId());
            if (newId == null) {
                newId = lastId + newIdCount + 1;
                ++newIdCount;
            }
            sourceIndividual.setId(newId);
        }
        Net result = UpdateWorker.update(target, source, errorReport, UpdateMode.APPEND);
        return result;
    }

    @Deprecated
    private static Family getOrCreateFamily(Net target, Individual sourceFather, Individual sourceMother) {
        Family result;
        Individual targetFather = sourceFather == null ? null : (Individual)target.individuals().getById(sourceFather.getId());
        Individual targetMother = sourceMother == null ? null : (Individual)target.individuals().getById(sourceMother.getId());
        if (targetMother == null && targetFather == null) {
            result = null;
        } else {
            if (targetMother == null || targetFather == null) {
                result = new Family(target.families().getLastId() + 1, targetFather, targetMother);
                target.families().add(result);
            } else {
                result = target.families().getBySpouses(targetFather, targetMother);
                if (result == null) {
                    result = new Family(target.families().getLastId() + 1, targetFather, targetMother);
                    target.families().add(result);
                }
            }
            if (targetFather != null) {
                targetFather.getPersonalFamilies().add(result);
            }
            if (targetMother != null) {
                targetMother.getPersonalFamilies().add(result);
            }
        }
        return result;
    }

    public static void update(Attributes target, Attributes source, Report errorReport, UpdateMode mode) {
        for (Attribute sourceAttribute : source) {
            if (!StringUtils.isNotBlank((CharSequence)sourceAttribute.getLabel()) || !StringUtils.isNotBlank((CharSequence)sourceAttribute.getValue())) continue;
            Attribute targetAttribute = (Attribute)target.get(sourceAttribute.getLabel());
            if (targetAttribute == null) {
                target.put(sourceAttribute.getLabel(), sourceAttribute.getValue());
                continue;
            }
            if (mode == UpdateMode.OVERWRITE) {
                target.add(new Attribute(String.valueOf(targetAttribute.getLabel()) + "_OLD", targetAttribute.getValue()));
                if (!targetAttribute.equals(sourceAttribute)) {
                    errorReport.outputs().appendln("Changed attribute " + sourceAttribute.getLabel() + "\t->\t" + sourceAttribute.getValue());
                }
                targetAttribute.setValue(sourceAttribute.getValue());
                continue;
            }
            if (mode != UpdateMode.APPEND) continue;
            target.add(new Attribute(String.valueOf(sourceAttribute.getLabel()) + "_ALT", sourceAttribute.getValue()));
            if (targetAttribute.equals(sourceAttribute)) continue;
            errorReport.outputs().appendln("Not changed attribute " + sourceAttribute.getLabel() + "\t->|\t" + sourceAttribute.getValue());
        }
    }

    public static Net update(Net original, Net source, Report errorReport, UpdateMode mode) throws PuckException {
        Net target = new Net(original);
        NetUtils.renumberFamilies(target);
        if (StringUtils.isBlank((CharSequence)target.getLabel())) {
            target.setLabel(source.getLabel());
        } else if (mode == UpdateMode.OVERWRITE && StringUtils.isNotBlank((CharSequence)source.getLabel())) {
            target.setLabel(source.getLabel());
        }
        HashMap originalTargetIds = new HashMap(target.individuals().size());
        Integer[] integerArray = target.individuals().getIds();
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            originalTargetIds.put(id, null);
            ++n2;
        }
        for (Individual sourceIndividual : source.individuals().toSortedList()) {
            String sourceName;
            Individual targetIndividual = (Individual)target.individuals().getById(sourceIndividual.getId());
            if (targetIndividual == null) {
                targetIndividual = new Individual(sourceIndividual.getId());
                target.individuals().add(targetIndividual);
            }
            if (!originalTargetIds.containsKey(targetIndividual.getId())) {
                targetIndividual.setName(sourceIndividual.getName());
                targetIndividual.setGender(sourceIndividual.getGender());
                targetIndividual.setBirthOrder(sourceIndividual.getBirthOrder());
                targetIndividual.attributes().addAll(sourceIndividual.attributes());
                if (sourceIndividual.getFather() != null) {
                    NetUtils.setFatherRelation(target, sourceIndividual.getFather().getId(), targetIndividual.getId());
                }
                if (sourceIndividual.getMother() != null) {
                    NetUtils.setMotherRelation(target, sourceIndividual.getMother().getId(), targetIndividual.getId());
                }
                for (Individual partner : sourceIndividual.getPartners()) {
                    NetUtils.setSpouseRelationAndFixRoles(target, targetIndividual.getId(), partner.getId());
                }
                continue;
            }
            if (mode == UpdateMode.OVERWRITE) {
                sourceName = sourceIndividual.getName();
                if (StringUtils.isNotBlank((CharSequence)sourceName) && sourceName.charAt(0) != '#' && sourceName.indexOf("*") == -1) {
                    if (StringUtils.isNotBlank((CharSequence)targetIndividual.getName()) && !targetIndividual.getName().equals(sourceName)) {
                        errorReport.outputs().appendln(targetIndividual + "\tchanged Name\t" + targetIndividual.getName() + "\t->\t" + sourceName);
                    }
                    targetIndividual.setName(sourceName);
                }
                if (!sourceIndividual.getGender().isUnknown()) {
                    if (!targetIndividual.getGender().isUnknown() && !targetIndividual.getGender().equals((Object)sourceIndividual.getGender())) {
                        errorReport.outputs().appendln(targetIndividual + "\tchanged Gender\t" + (Object)((Object)targetIndividual.getGender()) + "\t->\t" + (Object)((Object)sourceIndividual.getGender()));
                    }
                    targetIndividual.setGender(sourceIndividual.getGender());
                }
                if (sourceIndividual.getBirthOrder() != null) {
                    if (targetIndividual.getBirthOrder() != null && targetIndividual.getBirthOrder() != sourceIndividual.getBirthOrder()) {
                        errorReport.outputs().appendln(targetIndividual + "\tchanged Birth Order\t" + targetIndividual.getBirthOrder() + "\t->\t" + sourceIndividual.getBirthOrder());
                    }
                    targetIndividual.setBirthOrder(sourceIndividual.getBirthOrder());
                }
                UpdateWorker.update(targetIndividual.attributes(), sourceIndividual.attributes(), errorReport, mode);
                if (targetIndividual.getFather() != null && (sourceIndividual.getFather() == null || sourceIndividual.getFather() != targetIndividual.getFather())) {
                    errorReport.outputs().appendln(targetIndividual + "\tchanged Father\t" + targetIndividual.getFather() + "\t->\t" + sourceIndividual.getFather());
                    targetIndividual.getOriginFamily().getChildren().removeById(targetIndividual.getId());
                    targetIndividual.setOriginFamily(null);
                }
                if (targetIndividual.getFather() == null && sourceIndividual.getFather() != null) {
                    NetUtils.setFatherRelation(target, sourceIndividual.getFather().getId(), targetIndividual.getId());
                }
                if (targetIndividual.getMother() != null && (sourceIndividual.getMother() == null || sourceIndividual.getMother() != targetIndividual.getMother())) {
                    errorReport.outputs().appendln(targetIndividual + "\tchanged Father\t" + targetIndividual.getMother() + "\t->\t" + sourceIndividual.getMother());
                    targetIndividual.getOriginFamily().getChildren().removeById(targetIndividual.getId());
                    targetIndividual.setOriginFamily(null);
                }
                if (targetIndividual.getMother() == null && sourceIndividual.getMother() != null) {
                    NetUtils.setMotherRelation(target, sourceIndividual.getMother().getId(), targetIndividual.getId());
                }
                for (Object partner : sourceIndividual.getPartners()) {
                    NetUtils.setSpouseRelationAndFixRoles(target, targetIndividual.getId(), ((Individual)partner).getId());
                }
                continue;
            }
            UpdateWorker.update(targetIndividual.attributes(), sourceIndividual.attributes(), errorReport, mode);
            sourceName = sourceIndividual.getName();
            if (StringUtils.isNotBlank((CharSequence)sourceName) && sourceName.charAt(0) != '#' && sourceName.indexOf("*") == -1) {
                if (StringUtils.isBlank((CharSequence)targetIndividual.getName())) {
                    targetIndividual.setName(sourceName);
                } else if (!targetIndividual.getName().equals(sourceName)) {
                    errorReport.outputs().appendln(targetIndividual + "\tnot changed Name\t" + targetIndividual.getName() + "\t->|\t" + sourceName);
                }
            }
            if (!sourceIndividual.getGender().isUnknown()) {
                if (targetIndividual.getGender().isUnknown()) {
                    targetIndividual.setGender(sourceIndividual.getGender());
                } else if (!targetIndividual.getGender().equals((Object)sourceIndividual.getGender())) {
                    errorReport.outputs().appendln(targetIndividual + "\tnot changed Gender\t" + (Object)((Object)targetIndividual.getGender()) + "\t->|\t" + (Object)((Object)sourceIndividual.getGender()));
                }
            }
            if (targetIndividual.getBirthOrder() == null) {
                targetIndividual.setBirthOrder(sourceIndividual.getBirthOrder());
            } else if (sourceIndividual.getBirthOrder() != null && sourceIndividual.getBirthOrder() != targetIndividual.getBirthOrder()) {
                errorReport.outputs().appendln(targetIndividual + "\tnot changed Birth Order\t" + targetIndividual.getBirthOrder() + "\t->|\t" + sourceIndividual.getBirthOrder());
            }
            if (targetIndividual.getFather() == null && sourceIndividual.getFather() != null) {
                NetUtils.setFatherRelation(target, sourceIndividual.getFather().getId(), targetIndividual.getId());
            } else if (sourceIndividual.getFather() != null) {
                errorReport.outputs().appendln(targetIndividual + "\tnot changed Father\t" + targetIndividual.getFather() + "\t->|\t" + sourceIndividual.getFather());
            }
            if (targetIndividual.getMother() == null && sourceIndividual.getMother() != null) {
                NetUtils.setMotherRelation(target, sourceIndividual.getMother().getId(), targetIndividual.getId());
            } else if (sourceIndividual.getMother() != null) {
                errorReport.outputs().appendln(targetIndividual + "\tnot changed Mother\t" + targetIndividual.getMother() + "\t->|\t" + sourceIndividual.getMother());
            }
            for (Object partner : sourceIndividual.getPartners()) {
                NetUtils.setSpouseRelationAndFixRoles(target, targetIndividual.getId(), ((Individual)partner).getId());
            }
        }
        logger.debug("===> source " + source.relationModels().size());
        logger.debug("===> target " + target.relationModels().size());
        for (RelationModel sourceRelationModel : source.relationModels()) {
            RelationModel targetRelationModel = target.relationModels().getByName(sourceRelationModel.getName());
            if (targetRelationModel == null) {
                targetRelationModel = target.createRelationModel(sourceRelationModel);
            } else {
                for (Role sourceRole : sourceRelationModel.roles()) {
                    if (targetRelationModel.roles().getByName(sourceRole.getName()) != null) continue;
                    targetRelationModel.roles().add(new Role(sourceRole));
                }
            }
            Relations sourceRelations = source.relations().getByModel(sourceRelationModel);
            Relations targetRelations = target.relations().getByModel(targetRelationModel);
            for (Relation sourceRelation : sourceRelations) {
                Relation targetRelation = (Relation)targetRelations.getById(sourceRelation.getId());
                if (targetRelation == null) {
                    targetRelation = target.createRelation(sourceRelation.getTypedId(), sourceRelation.getName(), targetRelationModel);
                } else if (mode == UpdateMode.OVERWRITE) {
                    if (!sourceRelation.getName().equals(targetRelation.getName())) {
                        errorReport.outputs().appendln(String.valueOf(sourceRelation.getId()) + "\tChanged relation name " + targetRelation.getName() + "\t->\t" + targetRelation.getName());
                    }
                    targetRelation.setName(sourceRelation.getName());
                } else if (!sourceRelation.getName().equals(targetRelation.getName())) {
                    errorReport.outputs().appendln(String.valueOf(sourceRelation.getId()) + "\tNot changed relation name " + targetRelation.getName() + "\t->|\t" + targetRelation.getName());
                }
                for (Actor sourceActor : sourceRelation.actors()) {
                    if (targetRelation.hasActor(sourceActor)) continue;
                    Actor actor = target.createRelationActor(targetRelation, sourceActor.getId(), sourceActor.getRole().getName());
                    actor.setRelationOrder(sourceActor.getRelationOrder());
                }
                UpdateWorker.update(targetRelation.attributes(), targetRelation.attributes(), errorReport, mode);
            }
        }
        Net result = NetUtils.buildCleanedNet(target);
        return result;
    }

    public static enum UpdateMode {
        APPEND,
        OVERWRITE;

    }
}

