/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import fr.devinsy.util.StringList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Role;
import org.tip.puck.util.NumberablesHashMap;

public class Relations
extends NumberablesHashMap<Relation> {
    public Relations() {
    }

    public Relations(int capacity) {
        super(capacity);
    }

    public Relations(List<Relation> source) {
        this.add(source);
    }

    public Relations(Relations source) {
        this.add(source);
    }

    public int actorCount() {
        int result = 0;
        for (Relation relation : this) {
            result += relation.actors().size();
        }
        return result;
    }

    public Relations add(List<Relation> source) {
        Relations result = this.put(source);
        return result;
    }

    public Relations add(Relations source) {
        Relations result = this.put(source);
        return result;
    }

    public Actors getActors() {
        Actors result = new Actors();
        for (Relation relation : this) {
            result.addAll(relation.actors());
        }
        return result;
    }

    public StringList getAttributeLabels() {
        StringList result = new StringList();
        for (Relation relation : this) {
            for (String label : relation.attributes().labels()) {
                if (result.contains((Object)label)) continue;
                result.add((Object)label);
            }
        }
        return result;
    }

    public Relations getByIds(Integer[] ids) {
        Relations result;
        if (ids == null) {
            result = new Relations();
        } else {
            result = new Relations(ids.length);
            Integer[] integerArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Integer id = integerArray[n2];
                Relation relation = (Relation)this.getById(id);
                if (relation != null) {
                    result.add(relation);
                }
                ++n2;
            }
        }
        return result;
    }

    public Relations getByIndividual(Individual individual) {
        Relations result = new Relations();
        for (Relation relation : individual.relations()) {
            if (!this.contains(relation)) continue;
            result.add(relation);
        }
        return result;
    }

    public Relations getByModel(RelationModel model) {
        Relations result = new Relations();
        for (Relation relation : this) {
            if (relation.getModel() != model) continue;
            result.add(relation);
        }
        return result;
    }

    public Relations getByModelName(String name) {
        Relations result = new Relations();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            for (Relation relation : this) {
                if (!relation.getModel().getName().equals(name)) continue;
                result.add(relation);
            }
        }
        return result;
    }

    public Relations getByModelNames(StringList names) {
        Relations result = new Relations();
        for (String name : names) {
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            for (Relation relation : this) {
                if (!relation.getModel().getName().equals(name)) continue;
                result.add(relation);
            }
        }
        return result;
    }

    public Relations getByName(String name) {
        Relations result = new Relations();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            for (Relation relation : this) {
                if (!relation.getName().equals(name)) continue;
                result.add(relation);
            }
        }
        return result;
    }

    public Relations getByTime(String dateLabel, Integer time) {
        Relations result;
        if (time == null) {
            result = this;
        } else {
            result = new Relations();
            for (Relation relation : this) {
                if (!relation.getTime(dateLabel).equals(time)) continue;
                result.add(relation);
            }
        }
        return result;
    }

    public Relation getByTypedId(int typedId, RelationModel model) {
        boolean ended = false;
        Iterator iterator = this.iterator();
        Relation result = null;
        while (!ended) {
            if (iterator.hasNext()) {
                Relation relation = (Relation)iterator.next();
                if (relation.getTypedId() != typedId || !relation.getModel().equals(model)) continue;
                ended = true;
                result = relation;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    public Relations getByTypedIds(Integer[] typedIds, String modelName) {
        Relations result = new Relations();
        for (Relation relation : this.getByModelName(modelName)) {
            Integer[] integerArray = typedIds;
            int n = typedIds.length;
            int n2 = 0;
            while (n2 < n) {
                Integer typedId = integerArray[n2];
                if (relation.getTypedId() == typedId.intValue()) {
                    result.add(relation);
                }
                ++n2;
            }
        }
        return result;
    }

    public int getFirstFreeTypedId() {
        int result;
        int[] ids = new int[this.size()];
        int relationIndex = 0;
        for (Relation relation : this) {
            ids[relationIndex] = relation.getTypedId();
            ++relationIndex;
        }
        if (ids.length == 0) {
            result = 1;
        } else {
            Arrays.sort(ids);
            boolean ended = false;
            int index = 0;
            result = -1;
            while (!ended) {
                if (index < ids.length - 1) {
                    if (ids[index] + 1 == ids[index + 1]) {
                        ++index;
                        continue;
                    }
                    ended = true;
                    result = ids[index] + 1;
                    continue;
                }
                ended = true;
                result = ids[index] + 1;
            }
        }
        return result;
    }

    public Individuals getIndividuals() {
        Individuals result = new Individuals();
        for (Relation relation : this) {
            for (Individual individual : relation.getIndividuals()) {
                if (result.contains(individual)) continue;
                result.add(individual);
            }
        }
        return result;
    }

    public int getLastTypedId() {
        int result = 0;
        for (Relation relation : this.data.values()) {
            if (relation.getTypedId() <= result) continue;
            result = relation.getTypedId();
        }
        return result;
    }

    public RelationModels getRelationModels() {
        RelationModels result = new RelationModels();
        for (Relation relation : this) {
            if (result.contains(relation.getModel())) continue;
            result.add(relation.getModel());
        }
        return result;
    }

    public int nextFreeTypedId(NumberablesHashMap.IdStrategy strategy) {
        int result;
        if (strategy == null) {
            result = 0;
        } else {
            switch (strategy) {
                case FILL: {
                    result = this.getFirstFreeTypedId();
                    break;
                }
                case APPEND: {
                    result = this.getLastTypedId() + 1;
                    break;
                }
                case SIZE: {
                    result = this.size() + 1;
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    public Relations put(List<Relation> source) {
        if (source != null) {
            for (Relation relation : source) {
                this.add(relation);
            }
        }
        Relations result = this;
        return result;
    }

    public Relations put(Relations source) {
        if (source != null) {
            for (Relation relation : source) {
                this.add(relation);
            }
        }
        Relations result = this;
        return result;
    }

    public void remove(Relation relation) {
        if (relation != null) {
            this.removeById(relation.getId());
        }
    }

    public void removeRelationRole(RelationModel model, Role role) {
        if (model != null && role != null) {
            Relations relations = this.getByModel(model);
            for (Relation relation : relations) {
                Actors actors = relation.actors().getByRole(role);
                for (Actor actor : actors) {
                    relation.actors().remove(actor);
                    if (relation.actors().getById(actor.getId()) != null) continue;
                    actor.getIndividual().relations().removeById(relation.getId());
                }
            }
            model.roles().remove(role);
        }
    }

    public List<Relation> searchByName(String pattern) {
        Relations relations = new Relations();
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            for (Relation relation : this) {
                if (!relation.matches(pattern)) continue;
                relations.add(relation);
            }
        }
        List<Relation> result = relations.toSortedList();
        return result;
    }

    public List<Relation> toListSortedByTypeId() {
        List<Relation> result = this.toList();
        Collections.sort(result, new Comparator<Relation>(){

            @Override
            public int compare(Relation relation1, Relation relation2) {
                int result = relation1.getTypedId() - relation2.getTypedId();
                return result;
            }
        });
        return result;
    }
}

