/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.tip;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.tip.TIPLine;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.NetUtils;

public class TIPFile {
    private static final Logger logger = LoggerFactory.getLogger(TIPFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static Net load(File file) throws PuckException {
        Net result = TIPFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = TIPFile.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Net result = new Net();
        logger.debug("Read first block.");
        boolean ended = false;
        block11: while (!ended) {
            TIPLine source = TIPFile.readTIPLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            switch (source.lineType()) {
                case NET_INFO: {
                    result.attributes().put(source.propertyLabel(), source.propertyValue());
                    break;
                }
                case IDENTITY: {
                    Individual individual = result.get(source.individualId());
                    if (individual == null) {
                        individual = new Individual(source.individualId());
                        result.individuals().put(individual);
                    }
                    individual.setGender(source.gender());
                    individual.setName(source.name());
                    break;
                }
                case KINSHIP: {
                    switch (source.relation()) {
                        case FATHER: {
                            NetUtils.setFatherRelation(result, source.alterId(), source.individualId());
                            break;
                        }
                        case MOTHER: {
                            NetUtils.setMotherRelation(result, source.alterId(), source.individualId());
                            break;
                        }
                        case SPOUSE: {
                            NetUtils.setSpouseRelationAndFixRoles(result, source.individualId(), source.alterId());
                        }
                    }
                    continue block11;
                }
                case PROPERTY: {
                    NetUtils.setAttribute(result, source.individualId(), source.propertyLabel(), source.propertyValue());
                    NetUtils.setAttribute(result, source.individualId(), String.valueOf(source.propertyLabel()) + "_PLACE", source.propertyPlace());
                    NetUtils.setAttribute(result, source.individualId(), String.valueOf(source.propertyLabel()) + "_DATE", source.propertyDate());
                    if (source.alterId() == 0) break;
                    NetUtils.setAttribute(result, source.individualId(), String.valueOf(source.propertyLabel()) + "_ALTERID", String.valueOf(source.alterId()));
                }
            }
        }
        result = NetUtils.buildCleanedNet(result);
        logger.debug("Done.");
        return result;
    }

    public static TIPLine readTIPLine(BufferedReader in) throws PuckException {
        TIPLine result;
        try {
            String line = in.readLine();
            if (StringUtils.isBlank((CharSequence)line)) {
                result = null;
            } else {
                String[] tokens = line.split("\\t");
                if (tokens[0].startsWith("*")) {
                    result = new TIPLine(tokens[0].substring(1, tokens[0].indexOf(32)), tokens[0].substring(tokens[0].indexOf(32)));
                } else if (tokens[0].equals("0")) {
                    result = new TIPLine(Integer.parseInt(tokens[1]), Gender.valueOf(tokens[2].charAt(0)), tokens[3]);
                } else if (tokens[0].equals("1")) {
                    result = new TIPLine(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), TIPLine.Relation.values()[Integer.parseInt(tokens[3])]);
                } else if (tokens[0].equals("2")) {
                    result = new TIPLine(Integer.parseInt(tokens[1]), tokens[2], tokens[3], tokens[4], tokens[5], Integer.parseInt(tokens[6]));
                } else {
                    logger.warn("Ignoring unknown line type [" + tokens[0] + "]");
                    result = TIPFile.readTIPLine(in);
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                TIPFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void write(PrintWriter out, Net net) {
        logger.debug("Write first block labels.");
        for (Attribute attribute : net.attributes().toList()) {
            TIPFile.write(out, new TIPLine(attribute.getLabel(), attribute.getValue()));
        }
        for (Individual individual : net.individuals().toSortedList()) {
            TIPFile.write(out, new TIPLine(individual.getId(), individual.getGender(), individual.getName()));
            if (individual.getFather() != null) {
                TIPFile.write(out, new TIPLine(individual.getId(), individual.getFather().getId(), TIPLine.Relation.FATHER));
            }
            if (individual.getMother() != null) {
                TIPFile.write(out, new TIPLine(individual.getId(), individual.getMother().getId(), TIPLine.Relation.MOTHER));
            }
            for (Individual spouse : individual.getPartners()) {
                TIPFile.write(out, new TIPLine(individual.getId(), spouse.getId(), TIPLine.Relation.SPOUSE));
            }
        }
        out.println();
    }

    public static void write(PrintWriter out, TIPLine source) {
        if (source != null) {
            switch (source.lineType()) {
                case NET_INFO: {
                    out.println(String.format("*%s %s", source.propertyLabel(), source.propertyValue()));
                    break;
                }
                case IDENTITY: {
                    out.println(String.format("0\t%d\t%d\t%s", source.individualId(), source.gender().toInt(), source.name()));
                    break;
                }
                case KINSHIP: {
                    out.println(String.format("1\t%d\t%d\t%d", source.individualId(), source.alterId(), source.relation().ordinal()));
                    break;
                }
                case PROPERTY: {
                    out.println(String.format("2\t%d\t%s\t%s\t%s\t%s\t%d", source.individualId(), source.propertyLabel(), source.propertyValue(), source.propertyDate(), source.propertyPlace(), source.alterId()));
                }
            }
        }
    }
}

