/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.kinoath;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.kinoath.IndividualGroup;
import org.tip.puck.kinoath.IndividualGroups;
import org.tip.puck.kinoath.KinOathDiagram;
import org.tip.puck.kinoath.Puck2KinOath;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.kinoath.IndividualGroupsCellRenderer;
import org.tip.puckgui.views.kinoath.IndividualGroupsModel;
import org.tip.puckgui.views.kinoath.KinOathDiagramPanel;

public class IndividualGroupDiagramsPanel
extends JPanel {
    private static final long serialVersionUID = 651718283569255829L;
    private static final Logger logger = LoggerFactory.getLogger(IndividualGroupDiagramsPanel.class);
    int reportCounter = 0;
    private JPanel thisJPanel = this;
    private NetGUI netGUI;
    JList individualGroupList;
    JScrollPane individualGroupsScrollPane;
    KinOathDiagram diagram;
    private KinOathDiagramPanel diagramScrollPanel;

    public IndividualGroupDiagramsPanel(NetGUI guiManager, IndividualGroups source) {
        this.netGUI = guiManager;
        this.setLayout(new BoxLayout(this, 1));
        JSplitPane split = new JSplitPane();
        this.add(split);
        split.setAlignmentX(0.5f);
        JPanel individualGroupsPanel = new JPanel();
        individualGroupsPanel.setMinimumSize(new Dimension(200, 10));
        split.setLeftComponent(individualGroupsPanel);
        individualGroupsPanel.setLayout(new BoxLayout(individualGroupsPanel, 1));
        this.individualGroupsScrollPane = new JScrollPane();
        this.individualGroupsScrollPane.setVerticalScrollBarPolicy(22);
        individualGroupsPanel.add(this.individualGroupsScrollPane);
        this.individualGroupList = new JList();
        this.individualGroupList.setDoubleBuffered(true);
        this.individualGroupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                logger.debug("event = " + event.getValueIsAdjusting() + " " + event.getFirstIndex() + " " + event.getLastIndex() + " " + IndividualGroupDiagramsPanel.this.individualGroupList.getSelectedIndex());
                if (IndividualGroupDiagramsPanel.this.individualGroupList.getSelectedIndex() != -1) {
                    IndividualGroup group = (IndividualGroup)((JList)event.getSource()).getModel().getElementAt(IndividualGroupDiagramsPanel.this.individualGroupList.getSelectedIndex());
                    IndividualGroupDiagramsPanel.this.updateIndividualGroupDiagram(group);
                }
            }
        });
        this.individualGroupList.setSelectionMode(0);
        this.individualGroupList.setCellRenderer(new IndividualGroupsCellRenderer());
        this.individualGroupList.setModel(new IndividualGroupsModel(source));
        this.individualGroupsScrollPane.setViewportView(this.individualGroupList);
        JPanel diagramZonePanel = new JPanel();
        split.setRightComponent(diagramZonePanel);
        diagramZonePanel.setAlignmentX(0.0f);
        diagramZonePanel.setAlignmentY(0.0f);
        diagramZonePanel.setLayout(new BorderLayout(0, 0));
        JPanel parametersPanel = new JPanel();
        parametersPanel.setBorder(new EmptyBorder(0, 0, 2, 0));
        diagramZonePanel.add((Component)parametersPanel, "North");
        parametersPanel.setLayout(new BoxLayout(parametersPanel, 0));
        Component horizontalGlue_2 = Box.createHorizontalGlue();
        parametersPanel.add(horizontalGlue_2);
        JButton btnCenter = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("GlobalDiagramPanel.btnResetZoom.text"));
        parametersPanel.add(btnCenter);
        Component horizontalStrut_1 = Box.createHorizontalStrut(20);
        parametersPanel.add(horizontalStrut_1);
        JButton btnExport = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualGroupsDiagramPanel.btnExport.text"));
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    IndividualGroupDiagramsPanel.this.diagramScrollPanel.export();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        JButton btnCopy = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualGroupsDiagramPanel.btnCopy.text"));
        btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualGroupDiagramsPanel.this.diagramScrollPanel.copyToClipboard();
            }
        });
        parametersPanel.add(btnCopy);
        Component horizontalStrut_2 = Box.createHorizontalStrut(20);
        parametersPanel.add(horizontalStrut_2);
        parametersPanel.add(btnExport);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        parametersPanel.add(horizontalStrut);
        btnCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualGroupDiagramsPanel.this.diagramScrollPanel.resetZoom();
            }
        });
        JPanel diagramPanel = new JPanel();
        diagramZonePanel.add((Component)diagramPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        this.add(buttonsPanel);
        buttonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        JButton btnGroupsPrevious = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnPrevious.text"));
        btnGroupsPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualGroupDiagramsPanel.this.individualGroupList.getSelectedIndex();
                if (selectedIndex == -1) {
                    int size = IndividualGroupDiagramsPanel.this.individualGroupList.getModel().getSize();
                    if (size != 0) {
                        selectedIndex = size - 1;
                        IndividualGroupDiagramsPanel.this.individualGroupList.setSelectedIndex(selectedIndex);
                        IndividualGroupDiagramsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex > 0) {
                    IndividualGroupDiagramsPanel.this.individualGroupList.setSelectedIndex(--selectedIndex);
                    IndividualGroupDiagramsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        Component horizontalStrut_6 = Box.createHorizontalStrut(20);
        buttonsPanel.add(horizontalStrut_6);
        JButton btnClose = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnClose.text"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualGroupDiagramsPanel.this.netGUI.closeCurrentTab();
            }
        });
        buttonsPanel.add(btnClose);
        Component horizontalGlue_1 = Box.createHorizontalGlue();
        buttonsPanel.add(horizontalGlue_1);
        JButton btnSort = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.btnSort.text"));
        btnSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualGroup selectedGroup = IndividualGroupDiagramsPanel.this.getSelectedGroup();
                ((IndividualGroupsModel)IndividualGroupDiagramsPanel.this.individualGroupList.getModel()).touchSorting();
                if (selectedGroup != null) {
                    IndividualGroupDiagramsPanel.this.select(selectedGroup);
                }
            }
        });
        buttonsPanel.add(btnSort);
        Component horizontalGlue_4 = Box.createHorizontalGlue();
        buttonsPanel.add(horizontalGlue_4);
        buttonsPanel.add(btnGroupsPrevious);
        JButton btnGroupNext = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNext.text"));
        btnGroupNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualGroupDiagramsPanel.this.individualGroupList.getSelectedIndex();
                int size = IndividualGroupDiagramsPanel.this.individualGroupList.getModel().getSize();
                if (selectedIndex == -1) {
                    if (size != 0) {
                        selectedIndex = 0;
                        IndividualGroupDiagramsPanel.this.individualGroupList.setSelectedIndex(selectedIndex);
                        IndividualGroupDiagramsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex < size - 1) {
                    IndividualGroupDiagramsPanel.this.individualGroupList.setSelectedIndex(++selectedIndex);
                    IndividualGroupDiagramsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        buttonsPanel.add(btnGroupNext);
        Component horizontalGlue = Box.createHorizontalGlue();
        buttonsPanel.add(horizontalGlue);
        JPanel panel_13 = new JPanel();
        buttonsPanel.add(panel_13);
        panel_13.setLayout(new BoxLayout(panel_13, 0));
        this.diagramScrollPanel = new KinOathDiagramPanel();
        diagramPanel.setLayout(new BorderLayout(0, 0));
        diagramPanel.add((Component)((Object)this.diagramScrollPanel));
        JLabel label = new JLabel("zoom: shift-mouse right, scroll: shift-mouse left, crop: ctrl-mouse left, rotate: ctrl-mouse right");
        diagramZonePanel.add((Component)label, "South");
        this.selectByIndex(1);
    }

    public IndividualGroup getSelectedGroup() {
        IndividualGroup result = this.individualGroupList.getSelectedIndex() == -1 ? null : (IndividualGroup)((IndividualGroupsModel)this.individualGroupList.getModel()).getElementAt(this.individualGroupList.getSelectedIndex());
        return result;
    }

    public void select(IndividualGroup group) {
        int groupIndex = ((IndividualGroupsModel)this.individualGroupList.getModel()).indexOf(group);
        if (groupIndex >= 0 && groupIndex < ((IndividualGroupsModel)this.individualGroupList.getModel()).getSize()) {
            this.individualGroupList.setSelectedIndex(groupIndex);
            this.individualGroupList.ensureIndexIsVisible(groupIndex);
        } else if (((IndividualGroupsModel)this.individualGroupList.getModel()).getSize() != 0) {
            this.individualGroupList.setSelectedIndex(0);
            this.individualGroupList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualGroupDiagram(null);
        }
    }

    public void selectByIndex(int groupIndex) {
        if (groupIndex >= 0 && groupIndex < ((IndividualGroupsModel)this.individualGroupList.getModel()).getSize()) {
            this.individualGroupList.setSelectedIndex(groupIndex);
            this.individualGroupList.ensureIndexIsVisible(groupIndex);
        } else if (((IndividualGroupsModel)this.individualGroupList.getModel()).getSize() != 0) {
            this.individualGroupList.setSelectedIndex(0);
            this.individualGroupList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualGroupDiagram(null);
        }
    }

    public void updateIndividualGroupDiagram(IndividualGroup source) {
        if (source == null) {
            logger.debug("updateIndividualGroupDiagram(null)");
        } else {
            logger.debug("updateIndividualGroupDiagram(size=" + source.size() + ")");
            this.diagramScrollPanel.updateSource(Puck2KinOath.convert(source));
        }
    }

    public void updateGroupDiagram() {
        this.updateIndividualGroupDiagram(this.getSelectedGroup());
    }
}

