/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.JMapPane;
import org.geotools.swing.MapPane;
import org.geotools.swing.event.MapMouseAdapter;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.styling.JSimpleStyleDialog;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.geometry.Envelope;
import org.tip.puck.geo.tools.GeotoolsUtils;
import org.tip.puck.geo2.Place2;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.gis.SIGFile;
import org.tip.puckgui.util.GenericFileFilter;

public class MapPanel2
extends JPanel {
    private static final long serialVersionUID = -2451122245332109771L;
    private JTextField txtFile;
    StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
    public MapContent mapContent = new MapContent();
    private JTable table;
    JList listLayers = null;
    DefaultListModel listModel = new DefaultListModel();
    public double lastDraggedX = 0.0;
    public double lastDraggedY = 0.0;
    Tools selectedTool = Tools.DRAG;
    List<JToggleButton> listToggleButtons = new ArrayList<JToggleButton>();

    public MapPanel2(Graph<Place2> source) {
        this.setLayout(new BorderLayout(0, 0));
        final JMapPane mapPane = new JMapPane();
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.add((Component)tabbedPane, "Center");
        JPanel pMap = new JPanel();
        tabbedPane.addTab("Cartography", null, pMap, null);
        pMap.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        pMap.add(splitPane);
        JPanel panelRightMap = new JPanel();
        splitPane.setRightComponent(panelRightMap);
        panelRightMap.setLayout(new BorderLayout(0, 0));
        JMenuBar menuBarMap = new JMenuBar();
        panelRightMap.add((Component)menuBarMap, "North");
        final JToggleButton tglbtnDrag = new JToggleButton("");
        this.listToggleButtons.add(tglbtnDrag);
        tglbtnDrag.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionPan.png")));
        tglbtnDrag.setSelectedIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionPan_selected.png")));
        menuBarMap.add(tglbtnDrag);
        tglbtnDrag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel2.this.selectedTool = Tools.DRAG;
                MapPanel2.this.unselectToggleButtonsExcept(tglbtnDrag);
            }
        });
        final JToggleButton tglbtnSelect = new JToggleButton("");
        this.listToggleButtons.add(tglbtnSelect);
        tglbtnSelect.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionSelect.png")));
        tglbtnSelect.setSelectedIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionSelect_selected.png")));
        menuBarMap.add(tglbtnSelect);
        tglbtnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel2.this.selectedTool = Tools.SELECT;
                MapPanel2.this.unselectToggleButtonsExcept(tglbtnSelect);
            }
        });
        final JToggleButton tglbtnZoomIn = new JToggleButton("");
        this.listToggleButtons.add(tglbtnZoomIn);
        tglbtnZoomIn.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomIn.png")));
        tglbtnZoomIn.setSelectedIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomIn_selected.png")));
        menuBarMap.add(tglbtnZoomIn);
        tglbtnZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel2.this.selectedTool = Tools.ZOOMIN;
                MapPanel2.this.unselectToggleButtonsExcept(tglbtnZoomIn);
            }
        });
        final JToggleButton tglbtnZoomOut = new JToggleButton("");
        this.listToggleButtons.add(tglbtnZoomOut);
        tglbtnZoomOut.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomOut.png")));
        tglbtnZoomOut.setSelectedIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomOut_selected.png")));
        menuBarMap.add(tglbtnZoomOut);
        tglbtnZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel2.this.selectedTool = Tools.ZOOMOUT;
                MapPanel2.this.unselectToggleButtonsExcept(tglbtnZoomOut);
            }
        });
        JButton tglbtnCenterView = new JButton("");
        tglbtnCenterView.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomFullExtent.png")));
        menuBarMap.add(tglbtnCenterView);
        tglbtnCenterView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReferencedEnvelope env = MapPanel2.this.maximiseBoundsForLayers();
                mapPane.setDisplayArea((Envelope)env);
                mapPane.repaint();
            }
        });
        JButton btExportShapefile = new JButton("");
        btExportShapefile.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mSaveShapefile.png")));
        menuBarMap.add(btExportShapefile);
        btExportShapefile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel2.this.prepareExportShapeFile();
            }
        });
        JButton btExportSVG = new JButton("");
        btExportSVG.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mSaveSVG.png")));
        menuBarMap.add(btExportSVG);
        btExportSVG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel2.this.prepareExportSVG();
            }
        });
        JLabel statusBar = new JLabel("Status bar");
        panelRightMap.add((Component)statusBar, "South");
        mapPane.addMouseListener((MapMouseListener)new MapMouseAdapter(){

            public void onMouseClicked(MapMouseEvent ev) {
                DirectPosition2D pos = ev.getWorldPos();
                Coordinate coord = new Coordinate(pos.x, pos.y);
                ReferencedEnvelope env = mapPane.getDisplayArea();
                block0 : switch (ev.getButton()) {
                    case 1: {
                        switch (MapPanel2.this.selectedTool) {
                            case DRAG: {
                                env = MapPanel2.this.centerOn(env, coord);
                                break block0;
                            }
                            case ZOOMIN: {
                                env = MapPanel2.this.centerOn(env, coord);
                                double dh_zi = Math.abs(env.getHeight() - env.getHeight() * 1.03);
                                double dw_zi = Math.abs(env.getWidth() - env.getWidth() * 1.03);
                                env.expandBy(-Math.max(dh_zi, dw_zi));
                                break block0;
                            }
                            case ZOOMOUT: {
                                env = MapPanel2.this.centerOn(env, coord);
                                double dh_zo = Math.abs(env.getHeight() - env.getHeight() * 1.03);
                                double dw_zo = Math.abs(env.getWidth() - env.getWidth() * 1.03);
                                env.expandBy(Math.max(dh_zo, dw_zo));
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        env = MapPanel2.this.centerOn(env, coord);
                        break;
                    }
                }
                mapPane.setDisplayArea((Envelope)env);
                mapPane.repaint();
            }

            public void onMouseEntered(MapMouseEvent ev) {
            }

            public void onMouseExited(MapMouseEvent ev) {
            }
        });
        mapPane.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent ev) {
                switch (ev.getModifiers()) {
                    case 8: {
                        System.out.println(String.valueOf(ev.getX()) + " " + ev.getY());
                        Rectangle bounds = ev.getComponent().getBounds();
                        ReferencedEnvelope mapArea = mapPane.getDisplayArea();
                        double x = ev.getX();
                        double y = ev.getY();
                        double width = mapArea.getWidth();
                        double height = mapArea.getHeight();
                        double mapX = x * width / (double)bounds.width + mapArea.getMinX();
                        double mapY = (bounds.getHeight() - y) * height / (double)bounds.height + mapArea.getMinY();
                        if (MapPanel2.this.lastDraggedX > 0.0 && MapPanel2.this.lastDraggedY > 0.0) {
                            double dx = MapPanel2.this.lastDraggedX - mapX;
                            double dy = MapPanel2.this.lastDraggedY - mapY;
                            System.out.println(String.valueOf(mapX) + " " + mapY);
                            System.out.println(String.valueOf(dx) + " " + dy);
                            System.out.println();
                            Coordinate coord = new Coordinate(mapX + dx, mapY + dy);
                            ReferencedEnvelope env = MapPanel2.this.centerOn(mapArea, coord);
                            mapPane.setDisplayArea((Envelope)env);
                            mapPane.repaint();
                        }
                        MapPanel2.this.lastDraggedX = mapX;
                        MapPanel2.this.lastDraggedY = mapY;
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        mapPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent arg0) {
                ReferencedEnvelope env = mapPane.getDisplayArea();
                double clickToZoom = 0.03;
                int clicks = arg0.getWheelRotation();
                int sign = clicks < 0 ? -1 : 1;
                double width = env.getWidth();
                double delta = width * clickToZoom * (double)sign;
                env.expandBy(delta, delta);
                mapPane.setDisplayArea((Envelope)env);
                mapPane.repaint();
            }
        });
        panelRightMap.add((Component)mapPane, "Center");
        JPanel panelLeftList = new JPanel();
        splitPane.setLeftComponent(panelLeftList);
        panelLeftList.setLayout(new BorderLayout(0, 0));
        JMenuBar menuBarLayers = new JMenuBar();
        panelLeftList.add((Component)menuBarLayers, "South");
        JButton btnAddShapeLayer = new JButton("");
        btnAddShapeLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser inFileDlg = new JFileChooser("user.dir");
                inFileDlg.setFileFilter(new FileNameExtensionFilter("Shapefile (*.shp)", "shp"));
                int returnVal = inFileDlg.showOpenDialog(MapPanel2.this);
                if (returnVal == 0) {
                    String browseDir = inFileDlg.getCurrentDirectory().toString();
                    String inFile = null;
                    inFile = inFileDlg.getSelectedFile().toString();
                    inFileDlg.setCurrentDirectory(new File(inFile));
                    try {
                        MapPanel2.this.displaysShapefile(new File(inFile));
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        });
        btnAddShapeLayer.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
        menuBarLayers.add(btnAddShapeLayer);
        JButton btnRemoveShapeLayer = new JButton("");
        btnRemoveShapeLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String selectedLayerTitle = (String)MapPanel2.this.listLayers.getSelectedValue();
                Layer selectedLayer = null;
                for (Layer iterLayer : MapPanel2.this.mapContent.layers()) {
                    if (iterLayer.getTitle().compareTo(selectedLayerTitle) != 0) continue;
                    selectedLayer = iterLayer;
                    break;
                }
                MapPanel2.this.mapContent.removeLayer(selectedLayer);
                MapPanel2.this.listModel.removeElement(selectedLayerTitle);
                mapPane.repaint();
            }
        });
        btnRemoveShapeLayer.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
        menuBarLayers.add(btnRemoveShapeLayer);
        JButton btnLayerProperties = new JButton("");
        btnLayerProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String selectedLayerTitle = (String)MapPanel2.this.listLayers.getSelectedValue();
                Layer selectedLayer = null;
                for (Layer iterLayer : MapPanel2.this.mapContent.layers()) {
                    if (iterLayer.getTitle().compareTo(selectedLayerTitle) != 0) continue;
                    selectedLayer = iterLayer;
                    break;
                }
                if (selectedLayer != null) {
                    Style newStyle = JSimpleStyleDialog.showDialog(null, (SimpleFeatureType)((SimpleFeatureType)selectedLayer.getFeatureSource().getSchema()));
                    ((FeatureLayer)selectedLayer).setStyle(newStyle);
                    mapPane.repaint();
                }
            }
        });
        btnLayerProperties.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mParametersLayer.png")));
        menuBarLayers.add(btnLayerProperties);
        JButton btnLayerUp = new JButton("");
        btnLayerUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String selectedLayerTitle = (String)MapPanel2.this.listLayers.getSelectedValue();
                int selectedIndex = MapPanel2.this.listLayers.getSelectedIndex();
                Layer selectedLayer = null;
                int count = 0;
                for (Layer iterLayer : MapPanel2.this.mapContent.layers()) {
                    if (iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
                        selectedLayer = iterLayer;
                        break;
                    }
                    ++count;
                }
                int newPosition = count + 1;
                System.out.println(MapPanel2.this.mapContent.layers().size());
                System.out.println(MapPanel2.this.listModel.getSize());
                if (newPosition < MapPanel2.this.listModel.getSize()) {
                    MapPanel2.this.mapContent.moveLayer(count, newPosition);
                    MapPanel2.this.listModel.remove(selectedIndex);
                    if (selectedIndex - 1 < 0) {
                        selectedIndex = 0;
                    }
                    MapPanel2.this.listModel.insertElementAt(selectedLayerTitle, selectedIndex - 1);
                    MapPanel2.this.listLayers.setSelectedIndex(selectedIndex - 1);
                    mapPane.repaint();
                }
            }
        });
        btnLayerUp.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/up-16x16.png")));
        menuBarLayers.add(btnLayerUp);
        JButton btnLayerDown = new JButton("");
        btnLayerDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String selectedLayerTitle = (String)MapPanel2.this.listLayers.getSelectedValue();
                int selectedIndex = MapPanel2.this.listLayers.getSelectedIndex();
                Layer selectedLayer = null;
                int count = 0;
                for (Layer iterLayer : MapPanel2.this.mapContent.layers()) {
                    if (iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
                        selectedLayer = iterLayer;
                        break;
                    }
                    ++count;
                }
                int newPosition = count - 1;
                if (newPosition > -1) {
                    MapPanel2.this.mapContent.moveLayer(count, newPosition);
                    MapPanel2.this.listModel.remove(selectedIndex);
                    if (selectedIndex + 1 > MapPanel2.this.listModel.getSize()) {
                        selectedIndex = MapPanel2.this.listModel.getSize() - 1;
                    }
                    MapPanel2.this.listModel.insertElementAt(selectedLayerTitle, selectedIndex + 1);
                    mapPane.repaint();
                    MapPanel2.this.listLayers.setSelectedIndex(selectedIndex + 1);
                }
            }
        });
        btnLayerDown.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/down-16x16.png")));
        menuBarLayers.add(btnLayerDown);
        this.listLayers = new JList(this.listModel);
        panelLeftList.add((Component)this.listLayers, "Center");
        JPanel pConfig = new JPanel();
        tabbedPane.addTab("Parameters", null, pConfig, null);
        pConfig.setLayout(null);
        JCheckBox chckbxGeonames = new JCheckBox("Geonames");
        chckbxGeonames.setSelected(true);
        chckbxGeonames.setBounds(8, 8, 129, 23);
        pConfig.add(chckbxGeonames);
        JCheckBox chckbxPersonnalDatabase = new JCheckBox("Personnal Database");
        chckbxPersonnalDatabase.setBounds(8, 35, 175, 23);
        pConfig.add(chckbxPersonnalDatabase);
        this.txtFile = new JTextField();
        this.txtFile.setEnabled(false);
        this.txtFile.setText("File");
        this.txtFile.setBounds(23, 66, 114, 19);
        pConfig.add(this.txtFile);
        this.txtFile.setColumns(10);
        JButton btnNewButton = new JButton("Browse");
        btnNewButton.setEnabled(false);
        btnNewButton.setBounds(149, 63, 87, 25);
        pConfig.add(btnNewButton);
        JButton btnGeocode = new JButton("Geocode");
        btnGeocode.setBounds(316, 236, 117, 25);
        pConfig.add(btnGeocode);
        mapPane.setRenderer((GTRenderer)new StreamingRenderer());
        mapPane.setMapContent(this.mapContent);
        JPanel pTableGeoView = new JPanel();
        tabbedPane.addTab("Attributes table", null, pTableGeoView, null);
        pTableGeoView.setLayout(new BorderLayout(0, 0));
        JMenuBar menuBar = new JMenuBar();
        pTableGeoView.add((Component)menuBar, "North");
        JButton btnAddPoint = new JButton("");
        btnAddPoint.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
        menuBar.add(btnAddPoint);
        JButton btnDelPoint = new JButton("");
        btnDelPoint.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
        menuBar.add(btnDelPoint);
        this.table = new JTable();
        this.table.setSelectionMode(2);
        Object[] colName = new String[]{"id", "Name", "Country", "Long", "Lat"};
        DefaultTableModel modelAttributesTable = (DefaultTableModel)this.table.getModel();
        modelAttributesTable.setColumnIdentifiers(colName);
        this.table.setModel(modelAttributesTable);
        pTableGeoView.add((Component)this.table, "Center");
        try {
            this.displayWorldBorderShapefile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed = GeotoolsUtils.getFeaturesForNodesPlaces(source);
        this.diplayCollectionsPointsAndLines(collectionfeaturesReadyToBeDisplayed);
    }

    private DirectPosition2D calculateWorldPos(MapPane pane, MouseEvent event) {
        AffineTransform tr = pane.getScreenToWorldTransform();
        DirectPosition2D pos = new DirectPosition2D((double)event.getX(), (double)event.getY());
        tr.transform((Point2D)pos, (Point2D)pos);
        pos.setCoordinateReferenceSystem(pane.getMapContent().getCoordinateReferenceSystem());
        return pos;
    }

    private ReferencedEnvelope centerOn(ReferencedEnvelope env, Coordinate coordClicked) {
        Coordinate pEnv = env.centre();
        double dX = -(pEnv.x - coordClicked.x);
        double dY = -(pEnv.y - coordClicked.y);
        env.translate(dX, dY);
        return env;
    }

    private Style createFromSLD(File sld) {
        try {
            SLDParser stylereader = new SLDParser(this.styleFactory, sld.toURI().toURL());
            Style[] style = stylereader.readXML();
            return style[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Style createStyle(File file, FeatureSource<?, ?> featureSource) {
        File sld = this.toSLDFile(file);
        if (sld != null) {
            return this.createFromSLD(sld);
        }
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        return JSimpleStyleDialog.showDialog(null, (SimpleFeatureType)schema);
    }

    public void diplayCollectionsPointsAndLines(ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed) {
        SimpleFeatureSource featureSourcePoints = DataUtilities.source((FeatureCollection)((FeatureCollection)collectionfeaturesReadyToBeDisplayed.get(0)));
        Style stylePoints = this.createFromSLD(new File(MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/SCHEMA_POINTS.sld").getFile()));
        FeatureLayer layerPoints = new FeatureLayer((FeatureSource)featureSourcePoints, stylePoints);
        this.setUpTableData((FeatureSource<?, ?>)featureSourcePoints);
        ReferencedEnvelope bounds = layerPoints.getBounds();
        double dh = Math.abs(bounds.getHeight() - bounds.getHeight() * 1.1);
        double dw = Math.abs(bounds.getWidth() - bounds.getWidth() * 1.1);
        bounds.expandBy(Math.max(dh, dw));
        SimpleFeatureSource featureSourceLines = DataUtilities.source((FeatureCollection)((FeatureCollection)collectionfeaturesReadyToBeDisplayed.get(1)));
        Style styleLines = this.createFromSLD(new File(MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/SCHEMA_LINES.sld").getFile()));
        FeatureLayer layerLines = new FeatureLayer((FeatureSource)featureSourceLines, styleLines);
        this.mapContent.addLayer((Layer)layerPoints);
        layerPoints.setTitle("Points Layer");
        this.listModel.add(this.listModel.getSize() - 1, layerPoints.getTitle());
        this.mapContent.addLayer((Layer)layerLines);
        layerLines.setTitle("Links Layer");
        this.listModel.add(this.listModel.getSize() - 1, layerLines.getTitle());
        this.mapContent.getViewport().setBounds(bounds);
    }

    public void displayFeatureCollectionLayer(String title, FeatureCollection<?, ?> featureCollection, Style style) {
        FeatureLayer layer = new FeatureLayer(featureCollection, style);
        this.mapContent.addLayer((Layer)layer);
        layer.setTitle(title);
        this.listModel.addElement(title);
    }

    public void displayFeatureSourceLayer(String title, FeatureSource<?, ?> featureSource, Style style) {
        FeatureLayer layer = new FeatureLayer(featureSource, style);
        this.mapContent.addLayer((Layer)layer);
        layer.setTitle(title);
        this.listModel.addElement(title);
    }

    private void displaysShapefile(File file) throws IOException {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        Style style = this.createStyle(file, (FeatureSource<?, ?>)featureSource);
        this.displayFeatureSourceLayer(file.getName(), (FeatureSource<?, ?>)featureSource, style);
    }

    private void displaysShapefile(URL urlSHP, URL urlStyle) throws IOException {
        System.out.println("create style");
        System.out.println(urlStyle.getPath());
        Style style = this.createFromSLD(new File(urlStyle.getPath()));
        System.out.println(style.toString());
        FileDataStore store = FileDataStoreFinder.getDataStore((URL)urlSHP);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        this.displayFeatureSourceLayer("test", (FeatureSource<?, ?>)featureSource, style);
    }

    private void displayWorldBorderShapefile() throws IOException {
        String fileName = FilenameUtils.separatorsToSystem((String)MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.shp").getFile());
        URL urlShapeFile = MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.shp");
        URL urlStyle = MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.sld");
        System.out.println(urlShapeFile);
        this.displaysShapefile(urlShapeFile, urlStyle);
    }

    public List<Layer> getLayers() {
        return this.mapContent.layers();
    }

    public ReferencedEnvelope maximiseBoundsForLayers() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Layer iterLayer : this.getLayers()) {
            if (iterLayer.getTitle().compareTo("TM_WORLD_BORDERS-0.3.shp") == 0) continue;
            ReferencedEnvelope bounds = iterLayer.getBounds();
            double minXTemp = bounds.getMinX();
            minX = Math.min(minX, minXTemp);
            double maxXTemp = bounds.getMaxX();
            maxX = Math.max(maxX, maxXTemp);
            double minYTemp = bounds.getMinY();
            minY = Math.min(minY, minYTemp);
            double maxYTemp = bounds.getMaxY();
            maxY = Math.max(maxY, maxYTemp);
        }
        ReferencedEnvelope env = new ReferencedEnvelope();
        env.init(minX, maxX, minY, maxY);
        double dh = Math.abs(env.getHeight() - env.getHeight() * 1.1);
        double dw = Math.abs(env.getWidth() - env.getWidth() * 1.1);
        env.expandBy(Math.max(dh, dw));
        return env;
    }

    private void prepareExportShapeFile() {
        File targetFile = new File("exportPuck.shp");
        boolean ended = false;
        while (!ended) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(targetFile);
            chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
            chooser.setFileSelectionMode(0);
            chooser.setAcceptAllFileFilterUsed(false);
            GenericFileFilter defaultFileFilter = new GenericFileFilter("Shapefile (*.shp)", "shp");
            chooser.addChoosableFileFilter(defaultFileFilter);
            chooser.setFileFilter(defaultFileFilter);
            if (chooser.showSaveDialog(this) == 0) {
                boolean doSave;
                targetFile = chooser.getSelectedFile();
                if (targetFile.exists()) {
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                    int response = JOptionPane.showConfirmDialog(this, message, title, 1);
                    if (response == 0) {
                        doSave = true;
                        ended = true;
                    } else if (response == 1) {
                        doSave = false;
                        ended = false;
                    } else {
                        doSave = false;
                        ended = true;
                    }
                } else {
                    doSave = true;
                    ended = true;
                }
                if (!doSave) continue;
                SIGFile.exportToShapefile(this.getLayers(), targetFile);
                continue;
            }
            System.out.println("No Selection ");
            ended = true;
        }
    }

    private void prepareExportSVG() {
        File targetFile = new File("exportPuck.svg");
        boolean ended = false;
        while (!ended) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(targetFile);
            chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
            chooser.setFileSelectionMode(0);
            chooser.setAcceptAllFileFilterUsed(false);
            GenericFileFilter defaultFileFilter = new GenericFileFilter("Shapefile (*.shp)", "shp");
            chooser.addChoosableFileFilter(defaultFileFilter);
            chooser.setFileFilter(defaultFileFilter);
            if (chooser.showSaveDialog(this) == 0) {
                boolean doSave;
                targetFile = chooser.getSelectedFile();
                if (targetFile.exists()) {
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                    int response = JOptionPane.showConfirmDialog(this, message, title, 1);
                    if (response == 0) {
                        doSave = true;
                        ended = true;
                    } else if (response == 1) {
                        doSave = false;
                        ended = false;
                    } else {
                        doSave = false;
                        ended = true;
                    }
                } else {
                    doSave = true;
                    ended = true;
                }
                if (!doSave) continue;
                try {
                    FileOutputStream output = new FileOutputStream(targetFile);
                    ReferencedEnvelope env = this.maximiseBoundsForLayers();
                    SIGFile.exportSVG(this.mapContent, env, output, null);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("No Selection ");
            ended = true;
        }
    }

    public void setUpTableData(FeatureSource<?, ?> featureSourcePoints) {
        ArrayList<SimpleFeature> list;
        DefaultTableModel tableModel;
        block7: {
            tableModel = (DefaultTableModel)this.table.getModel();
            list = new ArrayList<SimpleFeature>();
            SimpleFeatureIterator iterator = null;
            try {
                try {
                    iterator = (SimpleFeatureIterator)featureSourcePoints.getFeatures().features();
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        list.add(feature);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    iterator.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                iterator.close();
                throw throwable;
            }
            iterator.close();
        }
        int index = 0;
        while (index < list.size()) {
            SimpleFeature feature = (SimpleFeature)list.get(index);
            Object[] data = new Object[5];
            data[0] = feature.getAttribute(0);
            data[1] = feature.getAttribute(1);
            data[2] = feature.getAttribute(2);
            Geometry g = (Geometry)feature.getAttribute("the_geom");
            data[3] = new Double(g.getCoordinate().x);
            data[4] = new Double(g.getCoordinate().y);
            tableModel.addRow(data);
            ++index;
        }
        this.table.setModel(tableModel);
        tableModel.fireTableDataChanged();
        this.table.repaint();
    }

    public File toSLDFile(File file) {
        String path = file.getAbsolutePath();
        String base = path.substring(0, path.length() - 4);
        String newPath = String.valueOf(base) + ".sld";
        File sld = new File(newPath);
        if (sld.exists()) {
            return sld;
        }
        newPath = String.valueOf(base) + ".SLD";
        sld = new File(newPath);
        if (sld.exists()) {
            return sld;
        }
        return null;
    }

    private void unselectToggleButtonsExcept(JToggleButton tglbSelected) {
        for (JToggleButton iterTglb : this.listToggleButtons) {
            iterTglb.setSelected(false);
        }
        tglbSelected.setSelected(true);
    }

    private static enum Tools {
        DRAG,
        SELECT,
        ZOOMIN,
        ZOOMOUT;

    }
}

