/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geneaquilt;

import fr.inria.aviz.geneaquilt.gui.quiltview.GeneaQuiltPanel;
import fr.inria.aviz.geneaquilt.model.Network;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.kinoath.IndividualGroup;
import org.tip.puck.kinoath.IndividualGroups;
import org.tip.puck.kinoath.KinOathDiagram;
import org.tip.puck.net.Families;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.GeneaQuiltConvert;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.kinoath.IndividualGroupsCellRenderer;
import org.tip.puckgui.views.kinoath.IndividualGroupsModel;

public class IndividualGroupQuiltsPanel
extends JPanel {
    private static final long serialVersionUID = 651718283569255829L;
    private static final Logger logger = LoggerFactory.getLogger(IndividualGroupQuiltsPanel.class);
    int reportCounter = 0;
    private JPanel thisJPanel = this;
    private NetGUI netGUI;
    JList individualGroupList;
    JScrollPane individualGroupsScrollPane;
    KinOathDiagram diagram;
    private GeneaQuiltPanel geneaQuiltPanel;
    private JSplitPane split;

    public IndividualGroupQuiltsPanel(NetGUI guiManager, IndividualGroups source) {
        this.netGUI = guiManager;
        this.setLayout(new BoxLayout(this, 1));
        this.split = new JSplitPane();
        this.add(this.split);
        this.split.setAlignmentX(0.5f);
        JPanel individualGroupsPanel = new JPanel();
        individualGroupsPanel.setMinimumSize(new Dimension(200, 10));
        this.split.setLeftComponent(individualGroupsPanel);
        individualGroupsPanel.setLayout(new BoxLayout(individualGroupsPanel, 1));
        this.individualGroupsScrollPane = new JScrollPane();
        this.individualGroupsScrollPane.setVerticalScrollBarPolicy(22);
        individualGroupsPanel.add(this.individualGroupsScrollPane);
        this.individualGroupList = new JList();
        this.individualGroupList.setDoubleBuffered(true);
        this.individualGroupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                logger.debug("event = " + event.getValueIsAdjusting() + " " + event.getFirstIndex() + " " + event.getLastIndex() + " " + IndividualGroupQuiltsPanel.this.individualGroupList.getSelectedIndex());
                if (IndividualGroupQuiltsPanel.this.individualGroupList.getSelectedIndex() != -1) {
                    IndividualGroup group = (IndividualGroup)((JList)event.getSource()).getModel().getElementAt(IndividualGroupQuiltsPanel.this.individualGroupList.getSelectedIndex());
                    IndividualGroupQuiltsPanel.this.updateIndividualGroupDiagram(group);
                }
            }
        });
        this.individualGroupList.setSelectionMode(0);
        this.individualGroupList.setCellRenderer(new IndividualGroupsCellRenderer());
        this.individualGroupList.setModel(new IndividualGroupsModel(source));
        this.individualGroupsScrollPane.setViewportView(this.individualGroupList);
        this.geneaQuiltPanel = new GeneaQuiltPanel(null, null);
        this.split.setRightComponent((Component)this.geneaQuiltPanel);
        JPanel buttonsPanel = new JPanel();
        this.add(buttonsPanel);
        buttonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        JButton btnGroupsPrevious = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnPrevious.text"));
        btnGroupsPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualGroupQuiltsPanel.this.individualGroupList.getSelectedIndex();
                if (selectedIndex == -1) {
                    int size = IndividualGroupQuiltsPanel.this.individualGroupList.getModel().getSize();
                    if (size != 0) {
                        selectedIndex = size - 1;
                        IndividualGroupQuiltsPanel.this.individualGroupList.setSelectedIndex(selectedIndex);
                        IndividualGroupQuiltsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex > 0) {
                    IndividualGroupQuiltsPanel.this.individualGroupList.setSelectedIndex(--selectedIndex);
                    IndividualGroupQuiltsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        Component horizontalStrut_6 = Box.createHorizontalStrut(20);
        buttonsPanel.add(horizontalStrut_6);
        JButton btnClose = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnClose.text"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualGroupQuiltsPanel.this.netGUI.closeCurrentTab();
            }
        });
        buttonsPanel.add(btnClose);
        Component horizontalGlue_1 = Box.createHorizontalGlue();
        buttonsPanel.add(horizontalGlue_1);
        JButton btnSort = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.btnSort.text"));
        btnSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualGroup selectedGroup = IndividualGroupQuiltsPanel.this.getSelectedGroup();
                ((IndividualGroupsModel)IndividualGroupQuiltsPanel.this.individualGroupList.getModel()).touchSorting();
                if (selectedGroup != null) {
                    IndividualGroupQuiltsPanel.this.select(selectedGroup);
                }
            }
        });
        buttonsPanel.add(btnSort);
        Component horizontalGlue_4 = Box.createHorizontalGlue();
        buttonsPanel.add(horizontalGlue_4);
        buttonsPanel.add(btnGroupsPrevious);
        JButton btnGroupNext = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNext.text"));
        btnGroupNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualGroupQuiltsPanel.this.individualGroupList.getSelectedIndex();
                int size = IndividualGroupQuiltsPanel.this.individualGroupList.getModel().getSize();
                if (selectedIndex == -1) {
                    if (size != 0) {
                        selectedIndex = 0;
                        IndividualGroupQuiltsPanel.this.individualGroupList.setSelectedIndex(selectedIndex);
                        IndividualGroupQuiltsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex < size - 1) {
                    IndividualGroupQuiltsPanel.this.individualGroupList.setSelectedIndex(++selectedIndex);
                    IndividualGroupQuiltsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        buttonsPanel.add(btnGroupNext);
        Component horizontalGlue = Box.createHorizontalGlue();
        buttonsPanel.add(horizontalGlue);
        JPanel panel_13 = new JPanel();
        buttonsPanel.add(panel_13);
        panel_13.setLayout(new BoxLayout(panel_13, 0));
        this.selectByIndex(1);
    }

    public IndividualGroup getSelectedGroup() {
        IndividualGroup result = this.individualGroupList.getSelectedIndex() == -1 ? null : (IndividualGroup)((IndividualGroupsModel)this.individualGroupList.getModel()).getElementAt(this.individualGroupList.getSelectedIndex());
        return result;
    }

    public void select(IndividualGroup group) {
        int groupIndex = ((IndividualGroupsModel)this.individualGroupList.getModel()).indexOf(group);
        if (groupIndex >= 0 && groupIndex < ((IndividualGroupsModel)this.individualGroupList.getModel()).getSize()) {
            this.individualGroupList.setSelectedIndex(groupIndex);
            this.individualGroupList.ensureIndexIsVisible(groupIndex);
        } else if (((IndividualGroupsModel)this.individualGroupList.getModel()).getSize() != 0) {
            this.individualGroupList.setSelectedIndex(0);
            this.individualGroupList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualGroupDiagram(null);
        }
    }

    public void selectByIndex(int groupIndex) {
        if (groupIndex >= 0 && groupIndex < ((IndividualGroupsModel)this.individualGroupList.getModel()).getSize()) {
            this.individualGroupList.setSelectedIndex(groupIndex);
            this.individualGroupList.ensureIndexIsVisible(groupIndex);
        } else if (((IndividualGroupsModel)this.individualGroupList.getModel()).getSize() != 0) {
            this.individualGroupList.setSelectedIndex(0);
            this.individualGroupList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualGroupDiagram(null);
        }
    }

    public void updateGroupDiagram() {
        this.updateIndividualGroupDiagram(this.getSelectedGroup());
    }

    public void updateIndividualGroupDiagram(IndividualGroup source) {
        if (source == null) {
            logger.debug("updateIndividualGroupDiagram(null)");
        } else {
            logger.debug("updateIndividualGroupDiagram(size=" + source.size() + ")");
            this.split.remove((Component)this.geneaQuiltPanel);
            Families families = new Families();
            for (Individual individual : source) {
                families.add(individual.getOriginFamily());
                families.add(individual.getPersonalFamilies());
            }
            Network network = GeneaQuiltConvert.convertToGeneaQuilt(source, families);
            this.geneaQuiltPanel = new GeneaQuiltPanel((JComponent)this, network);
            this.split.setRightComponent((Component)this.geneaQuiltPanel);
        }
    }
}

