/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geneaquilt;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import fr.inria.aviz.geneaquilt.gui.quiltview.GeneaQuiltPanel;
import fr.inria.aviz.geneaquilt.model.Network;
import fr.inria.aviz.geneaquilt.model.VertexComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.kinoath.IndividualGroup;
import org.tip.puck.kinoath.IndividualGroups;
import org.tip.puck.kinoath.KinOathDiagram;
import org.tip.puck.net.Families;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.GeneaQuiltConvert;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.geneaquilt.EventQuiltCriteria;
import org.tip.puckgui.views.kinoath.IndividualGroupsCellRenderer;
import org.tip.puckgui.views.kinoath.IndividualGroupsModel;

public class IndividualGroupEventQuiltsPanel
extends JPanel {
    private static final long serialVersionUID = 651718283569255829L;
    private static final Logger logger = LoggerFactory.getLogger(IndividualGroupEventQuiltsPanel.class);
    private static EventQuiltCriteria eventQuiltCriteria = new EventQuiltCriteria();
    private JPanel thisJPanel = this;
    private NetGUI netGUI;
    JList individualGroupList;
    JScrollPane individualGroupsScrollPane;
    KinOathDiagram diagram;
    private GeneaQuiltPanel geneaQuiltPanel;
    private JSplitPane split;
    private JCheckBox chckbxUndatedEvents;
    private JPanel pnlModels;
    private JComboBox cmbxComponentSteps;
    private JCheckBox chckbxUnlinkedIndividuals;

    public IndividualGroupEventQuiltsPanel(NetGUI guiManager, IndividualGroups source) {
        this.netGUI = guiManager;
        this.setLayout(new BoxLayout(this, 1));
        this.split = new JSplitPane();
        this.add(this.split);
        this.split.setAlignmentX(0.5f);
        JPanel individualGroupsPanel = new JPanel();
        individualGroupsPanel.setMinimumSize(new Dimension(200, 10));
        this.split.setLeftComponent(individualGroupsPanel);
        individualGroupsPanel.setLayout(new BorderLayout(0, 0));
        this.individualGroupsScrollPane = new JScrollPane();
        this.individualGroupsScrollPane.setVerticalScrollBarPolicy(22);
        individualGroupsPanel.add(this.individualGroupsScrollPane);
        this.individualGroupList = new JList();
        this.individualGroupList.setDoubleBuffered(true);
        this.individualGroupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                logger.debug("event = " + event.getValueIsAdjusting() + " " + event.getFirstIndex() + " " + event.getLastIndex() + " " + IndividualGroupEventQuiltsPanel.this.individualGroupList.getSelectedIndex());
                if (IndividualGroupEventQuiltsPanel.this.individualGroupList.getSelectedIndex() != -1) {
                    IndividualGroup group = (IndividualGroup)((JList)event.getSource()).getModel().getElementAt(IndividualGroupEventQuiltsPanel.this.individualGroupList.getSelectedIndex());
                    IndividualGroupEventQuiltsPanel.this.updateModels();
                    IndividualGroupEventQuiltsPanel.this.updateIndividualGroupDiagram(group);
                }
            }
        });
        this.individualGroupList.setSelectionMode(0);
        this.individualGroupList.setCellRenderer(new IndividualGroupsCellRenderer());
        this.individualGroupList.setModel(new IndividualGroupsModel(source));
        this.individualGroupsScrollPane.setViewportView(this.individualGroupList);
        JPanel panel = new JPanel();
        individualGroupsPanel.add((Component)panel, "South");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonsPanel = new JPanel();
        panel.add((Component)buttonsPanel, "North");
        buttonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        JButton btnGroupsPrevious = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnPrevious.text"));
        btnGroupsPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualGroupEventQuiltsPanel.this.individualGroupList.getSelectedIndex();
                if (selectedIndex == -1) {
                    int size = IndividualGroupEventQuiltsPanel.this.individualGroupList.getModel().getSize();
                    if (size != 0) {
                        selectedIndex = size - 1;
                        IndividualGroupEventQuiltsPanel.this.individualGroupList.setSelectedIndex(selectedIndex);
                        IndividualGroupEventQuiltsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex > 0) {
                    IndividualGroupEventQuiltsPanel.this.individualGroupList.setSelectedIndex(--selectedIndex);
                    IndividualGroupEventQuiltsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        JButton btnSort = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.btnSort.text"));
        buttonsPanel.add(btnSort);
        btnSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualGroup selectedGroup = IndividualGroupEventQuiltsPanel.this.getSelectedGroup();
                ((IndividualGroupsModel)IndividualGroupEventQuiltsPanel.this.individualGroupList.getModel()).touchSorting();
                if (selectedGroup != null) {
                    IndividualGroupEventQuiltsPanel.this.select(selectedGroup);
                }
            }
        });
        Component horizontalGlue = Box.createHorizontalGlue();
        buttonsPanel.add(horizontalGlue);
        buttonsPanel.add(btnGroupsPrevious);
        JButton btnGroupNext = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNext.text"));
        btnGroupNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualGroupEventQuiltsPanel.this.individualGroupList.getSelectedIndex();
                int size = IndividualGroupEventQuiltsPanel.this.individualGroupList.getModel().getSize();
                if (selectedIndex == -1) {
                    if (size != 0) {
                        selectedIndex = 0;
                        IndividualGroupEventQuiltsPanel.this.individualGroupList.setSelectedIndex(selectedIndex);
                        IndividualGroupEventQuiltsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex < size - 1) {
                    IndividualGroupEventQuiltsPanel.this.individualGroupList.setSelectedIndex(++selectedIndex);
                    IndividualGroupEventQuiltsPanel.this.individualGroupList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        buttonsPanel.add(btnGroupNext);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonsPanel.add(horizontalStrut);
        JPanel panel_13 = new JPanel();
        buttonsPanel.add(panel_13);
        panel_13.setLayout(new BoxLayout(panel_13, 0));
        JPanel panelLeftControls = new JPanel();
        panelLeftControls.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "On selection", 4, 2, null, new Color(51, 51, 51)));
        panel.add((Component)panelLeftControls, "Center");
        panelLeftControls.setPreferredSize(new Dimension(10, 300));
        panelLeftControls.setMinimumSize(new Dimension(10, 400));
        panelLeftControls.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblComponentSteps = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualGroupEventQuiltsPanel.lblComponentSteps.text"));
        lblComponentSteps.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualGroupEventQuiltsPanel.lblComponentSteps.toolTipText"));
        panelLeftControls.add((Component)lblComponentSteps, "2, 2, right, default");
        this.cmbxComponentSteps = new JComboBox();
        this.cmbxComponentSteps.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                IndividualGroupEventQuiltsPanel.this.refreshGroupDiagram();
            }
        });
        this.cmbxComponentSteps.setModel(new DefaultComboBoxModel<String>(new String[]{"NONE", "1"}));
        panelLeftControls.add((Component)this.cmbxComponentSteps, "4, 2, fill, default");
        this.chckbxUndatedEvents = new JCheckBox(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualGroupEventQuiltsPanel.chckbxWoDateEvents.text"));
        this.chckbxUndatedEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualGroupEventQuiltsPanel.this.refreshGroupDiagram();
            }
        });
        this.chckbxUndatedEvents.setSelected(true);
        panelLeftControls.add((Component)this.chckbxUndatedEvents, "2, 4, 3, 1");
        this.chckbxUnlinkedIndividuals = new JCheckBox(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualGroupEventQuiltsPanel.chckbxUnlinkedIndividuals.text"));
        this.chckbxUnlinkedIndividuals.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                IndividualGroupEventQuiltsPanel.this.refreshGroupDiagram();
            }
        });
        this.chckbxUnlinkedIndividuals.setSelected(true);
        panelLeftControls.add((Component)this.chckbxUnlinkedIndividuals, "2, 6, 3, 1");
        JLabel lblRelations = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualGroupEventQuiltsPanel.lblRelations.text"));
        panelLeftControls.add((Component)lblRelations, "2, 8, 3, 1");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        panelLeftControls.add((Component)scrollPane, "2, 10, 3, 1, fill, fill");
        this.pnlModels = new JPanel();
        scrollPane.setViewportView(this.pnlModels);
        this.pnlModels.setLayout(new BoxLayout(this.pnlModels, 1));
        this.geneaQuiltPanel = new GeneaQuiltPanel(null, null);
        this.split.setRightComponent((Component)this.geneaQuiltPanel);
        this.setCriteria(eventQuiltCriteria);
        this.selectByIndex(1);
    }

    private EventQuiltCriteria getCriteria() {
        EventQuiltCriteria result = new EventQuiltCriteria();
        result.setShowUndatedEvent(this.chckbxUndatedEvents.isSelected());
        result.setShowUnlinkedIndividual(this.chckbxUnlinkedIndividuals.isSelected());
        try {
            String value = (String)this.cmbxComponentSteps.getSelectedItem();
            Long number = Long.parseLong(value);
            result.setComponentSteps(number);
        }
        catch (NumberFormatException exception) {
            result.setComponentSteps(null);
        }
        result.getModels().clear();
        Component[] componentArray = this.pnlModels.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (((JCheckBox)component).isSelected()) {
                result.getModels().add((Object)((JCheckBox)component).getText());
            }
            ++n2;
        }
        logger.debug("models=[{}]", (Object)result.getModels().toStringWithCommas());
        return result;
    }

    public IndividualGroup getSelectedGroup() {
        IndividualGroup result = this.individualGroupList.getSelectedIndex() == -1 ? null : (IndividualGroup)((IndividualGroupsModel)this.individualGroupList.getModel()).getElementAt(this.individualGroupList.getSelectedIndex());
        return result;
    }

    public void refreshGroupDiagram() {
        this.refreshIndividualGroupDiagram(this.getSelectedGroup());
    }

    public void refreshIndividualGroupDiagram(IndividualGroup source) {
        if (source == null) {
            logger.debug("updateIndividualGroupDiagram(null)");
        } else {
            IndividualGroup target;
            logger.debug("updateIndividualGroupDiagram(size=" + source.size() + ")");
            EventQuiltCriteria criteria = this.getCriteria();
            logger.debug("Component step=[{}]", (Object)criteria.getComponentSteps());
            if (criteria.getComponentSteps() == null) {
                target = source;
            } else {
                target = new IndividualGroup(source);
                for (Individual individual : source) {
                    if (criteria.getModels().contains((Object)"Family (core)")) {
                        target.add(individual.getParents());
                        target.add(individual.getPartners());
                        target.add(individual.children());
                    }
                    for (Object relation : individual.relations()) {
                        if (!criteria.getModels().contains((Object)((Relation)relation).getModel().getName())) continue;
                        target.add(((Relation)relation).getIndividuals());
                    }
                }
            }
            this.split.remove((Component)this.geneaQuiltPanel);
            Families families = new Families();
            if (criteria.getModels().contains((Object)"Family (core)")) {
                for (Individual individual : source) {
                    families.add(individual.getOriginFamily());
                    families.add(individual.getPersonalFamilies());
                }
            }
            Relations relations = new Relations();
            for (Individual individual : source) {
                for (Relation relation : individual.relations()) {
                    if (!criteria.getModels().contains((Object)relation.getModel().getName())) continue;
                    relations.add(individual.relations());
                }
            }
            Network network = GeneaQuiltConvert.convertToEventQuilt(target, families, relations, this.getCriteria());
            this.geneaQuiltPanel = new GeneaQuiltPanel((JComponent)this, network, VertexComparator.Sorting.DATERANGE_START);
            this.split.setRightComponent((Component)this.geneaQuiltPanel);
        }
    }

    public void select(IndividualGroup group) {
        int groupIndex = ((IndividualGroupsModel)this.individualGroupList.getModel()).indexOf(group);
        if (groupIndex >= 0 && groupIndex < ((IndividualGroupsModel)this.individualGroupList.getModel()).getSize()) {
            this.individualGroupList.setSelectedIndex(groupIndex);
            this.individualGroupList.ensureIndexIsVisible(groupIndex);
            this.updateModels();
        } else if (((IndividualGroupsModel)this.individualGroupList.getModel()).getSize() != 0) {
            this.individualGroupList.setSelectedIndex(0);
            this.individualGroupList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualGroupDiagram(null);
        }
    }

    public void selectByIndex(int groupIndex) {
        if (groupIndex >= 0 && groupIndex < ((IndividualGroupsModel)this.individualGroupList.getModel()).getSize()) {
            this.individualGroupList.setSelectedIndex(groupIndex);
            this.individualGroupList.ensureIndexIsVisible(groupIndex);
        } else if (((IndividualGroupsModel)this.individualGroupList.getModel()).getSize() != 0) {
            this.individualGroupList.setSelectedIndex(0);
            this.individualGroupList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualGroupDiagram(null);
        }
    }

    private void setCriteria(EventQuiltCriteria source) {
        if (source != null) {
            this.chckbxUndatedEvents.setSelected(source.isShowUndatedEvent());
            this.chckbxUnlinkedIndividuals.setSelected(source.isShowUnlinkedIndividual());
            if (source.getComponentSteps() == null) {
                this.cmbxComponentSteps.setSelectedIndex(0);
            } else {
                this.cmbxComponentSteps.setSelectedItem(String.valueOf(source.getComponentSteps()));
            }
        }
    }

    public void updateGroupDiagram() {
        this.updateIndividualGroupDiagram(this.getSelectedGroup());
    }

    public void updateIndividualGroupDiagram(IndividualGroup source) {
        this.updateModels();
        this.refreshIndividualGroupDiagram(source);
    }

    private void updateModels() {
        this.pnlModels.removeAll();
        IndividualGroup group = this.getSelectedGroup();
        StringSet modelNames = new StringSet();
        for (Individual individual : group) {
            for (Relation relation : individual.relations()) {
                modelNames.put(relation.getModel().getName());
            }
        }
        StringList modelNameList = new StringList();
        modelNameList.append("Family (core)");
        modelNameList.append(modelNames.toStringList().sort());
        for (String modelName : modelNameList) {
            JCheckBox checkbox = new JCheckBox(modelName);
            checkbox.setSelected(true);
            this.pnlModels.add(checkbox);
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    IndividualGroupEventQuiltsPanel.this.refreshGroupDiagram();
                }
            });
        }
    }
}

