/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.SnowballCriteria;

public class SnowballStructureInputDialog
extends JDialog {
    private static final long serialVersionUID = -8101768566224840177L;
    private final JPanel contentPanel = new JPanel();
    private SnowballCriteria dialogCriteria;
    private static SnowballCriteria lastCriteria = new SnowballCriteria();
    private JComboBox cmbbxExpansionMode;
    private JSpinner spnrSeedReferenceYear;
    private JSpinner spnrMaxStepCount;
    private JComboBox cmbxSeedLabel;
    private JComboBox cmbxReachLabel;
    private JTextField txtfldSeedValue;

    public SnowballStructureInputDialog(AttributeDescriptors attributeDescriptors) {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Snowball Structure Input Dialog");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(SnowballStructureInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SnowballStructureInputDialog.this.dialogCriteria = null;
                SnowballStructureInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 400, 270);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSeedLabel = new JLabel("Seed Label:");
        this.contentPanel.add((Component)lblSeedLabel, "2, 2, right, default");
        this.cmbxSeedLabel = new JComboBox();
        this.contentPanel.add((Component)this.cmbxSeedLabel, "4, 2, fill, default");
        JLabel lblSeedValue = new JLabel("Seed Value:");
        this.contentPanel.add((Component)lblSeedValue, "2, 4, right, default");
        this.txtfldSeedValue = new JTextField();
        this.contentPanel.add((Component)this.txtfldSeedValue, "4, 4, fill, default");
        this.txtfldSeedValue.setColumns(10);
        JLabel lblReachLabel = new JLabel("Reach Label:");
        this.contentPanel.add((Component)lblReachLabel, "2, 6, right, default");
        this.cmbxReachLabel = new JComboBox();
        this.contentPanel.add((Component)this.cmbxReachLabel, "4, 6, fill, default");
        JLabel lblExpansionmode = new JLabel("ExpansionMode:");
        this.contentPanel.add((Component)lblExpansionmode, "2, 8, right, default");
        this.cmbbxExpansionMode = new JComboBox<Object>(ExpansionMode.getActiveLabels().toArray());
        this.contentPanel.add((Component)this.cmbbxExpansionMode, "4, 8, fill, default");
        JLabel lblMaxStepCount = new JLabel("Max Step Count:");
        this.contentPanel.add((Component)lblMaxStepCount, "2, 11, right, default");
        this.spnrMaxStepCount = new JSpinner();
        this.spnrMaxStepCount.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.contentPanel.add((Component)this.spnrMaxStepCount, "4, 11");
        JLabel lblSeedReferenceYear = new JLabel("Seed Reference Year:");
        this.contentPanel.add((Component)lblSeedReferenceYear, "2, 13, right, default");
        this.spnrSeedReferenceYear = new JSpinner();
        this.spnrSeedReferenceYear.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.contentPanel.add((Component)this.spnrSeedReferenceYear, "4, 13");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnowballStructureInputDialog.this.dialogCriteria = null;
                SnowballStructureInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("Launch");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnowballCriteria criteria = SnowballStructureInputDialog.this.getCriteria();
                lastCriteria = criteria;
                SnowballStructureInputDialog.this.dialogCriteria = criteria;
                SnowballStructureInputDialog.this.setVisible(false);
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        Object[] labels = attributeDescriptors.labelsSorted().toArray();
        this.cmbxSeedLabel.setModel(new DefaultComboBoxModel<Object>(labels));
        this.cmbxReachLabel.setModel(new DefaultComboBoxModel<Object>(labels));
        this.setCriteria(lastCriteria);
    }

    public SnowballCriteria getCriteria() {
        SnowballCriteria result = new SnowballCriteria();
        result.setSeedLabel((String)this.cmbxSeedLabel.getSelectedItem());
        result.setSeedValue(StringUtils.trim((String)this.txtfldSeedValue.getText()));
        result.setReachLabel((String)this.cmbxReachLabel.getSelectedItem());
        result.setExpansionMode(ExpansionMode.valueOf((String)this.cmbbxExpansionMode.getSelectedItem()));
        result.setMaxNrSteps((Integer)this.spnrMaxStepCount.getValue());
        result.setSeedReferenceYear((Integer)this.spnrSeedReferenceYear.getValue());
        return result;
    }

    public SnowballCriteria getDialogCriteria() {
        SnowballCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(SnowballCriteria source) {
        if (source != null) {
            this.cmbxSeedLabel.setSelectedItem(source.getSeedLabel());
            this.txtfldSeedValue.setText(source.getSeedValue());
            this.cmbxReachLabel.setSelectedItem(source.getReachLabel());
            this.cmbbxExpansionMode.setSelectedItem(source.getExpansionMode().name());
            this.spnrMaxStepCount.setValue(source.getMaxNrSteps());
            this.spnrSeedReferenceYear.setValue(source.getSeedReferenceYear());
        }
    }

    public static void main(String[] args) {
        SnowballStructureInputDialog.showDialog(null);
    }

    public static SnowballCriteria showDialog(AttributeDescriptors attributeDescriptors) {
        SnowballStructureInputDialog dialog = new SnowballStructureInputDialog(attributeDescriptors);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        SnowballCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

