/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import fr.devinsy.flatdb4geonames.swing.FlatDB4GeoNamesRequestPanel;
import fr.devinsy.flatdb4geonames.swing.downloaddatabase.DownloadDatabaseDialog;
import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import fr.inria.aviz.geneaquilt.gui.quiltview.GeneaQuiltPanel;
import fr.inria.aviz.geneaquilt.model.Network;
import fr.inria.aviz.geneaquilt.model.VertexComparator;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.PuckManager;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.KinshipChainsCriteria;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.io.GEOXLSFile;
import org.tip.puck.geo2.workers.GeocodingWorker;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.io.bar.BARFile;
import org.tip.puck.io.dat.DAT1File;
import org.tip.puck.io.ged.IdShrinker;
import org.tip.puck.io.iur.IURFile;
import org.tip.puck.io.kinsources.CatalogItem;
import org.tip.puck.io.kinsources.KinsourcesFile;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.io.selz.SELZFile;
import org.tip.puck.kinoath.ComponentWorker;
import org.tip.puck.kinoath.IndividualGroups;
import org.tip.puck.kinoath.SegmentationWorker;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.random.RandomNetReporter;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.AddChildRolesCriteria;
import org.tip.puck.net.relations.workers.RelationModelMaker;
import org.tip.puck.net.relations.workers.RelationModelReporter;
import org.tip.puck.net.relations.workers.RelationModelTXTFile;
import org.tip.puck.net.relations.workers.RelationReporter;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeFilter;
import org.tip.puck.net.workers.AttributeRenameCriteria;
import org.tip.puck.net.workers.AttributeReplaceValueCriteria;
import org.tip.puck.net.workers.AttributeSetValueCriteria;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.BicomponentWorker;
import org.tip.puck.net.workers.ControlReporter;
import org.tip.puck.net.workers.DistanceAttributeCriteria;
import org.tip.puck.net.workers.ExpandCriteria;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.GeneaQuiltConvert;
import org.tip.puck.net.workers.GeoPlaceNetCriteria;
import org.tip.puck.net.workers.HairCutWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetReporter;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.net.workers.SnowballCriteria;
import org.tip.puck.net.workers.TransmitAttributeValueCriteria;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportList;
import org.tip.puck.segmentation.Segment;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Slices;
import org.tip.puck.spacetime.workers.MissingTestimoniesCriteria;
import org.tip.puck.spacetime.workers.SequenceReporter;
import org.tip.puck.spacetime.workers.SliceMaker;
import org.tip.puck.spacetime.workers.SliceReporter;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.spacetime.workers.SpaceTimeReporter;
import org.tip.puck.spacetime.workers.UnknownPlacesCriteria;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.ToolBox;
import org.tip.puck.visualization.VisualizationController;
import org.tip.puck.visualization.style.implementations.OreGraph;
import org.tip.puck.visualization.style.implementations.PGraph;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.util.ButtonTabComponent;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.AboutPopup;
import org.tip.puckgui.views.AddChildRolesInputDialog;
import org.tip.puckgui.views.AllianceNetworkInputWindow;
import org.tip.puckgui.views.AttributeFilterInputDialog;
import org.tip.puckgui.views.AttributeRemoveAllInputDialog;
import org.tip.puckgui.views.AttributeRenameInputDialog;
import org.tip.puckgui.views.AttributeReplaceValueInputDialog;
import org.tip.puckgui.views.AttributeSetValueInputDialog;
import org.tip.puckgui.views.CalculatorWindow;
import org.tip.puckgui.views.CensusInputWindow;
import org.tip.puckgui.views.ClusterSizeExtractionInputWindow;
import org.tip.puckgui.views.ClusterValueExtractionInputWindow;
import org.tip.puckgui.views.ConfirmMainWindowCloseDialog;
import org.tip.puckgui.views.ConfirmQuitDialog;
import org.tip.puckgui.views.ControlInputWindow;
import org.tip.puckgui.views.CorpusPanel;
import org.tip.puckgui.views.CorpusSaveFileSelector;
import org.tip.puckgui.views.DifferentialCensusInputWindow;
import org.tip.puckgui.views.DiscontinuousItinerariesInputDialog;
import org.tip.puckgui.views.DistanceAttributeInputDialog;
import org.tip.puckgui.views.ExpandInputDialog;
import org.tip.puckgui.views.ExportBARFileSelector;
import org.tip.puckgui.views.FamiliesPanel;
import org.tip.puckgui.views.FieldworkInputWindow;
import org.tip.puckgui.views.FlowNetworkInputWindow;
import org.tip.puckgui.views.FooReporterInputWindow;
import org.tip.puckgui.views.FuseInputWindow;
import org.tip.puckgui.views.GeoPlaceNetDialog;
import org.tip.puckgui.views.HomonymReportInputWindow;
import org.tip.puckgui.views.IndividualsPanel;
import org.tip.puckgui.views.KinshipChainsInputDialog;
import org.tip.puckgui.views.KinsourcesCatalogSelectorDialog;
import org.tip.puckgui.views.ListByClusterInputWindow;
import org.tip.puckgui.views.ListMissingRelativesByClusterInputWindow;
import org.tip.puckgui.views.ListRelativesByClusterInputWindow;
import org.tip.puckgui.views.MissingTestimoniesInputDialog;
import org.tip.puckgui.views.OpenEncodingWindow;
import org.tip.puckgui.views.OpenRecentFolderMenuItem;
import org.tip.puckgui.views.OpenRecentMenuItem;
import org.tip.puckgui.views.PajekExportCriteria;
import org.tip.puckgui.views.PajekExportInputDialog;
import org.tip.puckgui.views.PartitionStatisticsInputWindow;
import org.tip.puckgui.views.PreferencesWindow;
import org.tip.puckgui.views.RandomCorpusInputWindow;
import org.tip.puckgui.views.RandomCorpusMASInputWindow;
import org.tip.puckgui.views.RelationAnalysisInputDialog;
import org.tip.puckgui.views.RelationModelInputWindow;
import org.tip.puckgui.views.RelationsPanel;
import org.tip.puckgui.views.ReportPanel;
import org.tip.puckgui.views.ReportsPanel;
import org.tip.puckgui.views.ReshufflingNetworkInputWindow;
import org.tip.puckgui.views.SegmentationPanel;
import org.tip.puckgui.views.SnowballStructureInputDialog;
import org.tip.puckgui.views.SpaceTimeAnalysisInputDialog;
import org.tip.puckgui.views.StatisticsInputWindow;
import org.tip.puckgui.views.TransmitAttributeValueInputDialog;
import org.tip.puckgui.views.UnknownPlacesInputDialog;
import org.tip.puckgui.views.ValuateExogenousAttributeCriteria;
import org.tip.puckgui.views.ValuateExogenousAttributeDialog;
import org.tip.puckgui.views.WindowMenuItem;
import org.tip.puckgui.views.geneaquilt.IndividualGroupEventQuiltsPanel;
import org.tip.puckgui.views.geneaquilt.IndividualGroupQuiltsPanel;
import org.tip.puckgui.views.geo.MapPanel2;
import org.tip.puckgui.views.geographyEditor.GeographyEditorPanel;
import org.tip.puckgui.views.geographyEditor.GeographyExportFileSelector;
import org.tip.puckgui.views.kinoath.GlobalDiagramPanel;
import org.tip.puckgui.views.kinoath.IndividualDiagramsPanel;
import org.tip.puckgui.views.kinoath.IndividualGroupDiagramsPanel;
import org.tip.puckgui.views.visualization.Test;
import org.tip.puckgui.views.visualization.VisualizationPanel;

public class MainWindow {
    private static final Logger logger = LoggerFactory.getLogger(MainWindow.class);
    private int reportCounter = 0;
    private JFrame frmPuck;
    private NetGUI netGUI;
    private JMenuItem mntmSave;
    private JMenuItem mntmRevert;
    private JMenu mntmRecent;
    private JTabbedPane tabbedPaneCorpus;
    private CorpusPanel corpusTab;
    private FamiliesPanel familiesTab;
    private IndividualsPanel individualsTab;
    private SegmentationPanel segmentationPanel;

    public MainWindow(NetGUI guiManager) {
        this.netGUI = guiManager;
        this.initialize();
        this.frmPuck.setVisible(true);
        this.updateMenuItems();
        this.updateTitle();
        this.getCorpusTab().update();
        this.getIndividualsTab().update();
        this.getFamiliesTab().update();
        this.getIndividualsTab().select(null);
        this.getFamiliesTab().select(null);
        for (RelationModel relationModel : this.netGUI.getNet().relationModels()) {
            this.addRawTab(relationModel.getName(), new RelationsPanel(this.netGUI, relationModel));
        }
    }

    public void addRawTab(String title, JPanel panel) {
        this.tabbedPaneCorpus.addTab(title, null, panel, null);
        this.tabbedPaneCorpus.setSelectedComponent(panel);
    }

    public void addRelationTab(RelationModel relationModel) {
        if (relationModel != null) {
            RelationsPanel relationPanel = new RelationsPanel(this.netGUI, relationModel);
            this.addRawTab(relationModel.getName(), relationPanel);
        }
    }

    public void addReportTab(Report report) {
        JPanel reportPanel = report.containsSubReport() ? new ReportsPanel(this.netGUI, report) : new ReportPanel(this.netGUI, report);
        this.addReportTab(report.title(), reportPanel);
    }

    public void addReportTab(String title, JPanel reportPanel) {
        ++this.reportCounter;
        this.addTab(String.valueOf(title) + " (" + this.reportCounter + ")", reportPanel);
    }

    public void addTab(String title, JPanel panel) {
        this.tabbedPaneCorpus.addTab(title, null, panel, null);
        this.tabbedPaneCorpus.setSelectedComponent(panel);
        this.tabbedPaneCorpus.setTabComponentAt(this.tabbedPaneCorpus.getSelectedIndex(), new ButtonTabComponent(this.tabbedPaneCorpus));
    }

    public void closeCurrentTab() {
        this.tabbedPaneCorpus.remove(this.tabbedPaneCorpus.getSelectedIndex());
    }

    public void closeRelationTabs() {
        for (RelationsPanel tab : this.getRelationTabs()) {
            this.tabbedPaneCorpus.remove(tab);
        }
    }

    public void closeVolatilTabs() {
        int tabIndex = this.tabbedPaneCorpus.getTabCount() - 1;
        while (tabIndex >= 3) {
            this.tabbedPaneCorpus.remove(tabIndex);
            --tabIndex;
        }
    }

    public void dispose() {
        this.frmPuck.dispose();
    }

    public CorpusPanel getCorpusTab() {
        return this.corpusTab;
    }

    public int getCurrentTabIndex() {
        int result = this.tabbedPaneCorpus.getSelectedIndex();
        return result;
    }

    public FamiliesPanel getFamiliesTab() {
        return this.familiesTab;
    }

    public IndividualsPanel getIndividualsTab() {
        return this.individualsTab;
    }

    public JFrame getJFrame() {
        JFrame result = this.frmPuck;
        return result;
    }

    public RelationsPanel getRelationTab(RelationModel relationModel) {
        int tabIndex = this.getRelationTabIndex(relationModel);
        RelationsPanel result = tabIndex == -1 ? null : (RelationsPanel)this.tabbedPaneCorpus.getComponent(tabIndex);
        return result;
    }

    public int getRelationTabIndex(RelationModel relationModel) {
        int result = -1;
        boolean ended = false;
        int tabIndex = 0;
        while (!ended) {
            if (tabIndex < this.tabbedPaneCorpus.getComponentCount()) {
                Component tab = this.tabbedPaneCorpus.getComponent(tabIndex);
                if (tab.getClass() == RelationsPanel.class && ((RelationsPanel)tab).getRelationModel() == relationModel) {
                    ended = true;
                    result = tabIndex;
                    continue;
                }
                ++tabIndex;
                continue;
            }
            ended = true;
            result = -1;
        }
        return result;
    }

    public List<RelationsPanel> getRelationTabs() {
        ArrayList<RelationsPanel> result = new ArrayList<RelationsPanel>();
        Component[] componentArray = this.tabbedPaneCorpus.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component tab = componentArray[n2];
            if (tab.getClass() == RelationsPanel.class) {
                result.add((RelationsPanel)tab);
            }
            ++n2;
        }
        return result;
    }

    public SegmentationPanel getSegmentationPanel() {
        return this.segmentationPanel;
    }

    private void initialize() {
        this.frmPuck = new JFrame();
        this.frmPuck.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.out.println("Closing event.");
                MainWindow.this.performCloseWindow();
            }
        });
        this.frmPuck.setIconImage(Toolkit.getDefaultToolkit().getImage(MainWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.frmPuck.setTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.frmPuck.title"));
        this.frmPuck.setBounds(50, 0, 1020, MainWindow.getDesktopHeight());
        this.frmPuck.setDefaultCloseOperation(0);
        JMenuBar menuBar = new JMenuBar();
        this.frmPuck.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnFile.text"));
        mnFile.setMnemonic('F');
        menuBar.add(mnFile);
        JMenu mnNew = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNew.text"));
        mnFile.add(mnNew);
        JMenuItem mntmBlankCorpus = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBlankCorpus.text"));
        mntmBlankCorpus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PuckGUI.instance().createNetGUI();
            }
        });
        mnNew.add(mntmBlankCorpus);
        JMenu mnRandomnetwork = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnRandomnetwork.text"));
        mnNew.add(mnRandomnetwork);
        JMenuItem mntmClassic = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClassic.text"));
        mntmClassic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    RandomCorpusInputWindow window = new RandomCorpusInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnRandomnetwork.add(mntmClassic);
        JMenuItem mntmTelmo = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTelmo.text"));
        mntmTelmo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    RandomCorpusMASInputWindow window = new RandomCorpusMASInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnRandomnetwork.add(mntmTelmo);
        JMenuItem mntmVariationsbc = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVariationsbc.text"));
        mntmVariationsbc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = RandomNetReporter.ReportMASVariation();
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        mnRandomnetwork.add(mntmVariationsbc);
        JMenuItem mntmEmptyAllianceNetwork = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEmptyAllianceNetwork.text"));
        mntmEmptyAllianceNetwork.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        mntmEmptyAllianceNetwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PuckGUI.instance().createGroupNetGUI(new Graph<Cluster<Individual>>(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("puckgui.defaultFileName")));
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        mnNew.add(mntmEmptyAllianceNetwork);
        JMenuItem mntmOpen = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpen.text"));
        mntmOpen.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpen.toolTipText"));
        mntmOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mntmOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File file = MainWindow.selectFile(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile().getParentFile());
                MainWindow.openSelectedFile(MainWindow.this.netGUI, MainWindow.this.frmPuck, file, PuckManager.DEFAULT_CHARSET_NAME);
            }
        });
        mnFile.add(mntmOpen);
        this.mntmRecent = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text"));
        this.mntmRecent.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                JMenu openRecentMenu = (JMenu)event.getSource();
                openRecentMenu.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent event) {
                JMenu openRecentMenu = (JMenu)event.getSource();
                for (File file : PuckGUI.instance().recentFiles()) {
                    openRecentMenu.add(new OpenRecentMenuItem(MainWindow.this.frmPuck, MainWindow.this.netGUI, file));
                }
            }
        });
        mnFile.add(this.mntmRecent);
        JMenu mnOpenRecentFolder = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnOpenFolder.text"));
        mnOpenRecentFolder.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent event) {
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                JMenu openRecentFolderMenu = (JMenu)event.getSource();
                openRecentFolderMenu.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent event) {
                JMenu openRecentFolderMenu = (JMenu)event.getSource();
                for (File folder : PuckGUI.instance().recentFolders()) {
                    openRecentFolderMenu.add(new OpenRecentFolderMenuItem(MainWindow.this.frmPuck, MainWindow.this.netGUI, folder));
                }
            }
        });
        mnFile.add(mnOpenRecentFolder);
        this.mntmRevert = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.text"));
        this.mntmRevert.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.mntmRevert.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.toolTipText"));
        this.mntmRevert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (MainWindow.this.netGUI.isChanged()) {
                        int response = JOptionPane.showConfirmDialog(MainWindow.this.frmPuck, "All changes will be lost. Confirm revert of this corpus?", "Revert confirm", 0);
                        if (response == 0) {
                            MainWindow.this.netGUI.revert();
                        }
                    } else {
                        MainWindow.this.netGUI.revert();
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case FILE_NOT_FOUND: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                            break;
                        }
                        case BAD_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                            break;
                        }
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmOpenEncoding = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpenEncoding.text"));
        mntmOpenEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String charsetName = OpenEncodingWindow.showDialog();
                    logger.debug("charset=[" + charsetName + "]");
                    if (charsetName != null) {
                        File file = MainWindow.selectFile(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile().getParentFile());
                        MainWindow.openSelectedFile(MainWindow.this.netGUI, MainWindow.this.frmPuck, file, charsetName);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmOpenEncoding);
        JMenuItem mntmOpenFromKinsources = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpenFromKinsources.text"));
        mntmOpenFromKinsources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CatalogItem criteria = KinsourcesCatalogSelectorDialog.showDialog();
                    if (criteria != null) {
                        logger.info("Download Kinsources dataset file [{}][{}]", (Object)criteria.getId(), (Object)criteria.getName());
                        Net newNet = KinsourcesFile.load(criteria.getId());
                        File newFile = new File(newNet.getLabel());
                        if (MainWindow.this.netGUI.isBlank()) {
                            MainWindow.this.netGUI.setFile(newFile);
                            MainWindow.this.netGUI.setNet(newNet);
                        } else {
                            PuckGUI.instance().createNetGUI(newFile, newNet);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmOpenFromKinsources);
        mnFile.add(this.mntmRevert);
        JSeparator separator_4 = new JSeparator();
        mnFile.add(separator_4);
        this.mntmSave = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSave.text"));
        this.mntmSave.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSave.toolTipText"));
        this.mntmSave.setEnabled(false);
        this.mntmSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mntmSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File targetFile = MainWindow.this.netGUI.getFile();
                    if (ToolBox.getExtension(targetFile) == null) {
                        targetFile = CorpusSaveFileSelector.showSelectorDialog(MainWindow.this.frmPuck, targetFile);
                    }
                    if (targetFile != null) {
                        PuckManager.saveNet(targetFile, MainWindow.this.netGUI.getNet());
                        MainWindow.this.netGUI.setFile(targetFile);
                        MainWindow.this.netGUI.setChanged(false);
                        PuckGUI.instance().recentFiles().updateFile(targetFile);
                        PuckGUI.instance().recentFolders().updateFolder(targetFile.getParentFile());
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmFuse = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFuse.text"));
        mntmFuse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    FuseInputWindow window = new FuseInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmFuse);
        JMenuItem mntmUpdateOverwriting = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUpdateOverwriting.text"));
        mntmUpdateOverwriting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    File file = MainWindow.selectFile(MainWindow.this.frmPuck, null);
                    if (file != null) {
                        Report report = new Report("Update report");
                        Net updatedNet = PuckManager.updateNetOverwriting(MainWindow.this.netGUI.getNet(), file, report);
                        NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), updatedNet);
                        newNetGui.setChanged(true, "-overwritten");
                        if (report.outputs().isNotEmpty()) {
                            newNetGui.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmUpdateOverwriting);
        JMenuItem mntmUpdateAppending = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUpdateAppending.text"));
        mntmUpdateAppending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = MainWindow.selectFile(MainWindow.this.frmPuck, null);
                    if (file != null) {
                        Report report = new Report("Update report");
                        Net updatedNet = PuckManager.updateNetAppending(MainWindow.this.netGUI.getNet(), file, report);
                        NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), updatedNet);
                        newNetGui.setChanged(true, "-appended");
                        if (report.outputs().isNotEmpty()) {
                            newNetGui.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmUpdateAppending);
        JSeparator separator_5 = new JSeparator();
        mnFile.add(separator_5);
        mnFile.add(this.mntmSave);
        JMenuItem mntmSaveAs = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveAs.text"));
        mntmSaveAs.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveAs.toolTipText"));
        mntmSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.performSaveAs(MainWindow.this.frmPuck, MainWindow.this.netGUI);
            }
        });
        mnFile.add(mntmSaveAs);
        JMenuItem mntmSaveACopy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveACopy.text"));
        mntmSaveACopy.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveACopy.toolTipText"));
        mntmSaveACopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File targetFile = CorpusSaveFileSelector.showSelectorDialog(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());
                    if (targetFile != null) {
                        PuckManager.saveNet(targetFile, MainWindow.this.netGUI.getNet());
                        PuckGUI.instance().recentFiles().updateFile(targetFile);
                        PuckGUI.instance().recentFolders().updateFolder(targetFile.getParentFile());
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmSaveACopy);
        JMenuItem mntmClose = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClose.text"));
        mntmClose.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClose.toolTipText"));
        mntmClose.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        mntmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.this.performCloseCorpus();
            }
        });
        JSeparator separator = new JSeparator();
        mnFile.add(separator);
        JMenuItem mntmExportToPajek = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportToPajek.text"));
        mntmExportToPajek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PajekExportCriteria criteria = PajekExportInputDialog.showDialog(MainWindow.this.netGUI.getFile(), (List<String>)IndividualValuator.getAttributeLabels(MainWindow.this.netGUI.getNet().individuals()));
                    if (criteria != null) {
                        PAJFile.exportToPajek(MainWindow.this.netGUI.getNet(), criteria.getTargetFileName(), criteria.getGraphType(), criteria.getPartitionLabelsNotBlank());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmExportBAR = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportOds.text"));
        mntmExportBAR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.performBARSave();
            }
        });
        JMenuItem mntmImportDat = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportDat.text"));
        mntmImportDat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    File file = MainWindow.selectDATFileToLoad(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());
                    if (file != null) {
                        Net net = DAT1File.load(file);
                        if (MainWindow.this.netGUI.isBlank()) {
                            MainWindow.this.netGUI.setFile(file);
                            MainWindow.this.netGUI.setNet(net);
                        } else {
                            PuckGUI.instance().createNetGUI(file, net);
                        }
                    }
                }
                catch (PuckException exception) {
                    String message;
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case FILE_NOT_FOUND: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                            break;
                        }
                        case BAD_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                            break;
                        }
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmImportDat);
        JMenuItem mntmImportSelz = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportOds.text"));
        mntmImportSelz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = MainWindow.selectSelzFileToLoad(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());
                    if (file != null) {
                        Net net = SELZFile.load(file, PuckManager.DEFAULT_CHARSET_NAME);
                        if (MainWindow.this.netGUI.isBlank()) {
                            MainWindow.this.netGUI.setFile(file);
                            MainWindow.this.netGUI.setNet(net);
                        } else {
                            PuckGUI.instance().createNetGUI(file, net);
                        }
                    }
                }
                catch (PuckException exception) {
                    String message;
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case FILE_NOT_FOUND: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                            break;
                        }
                        case BAD_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                            break;
                        }
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmImportSelz);
        mnFile.add(mntmExportBAR);
        mnFile.add(mntmExportToPajek);
        JSeparator separator_1 = new JSeparator();
        mnFile.add(separator_1);
        mnFile.add(mntmClose);
        JMenuItem mntmQuit = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuit.text"));
        mntmQuit.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuit.toolTipText"));
        mntmQuit.setMnemonic('Q');
        mntmQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quit action.");
                MainWindow.this.performQuit();
            }
        });
        JSeparator separator_7 = new JSeparator();
        mnFile.add(separator_7);
        mnFile.add(mntmQuit);
        JMenu mnEdit = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text_1"));
        mnEdit.setMnemonic('E');
        menuBar.add(mnEdit);
        JMenuItem mntmCut = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCut.text"));
        mntmCut.setAccelerator(KeyStroke.getKeyStroke(65489, 0));
        mntmCut.setEnabled(false);
        mnEdit.add(mntmCut);
        JMenuItem mntmCopy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopy.text"));
        mntmCopy.setAccelerator(KeyStroke.getKeyStroke(65485, 0));
        mntmCopy.setEnabled(false);
        mnEdit.add(mntmCopy);
        JMenuItem mntmPaste = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPaste.text"));
        mntmPaste.setAccelerator(KeyStroke.getKeyStroke(65487, 0));
        mntmPaste.setEnabled(false);
        mnEdit.add(mntmPaste);
        JMenuItem mntmDelete = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDelete.text"));
        mntmDelete.setEnabled(false);
        mnEdit.add(mntmDelete);
        JSeparator separator_2 = new JSeparator();
        mnEdit.add(separator_2);
        JMenuItem mntmPreferences = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPreferences.text"));
        mntmPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PreferencesWindow preferences = new PreferencesWindow();
                    preferences.setDefaultCloseOperation(2);
                    preferences.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JMenuItem mntmAddIndividual = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddIndividual.text"));
        mntmAddIndividual.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        mntmAddIndividual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.individualsTab.addIndividual();
            }
        });
        mnEdit.add(mntmAddIndividual);
        JMenuItem mntmFind = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFind.text"));
        mntmFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
                    case 1: {
                        MainWindow.this.individualsTab.setFocusOnFind();
                        break;
                    }
                    case 2: {
                        MainWindow.this.familiesTab.setFocusOnFind();
                    }
                }
            }
        });
        JMenuItem mntmAddPartner = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddPartner.text"));
        mntmAddPartner.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        mntmAddPartner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
                    case 1: {
                        MainWindow.this.individualsTab.addPartner();
                    }
                }
            }
        });
        JMenuItem mntmAddOriginFamily = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddOriginFamily.text"));
        mntmAddOriginFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
                    case 1: {
                        MainWindow.this.individualsTab.addOriginFamily();
                    }
                }
            }
        });
        mntmAddOriginFamily.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        mnEdit.add(mntmAddOriginFamily);
        mnEdit.add(mntmAddPartner);
        JMenuItem mntmAddChild = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddChild.text"));
        mntmAddChild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
                    case 1: {
                        MainWindow.this.individualsTab.addChild();
                        break;
                    }
                    case 2: {
                        MainWindow.this.familiesTab.addChild();
                    }
                }
            }
        });
        mntmAddChild.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        mnEdit.add(mntmAddChild);
        JMenuItem mntmAddFamily = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddFamily.text"));
        mntmAddFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.familiesTab.addFamily();
            }
        });
        mntmAddFamily.setAccelerator(KeyStroke.getKeyStroke(85, 3));
        mnEdit.add(mntmAddFamily);
        JMenuItem mntmAddRelationModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNewMenuItem.text_1"));
        mntmAddRelationModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RelationModelInputWindow window = new RelationModelInputWindow(MainWindow.this.netGUI, null);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnEdit.add(mntmAddRelationModel);
        JMenuItem mntmEditGeography = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEditGeography.text"));
        mntmEditGeography.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GeographyEditorPanel panel = new GeographyEditorPanel(MainWindow.this.netGUI);
                    MainWindow.this.addTab("Geography editor", panel);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnEdit.add(mntmEditGeography);
        mntmFind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        mnEdit.add(mntmFind);
        JSeparator separator_9 = new JSeparator();
        mnEdit.add(separator_9);
        mnEdit.add(mntmPreferences);
        JMenu mnCorpus = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnCorpus.text"));
        menuBar.add(mnCorpus);
        JMenuItem mntmListById = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListById.text"));
        mntmListById.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ArrayList<IndividualComparator.Sorting> sorting = new ArrayList<IndividualComparator.Sorting>();
                    sorting.add(IndividualComparator.Sorting.ID);
                    Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), sorting, null);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListById);
        JMenuItem mntmListByFirst = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByFirst.text"));
        mntmListByFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<IndividualComparator.Sorting> sorting = new ArrayList<IndividualComparator.Sorting>();
                    sorting.add(IndividualComparator.Sorting.FIRSTN);
                    sorting.add(IndividualComparator.Sorting.LASTN);
                    sorting.add(IndividualComparator.Sorting.ID);
                    Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), sorting, null);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListByFirst);
        JMenuItem mntmListByLast = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByLast.text"));
        mntmListByLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<IndividualComparator.Sorting> sorting = new ArrayList<IndividualComparator.Sorting>();
                    sorting.add(IndividualComparator.Sorting.LASTN);
                    sorting.add(IndividualComparator.Sorting.FIRSTN);
                    sorting.add(IndividualComparator.Sorting.ID);
                    Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), sorting, null);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListByLast);
        JMenuItem mntmListByClusters = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByClusters.text"));
        mntmListByClusters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ListByClusterInputWindow window = new ListByClusterInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmListByLast_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByLast_1.text"));
        mntmListByLast_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<String> details = new ArrayList<String>();
                    details.add("BAP_DATE");
                    details.add("PARENTS");
                    details.add("PARTNERS");
                    details.add("MARR_DATE");
                    details.add("CHILDREN");
                    details.add("FIRST_CHILD_BAP_DATE");
                    details.add("FIRST_CHILD_FIRST_MARR_DATE");
                    ArrayList<IndividualComparator.Sorting> sorting = new ArrayList<IndividualComparator.Sorting>();
                    sorting.add(IndividualComparator.Sorting.LASTN);
                    sorting.add(IndividualComparator.Sorting.FIRSTN);
                    sorting.add(IndividualComparator.Sorting.ID);
                    Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), sorting, details);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListByLast_1);
        mnCorpus.add(mntmListByClusters);
        JMenuItem mntmListRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListRelatives.text"));
        mntmListRelatives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ListRelativesByClusterInputWindow window = new ListRelativesByClusterInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListRelatives);
        JMenuItem mntmExportFamilyIds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportFamilyIds.text"));
        mntmExportFamilyIds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = StatisticsReporter.reportFamiliesByHusband(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmListMissingRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListMissingRelatives.text"));
        mntmListMissingRelatives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ListMissingRelativesByClusterInputWindow window = new ListMissingRelativesByClusterInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListMissingRelatives);
        mnCorpus.add(mntmExportFamilyIds);
        JMenuItem mntmListFamiliesBy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListFamiliesBy.text"));
        mntmListFamiliesBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = StatisticsReporter.reportFamiliesByWife(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListFamiliesBy);
        JMenuItem mntmHomonyms = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmHomonyms.text"));
        mntmHomonyms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    HomonymReportInputWindow window = new HomonymReportInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmHomonyms);
        JMenu mnControls = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnControls.text"));
        mnCorpus.add(mnControls);
        JMenuItem mntmControl = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControl.text"));
        mnControls.add(mntmControl);
        JSeparator separator_8 = new JSeparator();
        mnControls.add(separator_8);
        JMenuItem mntmControlSameSex = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlSameSex.text"));
        mnControls.add(mntmControlSameSex);
        JMenuItem mntmControlFemaleFathers = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlFemaleFathers.text"));
        mnControls.add(mntmControlFemaleFathers);
        JMenuItem mntmMultipleFathersOr = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMultipleFathersOr.text"));
        mntmMultipleFathersOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportMultipleFathersOrMothers(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls.add(mntmMultipleFathersOr);
        JMenuItem mntmControlCyclicDescent = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlCyclicDescent.text"));
        mnControls.add(mntmControlCyclicDescent);
        JMenuItem mntmControlUnknownSex = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlUnknownSex.text"));
        mnControls.add(mntmControlUnknownSex);
        JMenuItem mntmUnknownSexParents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUnknownSexParents.text"));
        mntmUnknownSexParents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = ControlReporter.reportUnknownSexParentsSpouses(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls.add(mntmUnknownSexParents);
        JMenuItem mntmControlNamelessPersons = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlNamelessPersons.text"));
        mnControls.add(mntmControlNamelessPersons);
        JMenuItem mntmControlParentchildMarriages = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlParentchildMarriages.text"));
        mnControls.add(mntmControlParentchildMarriages);
        JMenuItem mntmAutomarriage = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAutomarriage.text"));
        mntmAutomarriage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = ControlReporter.reportAutoMarriages(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls.add(mntmAutomarriage);
        JMenuItem mntmInconsistentDates = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmInconsistentDates.text"));
        mntmInconsistentDates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = ControlReporter.reportInconsistentDates(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls.add(mntmInconsistentDates);
        JMenuItem mntmMissingDatesCompact = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMissingDates.text"));
        mntmMissingDatesCompact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = ControlReporter.reportMissingDatesCompact(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmMissingDates = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMissingDates_1.text"));
        mntmMissingDates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = ControlReporter.reportMissingDates(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls.add(mntmMissingDates);
        mnControls.add(mntmMissingDatesCompact);
        mntmControlParentchildMarriages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportParentChildMarriages(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlNamelessPersons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportNamelessPersons(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlUnknownSex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportUnknownSexPersons(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlCyclicDescent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportCyclicDescentCases(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlFemaleFathers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportFemaleFathersOrMaleMothers(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlSameSex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportSameSexSpouses(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ControlInputWindow window = new ControlInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmAttributesStatistics = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAttributesStatistics.text"));
        mntmAttributesStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = MainWindow.this.netGUI.getSegmentation().isAtTheTop() ? StatisticsReporter.reportAttributeStatistics(MainWindow.this.netGUI.getNet()) : StatisticsReporter.reportAttributeStatistics(MainWindow.this.netGUI.getSegmentation());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmAttributesStatistics);
        JMenuItem mntmSnowballStructure = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSnowballStructure.text"));
        mntmSnowballStructure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getCurrentIndividuals(), null);
                    SnowballCriteria criteria = SnowballStructureInputDialog.showDialog(attributeDescriptors);
                    if (criteria != null) {
                        logger.debug("criteria=" + criteria.toString());
                        Report report = NetReporter.reportSteps(MainWindow.this.netGUI.getSegmentation(), criteria);
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmAttributeValueStatistics = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAttributeValueStatistics.text"));
        mntmAttributeValueStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Report report = MainWindow.this.netGUI.getSegmentation().isAtTheTop() ? StatisticsReporter.reportAttributeValueStatistics(MainWindow.this.netGUI.getNet()) : StatisticsReporter.reportAttributeValueStatistics(MainWindow.this.netGUI.getSegmentation());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmAttributeValueStatistics);
        mnCorpus.add(mntmSnowballStructure);
        JSeparator separator_6 = new JSeparator();
        mnCorpus.add(separator_6);
        JMenu mnTransform = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTransform.text"));
        menuBar.add(mnTransform);
        JMenuItem mntmAnonymizeByGender = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByGender.text"));
        mntmAnonymizeByGender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    AttributeWorker.anonymizeByGenderAndId(currentIndividuals);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-anonymized");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmAnonymizeByFirst = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByFirst.text_1"));
        mntmAnonymizeByFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net targetNet = new Net(MainWindow.this.netGUI.getNet());
                    Individuals currentIndividuals = targetNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    AttributeWorker.anonymizeByFirstName(currentIndividuals);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), targetNet);
                    newNetGui.setChanged(true, "-anonymized");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmAnonymizeByLast = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByLast.text_1"));
        mntmAnonymizeByLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    AttributeWorker.anonymizeByLastName(currentIndividuals);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-anonymized");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmToModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmToModel.text"));
        mntmToModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RelationModel model = RelationModelMaker.create(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.addRelationTab(model);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmToModel);
        JSeparator separator_20 = new JSeparator();
        mnTransform.add(separator_20);
        JMenuItem mntmDuplicate = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDuplicate.text"));
        mnTransform.add(mntmDuplicate);
        mntmDuplicate.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        mntmDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    PuckGUI.instance().duplicate(MainWindow.this.netGUI);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmAnonymizeByFirst);
        mnTransform.add(mntmAnonymizeByLast);
        mnTransform.add(mntmAnonymizeByGender);
        JMenuItem mntmNumberNames_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNumberNames_1.text"));
        mntmNumberNames_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net targetNet = MainWindow.this.netGUI.getNet();
                    Individuals currentIndividuals = targetNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    NetUtils.numberNames(currentIndividuals);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), targetNet);
                    newNetGui.setChanged(true, "-names_numbered");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmNumberNames_1);
        JMenuItem mntmNamesToAttributes = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNamesToAttributes.text"));
        mntmNamesToAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Net targetNet = MainWindow.this.netGUI.getNet();
                    Individuals currentIndividuals = targetNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    NetUtils.namesToAttributes(currentIndividuals);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), targetNet);
                    newNetGui.setChanged(true, "-names_as_attributes");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmNamesToAttributes);
        JSeparator separator_18 = new JSeparator();
        mnTransform.add(separator_18);
        JMenuItem mntmRenameExogenousAttribute = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenameExogenousAttribute.text"));
        mntmRenameExogenousAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StringList relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation(), null);
                    AttributeRenameCriteria criteria = AttributeRenameInputDialog.showDialog((List<String>)relationModelNames, attributeDescriptors);
                    if (criteria != null) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());
                        long count = AttributeWorker.renameAttribute(newNet, newSegmentation, criteria);
                        String title = "Attribute Rename Count";
                        String message = "Number of attribute touched: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        if (count > 0L) {
                            newSegmentation.refresh();
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
                            newNetGui.setChanged(true, "-attributeRename");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmRenameExogenousAttribute);
        JMenuItem mntmValuateExogeneousAttribute = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmValuateExogeneousAttribute.text"));
        mntmValuateExogeneousAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ValuateExogenousAttributeCriteria criteria = ValuateExogenousAttributeDialog.showDialog();
                    if (criteria != null) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        int count = AttributeWorker.valuateExogenousAttribute(newNet.individuals(), criteria.getSourceLabel(), criteria.getTargetLabel(), criteria.getValuePrefix());
                        String title = "Valuate Exogenous Attribute Count";
                        String message = "Number of attribute touched: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        if (count > 0) {
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                            newNetGui.setChanged(true, "-attributeValuated");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmFilterAttribute = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFilterAttribute.text"));
        mntmFilterAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StringList relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation(), null);
                    AttributeFilter filter = AttributeFilterInputDialog.showDialog((List<String>)relationModelNames, attributeDescriptors);
                    if (filter != null) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());
                        long count = AttributeWorker.filter(newNet, newSegmentation, filter);
                        String title = "Filter Attribute Count";
                        String message = "Number of attribute touched: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        if (count > 0L) {
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
                            newNetGui.setChanged(true, "-attributeFilter");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmFilterAttribute);
        JMenuItem mntmReplaceAttributeValue = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmReplaceAttributeValue.text"));
        mntmReplaceAttributeValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StringList relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation(), null);
                    AttributeReplaceValueCriteria criteria = AttributeReplaceValueInputDialog.showDialog((List<String>)relationModelNames, attributeDescriptors);
                    if (criteria != null) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());
                        long count = AttributeWorker.replaceAttributeValue(newNet, newSegmentation, criteria);
                        String title = "Attribute Replace Count";
                        String message = "Number of attribute touched: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        if (count > 0L) {
                            newSegmentation.refresh();
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
                            newNetGui.setChanged(true, "-attributeReplace");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmSetAttributeValue = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSetAttributeValue.text"));
        mntmSetAttributeValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StringList relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation(), null);
                    AttributeSetValueCriteria criteria = AttributeSetValueInputDialog.showDialog((List<String>)relationModelNames, attributeDescriptors);
                    if (criteria != null) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());
                        long count = AttributeWorker.setAttributeValue(newNet, newSegmentation, criteria);
                        String title = "Attribute Set Count";
                        String message = "Number of attribute touched: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        if (count > 0L) {
                            newSegmentation.refresh();
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
                            newNetGui.setChanged(true, "-attributeSet");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmSetAttributeValue);
        mnTransform.add(mntmReplaceAttributeValue);
        mnTransform.add(mntmValuateExogeneousAttribute);
        JMenuItem mntmRemoveAllAttributes = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRemoveAllAttributes.text"));
        mntmRemoveAllAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeRemoveAllInputDialog.Criteria criteria = AttributeRemoveAllInputDialog.showDialog();
                    if (criteria != null) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());
                        long count = criteria == AttributeRemoveAllInputDialog.Criteria.CORPUS_INCLUDED ? AttributeWorker.removeAllAttributes(newNet) : AttributeWorker.removeAllAttributesExceptCorpus(newNet);
                        String title = "Attribute Remove Count";
                        String message = "Number of removed attributes: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        if (count > 0L) {
                            newSegmentation.refresh();
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
                            newNetGui.setChanged(true, "-attributeRemoved");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmRemoveAllAttributes);
        JMenuItem mntmTransmitAttributeValues = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTransmitAttributeValues.text"));
        mntmTransmitAttributeValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    StringList labels = IndividualValuator.getAttributeLabels(MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals());
                    TransmitAttributeValueCriteria criteria = TransmitAttributeValueInputDialog.showDialog((List<String>)labels);
                    if (criteria != null) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());
                        int count = NetUtils.transmitAttributeValue(newSegmentation.getCurrentIndividuals(), criteria);
                        String title = "Transmit Attribute Value Count";
                        String message = "Number of attribute transmitted: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        if (count > 0) {
                            newSegmentation.refresh();
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
                            newNetGui.setChanged(true, "-transmittedAttributeValue");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmTransmitAttributeValues);
        JSeparator separator_19 = new JSeparator();
        mnTransform.add(separator_19);
        JMenuItem mntmMarryCoparents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMarryCoparents.text"));
        mntmMarryCoparents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    int count = NetUtils.marryCoparents(newNet);
                    String title = "Marry co-parents Result";
                    String message = "Number of unmarried co-parents married: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-married");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmMarryCoparents);
        JMenuItem mntmRenumber = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumber.text"));
        mnTransform.add(mntmRenumber);
        mntmRenumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    NetUtils.renumberIndividuals(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.setChanged(true, "renumbered");
                    MainWindow.this.netGUI.updateAll();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmRenumber.setEnabled(true);
        JMenuItem mntmRenumberIdsFrom = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumberIdsFrom.text"));
        mntmRenumberIdsFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int count = NetUtils.renumberFromAttribute(MainWindow.this.netGUI.getNet(), "ID");
                    String title = "Renumber ids from ID Result";
                    String message = "Number of individuals renumbered: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    if (count > 0) {
                        MainWindow.this.netGUI.setChanged(true, "renumbered");
                        MainWindow.this.netGUI.updateAll();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmRenumberFamilyIds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumberFamilyIds.text"));
        mntmRenumberFamilyIds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    NetUtils.renumberFamilies(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.setChanged(true, "renumbered");
                    MainWindow.this.netGUI.updateAll();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmRenumberFamilyIds.setEnabled(true);
        mnTransform.add(mntmRenumberFamilyIds);
        mnTransform.add(mntmRenumberIdsFrom);
        JMenuItem mntmFamiliesAsRelations = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddEditableFamilies.text"));
        mntmFamiliesAsRelations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RelationModel model = NetUtils.createRelationsFromFamilies(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.setChanged(true);
                    MainWindow.this.netGUI.addRelationTab(model);
                    MainWindow.this.netGUI.updateAll();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmRenumberIdsFrom_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumberIdsFrom_1.text"));
        mntmRenumberIdsFrom_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int count = NetUtils.renumberFromAttribute(MainWindow.this.netGUI.getNet(), "REFN");
                    String title = "Renumber ids from REFN Result";
                    String message = "Number of individuals renumbered: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    if (count > 0) {
                        MainWindow.this.netGUI.setChanged(true, "re-numbered");
                        MainWindow.this.netGUI.updateAll();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmRenumberIdsFrom_1);
        JSeparator separator_21 = new JSeparator();
        mnTransform.add(separator_21);
        mnTransform.add(mntmFamiliesAsRelations);
        JMenuItem mntmEnlargeFromAttributes = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEnlargeFromAttributes.text"));
        mntmEnlargeFromAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HashMap<String, String> husbandLabels = new HashMap<String, String>();
                husbandLabels.put("HUSB_prepar", "prepar");
                husbandLabels.put("HUSB_nompar", "nompar");
                husbandLabels.put("HUSB_premar", "premar");
                husbandLabels.put("HUSB_nommar", "nommar");
                HashMap<String, String> wifeLabels = new HashMap<String, String>();
                wifeLabels.put("WIFE_prepar", "prepar");
                wifeLabels.put("WIFE_nompar", "nompar");
                wifeLabels.put("WIFE_premar", "premar");
                wifeLabels.put("WIFE_nommar", "nommar");
                try {
                    NetUtils.enlargeNetFromAttributes(MainWindow.this.netGUI.getNet(), "prepar", "nompar", "premar", "nommar", "HUSB_prenom", "HUSB_nomnom", "WIFE_prenom", "WIFE_nomnom", husbandLabels, wifeLabels, "avipap", "avipan", "aviapp", "aviapn", "avimap", "aviman", "aviamp", "aviamn");
                }
                catch (PuckException e) {
                    e.printStackTrace();
                }
                MainWindow.this.netGUI.setChanged(true);
                MainWindow.this.netGUI.updateAll();
            }
        });
        JMenuItem mntmAddLifeEvents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddLifeEvents.text"));
        mntmAddLifeEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    RelationModel model = NetUtils.createLifeEvents(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.setChanged(true);
                    MainWindow.this.netGUI.addRelationTab(model);
                    MainWindow.this.netGUI.updateAll();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmFamiliesFromRelations = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFamiliesFromRelations.text"));
        mntmFamiliesFromRelations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String relationLabel = "HOUSEHOLD";
                    HashMap<String, String> labels = new HashMap<String, String>();
                    labels.put("husband", "chef");
                    labels.put("wife", "femme");
                    labels.put("son", "fils");
                    labels.put("daughter", "fille");
                    labels.put("otherSon", "fils d'autre part");
                    labels.put("otherDaughter", "fille d'autre part");
                    labels.put("otherWife", "femme d'autre part");
                    labels.put("naturalSon", "fils naturel");
                    labels.put("naturalDaughter", "fille naturelle");
                    labels.put("brother", "fr\ufffdre");
                    labels.put("sister", "s\ufffdur");
                    labels.put("husbandMother", "m\ufffdre");
                    NetUtils.createFamiliesFromRelations(MainWindow.this.netGUI.getNet(), relationLabel, labels);
                    MainWindow.this.netGUI.setChanged(true);
                    MainWindow.this.netGUI.updateAll();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmFamiliesFromRelations);
        mnTransform.add(mntmAddLifeEvents);
        JMenuItem mntmRelationsFromAttributes = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRelationsFromAttributes.text"));
        mntmRelationsFromAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String relationLabel = "HOUSEHOLD";
                    String roleLabel = "ROLE";
                    RelationModel model = NetUtils.createRelationsFromAttributes(MainWindow.this.netGUI.getNet(), relationLabel, roleLabel);
                    MainWindow.this.netGUI.setChanged(true);
                    MainWindow.this.netGUI.addRelationTab(model);
                    MainWindow.this.netGUI.updateAll();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmRelationsFromAttributes);
        mnTransform.add(mntmEnlargeFromAttributes);
        JSeparator separator_11 = new JSeparator();
        mnTransform.add(separator_11);
        JMenu mnReduce = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnReduce.text"));
        mnTransform.add(mnReduce);
        JMenuItem mntmCuttingTails = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyCuttingTails.text_1"));
        mnReduce.add(mntmCuttingTails);
        JMenuItem mntmCopyWithoutMarked = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutMarked.text"));
        mnReduce.add(mntmCopyWithoutMarked);
        JMenuItem mntmCopyWithoutStruct = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutStruct.text"));
        mnReduce.add(mntmCopyWithoutStruct);
        JMenuItem mntmEliminateSingles = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEliminateSingles.text"));
        mnReduce.add(mntmEliminateSingles);
        JMenuItem mntmCopyWithoutVirtuals = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutVirtuals.text"));
        mnReduce.add(mntmCopyWithoutVirtuals);
        mntmCopyWithoutVirtuals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = MainWindow.this.netGUI.getNet();
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    int count = NetUtils.eliminateVirtuals(newNet, currentIndividuals);
                    String title = "Eliminate Virtuals Individuals Result";
                    String message = "Number of individuals removed: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-wo_virtuals");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmEliminateSingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Chronometer chrono = new Chronometer();
                    Net newNet = MainWindow.this.netGUI.getNet();
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    int previousIndividualCount = newNet.individuals().size();
                    int count = NetUtils.eliminateSingles(newNet, currentIndividuals);
                    String title = "Eliminate Unmarried Result";
                    String message = String.format("Eliminated singles: %d\nPrevious count: %d\nUpdated count: %d\nTime spent: %d ms", count, previousIndividualCount, MainWindow.this.netGUI.getNet().individuals().size(), chrono.stop().interval());
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-no-singles");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmCopyWithoutStruct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = MainWindow.this.netGUI.getNet();
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    int count = NetUtils.eliminateStructuralChildren(newNet, currentIndividuals);
                    String title = "Eliminate Structural Children Result";
                    String message = "Number of individuals removed: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGUI = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGUI.setChanged(true, "-adults");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmCopyWithoutMarked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    Relations currentRelations = newNet.relations().getByIds(MainWindow.this.netGUI.getCurrentRelations().getIds());
                    Report report = new Report("Consolidation report");
                    NetUtils.eliminateDoubleIndividuals(newNet, currentIndividuals, report);
                    report.outputs().appendln();
                    NetUtils.eliminateDoubleRelations(newNet, currentRelations, report);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-univocal");
                    if (report.outputs().isNotEmpty()) {
                        newNetGui.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmCuttingTails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    int count = HairCutWorker.shave(newNet);
                    String title = "Haircut Result";
                    String message = "Number of individuals eliminated: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-shaved");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenu mnExtract = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnExtract.text"));
        mnTransform.add(mnExtract);
        JMenuItem mntmExtractCurrentSegment = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractCurrentSegment.text"));
        mnExtract.add(mntmExtractCurrentSegment);
        mntmExtractCurrentSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Segment segment = MainWindow.this.netGUI.getSegmentation().getCurrentSegment();
                    String segmentLabels = MainWindow.this.netGUI.getSegmentation().getSegmentLabels().toStringSeparatedBy("; ");
                    Net newNet = NetUtils.extract(MainWindow.this.netGUI.getNet(), segment, segmentLabels);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmCurrentCluster = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCurrentCluster.text_1"));
        mntmCurrentCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = NetUtils.extractCurrentCluster(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation());
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmCurrentCluster.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        mnExtract.add(mntmCurrentCluster);
        JMenuItem mntmExtractCore = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractCore.text"));
        mnExtract.add(mntmExtractCore);
        JMenuItem mntmKernel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKernel.text"));
        mnExtract.add(mntmKernel);
        JMenuItem mntmMaximalBicomponent = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMaximalBicomponent.text"));
        mnExtract.add(mntmMaximalBicomponent);
        mntmMaximalBicomponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net target = BicomponentWorker.getMaximalBicomponent(MainWindow.this.netGUI.getNet());
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
                    newNetGui.setChanged(true, "-maxBicomponent");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmExtractLargeClusters = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractLargeClusters.text"));
        mnExtract.add(mntmExtractLargeClusters);
        JMenuItem mntmExtractPositiveCluster = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractPositiveCluster.text"));
        mnExtract.add(mntmExtractPositiveCluster);
        mntmExtractPositiveCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ClusterValueExtractionInputWindow window = new ClusterValueExtractionInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmExtractLargeClusters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ClusterSizeExtractionInputWindow window = new ClusterSizeExtractionInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmKernel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net target = BicomponentWorker.getKernel(MainWindow.this.netGUI.getNet());
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
                    newNetGui.setChanged(true, "-kernel");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmExtractCore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net target = BicomponentWorker.getCore(MainWindow.this.netGUI.getNet());
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
                    newNetGui.setChanged(true, "-core");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JSeparator separator_17 = new JSeparator();
        mnTransform.add(separator_17);
        JMenuItem mntmShufflePgraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmShufflePgraph.text"));
        mntmShufflePgraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ReshufflingNetworkInputWindow window = new ReshufflingNetworkInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenu mnNewMenu = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text_2"));
        mnTransform.add(mnNewMenu);
        JMenuItem mntmUniversal = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUniversal.text"));
        mntmUniversal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.KIN, FiliationType.COGNATIC, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_ALL_KIN");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmAllRelated = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAllRelated.text"));
        mntmAllRelated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.RELATED, null, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_RELATIONS");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmUniversal_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUniversal_1.text"));
        mntmUniversal_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.ALL, FiliationType.COGNATIC, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_ALL");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmSpecialFeature = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSpecialFeature.text"));
        mntmSpecialFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExpandCriteria criteria = ExpandInputDialog.showDialog();
                    if (criteria != null) {
                        Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), criteria.getExpansionMode(), criteria.getFiliationType(), criteria.getMaxStep());
                        NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                        newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_" + criteria.getSubTitle());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmSpecialFeature);
        mnNewMenu.add(mntmUniversal_1);
        mnNewMenu.add(mntmAllRelated);
        mnNewMenu.add(mntmUniversal);
        JMenuItem mntmBottomup = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBottomup.text"));
        mntmBottomup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.PARENT, FiliationType.COGNATIC, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_UP");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmBottomup);
        JMenuItem mntmTopdown = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTopdown.text"));
        mntmTopdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.CHILD, FiliationType.COGNATIC, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_DOWN");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmAscendingagnatic = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAscendingagnatic.text"));
        mntmAscendingagnatic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.PARENT, FiliationType.AGNATIC, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_UP_A");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmAscendingagnatic);
        JMenuItem mntmAscendinguterine = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAscendinguterine.text"));
        mntmAscendinguterine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.PARENT, FiliationType.UTERINE, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_UP");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmAscendinguterine);
        mnNewMenu.add(mntmTopdown);
        JMenuItem mntmConjugal = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmConjugal.text"));
        mntmConjugal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.SPOUSE, FiliationType.COGNATIC, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_MARR");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmDescendingagnatic = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDescendingagnatic.text"));
        mntmDescendingagnatic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.CHILD, FiliationType.AGNATIC, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_DOWN_A");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmDescendingagnatic);
        JMenuItem mntmDescendinguterine = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDescendinguterine.text"));
        mntmDescendinguterine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.CHILD, FiliationType.UTERINE, 0);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_DOWN_U");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmDescendinguterine);
        mnNewMenu.add(mntmConjugal);
        JSeparator separator_15 = new JSeparator();
        mnTransform.add(separator_15);
        JMenu mnShrink = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnShrink.text"));
        mnTransform.add(mnShrink);
        JMenuItem mntmInterMarriageReport = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmIntermarriageReport.text"));
        mnShrink.add(mntmInterMarriageReport);
        JMenuItem mntmFlowReport = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFlowReport_1.text"));
        mnShrink.add(mntmFlowReport);
        mntmFlowReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FlowNetworkInputWindow window = new FlowNetworkInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmInterMarriageReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AllianceNetworkInputWindow window = new AllianceNetworkInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JSeparator separator_16 = new JSeparator();
        mnTransform.add(separator_16);
        mnTransform.add(mntmShufflePgraph);
        JMenuItem mntmVirtualFieldwork = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVirtualFieldwork.text"));
        mntmVirtualFieldwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FieldworkInputWindow window = new FieldworkInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmVirtualFieldwork);
        JMenuItem mntmVirtualFieldworkVariations = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVirtualFieldworkVariations.text"));
        mntmVirtualFieldworkVariations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = RandomNetReporter.reportVirtualFieldworkVariations(MainWindow.this.netGUI.getSegmentation());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (PuckException e) {
                    e.printStackTrace();
                }
            }
        });
        mnTransform.add(mntmVirtualFieldworkVariations);
        JMenu mnCensus = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnCensus.text"));
        menuBar.add(mnCensus);
        JMenuItem mntmPedigree = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPedigree.text"));
        mntmPedigree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Individual ego = MainWindow.this.netGUI.selectedIndividual();
                    if (ego == null) {
                        String title = "Information";
                        String message = "Please, select an individual on the list.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                    } else {
                        String parameter = JOptionPane.showInputDialog(null, "Maximal generational depth: ", "Pedigree Report", 3);
                        logger.debug("parameter=[" + parameter + "]");
                        if (parameter != null) {
                            int maxDepth = Integer.parseInt(parameter);
                            Report report = CensusReporter.reportPedigree(MainWindow.this.netGUI.getNet().getLabel(), ego, maxDepth);
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmPedigree);
        JMenuItem mntmRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRelatives.text"));
        mntmRelatives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Individual ego = MainWindow.this.netGUI.selectedIndividual();
                    if (ego == null) {
                        String title = "Information";
                        String message = "Please, select an individual on the list.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                    } else {
                        String parameter = JOptionPane.showInputDialog(null, "Enter kinship string (in positional notation): ", "Chains Report", 3);
                        logger.debug("parameter=[" + parameter + "]");
                        Report report = CensusReporter.reportRelatives(MainWindow.this.netGUI.getNet().getLabel(), ego, parameter);
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmProgeniture = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmProgeniture.text"));
        mntmProgeniture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Individual ego = MainWindow.this.netGUI.selectedIndividual();
                    if (ego == null) {
                        String title = "Information";
                        String message = "Please, select an individual on the list.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                    } else {
                        String parameter = JOptionPane.showInputDialog(null, "Maximal generational depth: ", "Progeniture Report", 3);
                        logger.debug("parameter=[" + parameter + "]");
                        if (parameter != null) {
                            int maxDepth = Integer.parseInt(parameter);
                            Report report = CensusReporter.reportProgeniture(MainWindow.this.netGUI.getNet().getLabel(), ego, maxDepth);
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmProgeniture);
        mnCensus.add(mntmRelatives);
        JMenuItem mntmKinshipChains = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKinshipChains.text"));
        mntmKinshipChains.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Individual ego = MainWindow.this.netGUI.selectedIndividual();
                    if (ego == null) {
                        String title = "Information";
                        String message = "Please, select an individual on the list.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                    } else {
                        KinshipChainsCriteria criteria = KinshipChainsInputDialog.showDialog();
                        if (criteria != null) {
                            Individual alter = MainWindow.this.netGUI.getNet().get(criteria.getAlterId());
                            Report report = CensusReporter.reportKinshipChains(MainWindow.this.netGUI.getNet().getLabel(), ego, alter, criteria.getMaximalDepth(), criteria.getMaximalOrder(), criteria.getChainClassification());
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmKinshipChains);
        JMenuItem mntmFindCircuit2 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFindCircuit2.text"));
        mntmFindCircuit2.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        mntmFindCircuit2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CensusInputWindow window = new CensusInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmDistances = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDistances.text"));
        mntmDistances.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    DistanceAttributeCriteria criteria = DistanceAttributeInputDialog.showDialog();
                    if (criteria != null) {
                        Individual ego = MainWindow.this.netGUI.selectedIndividual();
                        if (ego == null) {
                            throw new IllegalArgumentException("Please, select an individual in tab.");
                        }
                        StatisticsWorker.getDistances(ego, criteria.getMaxDistance(), criteria.getFiliationType());
                        MainWindow.this.netGUI.updateAll();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmDistances);
        JSeparator separator_13 = new JSeparator();
        mnCensus.add(separator_13);
        JMenuItem mntmBasicInformation = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBasicInformation.text"));
        mnCensus.add(mntmBasicInformation);
        mntmBasicInformation.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        mntmBasicInformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Chronometer chrono = new Chronometer();
                    Report report = StatisticsReporter.reportBasicInformation(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation());
                    chrono.stop();
                    logger.info(String.format("Time spent: %d ms", chrono.interval()));
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmBasicGraphs = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBasicGraphs.text"));
        mnCensus.add(mntmBasicGraphs);
        mntmBasicGraphs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StatisticsInputWindow window = new StatisticsInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmBasicGraphs.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        JMenuItem mntmPartitionStatistics = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPartitionStatistics.text"));
        mntmPartitionStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PartitionStatisticsInputWindow window = new PartitionStatisticsInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmPartitionStatistics);
        JSeparator separator_14 = new JSeparator();
        mnCensus.add(separator_14);
        mnCensus.add(mntmFindCircuit2);
        JMenuItem mntmDifferentialCensus = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDifferentialCensus.text"));
        mntmDifferentialCensus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    DifferentialCensusInputWindow window = new DifferentialCensusInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmDifferentialCensus);
        JSeparator separator_12 = new JSeparator();
        mnCensus.add(separator_12);
        JMenuItem mntmSynopsis = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSynopsis.text"));
        mntmSynopsis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File file = MainWindow.selectFolder(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile().getParentFile());
                if (file != null) {
                    String directory = file.getAbsolutePath();
                    Report report = StatisticsReporter.reportSynopsis(directory);
                    MainWindow.this.netGUI.addReportTab(report);
                }
            }
        });
        mnCensus.add(mntmSynopsis);
        JMenu mnTerms = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTerms.text"));
        menuBar.add(mnTerms);
        JMenuItem mntmListChains = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListChains.text"));
        mntmListChains.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = CensusReporter.reportKinshipChainsForTerms(MainWindow.this.netGUI.getSegmentation());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmListWithTypes = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListWithTypes.text"));
        mntmListWithTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = StatisticsReporter.reportTerms(MainWindow.this.netGUI.getSegmentation());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTerms.add(mntmListWithTypes);
        mnTerms.add(mntmListChains);
        JMenuItem mntmReciprocals = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmReciprocals.text"));
        mntmReciprocals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = CensusReporter.reportReciprocalTerms(MainWindow.this.netGUI.getSegmentation());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTerms.add(mntmReciprocals);
        JMenuItem mntmProducts = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmProducts.text"));
        mntmProducts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = CensusReporter.reportTermProducts(MainWindow.this.netGUI.getSegmentation());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTerms.add(mntmProducts);
        JMenuItem mntmTest = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTest.text"));
        mntmTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    int maxDistance = 10;
                    int maxIterations = 2;
                    RelationModel model2 = RelationModelMaker.create(MainWindow.this.netGUI.getNet());
                    Report report = new RelationModelReporter(model2).reportModel(maxIterations);
                    MainWindow.this.netGUI.addReportTab(report);
                    MainWindow.this.netGUI.addRelationTab(model2);
                    MainWindow.this.netGUI.setChanged(true);
                    MainWindow.this.netGUI.updateAll();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTerms.add(mntmTest);
        JMenu mnRelations = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnRelations.text"));
        menuBar.add(mnRelations);
        JMenuItem mntmAddModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddModel.text"));
        mntmAddModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RelationModelInputWindow window = new RelationModelInputWindow(MainWindow.this.netGUI, null);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnRelations.add(mntmAddModel);
        JMenuItem mntmImportModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportModel.text"));
        mntmImportModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = MainWindow.selectRelationModelFileToLoad(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());
                    if (file != null) {
                        StringList list = RelationModelTXTFile.load(file, "UTF-8");
                        RelationModel model = RelationModelMaker.create(file.getName(), list);
                        MainWindow.this.netGUI.addRelationTab(model);
                        MainWindow.this.netGUI.setChanged(true);
                        MainWindow.this.netGUI.updateAll();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnRelations.add(mntmImportModel);
        JMenuItem mntmFromGenealogy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFromGenealogy.text"));
        mntmFromGenealogy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    RelationModel model = RelationModelMaker.create(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.addRelationTab(model);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnRelations.add(mntmFromGenealogy);
        JMenu mnSequences = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnSequences.text"));
        menuBar.add(mnSequences);
        JMenu mnReports = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnReports.text_1"));
        mnSequences.add(mnReports);
        JMenuItem mntmItineraries = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmItineraries.text_1"));
        mntmItineraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    SpaceTimeCriteria criteria = new SpaceTimeCriteria();
                    Report report = SequenceReporter.reportSequences(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation(), criteria);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnReports.add(mntmItineraries);
        JMenuItem mntmSliceReport = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSliceReport.text"));
        mntmSliceReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    SpaceTimeCriteria criteria = new SpaceTimeCriteria();
                    criteria.setRelationModelName("RESIDENCE");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnReports.add(mntmSliceReport);
        JMenu mnAnalysis = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnAnalysis.text"));
        mnSequences.add(mnAnalysis);
        JMenu mnSequences_1 = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnSequences_1.text"));
        mnAnalysis.add(mnSequences_1);
        JMenuItem mntmGeneralSequenceStatistics = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmGeneralSequenceStatistics.text"));
        mntmGeneralSequenceStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = SequenceReporter.reportSequenceCensus(MainWindow.this.netGUI.getSegmentation(), SpaceTimeCriteria.CensusType.GENERAL);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSequences_1.add(mntmGeneralSequenceStatistics);
        JMenuItem mntmTrajectories = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTrajectories.text"));
        mntmTrajectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = SequenceReporter.reportSequenceCensus(MainWindow.this.netGUI.getSegmentation(), SpaceTimeCriteria.CensusType.PARCOURS);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSequences_1.add(mntmTrajectories);
        JMenuItem menuItem_3 = new JMenuItem("Ego-Networks");
        menuItem_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = SequenceReporter.reportSequenceCensus(MainWindow.this.netGUI.getSegmentation(), SpaceTimeCriteria.CensusType.EGONETWORKS);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSequences_1.add(menuItem_3);
        JMenuItem menuItem_4 = new JMenuItem("Parcours-Networks");
        menuItem_4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = SequenceReporter.reportSequenceCensus(MainWindow.this.netGUI.getSegmentation(), SpaceTimeCriteria.CensusType.PARCOURSNETWORKS);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSequences_1.add(menuItem_4);
        JMenu mnSlices = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnSlices.text"));
        mnAnalysis.add(mnSlices);
        JMenuItem mntmGeneralSliceStatistics = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmGeneralSliceStatistics.text"));
        mntmGeneralSliceStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StatisticsCriteria criteria = new StatisticsCriteria();
                SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(SpaceTimeCriteria.CensusType.PARCOURS);
                PartitionCriteria placeCriteria = PartitionCriteria.createRaw("BIRT_PLAC");
                placeCriteria.setLabelParameter("Afagnangbleta");
                criteria.getPartitionCriterias().add(placeCriteria);
                criteria.getPartitionCriterias().add(PartitionCriteria.createSizedGrouping("AGE", null, 0.0, 20.0, null));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("QUARTER"));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("PATRIL"));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("OCCU"));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("MATRISTATUS"));
                criteria.setPlaceParameter("DEPARTMENT");
                SpaceTimeCriteria sliceCriteria = new SpaceTimeCriteria();
                sliceCriteria.setRelationModelName("RESIDENCE");
                sliceCriteria.setLocalUnitLabel("HOUSE");
                String referentName = censusCriteria.getDefaultReferentRoleName();
                try {
                    Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(sliceCriteria.getRelationModelName());
                    for (Relation relation : relations) {
                        relation.updateReferents(referentName);
                    }
                    Slices relationCensus = SliceMaker.createSlices(MainWindow.this.netGUI.getSegmentation(), sliceCriteria);
                    Report report1 = SliceReporter.reportIndividualStatics(relationCensus, criteria);
                    MainWindow.this.netGUI.addReportTab(report1);
                    Report report2 = SliceReporter.reportIndividualDynamics(relationCensus, criteria);
                    MainWindow.this.netGUI.addReportTab(report2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSlices.add(mntmGeneralSliceStatistics);
        JMenuItem mntmTrajectoriesgroups = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTrajectoriesgroups.text"));
        mntmTrajectoriesgroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsCriteria criteria = new StatisticsCriteria();
                SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(SpaceTimeCriteria.CensusType.PARCOURS);
                PartitionCriteria placeCriteria = PartitionCriteria.createRaw("BIRT_PLAC");
                placeCriteria.setLabelParameter("Afagnangbleta");
                criteria.getPartitionCriterias().add(placeCriteria);
                criteria.getPartitionCriterias().add(PartitionCriteria.createSizedGrouping("AGE", null, 0.0, 20.0, null));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("QUARTER"));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("PATRIL"));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("OCCU"));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("MATRISTATUS"));
                criteria.setPlaceParameter("DEPARTMENT");
                SpaceTimeCriteria sliceCriteria = new SpaceTimeCriteria();
                sliceCriteria.setRelationModelName("RESIDENCE");
                sliceCriteria.setLocalUnitLabel("HOUSE");
                String referentName = censusCriteria.getDefaultReferentRoleName();
                try {
                    Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(sliceCriteria.getRelationModelName());
                    for (Relation relation : relations) {
                        relation.updateReferents(referentName);
                    }
                    Slices relationCensus = SliceMaker.createSlices(MainWindow.this.netGUI.getSegmentation(), sliceCriteria);
                    Report report3 = SliceReporter.reportDevelopmentCycles(relationCensus, criteria);
                    MainWindow.this.netGUI.addReportTab(report3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSlices.add(mntmTrajectoriesgroups);
        JMenuItem mntmEgoNetworks = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEgoNetworks.text"));
        mntmEgoNetworks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StatisticsCriteria criteria = new StatisticsCriteria();
                SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(SpaceTimeCriteria.CensusType.PARCOURS);
                PartitionCriteria placeCriteria = PartitionCriteria.createRaw("BIRT_PLAC");
                placeCriteria.setLabelParameter("Afagnangbleta");
                criteria.getPartitionCriterias().add(placeCriteria);
                criteria.getPartitionCriterias().add(PartitionCriteria.createSizedGrouping("AGE", null, 0.0, 20.0, null));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("QUARTER"));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("PATRIL"));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("OCCU"));
                criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("MATRISTATUS"));
                criteria.setPlaceParameter("DEPARTMENT");
                SpaceTimeCriteria sliceCriteria = new SpaceTimeCriteria();
                sliceCriteria.setRelationModelName("RESIDENCE");
                sliceCriteria.setLocalUnitLabel("HOUSE");
                sliceCriteria.setRelationClassificationTypes(new ArrayList<SpaceTimeCriteria.RelationClassificationType>());
                sliceCriteria.setEgoRoleName("RESIDENT");
                String referentName = censusCriteria.getDefaultReferentRoleName();
                try {
                    Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(sliceCriteria.getRelationModelName());
                    for (Relation relation : relations) {
                        relation.updateReferents(referentName);
                    }
                    Slices relationCensus = SliceMaker.createSlices(MainWindow.this.netGUI.getSegmentation(), sliceCriteria);
                    Report report = SliceReporter.reportEgoNetworks(relationCensus, criteria);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSlices.add(mntmEgoNetworks);
        JMenuItem mntmInternalStructures = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmInternalStructures.text"));
        mntmInternalStructures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(SpaceTimeCriteria.CensusType.PARCOURS);
                censusCriteria.setRelationModelName("MIGEVENT");
                String relationModelName = censusCriteria.getRelationModelName();
                String referentName = censusCriteria.getDefaultReferentRoleName();
                Integer[] times = censusCriteria.getDates();
                times = null;
                boolean reducedTrees = true;
                try {
                    Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(relationModelName);
                    for (Relation relation : relations) {
                        relation.updateReferents(referentName);
                    }
                    Report report = null;
                    if (times == null) {
                        report = RelationReporter.reportTreeStructure(MainWindow.this.netGUI.getSegmentation(), censusCriteria, null, reducedTrees);
                        MainWindow.this.netGUI.addReportTab(report);
                    } else {
                        Integer[] integerArray = times;
                        int n = times.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int time = integerArray[n2];
                            report = RelationReporter.reportTreeStructure(MainWindow.this.netGUI.getSegmentation(), censusCriteria, time, reducedTrees);
                            MainWindow.this.netGUI.addReportTab(report);
                            ++n2;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnAnalysis.add(mntmInternalStructures);
        JMenuItem mntmCircuitCensus = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCircuitCensus.text"));
        mntmCircuitCensus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SpaceTimeCriteria criteria = new SpaceTimeCriteria();
                criteria.setRelationModelName("RESIDENCE");
                criteria.setEgoRoleName("RESIDENT");
                criteria.setRoleNames(Arrays.asList("REFERENT"));
                try {
                    for (Report report3 : RelationReporter.reportRelationCensus(MainWindow.this.netGUI.getSegmentation(), criteria)) {
                        MainWindow.this.netGUI.addReportTab(report3);
                    }
                }
                catch (PuckException e) {
                    e.printStackTrace();
                }
            }
        });
        mnAnalysis.add(mntmCircuitCensus);
        JMenuItem mntmDifferentialCircuitCensus = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDifferentialCircuitCensus.text"));
        mntmDifferentialCircuitCensus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CensusCriteria criteria = new CensusCriteria();
                    SpaceTimeCriteria spaceTimeCriteria = new SpaceTimeCriteria();
                    spaceTimeCriteria.setRelationModelName("RESIDENCE");
                    criteria.setPattern(spaceTimeCriteria.getPattern());
                    criteria.setChainClassification(spaceTimeCriteria.getChainClassification());
                    PuckGUI.instance().getPreferences().setDifferentialCensusCriteria(criteria);
                    Integer[] dates = spaceTimeCriteria.getDates();
                    if (dates == null) {
                        Report report = CensusReporter.reportDifferentialCensus(MainWindow.this.netGUI.getSegmentation(), spaceTimeCriteria, null, criteria);
                        MainWindow.this.netGUI.addReportTab(report);
                    } else {
                        Integer[] integerArray = dates;
                        int n = dates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Integer date = integerArray[n2];
                            Report report = CensusReporter.reportDifferentialCensus(MainWindow.this.netGUI.getSegmentation(), spaceTimeCriteria, date, criteria);
                            MainWindow.this.netGUI.addReportTab(report);
                            ++n2;
                        }
                    }
                }
                catch (PuckException exception) {
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            }
        });
        mnAnalysis.add(mntmDifferentialCircuitCensus);
        JMenu mnTransform_1 = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTransform_1.text"));
        mnSequences.add(mnTransform_1);
        JMenuItem mntmTransform = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCensus.text"));
        mntmTransform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getSegmentation(), null);
                    AddChildRolesCriteria criteria = AddChildRolesInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels(), attributeDescriptors);
                    RelationWorker.addChildRoles(MainWindow.this.netGUI.getNet(), criteria);
                    MainWindow.this.netGUI.updateAll();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform_1.add(mntmTransform);
        JMenu mnControls_1 = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnControls_1.text"));
        mnSequences.add(mnControls_1);
        JMenuItem mntmUnknownPlaces = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUnknownPlaces.text"));
        mnControls_1.add(mntmUnknownPlaces);
        JMenuItem mntmUnknownPlaces_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUnknownPlaces_1.text"));
        mntmUnknownPlaces_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    StringList relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
                    UnknownPlacesCriteria criteria = UnknownPlacesInputDialog.showDialog(relationModelNames);
                    if (criteria != null) {
                        Report report = SequenceReporter.reportUnknownPlaces(MainWindow.this.netGUI.getSegmentation(), criteria, ResourceBundle.getBundle("org.tip.puckgui.messages"));
                        if (report.status() == 0) {
                            String title = "Control special features report";
                            String message = "No special features found.";
                            JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        } else {
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls_1.add(mntmUnknownPlaces_1);
        JMenuItem mntmUncodedPlaces = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUncodedPlaces.text"));
        mntmUncodedPlaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = SequenceReporter.reportUncodedPlaces(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls_1.add(mntmUncodedPlaces);
        JMenuItem mntmUnknownRelations = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUnknownRelations.text"));
        mntmUnknownRelations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getCurrentRelations(), null);
                    SpaceTimeCriteria criteria = DiscontinuousItinerariesInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels(), attributeDescriptors);
                    criteria.getRelationModelNames().add("RELATIVE");
                    criteria.getRelationModelNames().add("APPRENTICESHIP");
                    criteria.getRelationModelNames().add("FRIENDSHIP");
                    criteria.getRelationModelNames().add("RENT");
                    criteria.getRelationModelNames().add("EMPLOYMENT");
                    criteria.getRelationModelNames().add("INITIATION");
                    criteria.getRelationModelNames().add("UNRELATED");
                    if (criteria != null) {
                        Report report = SequenceReporter.reportUnknownRelations(MainWindow.this.netGUI.getSegmentation(), criteria, ResourceBundle.getBundle("org.tip.puckgui.messages"));
                        if (report.status() == 0) {
                            String title = "Control special features report";
                            String message = "No special features found.";
                            JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        } else {
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls_1.add(mntmUnknownRelations);
        JMenuItem mntmDiscontinuousItineraries = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDiscontinuousItineraries.text"));
        mnControls_1.add(mntmDiscontinuousItineraries);
        JMenuItem mntmDiscontinousBiographies = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDiscontinousBiographies.text"));
        mntmDiscontinousBiographies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getCurrentRelations(), null);
                    SpaceTimeCriteria criteria = DiscontinuousItinerariesInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels(), attributeDescriptors);
                    if (criteria != null) {
                        Report report = SequenceReporter.reportDiscontinuousBiographies(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation(), criteria, ResourceBundle.getBundle("org.tip.puckgui.messages"));
                        if (report.status() == 0) {
                            String title = "Control special features report";
                            String message = "No special features found.";
                            JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        } else {
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls_1.add(mntmDiscontinousBiographies);
        JMenuItem mntmMissingWitnesses = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMissingWitnesses.text"));
        mnControls_1.add(mntmMissingWitnesses);
        JSeparator separator_22 = new JSeparator();
        mnSequences.add(separator_22);
        JMenuItem mntmRelationAnalysis = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRelationAnalysis.text"));
        mntmRelationAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getSegmentation().getCurrentRelations(), null);
                    SpaceTimeCriteria criteria = RelationAnalysisInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels(), attributeDescriptors);
                    if (criteria != null) {
                        Object censusCriteria = new SpaceTimeCriteria(SpaceTimeCriteria.CensusType.PARCOURS);
                        String relationModelName = ((SpaceTimeCriteria)censusCriteria).getRelationModelName();
                        String referentName = ((SpaceTimeCriteria)censusCriteria).getDefaultReferentRoleName();
                        Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(relationModelName);
                        for (Relation relation : relations) {
                            relation.updateReferents(referentName);
                        }
                        boolean reducedTrees = true;
                        Report report = RelationReporter.reportTreeStructure(MainWindow.this.netGUI.getSegmentation(), (SpaceTimeCriteria)censusCriteria, null, reducedTrees);
                        MainWindow.this.netGUI.addReportTab(report);
                        criteria.setEgoRoleName("RESIDENT");
                        criteria.setRoleNames(Arrays.asList("REFERENT"));
                        for (Report report3 : RelationReporter.reportRelationCensus(MainWindow.this.netGUI.getSegmentation(), criteria)) {
                            MainWindow.this.netGUI.addReportTab(report3);
                        }
                        censusCriteria = new CensusCriteria();
                        ((CensusCriteria)censusCriteria).setPattern(criteria.getPattern());
                        ((CensusCriteria)censusCriteria).setChainClassification(criteria.getChainClassification());
                        PuckGUI.instance().getPreferences().setDifferentialCensusCriteria((CensusCriteria)censusCriteria);
                        Integer[] dates = criteria.getDates();
                        if (dates == null) {
                            Report report2 = CensusReporter.reportDifferentialCensus(MainWindow.this.netGUI.getSegmentation(), criteria, null, (CensusCriteria)censusCriteria);
                            MainWindow.this.netGUI.addReportTab(report2);
                        } else {
                            Integer[] integerArray = dates;
                            int n = dates.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Integer date = integerArray[n2];
                                Report report3 = CensusReporter.reportDifferentialCensus(MainWindow.this.netGUI.getSegmentation(), criteria, date, (CensusCriteria)censusCriteria);
                                MainWindow.this.netGUI.addReportTab(report3);
                                ++n2;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSequences.add(mntmRelationAnalysis);
        JMenuItem mntmConvertGeography = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmConvertGeographytemp.text"));
        mntmConvertGeography.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String targetFileName = "togo.geo.csv";
                    File targetFile = GeographyExportFileSelector.showSelectorDialog(MainWindow.this.frmPuck, new File(targetFileName));
                    if (targetFile != null) {
                        GEOXLSFile.save(targetFile, Geography.getInstance());
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSequences.add(mntmConvertGeography);
        JMenuItem mntmSpaceTimeAnalysis = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSpaceTimeAnalysis.text"));
        mntmSpaceTimeAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getSegmentation(), null);
                    SpaceTimeCriteria criteria = SpaceTimeAnalysisInputDialog.showDialog(MainWindow.this.netGUI.getSegmentation(), MainWindow.this.netGUI.getNet().relationModels(), attributeDescriptors);
                    if (criteria != null) {
                        ReportList reports = SpaceTimeReporter.reportHugeAnalysis(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation(), criteria, ResourceBundle.getBundle("org.tip.puckgui.messages"));
                        for (Report report : reports) {
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                        if (criteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.DRAW)) {
                            Graph<Place2> geocodedGraph = SequenceReporter.getTrajectoryGraph2(MainWindow.this.netGUI.getNet().getGeography2(), MainWindow.this.netGUI.getSegmentation(), criteria);
                            MapPanel2 geographyMap = new MapPanel2(geocodedGraph);
                            MainWindow.this.addTab("Geography", geographyMap);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnSequences.add(mntmSpaceTimeAnalysis);
        mntmMissingWitnesses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    MissingTestimoniesCriteria criteria = MissingTestimoniesInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels());
                    if (criteria != null) {
                        Report report = SequenceReporter.reportMissingTestimonies(MainWindow.this.netGUI.getSegmentation(), criteria, ResourceBundle.getBundle("org.tip.puckgui.messages"));
                        if (report.status() == 0) {
                            String title = "Control special features report";
                            String message = "No special features found.";
                            JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        } else {
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmDiscontinuousItineraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getCurrentRelations(), null);
                    SpaceTimeCriteria criteria = DiscontinuousItinerariesInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels(), attributeDescriptors);
                    if (criteria != null) {
                        Report report = SequenceReporter.reportDiscontinuousItineraries(MainWindow.this.netGUI.getSegmentation(), criteria, ResourceBundle.getBundle("org.tip.puckgui.messages"));
                        if (report.status() == 0) {
                            String title = "Control special features report";
                            String message = "No special features found.";
                            JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        } else {
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmUnknownPlaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = SequenceReporter.reportUnknownPlaces(MainWindow.this.netGUI.getSegmentation(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenu mnDraw = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnDraw.text"));
        menuBar.add(mnDraw);
        JMenuItem mntmOregraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOregraph.text"));
        mntmOregraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Graph<Individual> graph = NetUtils.createOreGraph(MainWindow.this.netGUI.getSegmentation());
                    VisualizationController vizController = VisualizationController.getSharedInstance();
                    VisualizationPanel buildView = vizController.buildView(graph, OreGraph.class);
                    MainWindow.this.addTab("Ore-Graph Draw", buildView);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mnDraw.add(mntmOregraph);
        JMenuItem mntmPgraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPgraph.text"));
        mntmPgraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Graph<Individual> graph = NetUtils.createOreGraph(MainWindow.this.netGUI.getSegmentation());
                    VisualizationController vizController = VisualizationController.getSharedInstance();
                    VisualizationPanel buildView = vizController.buildView(graph, PGraph.class);
                    MainWindow.this.addTab("P-Graph Draw", buildView);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mnDraw.add(mntmPgraph);
        JMenuItem mntmFullDiagram = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFullDiagram.text"));
        mntmFullDiagram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Individuals currentIndividuals = MainWindow.this.netGUI.getCurrentIndividuals();
                GlobalDiagramPanel diagramPanel = new GlobalDiagramPanel(MainWindow.this.netGUI, currentIndividuals);
                MainWindow.this.addTab("Full diagram", diagramPanel);
            }
        });
        JMenuItem mntmKinoath = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKinoath.text"));
        mntmKinoath.setEnabled(false);
        mnDraw.add(mntmKinoath);
        mnDraw.add(mntmFullDiagram);
        JMenuItem mntmComponentDiagrams = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmComponentDiagram.text"));
        mntmComponentDiagrams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Individuals currentIndividuals = MainWindow.this.netGUI.getCurrentIndividuals();
                IndividualGroups groups = ComponentWorker.searchKinComponents(currentIndividuals);
                IndividualGroupDiagramsPanel diagramPanel = new IndividualGroupDiagramsPanel(MainWindow.this.netGUI, groups);
                MainWindow.this.addReportTab("Component diagrams", diagramPanel);
            }
        });
        JMenuItem mntmIndividualDiagrams = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmIndividualDiagram.text"));
        mntmIndividualDiagrams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel diagramPanel = new IndividualDiagramsPanel(MainWindow.this.netGUI);
                diagramPanel.update(MainWindow.this.getIndividualsTab().getSelectedIndividual());
                MainWindow.this.addReportTab("Ind. diagrams", diagramPanel);
            }
        });
        mnDraw.add(mntmIndividualDiagrams);
        JMenuItem mntmSegmentDiagrams = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPartitionDiagrams.text"));
        mntmSegmentDiagrams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualGroups groups = SegmentationWorker.convert(MainWindow.this.netGUI.getSegmentation().getCurrentSegment());
                IndividualGroupDiagramsPanel diagramPanel = new IndividualGroupDiagramsPanel(MainWindow.this.netGUI, groups);
                MainWindow.this.addReportTab("Segment diagrams", diagramPanel);
            }
        });
        mnDraw.add(mntmSegmentDiagrams);
        mnDraw.add(mntmComponentDiagrams);
        JMenuItem mntmGeneaquilt = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmGeneaquilt.text"));
        mntmGeneaquilt.setEnabled(false);
        mnDraw.add(mntmGeneaquilt);
        JMenuItem mntmGeneaQuiltViewFull = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuiltDiagram.text"));
        mntmGeneaQuiltViewFull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Network network = GeneaQuiltConvert.convertToGeneaQuilt(MainWindow.this.netGUI.getNet());
                logger.debug("convert done.");
                GeneaQuiltPanel geneaQuiltPanel = new GeneaQuiltPanel((JComponent)MainWindow.this.tabbedPaneCorpus, network);
                logger.debug("panel done.");
                MainWindow.this.addReportTab("Full quilt", (JPanel)geneaQuiltPanel);
            }
        });
        mnDraw.add(mntmGeneaQuiltViewFull);
        JMenuItem mntmGeneaQuiltSegment = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSegmentQuilt.text"));
        mntmGeneaQuiltSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Network network = GeneaQuiltConvert.convertToGeneaQuilt(MainWindow.this.netGUI.getCurrentIndividuals(), MainWindow.this.netGUI.getCurrentFamilies());
                logger.debug("convert done.");
                GeneaQuiltPanel geneaQuiltPanel = new GeneaQuiltPanel((JComponent)MainWindow.this.tabbedPaneCorpus, network);
                logger.debug("panel done.");
                MainWindow.this.addReportTab("Segment quilt", (JPanel)geneaQuiltPanel);
            }
        });
        mnDraw.add(mntmGeneaQuiltSegment);
        JMenuItem mntmGeneaQuiltSegments = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSegmentQuilts.text"));
        mntmGeneaQuiltSegments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualGroups groups = SegmentationWorker.convert(MainWindow.this.netGUI.getSegmentation().getCurrentSegment());
                IndividualGroupQuiltsPanel diagramPanel = new IndividualGroupQuiltsPanel(MainWindow.this.netGUI, groups);
                MainWindow.this.addReportTab("Segment quilts", diagramPanel);
            }
        });
        mnDraw.add(mntmGeneaQuiltSegments);
        JMenuItem mntmGeneaQuiltComponents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmComponentQuilts.text"));
        mntmGeneaQuiltComponents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Individuals currentIndividuals = MainWindow.this.netGUI.getCurrentIndividuals();
                IndividualGroups groups = ComponentWorker.searchKinComponents(currentIndividuals);
                IndividualGroupQuiltsPanel quiltPanel = new IndividualGroupQuiltsPanel(MainWindow.this.netGUI, groups);
                MainWindow.this.addReportTab("Component quilts", quiltPanel);
            }
        });
        mnDraw.add(mntmGeneaQuiltComponents);
        JMenuItem mntmEventquiltViews = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEventquiltViews.text"));
        mntmEventquiltViews.setEnabled(false);
        mnDraw.add(mntmEventquiltViews);
        JMenuItem mntmEventQuiltFull = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFullQuilt.text"));
        mntmEventQuiltFull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Network network = GeneaQuiltConvert.convertToEventQuilt(MainWindow.this.netGUI.getNet());
                logger.debug("convert done.");
                GeneaQuiltPanel geneaQuiltPanel = new GeneaQuiltPanel((JComponent)MainWindow.this.tabbedPaneCorpus, network, VertexComparator.Sorting.DATERANGE_START);
                logger.debug("panel done.");
                MainWindow.this.addReportTab("Full event quilt", (JPanel)geneaQuiltPanel);
            }
        });
        mnDraw.add(mntmEventQuiltFull);
        JMenuItem mntmEventQuiltComponents = new JMenuItem("Component quilts");
        mntmEventQuiltComponents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Individuals currentIndividuals = MainWindow.this.netGUI.getCurrentIndividuals();
                IndividualGroups groups = ComponentWorker.searchComponents(currentIndividuals);
                IndividualGroupEventQuiltsPanel quiltPanel = new IndividualGroupEventQuiltsPanel(MainWindow.this.netGUI, groups);
                MainWindow.this.addReportTab("Component event quilts", quiltPanel);
            }
        });
        JMenuItem mntmEvenQuiltSegment = new JMenuItem("Segment quilt");
        mntmEvenQuiltSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Network network = GeneaQuiltConvert.convertToEventQuilt(MainWindow.this.netGUI.getCurrentIndividuals(), MainWindow.this.netGUI.getCurrentFamilies(), MainWindow.this.netGUI.getCurrentRelations());
                logger.debug("convert done.");
                GeneaQuiltPanel geneaQuiltPanel = new GeneaQuiltPanel((JComponent)MainWindow.this.tabbedPaneCorpus, network, VertexComparator.Sorting.DATERANGE_START);
                logger.debug("panel done.");
                MainWindow.this.addReportTab("Segment event quilt", (JPanel)geneaQuiltPanel);
            }
        });
        mnDraw.add(mntmEvenQuiltSegment);
        JMenuItem mntmEventQuiltSegments = new JMenuItem("Segment quilts");
        mntmEventQuiltSegments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualGroups groups = SegmentationWorker.convert(MainWindow.this.netGUI.getSegmentation().getCurrentSegment());
                IndividualGroupEventQuiltsPanel diagramPanel = new IndividualGroupEventQuiltsPanel(MainWindow.this.netGUI, groups);
                MainWindow.this.addReportTab("Segment event quilts", diagramPanel);
            }
        });
        mnDraw.add(mntmEventQuiltSegments);
        mnDraw.add(mntmEventQuiltComponents);
        JMenuItem mntmGeoViews = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmGeoViews.text"));
        mntmGeoViews.setEnabled(false);
        mnDraw.add(mntmGeoViews);
        JMenuItem mntmNetPlaces = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNetPlaces.text"));
        mntmNetPlaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    GeoPlaceNetCriteria criteria = GeoPlaceNetDialog.showDialog((List<String>)MainWindow.this.netGUI.getNet().relationModels().nameList());
                    if (criteria != null) {
                        StringSet toponyms = AttributeWorker.getExogenousAttributeValues(MainWindow.this.netGUI.getNet(), criteria.getScopes(), "^.*_PLAC.*$");
                        double weightStep = criteria.isWeight() ? 1.0 : 0.0;
                        Graph<Place2> geocodedGraph = GeocodingWorker.geocodeToponymStrings(MainWindow.this.netGUI.getNet().getGeography2(), toponyms, weightStep);
                        MapPanel2 geographyMap = new MapPanel2(geocodedGraph);
                        MainWindow.this.addTab("Geography", geographyMap);
                        String title = "Information";
                        StringList buffer = new StringList();
                        buffer.append("Toponym count   =").appendln(toponyms.size());
                        buffer.append("Graph node count=").appendln(geocodedGraph.nodeCount());
                        String message = buffer.toString();
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnDraw.add(mntmNetPlaces);
        JMenu mnTools = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTools.text"));
        menuBar.add(mnTools);
        JMenuItem mntmCalculator = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCalculator.text"));
        mntmCalculator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    CalculatorWindow window = new CalculatorWindow(MainWindow.this.netGUI);
                    window.getJFrame().setDefaultCloseOperation(2);
                    window.getJFrame().setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTools.add(mntmCalculator);
        JMenuItem mntmFlatdbgeonames = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFlatdbgeonames.text"));
        mntmFlatdbgeonames.setHorizontalAlignment(0);
        mntmFlatdbgeonames.setEnabled(false);
        mnTools.add(mntmFlatdbgeonames);
        JMenuItem mntmDownloadFlatdbgeonamesDatabase = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDownloadFlatdbgeonamesDatabase.text"));
        mntmDownloadFlatdbgeonamesDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    DownloadDatabaseDialog.showDialog();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            }
        });
        mnTools.add(mntmDownloadFlatdbgeonamesDatabase);
        JMenuItem mntmRequest = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRequest.text"));
        mntmRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    MainWindow.this.addTab("FlatDB4GeoNames", (JPanel)new FlatDB4GeoNamesRequestPanel());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            }
        });
        mnTools.add(mntmRequest);
        JMenu mnWindows = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnWindows.text"));
        mnWindows.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent event) {
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                JMenu windowsMenu = (JMenu)event.getSource();
                windowsMenu.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent event) {
                JMenu windowsMenu = (JMenu)event.getSource();
                for (WindowGUI windowGUI : PuckGUI.instance().windowGUIs()) {
                    windowsMenu.add(new WindowMenuItem(windowGUI));
                }
            }
        });
        menuBar.add(mnWindows);
        JMenu mnHelp = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnHelp.text"));
        mnHelp.setMnemonic('H');
        menuBar.add(mnHelp);
        JMenuItem mntmOfficialWebSite = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOfficialWebSite.text"));
        mntmOfficialWebSite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.callPuckHelp((JMenuItem)event.getSource());
            }
        });
        mnHelp.add(mntmOfficialWebSite);
        JMenuItem mntmAboutPuck = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAboutPuck.text"));
        mntmAboutPuck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AboutPopup dialog = new AboutPopup();
                    dialog.setDefaultCloseOperation(2);
                    dialog.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JSeparator separator_3 = new JSeparator();
        mnHelp.add(separator_3);
        mnHelp.add(mntmAboutPuck);
        JMenu mnFoo = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnFoo.text"));
        mnFoo.setVisible(false);
        mnFoo.setEnabled(false);
        menuBar.add(mnFoo);
        JMenuItem mntmFooworker = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFooworker.text"));
        mnFoo.add(mntmFooworker);
        JMenuItem mntmTestDev = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTestDev.text"));
        mnFoo.add(mntmTestDev);
        mntmTestDev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GraphReporter.test();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mntmTestDev.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        JMenuItem mntmVisualizationTest = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVisualizationTdev.text"));
        mntmVisualizationTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Test.test((NetGUI)MainWindow.this.netGUI);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mntmVisualizationTest.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        mnFoo.add(mntmVisualizationTest);
        mntmFooworker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FooReporterInputWindow window = new FooReporterInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.frmPuck.getContentPane().setLayout(new BoxLayout(this.frmPuck.getContentPane(), 1));
        this.segmentationPanel = new SegmentationPanel(this.netGUI);
        this.frmPuck.getContentPane().add(this.segmentationPanel);
        this.tabbedPaneCorpus = new JTabbedPane(1);
        this.frmPuck.getContentPane().add(this.tabbedPaneCorpus);
        this.corpusTab = new CorpusPanel(this.netGUI);
        this.tabbedPaneCorpus.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.corpusTab.title"), null, this.corpusTab, null);
        this.individualsTab = new IndividualsPanel(this.netGUI);
        this.tabbedPaneCorpus.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individualsPanel.title"), null, this.individualsTab, null);
        this.familiesTab = new FamiliesPanel(this.netGUI);
        this.tabbedPaneCorpus.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.familiesPanel.title"), null, this.familiesTab, null);
    }

    protected void performBARSave() {
        try {
            File targetFile = ExportBARFileSelector.showSelectorDialog(this.frmPuck, this.netGUI.getFile());
            if (targetFile != null) {
                BARFile.save(targetFile, this.netGUI.getNet());
            }
        }
        catch (PuckException exception) {
            String message;
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
            switch (PuckExceptions.valueOf(exception.getCode())) {
                case UNSUPPORTED_FILE_FORMAT: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                    break;
                }
                case NOT_A_FILE: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                    break;
                }
                case UNSUPPORTED_ENCODING: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                    break;
                }
                default: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                }
            }
            JOptionPane.showMessageDialog(this.frmPuck, message, title, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String title = "Error computerum est";
            String message = "Error occured during working: " + exception.getMessage();
            JOptionPane.showMessageDialog(this.frmPuck, message, title, 0);
        }
    }

    private void performCloseCorpus() {
        if (!this.netGUI.isChanged() || this.netGUI.isChanged() && ConfirmMainWindowCloseDialog.showDialog(this.frmPuck, this.netGUI)) {
            if (PuckGUI.instance().windowGUIs().size() == 1) {
                if (!this.netGUI.isBlank()) {
                    this.netGUI.setBlank();
                }
            } else {
                PuckGUI.instance().close(this.netGUI);
                this.frmPuck.dispose();
            }
        }
    }

    private void performCloseWindow() {
        if (!this.netGUI.isChanged() || this.netGUI.isChanged() && ConfirmMainWindowCloseDialog.showDialog(this.frmPuck, this.netGUI)) {
            if (PuckGUI.instance().windowGUIs().size() == 1) {
                if (this.netGUI.isBlank()) {
                    PuckGUI.instance().exit();
                } else {
                    this.netGUI.setBlank();
                }
            } else {
                PuckGUI.instance().close(this.netGUI);
                this.frmPuck.dispose();
            }
        }
    }

    private void performQuit() {
        if (!PuckGUI.instance().existsUnsavedChanges() || PuckGUI.instance().existsUnsavedChanges() && ConfirmQuitDialog.showDialog(this.frmPuck)) {
            PuckGUI.instance().exit();
        }
    }

    public void selectFamiliesTab(Family family) {
        this.tabbedPaneCorpus.setSelectedIndex(2);
        this.familiesTab.select(family);
    }

    public void selectIndividualsTab() {
        this.tabbedPaneCorpus.setSelectedIndex(1);
    }

    public void selectIndividualsTab(Individual individual) {
        this.tabbedPaneCorpus.setSelectedIndex(1);
        this.individualsTab.select(individual);
    }

    public void selectRelationTab(Relation relation) {
        int tabIndex = this.getRelationTabIndex(relation.getModel());
        if (tabIndex != -1) {
            this.tabbedPaneCorpus.setSelectedIndex(tabIndex);
            RelationsPanel tab = (RelationsPanel)this.tabbedPaneCorpus.getComponent(tabIndex);
            tab.select(relation);
        }
    }

    public void selectTab(int tabIndex) {
        this.tabbedPaneCorpus.setSelectedIndex(tabIndex);
    }

    public void setIndividualsTab(Individual individual) {
        this.individualsTab.select(individual);
    }

    public void toFront() {
        this.frmPuck.toFront();
    }

    public void updateLocale(Locale locale) {
        this.frmPuck.setLocale(locale);
    }

    public void updateMenuItems() {
        if (this.netGUI.isChanged()) {
            this.mntmSave.setEnabled(true);
            if (this.netGUI.getFile() == null) {
                this.mntmRevert.setEnabled(false);
            } else {
                this.mntmRevert.setEnabled(this.netGUI.getFile().exists());
            }
            this.mntmRevert.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.text"));
        } else {
            this.mntmSave.setEnabled(false);
            if (this.netGUI.getFile() == null) {
                this.mntmRevert.setEnabled(false);
                this.mntmRevert.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.text"));
            } else {
                this.mntmRevert.setEnabled(this.netGUI.getFile().exists());
                this.mntmRevert.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmReload.text"));
            }
        }
    }

    public void updateTitle() {
        String changeToken;
        if (this.netGUI.isChanged()) {
            changeToken = "*";
            this.frmPuck.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
        } else {
            changeToken = "";
            this.frmPuck.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
        }
        this.frmPuck.setTitle(String.valueOf(changeToken) + this.netGUI.getFile().getName() + "-" + this.netGUI.getId() + " - Puck");
    }

    public static void callPuckHelp(JMenuItem source) {
        String HELP_URL = "http://www.kintip.net/puck-aide-mainmenu-24";
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    URI uri = new URI(HELP_URL);
                    desktop.browse(uri);
                } else if (source != null) {
                    source.setEnabled(false);
                }
            } else if (source != null) {
                source.setEnabled(false);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("The system cannot find the URL specified: [" + HELP_URL + "]");
            JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", 0);
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
            System.out.println("Illegal character in path [" + HELP_URL + "]");
            JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", 0);
        }
    }

    public static int getDesktopHeight() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        GraphicsConfiguration gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Insets insets = toolkit.getScreenInsets(gconf);
        int result = (int)(dim.getHeight() - (double)insets.bottom - (double)insets.top);
        return result;
    }

    public static void openConflictingFile(NetGUI netGUI, JFrame parentPanel, File file, String charsetName) {
        try {
            Object[] options = new Object[]{"IUR", "BAR", "Cancel"};
            int choice = JOptionPane.showOptionDialog(parentPanel, "Puck can not determine the file format. Please, speficy it.", "BAR or IUR?", 1, 3, null, options, null);
            if (choice != 2) {
                Net net = choice == 1 ? BARFile.load(file, charsetName) : IURFile.load(file, charsetName);
                PuckGUI.instance().recentFiles().updateFile(file);
                PuckGUI.instance().recentFolders().updateFolder(file.getParentFile());
                if (netGUI.isBlank()) {
                    netGUI.updateFile(file, net);
                } else {
                    PuckGUI.instance().createNetGUI(file, net);
                }
            }
        }
        catch (PuckException exception) {
            exception.printStackTrace();
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
            switch (PuckExceptions.valueOf(exception.getCode())) {
                case FILE_NOT_FOUND: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                case BAD_FILE_FORMAT: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                case UNSUPPORTED_FILE_FORMAT: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                case NOT_A_FILE: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                case UNSUPPORTED_ENCODING: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                default: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String subtitle = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
            String submessage = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
            JOptionPane.showMessageDialog(parentPanel, submessage, subtitle, 0);
        }
    }

    public static void openSelectedFile(NetGUI netGUI, JFrame parentPanel, File file, String charsetName) {
        try {
            if (file != null) {
                if (netGUI.isBlank()) {
                    netGUI.updateFile(file, charsetName);
                } else {
                    PuckGUI.instance().createNetGUI(file, charsetName);
                }
                PuckGUI.instance().recentFiles().updateFile(file);
                PuckGUI.instance().recentFolders().updateFolder(file.getParentFile());
            }
        }
        catch (PuckException exception) {
            exception.printStackTrace();
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
            switch (PuckExceptions.valueOf(exception.getCode())) {
                case FILE_NOT_FOUND: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                case BAD_FILE_FORMAT: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                case UNSUPPORTED_FILE_FORMAT: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                case NOT_A_FILE: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                case UNSUPPORTED_ENCODING: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
                case FORMAT_CONFLICT: {
                    MainWindow.openConflictingFile(netGUI, parentPanel, file, charsetName);
                    break;
                }
                default: {
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (IdShrinker.containsLongId(file)) {
                    JOptionPane.showMessageDialog(parentPanel, "GEDCOM file with long ids detected.\nWill try to load it with shrinked ids.\nWarning: new file will be created.", "GEDCOM Long IDs detected.", 2);
                    File fixedfile = IdShrinker.shrink(file);
                    if (netGUI.isBlank()) {
                        netGUI.updateFile(fixedfile, charsetName);
                    } else {
                        PuckGUI.instance().createNetGUI(fixedfile, charsetName);
                    }
                } else {
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                    JOptionPane.showMessageDialog(parentPanel, message, title, 0);
                }
            }
            catch (Exception subException) {
                subException.printStackTrace();
                String subtitle = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                String submessage = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                JOptionPane.showMessageDialog(parentPanel, submessage, subtitle, 0);
            }
        }
    }

    public static boolean performSaveAs(Component parent, NetGUI netGUI) {
        boolean result;
        try {
            File targetFile = CorpusSaveFileSelector.showSelectorDialog(parent, netGUI.getFile());
            if (targetFile == null) {
                result = false;
            } else {
                PuckManager.saveNet(targetFile, netGUI.getNet());
                netGUI.setFile(targetFile);
                netGUI.setChanged(false);
                PuckGUI.instance().recentFiles().updateFile(targetFile);
                PuckGUI.instance().recentFolders().updateFolder(targetFile.getParentFile());
                result = true;
            }
        }
        catch (PuckException exception) {
            String message;
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
            switch (PuckExceptions.valueOf(exception.getCode())) {
                case UNSUPPORTED_FILE_FORMAT: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                    break;
                }
                case NOT_A_FILE: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                    break;
                }
                case UNSUPPORTED_ENCODING: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                    break;
                }
                default: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                }
            }
            JOptionPane.showMessageDialog(parent, message, title, 0);
            result = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String title = "Error computerum est";
            String message = "Error occured during working: " + exception.getMessage();
            JOptionPane.showMessageDialog(parent, message, title, 0);
            result = false;
        }
        return result;
    }

    public static File selectDATFileToLoad(Component parentPanel, File targetFile) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (targetFile != null && StringUtils.isNotBlank((CharSequence)targetFile.getAbsolutePath())) {
            chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".dat"));
        }
        chooser.setDialogTitle("Import DAT");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("DAT (*.dat)", "dat");
        chooser.addChoosableFileFilter(defaultFileFilter);
        chooser.setFileFilter(defaultFileFilter);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }

    public static File selectFile(JFrame parentPanel, File folder) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (folder != null && folder.exists() && folder.isDirectory()) {
            chooser.setCurrentDirectory(folder);
        } else if (PuckGUI.instance().recentFolders().isEmpty()) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
        }
        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(true);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("Genealogic files (*.ged, *.ods, *.paj, *.pl, *.puc, *.tip, *.txt, *.xls, *.xml)", "ged", "ods", "paj", "pl", "puc", "tip", "txt", "xls", "xml");
        chooser.addChoosableFileFilter(defaultFileFilter);
        chooser.addChoosableFileFilter(new GenericFileFilter("GEDCOM (*.ged)", "ged"));
        chooser.addChoosableFileFilter(new GenericFileFilter("OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Pajek Network (*.paj)", "paj"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Prolog (*.pl)", "pl"));
        chooser.addChoosableFileFilter(new GenericFileFilter("PUCK (*.puc)", "puc"));
        chooser.addChoosableFileFilter(new GenericFileFilter("TIP (*.tip)", "tip"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Text BAR/IUR (*.txt)", "txt"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Extensible Markup Language (*.xml)", "xml"));
        chooser.setFileFilter(defaultFileFilter);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            logger.debug("No Selection ");
            result = null;
        }
        return result;
    }

    public static File selectFolder(JFrame parentPanel, File folder) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (folder != null && folder.exists() && folder.isDirectory()) {
            chooser.setCurrentDirectory(folder);
        } else if (PuckGUI.instance().recentFolders().isEmpty()) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
        }
        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(true);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            logger.debug("No Selection ");
            result = null;
        }
        return result;
    }

    public static File selectRelationModelFileToLoad(Component parentPanel, File targetFile) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (targetFile != null && StringUtils.isNotBlank((CharSequence)targetFile.getAbsolutePath())) {
            chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".txt"));
        }
        chooser.setDialogTitle("Import Relation Model");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("TXT (*.txt)", "txt");
        chooser.addChoosableFileFilter(defaultFileFilter);
        chooser.setFileFilter(defaultFileFilter);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }

    public static File selectSelzFileToLoad(Component parentPanel, File targetFile) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (targetFile != null && StringUtils.isNotBlank((CharSequence)targetFile.getAbsolutePath())) {
            chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".txt"));
        }
        chooser.setDialogTitle("Import Selz");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("Selz files (*.ods, *.txt, *.xls)", "ods", "txt", "xls");
        chooser.addChoosableFileFilter(defaultFileFilter);
        chooser.addChoosableFileFilter(new GenericFileFilter("OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Text (*.txt)", "txt"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
        chooser.setFileFilter(defaultFileFilter);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)chooser.getCurrentDirectory());
            logger.debug("getSelectedFile(): {}", (Object)chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

