/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.tip.puck.net.workers.GeoPlaceNetCriteria;
import org.tip.puck.net.workers.NetNodeType;

public class GeoPlaceNetDialog
extends JDialog {
    private static final long serialVersionUID = -6151594508277487557L;
    private final JPanel contentPanel = new JPanel();
    private GeoPlaceNetCriteria dialogCriteria;
    private static GeoPlaceNetCriteria lastCriteria = new GeoPlaceNetCriteria();
    private JCheckBox chckbxWeight;
    private JPanel pnlSelections;
    private StringList targetLabels = new StringList();

    public GeoPlaceNetDialog(List<String> relationModelNames) {
        this.targetLabels.add((Object)"INDIVIDUALS");
        this.targetLabels.add((Object)"FAMILIES");
        this.targetLabels.addAll(relationModelNames);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("GeoPlaces Scope Selector");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(GeoPlaceNetDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GeoPlaceNetDialog.this.dialogCriteria = null;
                GeoPlaceNetDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 420, 278);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblNewLabel = new JLabel("<html>\n<p>This menu item will display places<br/>\nfrom the net nodes (attributes with<br/>\nlabels containing \"_PLAC\").</p>\n<p>In order to search for those attributes,<br/>\nplease select the node types to manage.</p>\n<br/>\n</html>");
        this.contentPanel.add((Component)lblNewLabel, "2, 2, 3, 1");
        JLabel lblScopes = new JLabel("Scopes:");
        this.contentPanel.add((Component)lblScopes, "2, 4, right, default");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        this.contentPanel.add((Component)scrollPane, "4, 4, fill, fill");
        this.pnlSelections = new JPanel();
        scrollPane.setViewportView(this.pnlSelections);
        this.pnlSelections.setLayout(new BoxLayout(this.pnlSelections, 1));
        JLabel lblNewLabel_1 = new JLabel("Weight");
        this.contentPanel.add((Component)lblNewLabel_1, "2, 6");
        this.chckbxWeight = new JCheckBox("");
        this.chckbxWeight.setSelected(true);
        this.contentPanel.add((Component)this.chckbxWeight, "4, 6");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeoPlaceNetDialog.this.dialogCriteria = null;
                GeoPlaceNetDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("Launch");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GeoPlaceNetCriteria criteria = GeoPlaceNetDialog.this.getCriteria();
                if (criteria.getScopes().isEmpty()) {
                    String title = "Invalid input";
                    String message = "Please, select at least one node type.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    GeoPlaceNetDialog.this.dialogCriteria = criteria;
                    GeoPlaceNetDialog.this.setVisible(false);
                }
            }
        });
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public GeoPlaceNetCriteria getCriteria() {
        GeoPlaceNetCriteria result = new GeoPlaceNetCriteria();
        result.setWeight(this.chckbxWeight.isSelected());
        result.getScopes().clear();
        int index = 0;
        while (index < this.pnlSelections.getComponentCount()) {
            Component component = this.pnlSelections.getComponent(index);
            if (((JCheckBox)component).isSelected()) {
                switch (index) {
                    case 0: {
                        result.getScopes().add(new NetNodeType(NetNodeType.Scope.INDIVIDUALS));
                        break;
                    }
                    case 1: {
                        result.getScopes().add(new NetNodeType(NetNodeType.Scope.FAMILIES));
                        break;
                    }
                    default: {
                        result.getScopes().add(new NetNodeType(((JCheckBox)component).getText()));
                    }
                }
            }
            ++index;
        }
        return result;
    }

    public GeoPlaceNetCriteria getDialogCriteria() {
        GeoPlaceNetCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(GeoPlaceNetCriteria source) {
        if (source != null) {
            for (String label : this.targetLabels) {
                JCheckBox checkBox = new JCheckBox(label);
                checkBox.setSelected(true);
                this.pnlSelections.add(checkBox);
            }
            this.chckbxWeight.setSelected(source.isWeight());
        }
    }

    public static void main(String[] args) {
        GeoPlaceNetDialog.showDialog(null);
    }

    public static GeoPlaceNetCriteria showDialog(List<String> relationModelNames) {
        GeoPlaceNetDialog dialog = new GeoPlaceNetDialog(relationModelNames);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        GeoPlaceNetCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

