/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.graphs.GeoNetworkUtils;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.workers.GeocodingWorker;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Node;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.CorrelationMatrix;
import org.tip.puck.spacetime.EventTriangle;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.spacetime.workers.MissingTestimoniesCriteria;
import org.tip.puck.spacetime.workers.SequenceCensus;
import org.tip.puck.spacetime.workers.SequenceMaker;
import org.tip.puck.spacetime.workers.SequenceWorker;
import org.tip.puck.spacetime.workers.SequencesCensus;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.spacetime.workers.UnknownPlacesCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class SequenceReporter {
    private static StringList getStories(Relation event) {
        StringList result = new StringList();
        for (Attribute attribute : event.attributes()) {
            String story = "";
            if (!attribute.getLabel().contains("NOTE")) continue;
            String[] label = attribute.getLabel().split("_");
            if (label.length > 1 && StringUtils.isNumeric((CharSequence)label[1])) {
                int id = Integer.parseInt(label[1]);
                Individual indi = (Individual)event.getIndividuals().getById(id);
                story = String.valueOf(story) + indi.signature() + ": ";
            }
            story = String.valueOf(story) + attribute.getValue();
            result.appendln(story);
        }
        return result;
    }

    public static Report reportDiscontinuousItineraries(Segmentation segmentation, SpaceTimeCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Discontinuous Itineraries");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (Sequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
            Sequences partials = SequenceWorker.split(itinerary);
            if (partials.size() <= 1) continue;
            ++errorCount;
            errors.appendln(itinerary.getEgo().signature());
            int j = 0;
            for (Sequence partial : partials) {
                if (partial.getEvents().size() != 0 && j > 0) {
                    errors.appendln(partial.getFirst() + "\t" + partial.getEvents().get(partial.getFirst()));
                }
                ++j;
            }
            errors.appendln();
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportUnknownRelations(Segmentation segmentation, SpaceTimeCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Unknown Relations");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        TreeMap<Individual, Individuals> unknownRelations = new TreeMap<Individual, Individuals>();
        for (Sequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
            SequenceCensus census = new SequenceCensus(itinerary, criteria);
            for (Individual alter : census.getAllAlters()) {
                if (census.getRelationsByAlter().get(alter).size() != 0) continue;
                Individuals unknowns = (Individuals)unknownRelations.get(itinerary.getEgo());
                if (unknowns == null) {
                    unknowns = new Individuals();
                    unknownRelations.put(itinerary.getEgo(), unknowns);
                }
                unknowns.put(alter);
                ++errorCount;
            }
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Unknown Relations") + "\n"));
        for (Individual ego : unknownRelations.keySet()) {
            for (Individual alter : ((Individuals)unknownRelations.get(ego)).toSortedList()) {
                errors.add((Object)(ego + "\t" + alter + "\n"));
            }
        }
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportDiscontinuousBiographies(Net net, Segmentation segmentation, SpaceTimeCriteria criteria, ResourceBundle bundle) throws PuckException {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Discontinuous Itineraries");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (Sequence itinerary : SequenceMaker.createBiographies(net, segmentation, criteria).toSortedList()) {
            Sequences partials = SequenceWorker.split(itinerary);
            if (partials.size() <= 1) continue;
            ++errorCount;
            errors.appendln(itinerary.getEgo().signature());
            int j = 0;
            for (Sequence partial : partials) {
                if (partial.getEvents().size() != 0 && j > 0) {
                    errors.appendln(partial.getFirst() + "\t" + partial.getEvents().get(partial.getFirst()));
                }
                ++j;
            }
            errors.appendln();
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportMissingTestimonies(Segmentation segmentation, MissingTestimoniesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Missing Testimonies");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (Relation event : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())) {
            for (Individual witness : event.getIndividuals(criteria.getEgoRoleName())) {
                if (!segmentation.getCurrentIndividuals().contains(witness)) continue;
                boolean missing = true;
                for (Attribute attribute : event.attributes()) {
                    if (!attribute.getLabel().contains("NOTE")) continue;
                    String signature = String.valueOf(witness.getId()) + ":";
                    if (!attribute.getValue().contains(signature)) continue;
                    missing = false;
                    break;
                }
                if (!missing) continue;
                ++errorCount;
                errors.appendln(String.valueOf(witness.signature()) + "\t" + event.getTypedId() + "\t" + event.getName());
            }
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Missing Testimonies") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportGeneralSequenceCensus(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report("General ");
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        Sequences sequences = new Sequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS") || label.contains("NRSTATIONS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.FREE_GROUPING);
                partitionCriteria.setIntervals(PartitionMaker.getIntervals("1 5 10 15 20 25"));
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            Object chart = null;
            if (!(label.contains("ALTERS") || label.contains("PROFILE") || label.equals("MEAN_NR_MOVES"))) {
                NumberedValues values = census.getValues(label);
                Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (label.equals("MEAN_NR_MOVES")) {
                Map<Value, Double[]> map = census.getMeanNrMoves();
                chart = StatisticsReporter.createMapChart(map, label, new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            }
            if (chart == null) continue;
            charts.add((ReportChart)chart);
            ReportTable table = ReportTable.transpose(((ReportChart)chart).createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_")) continue;
            label.contains("RELATIONS");
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
        }
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if (census.getValues("NREVENTS").get(ego.getId()) == null) continue;
            detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
            for (String label : censusCriteria.getCensusOperationLabels()) {
                detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
            }
            detailReport.outputs().appendln();
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String title : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(title);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportEgoNetworksCensus(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Ego Networks");
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = null;
        if (censusCriteria.getEgoNetworksOperations().contains((Object)SpaceTimeCriteria.EgoNetworksOperation.COHESION)) {
            componentReport = new Report("Components");
        }
        ArrayList<Object> charts = new ArrayList<Object>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        Sequences sequences = new Sequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            Iterator<String> chart = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues values = census.getValues(label);
                Object partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                    if (((Partition)partition).maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (chart == null) continue;
            charts.add(chart);
            ReportTable table = ReportTable.transpose(((ReportChart)((Object)chart)).createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_")) continue;
            label.contains("RELATIONS");
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap componentChartMaps = new TreeMap();
        TreeMap componentChartSizeMaps = new TreeMap();
        for (String networkTitle : censusCriteria.getNetworkTitles()) {
            componentChartMaps.put(networkTitle, new TreeMap());
            componentChartSizeMaps.put(networkTitle, new TreeMap());
        }
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if (census.getValues("SIZE").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String label : censusCriteria.getCensusOperationLabels()) {
                    detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            if (!censusCriteria.getEgoNetworksOperations().contains((Object)SpaceTimeCriteria.EgoNetworksOperation.COHESION)) continue;
            for (String networkTitle : censusCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
                Map componentChartMap = (Map)componentChartMaps.get(networkTitle);
                Map componentChartSizeMap = (Map)componentChartSizeMaps.get(networkTitle);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + networkTitle);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    Double[] map = (Double[])componentChartMap.get(value);
                    Double[] map2 = (Double[])componentChartSizeMap.get(value);
                    if (map == null) {
                        map = new Double[]{0.0, 0.0, 0.0};
                        componentChartMap.put(value, map);
                        map2 = new Double[]{0.0, 0.0, 0.0};
                        componentChartSizeMap.put(value, map2);
                    }
                    int n = ego.getGender().toInt();
                    map[n] = map[n] + 1.0;
                    map[2] = map[2] + 1.0;
                    int n2 = ego.getGender().toInt();
                    map2[n2] = map2[n2] + (double)components.getCluster(value).size();
                    map2[2] = map2[2] + (double)components.getCluster(value).size();
                }
            }
        }
        for (String networkTitle : censusCriteria.getNetworkTitles()) {
            Map componentChartMap = (Map)componentChartMaps.get(networkTitle);
            Map componentChartSizeMap = (Map)componentChartSizeMaps.get(networkTitle);
            for (Value value : componentChartMap.keySet()) {
                Double[] sums = (Double[])componentChartSizeMap.get(value);
                int i = 0;
                while (i < 3) {
                    sums[i] = new Double(sums[i] / ((Double[])componentChartMap.get(value))[i]);
                    ++i;
                }
            }
            ReportChart componentChart = StatisticsReporter.createMapChart(componentChartMap, "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            charts.add(componentChart);
            tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
            ReportChart componentSizeChart = StatisticsReporter.createMapChart(componentChartSizeMap, "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            charts.add(componentSizeChart);
            tables.add(ReportTable.transpose(componentSizeChart.createReportTableWithSum()));
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (componentReport != null) {
            result.outputs().append(componentReport);
        }
        if (censusCriteria.getEgoNetworksOperations().contains((Object)SpaceTimeCriteria.EgoNetworksOperation.EXPORT_EGO_NETWORKS)) {
            Map<String, StringList> pajekBuffers = census.getPajekBuffers();
            for (String title : pajekBuffers.keySet()) {
                StringList pajekBuffer = pajekBuffers.get(title);
                if (pajekBuffer.length() == 0) continue;
                File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
                ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
                result.outputs().appendln();
                result.outputs().append(rawData);
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportParcoursNetworksCensus(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Object relationClassificationType;
        Chronometer chrono = new Chronometer();
        Report result = new Report("Parcours Networks");
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = null;
        if (censusCriteria.getParcoursNetworksOperations().contains((Object)SpaceTimeCriteria.ParcoursNetworksOperation.COHESION)) {
            componentReport = new Report("Components");
        }
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        Sequences sequences = new Sequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            ReportChart chart = null;
            if (label.contains("SIMILARITY")) {
                relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                Map<Value, Double[]> similaritiesMap = census.getSimilaritiesMap((SpaceTimeCriteria.RelationClassificationType)((Object)relationClassificationType));
                chart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[]{"HH", "FH", "HF", "FF", "All"}, ReportChart.GraphType.LINES);
                for (Value key : similaritiesMap.keySet()) {
                    overallReport.outputs().appendln(String.valueOf(label) + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100.0));
                }
            } else if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues values = census.getValues(label);
                Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (chart == null) continue;
            charts.add(chart);
            if (label.equals("SIMILARITY")) {
                tables.add(ReportTable.transpose(chart.createReportTable()));
                continue;
            }
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        Map<String, Map<String, Map<String, Value>>> parcoursNetworkStatistics = census.getParcoursNetworkStatistics();
        ArrayList<String> clusterValues = new ArrayList<String>(parcoursNetworkStatistics.keySet());
        if (parcoursNetworkStatistics != null) {
            overallReport.outputs().appendln("Parcours Network Statistics");
            String headLine = null;
            boolean first = true;
            for (String nodeLabel : parcoursNetworkStatistics.get("Total").keySet()) {
                Object line = nodeLabel;
                headLine = "Node";
                for (String genderLabel : clusterValues) {
                    Map<String, Value> statistics = parcoursNetworkStatistics.get(genderLabel).get(nodeLabel);
                    for (String statisticsLabel : censusCriteria.getNodeStatisticsLabels()) {
                        if (first) {
                            headLine = String.valueOf(headLine) + "\t" + statisticsLabel + " (" + genderLabel + ")";
                        }
                        line = statistics != null ? String.valueOf(line) + "\t" + statistics.get(statisticsLabel) : String.valueOf(line) + "\t";
                    }
                }
                if (first) {
                    overallReport.outputs().appendln(headLine);
                    first = false;
                }
                overallReport.outputs().appendln(line);
            }
        }
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            if (partitionLabel.contains("SIMILARITY")) {
                relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel.lastIndexOf("_") + 1));
                detailReport.outputs().append("\tSIMILARITY_PARENT_" + relationClassificationType + "\tSIMILARITY_CHILD_" + relationClassificationType + "\tSIMILARITY_SIBLING_" + relationClassificationType + "\tSIMILARITY_SPOUSE_" + relationClassificationType);
                continue;
            }
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap componentChartMaps = new TreeMap();
        for (String networkTitle : censusCriteria.getNetworkTitles()) {
            componentChartMaps.put(networkTitle, new TreeMap());
        }
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if (census.getValues("NREVENTS").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String label : censusCriteria.getCensusOperationLabels()) {
                    if (label.contains("SIMILARITY")) {
                        String[] keys;
                        Value value = (Value)census.getValues(label).get(ego.getId());
                        Map indiSimilaritiesMap = value.mapValue();
                        String[] stringArray = keys = new String[]{"PARENT", "CHILD", "SIBLING", "SPOUSE"};
                        int n = keys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            Double[] sim = (Double[])indiSimilaritiesMap.get(new Value(key));
                            if (sim != null) {
                                detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
                            }
                            ++n2;
                        }
                        continue;
                    }
                    detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            if (componentReport == null) continue;
            for (String networkTitle : censusCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
                Map componentChartMap = (Map)componentChartMaps.get(networkTitle);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + networkTitle);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    Double[] map = (Double[])componentChartMap.get(value);
                    if (map == null) {
                        map = new Double[]{0.0, 0.0, 0.0};
                        componentChartMap.put(value, map);
                    }
                    int n = ego.getGender().toInt();
                    map[n] = map[n] + 1.0;
                    map[2] = map[2] + 1.0;
                }
            }
        }
        for (String networkTitle : censusCriteria.getNetworkTitles()) {
            ReportChart componentChart = StatisticsReporter.createMapChart((Map)componentChartMaps.get(networkTitle), "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            charts.add(componentChart);
            tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
            if (census.getRelationConnectionMatrix() == null) continue;
            for (ReportChart chart : census.getRelationConnectionMatrix().getCharts()) {
                charts.add(chart);
            }
            tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        result.outputs().append(componentReport);
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String title : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(title);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportTrajectoriesCensus(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Trajectories");
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report treeReport = null;
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.LIST_TREES)) {
            treeReport = new Report("Trees");
        }
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        Sequences sequences = new Sequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS") || label.contains("NRSTATIONS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            Iterator<String> chart = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues values = census.getValues(label);
                Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (chart == null) continue;
            charts.add((ReportChart)((Object)chart));
            ReportTable table = ReportTable.transpose(((ReportChart)((Object)chart)).createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
        }
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if (census.getValues("NREVENTS").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String label : censusCriteria.getCensusOperationLabels()) {
                    detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {
                CorrelationMatrix subSequenceMatrix;
                if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {
                    CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationClassificationType.toString());
                    if (eventSequenceMatrix != null) {
                        for (ReportChart chart : eventSequenceMatrix.getCharts()) {
                            charts.add(chart);
                        }
                        tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
                    }
                    overallReport.outputs().appendln();
                    overallReport.outputs().appendln("Sequence Network Statistics " + (Object)((Object)relationClassificationType));
                    overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
                    Gender[] genderArray = Gender.values();
                    int n = genderArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Gender gender = genderArray[n2];
                        GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);
                        String centralReferents = "";
                        for (Cluster<String> centralReferent : profile.getCentralReferents()) {
                            centralReferents = String.valueOf(centralReferents) + centralReferent.getValue() + " ";
                        }
                        double maxBetweenness = profile.getMaxBetweenness();
                        double density = profile.density();
                        double endo = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.NORMALIZED), 2);
                        double endoExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.DIVERGENCE_NORMALIZED), 2);
                        double conc = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE), 2);
                        double concExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.DIVERGENCE), 2);
                        double sym = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE), 2);
                        double symExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.DIVERGENCE), 2);
                        overallReport.outputs().appendln((Object)((Object)gender) + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t" + centralReferents + "(" + maxBetweenness + ") betweenness centrality");
                        ++n2;
                    }
                    overallReport.outputs().appendln();
                }
                if (!censusCriteria.getNetworkTitles().contains("Sequence Type Network") || (subSequenceMatrix = census.getSubSequenceMatrix(relationClassificationType.toString())) == null) continue;
                charts.add(subSequenceMatrix.getRamificationChart());
            }
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (treeReport != null) {
            result.outputs().append(treeReport);
        }
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.EXPORT_EVENT_TYPE_NETWORK) || censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.EXPORT_SEQUENCE_TYPE_NETWORK)) {
            Map<String, StringList> pajekBuffers = census.getPajekBuffers();
            for (String title : pajekBuffers.keySet()) {
                StringList pajekBuffer = pajekBuffers.get(title);
                if (pajekBuffer.length() == 0) continue;
                File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
                ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
                result.outputs().appendln();
                result.outputs().append(rawData);
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Graph<Place> getTrajectoryGraph(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Graph<Place> result = null;
        ArrayList charts = new ArrayList();
        ArrayList tables = new ArrayList();
        Sequences sequences = new Sequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.DRAW)) {
            CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix("PLACE");
            Graph drawGraph = eventSequenceMatrix.getSequenceNetwork("PLACE", Gender.UNKNOWN);
            result = GeoNetworkUtils.createGeoNetwork(drawGraph, censusCriteria.getLevel());
        }
        return result;
    }

    public static Graph<Place2> getTrajectoryGraph2(Geography2 geography, Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Graph<Place2> result = null;
        ArrayList charts = new ArrayList();
        ArrayList tables = new ArrayList();
        Sequences sequences = new Sequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.DRAW)) {
            CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix("PLACE");
            Graph drawGraph = eventSequenceMatrix.getSequenceNetwork("PLACE", Gender.UNKNOWN);
            Graph<String> placeNameGraph = GeoNetworkUtils.createGeoNetwork2(drawGraph, censusCriteria.getLevel());
            result = GeocodingWorker.geocodeGraph(geography, placeNameGraph);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Report reportSequenceCensus(Segmentation segmentation, SpaceTimeCriteria.CensusType censusType) throws PuckException {
        Iterator<String> partitionCriteria;
        Chronometer chrono = new Chronometer();
        Report result = new Report(censusType.toString());
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = new Report("Components");
        Report treeReport = new Report("Trees");
        ArrayList<Object> charts = new ArrayList<Object>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(censusType);
        Sequences sequences = new Sequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            void var17_20;
            partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)((Object)partitionCriteria)).setStart(0.0);
                ((PartitionCriteria)((Object)partitionCriteria)).setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)((Object)partitionCriteria)).setStart(-100.0);
                ((PartitionCriteria)((Object)partitionCriteria)).setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)((Object)partitionCriteria)).setStart(0.0);
                ((PartitionCriteria)((Object)partitionCriteria)).setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)((Object)partitionCriteria)).setStart(0.0);
                ((PartitionCriteria)((Object)partitionCriteria)).setSize(1.0);
            } else {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.RAW);
            }
            Object var17_21 = null;
            if (label.contains("SIMILARITY")) {
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                Map<Value, Double[]> similaritiesMap = census.getSimilaritiesMap(relationClassificationType);
                ReportChart reportChart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[]{"HH", "FH", "HF", "FF", "All"}, ReportChart.GraphType.LINES);
                for (Value key : similaritiesMap.keySet()) {
                    overallReport.outputs().appendln(String.valueOf(label) + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100.0));
                }
            } else if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues numberedValues = census.getValues(label);
                Iterator<String> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), numberedValues, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.RAW);
                    ((PartitionCriteria)((Object)partitionCriteria)).setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    ((PartitionCriteria)((Object)partitionCriteria)).setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), numberedValues, partitionCriteria);
                    if (((Partition)((Object)partition)).maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(numberedValues, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + numberedValues.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (var17_20 == null) continue;
            charts.add(var17_20);
            if (label.equals("SIMILARITY")) {
                tables.add(ReportTable.transpose(var17_20.createReportTable()));
                continue;
            }
            ReportTable reportTable = ReportTable.transpose(var17_20.createReportTableWithSum());
            tables.add(reportTable);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(reportTable));
        }
        overallReport.outputs().appendln();
        Map<String, Map<String, Map<String, Value>>> parcoursNetworkStatistics = census.getParcoursNetworkStatistics();
        if (parcoursNetworkStatistics != null) {
            overallReport.outputs().appendln("Parcours Network Statistics");
            partitionCriteria = parcoursNetworkStatistics.get("Total").keySet().iterator();
            while (partitionCriteria.hasNext()) {
                void var17_26;
                String nodeLabel;
                String string = nodeLabel = partitionCriteria.next();
                for (String string2 : parcoursNetworkStatistics.get("Total").get(nodeLabel).keySet()) {
                    for (String genderLabel : parcoursNetworkStatistics.keySet()) {
                        String string3 = String.valueOf(var17_26) + "\t" + parcoursNetworkStatistics.get(genderLabel).get(nodeLabel).get(string2);
                    }
                }
                overallReport.outputs().appendln(var17_26);
            }
        }
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            if (partitionLabel.contains("SIMILARITY")) {
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel.lastIndexOf("_") + 1));
                detailReport.outputs().append("\tSIMILARITY_PARENT_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_CHILD_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_SIBLING_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_SPOUSE_" + (Object)((Object)relationClassificationType));
                continue;
            }
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap<Value, Double[]> componentChartMap = new TreeMap<Value, Double[]>();
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if ((censusType == SpaceTimeCriteria.CensusType.GENERAL || censusType == SpaceTimeCriteria.CensusType.PARCOURS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) && census.getValues("NREVENTS").get(ego.getId()) != null || censusType == SpaceTimeCriteria.CensusType.EGONETWORKS && census.getValues("SIZE").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String string : censusCriteria.getCensusOperationLabels()) {
                    if (string.contains("SIMILARITY")) {
                        String[] keys;
                        Value value = (Value)census.getValues(string).get(ego.getId());
                        Map indiSimilaritiesMap = value.mapValue();
                        String[] stringArray = keys = new String[]{"PARENT", "CHILD", "SIBLING", "SPOUSE"};
                        int n = keys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            Double[] sim = (Double[])indiSimilaritiesMap.get(new Value(key));
                            if (sim != null) {
                                detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
                            }
                            ++n2;
                        }
                        continue;
                    }
                    detailReport.outputs().append("\t" + census.getValues(string).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            if (censusType != SpaceTimeCriteria.CensusType.EGONETWORKS && censusType != SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) continue;
            for (String string : censusCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(string);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + string);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    Double[] map = (Double[])componentChartMap.get(value);
                    if (map == null) {
                        map = new Double[]{0.0, 0.0, 0.0};
                        componentChartMap.put(value, map);
                    }
                    int n = ego.getGender().toInt();
                    map[n] = map[n] + 1.0;
                    map[2] = map[2] + 1.0;
                }
            }
        }
        if (censusType == SpaceTimeCriteria.CensusType.EGONETWORKS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) {
            ReportChart componentChart = StatisticsReporter.createMapChart(componentChartMap, "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            charts.add(componentChart);
            tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
            if (census.getRelationConnectionMatrix() != null) {
                for (ReportChart reportChart : census.getRelationConnectionMatrix().getCharts()) {
                    charts.add(reportChart);
                }
                tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
            }
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {
                CorrelationMatrix correlationMatrix;
                if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {
                    CorrelationMatrix correlationMatrix2 = census.getEventSequenceMatrix(relationClassificationType.toString());
                    if (correlationMatrix2 != null) {
                        for (ReportChart chart : correlationMatrix2.getCharts()) {
                            charts.add(chart);
                        }
                        tables.add(correlationMatrix2.getTable("Event Type Sequences"));
                    }
                    overallReport.outputs().appendln();
                    overallReport.outputs().appendln("Sequence Network Statistics " + (Object)((Object)relationClassificationType));
                    overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
                    Gender[] genderArray = Gender.values();
                    int components = genderArray.length;
                    int componentsMap = 0;
                    while (componentsMap < components) {
                        Gender gender = genderArray[componentsMap];
                        GraphProfile<Cluster<String>> profile = correlationMatrix2.getProfile(gender);
                        String centralReferents = "";
                        for (Cluster<String> centralReferent : profile.getCentralReferents()) {
                            centralReferents = String.valueOf(centralReferents) + centralReferent.getValue() + " ";
                        }
                        double maxBetweenness = profile.getMaxBetweenness();
                        double density = profile.density();
                        double endo = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.NORMALIZED), 2);
                        double endoExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.DIVERGENCE_NORMALIZED), 2);
                        double conc = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE), 2);
                        double concExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.DIVERGENCE), 2);
                        double sym = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE), 2);
                        double symExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.DIVERGENCE), 2);
                        overallReport.outputs().appendln((Object)((Object)gender) + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t" + centralReferents + "(" + maxBetweenness + ") betweenness centrality");
                        ++componentsMap;
                    }
                    overallReport.outputs().appendln();
                }
                if (!censusCriteria.getNetworkTitles().contains("Sequence Type Network") || (correlationMatrix = census.getSubSequenceMatrix(relationClassificationType.toString())) == null) continue;
                charts.add(correlationMatrix.getRamificationChart());
            }
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (censusType == SpaceTimeCriteria.CensusType.EGONETWORKS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) {
            result.outputs().append(componentReport);
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            result.outputs().append(treeReport);
        }
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String string : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(string);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + string), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + string + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportSequences(Net net, Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Relation event;
        Individual ego;
        String spouseFilterLabel = "INTERV";
        Chronometer chrono = new Chronometer();
        Report result = new Report("Sequence Report");
        result.setOrigin("Sequence reporter");
        Report surveyReport = null;
        Report detailedReport = null;
        Report actorEventTableReport = null;
        Report interactionTableReport = null;
        Report biographyReport = null;
        Report extendedBiographyReport = null;
        ArrayList<Report> reports = new ArrayList<Report>();
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.ITINERARIES_SURVEY)) {
            surveyReport = new Report("Survey");
            reports.add(surveyReport);
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.ITINERARIES_DETAILS)) {
            detailedReport = new Report("Details");
            reports.add(detailedReport);
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.ACTOR_EVENT_TABLES)) {
            actorEventTableReport = new Report("Actor-Event tables");
            reports.add(actorEventTableReport);
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.INTERACTION_TABLES)) {
            interactionTableReport = new Report("Interaction tables");
            reports.add(interactionTableReport);
        }
        Geography geography = censusCriteria.getGeography();
        Sequences sequences = new Sequences();
        for (Individual ego2 : segmentation.getCurrentIndividuals().toSortedList()) {
            if (surveyReport != null) {
                surveyReport.outputs().appendln(ego2.signature());
                surveyReport.outputs().appendln();
            }
            if (detailedReport != null) {
                detailedReport.outputs().appendln(ego2.signature());
                detailedReport.outputs().appendln();
            }
            Sequence sequence = SequenceMaker.createPersonalSequence(ego2, censusCriteria);
            sequences.add(sequence);
            for (Individual spouse : ego2.spouses()) {
                spouse.getAttributeValue(spouseFilterLabel);
            }
            if (actorEventTableReport != null) {
                actorEventTableReport.outputs().append(sequence.roleTable());
            }
            if (interactionTableReport != null) {
                interactionTableReport.outputs().append(sequence.interactionTable());
            }
            Sequences subSequences = SequenceWorker.split(sequence);
            for (Iterator<Ordinal> subSequence : subSequences) {
                if (subSequences.size() > 1) {
                    if (surveyReport != null) {
                        surveyReport.outputs().appendln(((Sequence)((Object)subSequence)).getId());
                    }
                    if (detailedReport != null) {
                        detailedReport.outputs().appendln(((Sequence)((Object)subSequence)).getId());
                    }
                }
                for (Ordinal key : ((Sequence)((Object)subSequence)).getEvents().keySet()) {
                    Relation event2 = ((Sequence)((Object)subSequence)).getEvents().get(key);
                    Place start = geography.getByHomonym(event2.getAttributeValue("START_PLACE"));
                    Place end = geography.getByHomonym(event2.getAttributeValue("END_PLACE"));
                    Place ancestor = geography.getCommonAncestor(start, end);
                    GeoLevel commonLevel = null;
                    String commonPlaceName = null;
                    String startPlaceLabel = censusCriteria.getStartPlaceLabel();
                    String endPlaceLabel = censusCriteria.getEndPlaceLabel();
                    if (ancestor != null) {
                        commonLevel = ancestor.getLevel();
                        commonPlaceName = ancestor.getName();
                    }
                    String order = SequenceWorker.order(event2, ego2);
                    if (surveyReport != null) {
                        surveyReport.outputs().appendln(key + "\t" + order + "\t" + key.getYear() + "\t(" + ((Sequence)((Object)subSequence)).getAge(key.getYear()) + ")\t" + event2.getTypedId() + "\t" + event2.getAttributeValue(startPlaceLabel) + "\t" + event2.getAttributeValue(endPlaceLabel) + "\t" + (Object)((Object)commonLevel) + "\t(" + commonPlaceName + ")\t");
                    }
                    if (detailedReport == null) continue;
                    detailedReport.outputs().appendln(key + "\t" + order + "\t" + key.getYear() + "\t(" + ((Sequence)((Object)subSequence)).getAge(key.getYear()) + ")\t" + event2.getTypedId() + "\t" + event2.getAttributeValue(startPlaceLabel) + "\t" + event2.getAttributeValue(endPlaceLabel) + "\t" + (Object)((Object)commonLevel) + "\t(" + commonPlaceName + ")\t");
                    detailedReport.outputs().appendln();
                    detailedReport.outputs().appendln(SequenceReporter.getStories(event2));
                }
                for (Report report : reports) {
                    report.outputs().appendln();
                }
            }
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.BIOGRAPHIES)) {
            biographyReport = new Report("Biographies");
            reports.add(biographyReport);
            for (Sequence biography : SequenceMaker.createBiographies(net, segmentation, censusCriteria).toSortedList()) {
                ego = (Individual)segmentation.getCurrentIndividuals().getById(biography.getId());
                biographyReport.outputs().appendln(ego.signature());
                for (Ordinal key : biography.getEvents().keySet()) {
                    event = biography.getEvent(key);
                    biographyReport.outputs().appendln(key + "\t" + event.getRoles(ego).toString() + " (" + biography.getAge(key.getYear()) + ")\t" + event.getName() + "\t" + SequenceCensus.getEgoRolePartners(event, censusCriteria, ego));
                }
                biographyReport.outputs().appendln();
            }
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.EXTENDED_BIOGRAPHIES)) {
            extendedBiographyReport = new Report("Extended biographies");
            reports.add(extendedBiographyReport);
            for (Sequence extendedBiography : SequenceMaker.createExtendedBiographies(net, segmentation, censusCriteria).toSortedList()) {
                ego = (Individual)segmentation.getCurrentIndividuals().getById(extendedBiography.getId());
                extendedBiographyReport.outputs().appendln(ego.signature());
                for (Ordinal key : extendedBiography.getEvents().keySet()) {
                    event = extendedBiography.getEvent(key);
                    extendedBiographyReport.outputs().appendln(key + "\t" + event.getRoles(ego).toString() + " (" + extendedBiography.getAge(key.getYear()) + ")\t" + event.getName() + " " + SequenceCensus.getEgoRolePartners(event, censusCriteria, ego));
                }
                extendedBiographyReport.outputs().appendln();
            }
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.EXPORT_RELATION_GRAPH)) {
            Graph<Individual> graph = NetUtils.createRelationGraph(segmentation, censusCriteria.getRelationModelName());
            ArrayList<String> partitionLabels = new ArrayList<String>();
            StringList pajekBuffer = new StringList();
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(graph, partitionLabels));
            pajekBuffer.appendln();
            if (pajekBuffer.length() != 0) {
                File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Relation Network"), ".paj");
                ReportRawData rawData = new ReportRawData("Export Relation Network to Pajek", "Pajek", "paj", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
                result.outputs().appendln();
                result.outputs().append(rawData);
            }
        }
        for (Report report : reports) {
            result.outputs().append(report);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static void reportSequenceTree(Report report, String value, Graph<Cluster<String>> sequenceTypeNetwork) {
        report.outputs().appendln("Sequence Tree " + value);
        Node<Cluster<String>> start = sequenceTypeNetwork.getNode(1);
        Stack stack = new Stack();
        report.outputs().appendln(start.getReferent() + "\t" + start.getReferent().size());
        stack.push(start);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            for (Node next : node.getOutNodes().toListSortedByLabel()) {
                report.outputs().appendln(next.getReferent() + "\t" + ((Cluster)next.getReferent()).size());
                stack.push(next);
            }
        }
        report.outputs().appendln();
    }

    private static void reportTriangles(Report report, Segmentation segmentation) throws PuckException {
        HashMap<Integer, Partition<EventTriangle>> trianglesMap = new HashMap<Integer, Partition<EventTriangle>>();
        Partition<EventTriangle> allTriangles = new Partition<EventTriangle>();
        Partition<Individual> triangleTypes = new Partition<Individual>();
        for (Individual ego : segmentation.getCurrentIndividuals()) {
            Individuals individuals = ego.getRelated("Migevent");
            individuals.add(ego);
            Partition<EventTriangle> triangles = SequenceWorker.getTriangles(individuals, "Migevent");
            allTriangles.add(triangles);
            trianglesMap.put(ego.getId(), triangles);
            for (Cluster<EventTriangle> cluster : triangles.getClusters()) {
                triangleTypes.put(ego, cluster.getValue());
            }
        }
        Report trianglesReport = new Report("Triangles");
        trianglesReport.outputs().appendln("Type\tnrTriangles\tnrEgoNetworks");
        for (Cluster cluster : allTriangles.getClusters().toListSortedByValue()) {
            trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + triangleTypes.getCluster(cluster.getValue()).size());
        }
        trianglesReport.outputs().appendln();
        PartitionCriteria partitionCriteria = new PartitionCriteria("Triangles");
        ReportChart chart5 = StatisticsReporter.createPartitionChart(allTriangles, partitionCriteria, null);
        trianglesReport.outputs().appendln(chart5);
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            Partition triangles = (Partition)trianglesMap.get(ego.getId());
            trianglesReport.outputs().appendln(ego + "\t" + triangles.size() + " types");
            for (Cluster cluster : triangles.getClusters().toListSortedByValue()) {
                trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size());
                for (EventTriangle triangle : cluster.getItems()) {
                    trianglesReport.outputs().appendln(triangle.getEventPattern());
                }
                trianglesReport.outputs().appendln();
            }
            trianglesReport.outputs().appendln();
        }
    }

    public static Report reportUnknownPlaces(Segmentation segmentation, ResourceBundle bundle) {
        UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
        criteria.setIncludedIndividual(true);
        criteria.setIncludedAllRelations(true);
        Report result = SequenceReporter.reportUnknownPlaces(segmentation, criteria, bundle);
        return result;
    }

    public static Report reportUncodedPlaces(Segmentation segmentation, ResourceBundle bundle) {
        UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
        criteria.setIncludedIndividual(true);
        criteria.setIncludedAllRelations(true);
        Report result = SequenceReporter.reportUncodedPlaces(segmentation, criteria, bundle);
        return result;
    }

    public static Report reportUnknownPlaces(Segmentation segmentation, UnknownPlacesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        Geography geography = Geography.getInstance();
        Partition<String> unknownPlaces = new Partition<String>();
        int errorCount = 0;
        StringList errors = new StringList();
        if (criteria.isIncludedIndividual()) {
            for (Individual individual : segmentation.getCurrentIndividuals()) {
                for (Attribute attribute : individual.attributes()) {
                    if (!attribute.getLabel().contains("PLAC") || geography.getByHomonym(attribute.getValue()) != null) continue;
                    unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
                    ++errorCount;
                }
            }
        }
        Relations relations = criteria.isIncludedAllRelations() ? segmentation.getCurrentRelations() : (criteria.getRelationNames().isEmpty() ? new Relations() : segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames()));
        for (Relation relation : relations) {
            for (Attribute attribute : relation.attributes()) {
                if (!attribute.getLabel().contains("PLAC") || geography.getByHomonym(attribute.getValue()) != null) continue;
                unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
                ++errorCount;
            }
        }
        for (Cluster cluster : unknownPlaces.getClusters()) {
            errors.appendln(cluster.getValue().toString());
            for (String placeName : cluster.getItems()) {
                errors.appendln("\t" + placeName);
            }
            errors.appendln();
        }
        Report result = new Report();
        result.setTitle("Unknown Places");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Unknown Places") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportUncodedPlaces(Segmentation segmentation, UnknownPlacesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        Geography geography = Geography.getInstance();
        Partition<Object> uncodedPlaces = new Partition<Object>();
        int errorCount = 0;
        StringList errors = new StringList();
        if (criteria.isIncludedIndividual()) {
            for (Individual individual : segmentation.getCurrentIndividuals()) {
                for (Attribute attribute : individual.attributes()) {
                    Object place;
                    if (!attribute.getLabel().contains("PLAC") || (place = geography.getByHomonym(attribute.getValue())) == null || ((Place)place).getCoordinate() != null) continue;
                    uncodedPlaces.put(place, new Value(((Place)place).getLevel()));
                    Place sup = ((Place)place).getSup();
                    while (sup.getCoordinate() == null) {
                        uncodedPlaces.put(sup, new Value(sup.getLevel()));
                        sup = sup.getSup();
                    }
                }
            }
        }
        Relations relations = criteria.isIncludedAllRelations() ? segmentation.getCurrentRelations() : (criteria.getRelationNames().isEmpty() ? new Relations() : segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames()));
        for (Relation relation : relations) {
            for (Attribute attribute : relation.attributes()) {
                Place place;
                if (!attribute.getLabel().contains("PLAC") || (place = geography.getByHomonym(attribute.getValue())) == null || place.getCoordinate() != null) continue;
                uncodedPlaces.put(place, new Value(place.getLevel()));
                Place sup = place.getSup();
                while (sup.getCoordinate() == null) {
                    uncodedPlaces.put(sup, new Value(sup.getLevel()));
                    sup = sup.getSup();
                }
            }
        }
        for (Cluster cluster : uncodedPlaces.getClusters().toListSortedByValue()) {
            errors.appendln(String.valueOf(cluster.getValue().toString()) + " " + cluster.size());
            errorCount += cluster.size();
            ArrayList<String> toponyms = new ArrayList<String>();
            for (Object place : cluster.getItems()) {
                toponyms.add(((Place)place).getToponym());
            }
            Collections.sort(toponyms);
            for (String toponym : toponyms) {
                errors.appendln("\t" + toponym);
            }
            errors.appendln();
        }
        Report result = new Report();
        result.setTitle("Uncoded Places");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Uncoded Places") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static int sequenceNumber(Cluster<String> cluster) {
        HashSet<String> set = new HashSet<String>();
        for (String string : cluster.getItems()) {
            set.add(string.split("\\s")[0]);
        }
        int result = set.size();
        return result;
    }
}

