/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import com.mysql.jdbc.StringUtils;
import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphComparatorByArcCount;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.SequenceProfile;
import org.tip.puck.spacetime.workers.SequenceMaker;
import org.tip.puck.spacetime.workers.SequenceWorker;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Trafo;
import org.tip.puck.util.Value;

public class SequenceCensus {
    private Individual ego;
    private List<Relation> events;
    private String egoRoleName;
    private int[] maxDepths;
    private GeoLevel level;
    private List<String> placeNames;
    private List<String> relationModelNames;
    private List<String> roleNames;
    private List<SpaceTimeCriteria.RelationClassificationType> types;
    private List<SpaceTimeCriteria.RelationClassificationType> mainEventTypes;
    private String relationModelName;
    private Geography geography;
    private List<Place> placeList;
    private String chainClassification;
    private String alterAttributeLabel;
    private String alterAttributeValue;
    private int length;
    private int threshold;
    private Map<String, Set<Individual>> altersByRoles;
    private Map<Individual, List<String>> rolesByAlter;
    private Map<Individual, List<String>> relationsByAlter;
    private Map<String, List<String>> relationsByRoles;
    private Map<Individual, List<Relation>> eventsByAlter;
    private Map<Integer, List<Individual>> coverage;
    private Map<SpaceTimeCriteria.RelationClassificationType, Map<Relation, String>> eventEvaluations;
    private Map<String, Double> specificDensities;
    private List<String> impersonalRelations;
    private Map<String, GraphProfile<Individual>> networkProfiles;
    private Map<String, GraphProfile<Cluster<Relation>>> eventTypeNetworkProfiles;
    private Map<String, GraphProfile<Relation>> eventNetworkProfiles;
    private Map<String, List<String>> partitionLabels;
    private Map<SpaceTimeCriteria.RelationClassificationType, Graph<Set<Individual>>> parcoursSimilarityTrees;
    private Map<SpaceTimeCriteria.RelationClassificationType, SequenceProfile> sequenceProfiles;
    private String pattern;
    private String impersonalLabel = "NOHOST";

    public SequenceCensus(Sequence source, SpaceTimeCriteria criteria) {
        this.ego = source.getEgo();
        this.events = new ArrayList<Relation>();
        this.length = 0;
        for (Relation event : source.getEvents().values()) {
            this.events.add(event);
            if (SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event)) continue;
            ++this.length;
        }
        this.egoRoleName = criteria.getEgoRoleName();
        this.pattern = criteria.getPattern();
        this.maxDepths = ToolBox.stringsToInts(criteria.getPattern());
        this.level = criteria.getLevel();
        this.partitionLabels = criteria.getPartitionLabels();
        this.relationModelName = criteria.getRelationModelName();
        this.relationModelNames = criteria.getRelationModelNames();
        this.geography = criteria.getGeography();
        this.roleNames = criteria.getRoleNames();
        this.types = criteria.getTypes();
        this.chainClassification = criteria.getChainClassification();
        this.alterAttributeLabel = criteria.getAlterFilterAttributeLabel();
        this.alterAttributeValue = criteria.getAlterFilterAttributeValue();
        this.mainEventTypes = criteria.getMainRelationClassificationTypes();
        this.placeNames = criteria.getMinimalPlaceNames();
        this.threshold = 20;
        if (this.mainEventTypes.contains((Object)SpaceTimeCriteria.RelationClassificationType.TREES)) {
            for (Relation event : this.events) {
                event.updateReferents(criteria.getDefaultReferentRoleName());
            }
        }
        if ((this.types.contains((Object)SpaceTimeCriteria.RelationClassificationType.MIG) || this.types.contains((Object)SpaceTimeCriteria.RelationClassificationType.HOSTMIG) || this.types.contains((Object)SpaceTimeCriteria.RelationClassificationType.MIGRATIONTYPE) || this.types.contains((Object)SpaceTimeCriteria.RelationClassificationType.CHILDMIGRATIONTYPE)) && !this.roleNames.contains("MIG")) {
            this.roleNames.add("MIG");
        }
        if ((this.types.contains((Object)SpaceTimeCriteria.RelationClassificationType.HOST) || this.types.contains((Object)SpaceTimeCriteria.RelationClassificationType.HOSTMIG) || this.types.contains((Object)SpaceTimeCriteria.RelationClassificationType.MIGRATIONTYPE) || this.types.contains((Object)SpaceTimeCriteria.RelationClassificationType.CHILDMIGRATIONTYPE)) && !this.roleNames.contains("HOST")) {
            this.roleNames.add("HOST");
        }
        this.sequenceProfiles = new HashMap<SpaceTimeCriteria.RelationClassificationType, SequenceProfile>();
        this.networkProfiles = new HashMap<String, GraphProfile<Individual>>();
        this.eventNetworkProfiles = new HashMap<String, GraphProfile<Relation>>();
        this.eventTypeNetworkProfiles = new HashMap<String, GraphProfile<Cluster<Relation>>>();
        this.setAlters();
        this.setAlterRelations("ALL");
        this.evaluateEvents();
        for (String networkTitle : criteria.getNetworkTitles()) {
            if (networkTitle.contains("Ego Network")) {
                this.setEgoNetworks();
                continue;
            }
            if (networkTitle.contains("Parcours Network")) {
                this.setParcoursNetworks();
                continue;
            }
            if (networkTitle.contains("Parcours Intersection Network")) {
                this.setParcoursIntersectionNetworks();
                continue;
            }
            if (!networkTitle.contains("Parcours Similarity Network")) continue;
            this.setParcoursSimilarityNetworks();
        }
    }

    private void setEgoNetworks() {
        this.networkProfiles.put("Ego Network", new GraphProfile<Individual>(this.getEgoNetwork(), this.ego));
        this.networkProfiles.put("Nonmediated Ego Network", new GraphProfile<Individual>(this.getNonMediatedEgoNetwork(), this.ego));
        this.setSpecificDensities("Ego Network");
        this.setComponentTypes("Nonmediated Ego Network");
    }

    private List<String> getNetworkRelations(Graph<Individual> graph) {
        ArrayList<String> result = new ArrayList<String>();
        for (Node<Individual> node : graph.getNodes().toListSortedById()) {
            Individual referent = node.getReferent();
            for (String relation : this.relationsByAlter.get(referent)) {
                if (result.contains(relation)) continue;
                result.add(relation);
            }
        }
        Collections.sort(result);
        return result;
    }

    private List<String[]> getConnectedRelations(Partition<Node<Individual>> partition) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Cluster<Node<Individual>> cluster : partition.getClusters()) {
            ArrayList<String> relations = new ArrayList<String>();
            for (Node<Individual> node : cluster.getItems()) {
                Individual referent = node.getReferent();
                for (String relation : this.relationsByAlter.get(referent)) {
                    if (relations.contains(relation)) continue;
                    relations.add(relation);
                }
            }
            Collections.sort(relations);
            for (String firstRelation : relations) {
                for (String secondRelation : relations) {
                    String[] pair;
                    if (firstRelation.equals(secondRelation) || result.contains(pair = new String[]{firstRelation, secondRelation})) continue;
                    result.add(pair);
                }
            }
        }
        return result;
    }

    private String getComponentType(Cluster<Node<Individual>> component) {
        String result = null;
        ArrayList<String> relations = new ArrayList<String>();
        for (Node<Individual> node : component.getItems()) {
            Individual referent = node.getReferent();
            relations.addAll((Collection<String>)this.relationsByAlter.get(referent));
        }
        if (PuckUtils.containsStrings(relations, "FATHER;PATERNAL_HOME") && PuckUtils.containsStrings(relations, "MOTHER")) {
            result = "PARENT";
        } else if (PuckUtils.containsStrings(relations, "FATHER;PATERNAL_HOME")) {
            result = "FATHER";
        } else if (PuckUtils.containsStrings(relations, "MOTHER;MATERNAL_HOME")) {
            result = "MOTHER";
        } else if (PuckUtils.containsStrings(relations, "SPOUSE;MARITAL_HOME")) {
            result = "SPOUSE";
        } else if (PuckUtils.containsStrings(relations, "RELATIVE;RELATIVE_AGNATIC;RELATIVE_UTERINE;RELATIVE_COGNATIC")) {
            result = "RELATIVE";
        } else if (PuckUtils.containsStrings(relations, "AFFINE")) {
            result = "AFFINE";
        } else if (PuckUtils.containsStrings(relations, "EMPLOYER")) {
            result = "EMPLOYER";
        }
        if (result == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String relationModelName : this.relationModelNames) {
                if (this.ego.relations().getByModelName(relationModelName).size() <= 0) continue;
                RelationModel model = ((Relation)this.ego.relations().getByModelName(relationModelName).getFirst()).getModel();
                for (Role role : model.roles()) {
                    if (!relations.contains(role.getName()) || list.contains(role.getName())) continue;
                    list.add(role.getName());
                }
            }
            Collections.sort(list);
            if (list.size() > 0) {
                result = "";
                for (String item : list) {
                    if (result.length() > 0) {
                        result = String.valueOf(result) + "-";
                    }
                    result = String.valueOf(result) + item;
                }
            }
        }
        if (result == null) {
            result = relations.size() > 0 ? "OTHER" : "UNKNOWN";
        }
        return result;
    }

    private void setParcoursNetworks() {
        for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : this.mainEventTypes) {
            this.eventTypeNetworkProfiles.put("Parcours Network_" + (Object)((Object)relationClassificationType), new GraphProfile<Cluster<Relation>>(this.getParcoursNetwork(relationClassificationType)));
            if (!this.partitionLabels.get("Parcours Network_" + (Object)((Object)relationClassificationType)).contains("COMPONENT")) continue;
            this.setComponentTypes("Parcours Network_" + (Object)((Object)relationClassificationType));
        }
        this.eventNetworkProfiles.put("Parcours", new GraphProfile<Relation>(this.getParcoursGraph()));
        this.eventNetworkProfiles.put("Extended Parcours", new GraphProfile(this.getExtendedParcoursGraph()));
        this.eventNetworkProfiles.put("Multiple Parcours", new GraphProfile<Relation>(this.getMultipleParcoursGraph()));
    }

    private void setParcoursIntersectionNetworks() {
        this.networkProfiles.put("Parcours Intersection Network", new GraphProfile<Individual>(this.getParcoursIntersectionNetwork(), this.ego));
        if (this.partitionLabels.get("Parcours Intersection Network").contains("COMPONENT")) {
            this.setComponentTypes("Parcours Intersection Network");
        }
    }

    private void setParcoursSimilarityNetworks() {
        this.parcoursSimilarityTrees = new HashMap<SpaceTimeCriteria.RelationClassificationType, Graph<Set<Individual>>>();
        for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : this.mainEventTypes) {
            this.networkProfiles.put("Parcours Similarity Network_" + (Object)((Object)relationClassificationType), new GraphProfile<Individual>(this.getParcoursSimilarityNetwork(relationClassificationType), this.ego));
            if (!this.partitionLabels.get("Parcours Similarity Network_" + (Object)((Object)relationClassificationType)).contains("COMPONENT")) continue;
            this.setComponentTypes("Parcours Similarity Network_" + (Object)((Object)relationClassificationType));
        }
    }

    private <E> void makeAlterRelationPartition(Graph<E> network) {
        for (Node<E> node : network.getNodes()) {
            E referent = node.getReferent();
            Individual alter = null;
            if (referent instanceof Individual) {
                alter = (Individual)referent;
            } else if (referent instanceof Set && ((Set)referent).size() == 1) {
                Iterator iterator = ((Set)referent).iterator();
                while (iterator.hasNext()) {
                    Individual element;
                    alter = element = (Individual)iterator.next();
                }
            }
            if (alter == null) continue;
            List<String> relations = this.relationsByAlter.get(alter);
            if (alter == this.ego) {
                node.setAttribute("EGO-RELATION", "EGO");
                continue;
            }
            if (relations == null) continue;
            node.setAttribute("EGO-RELATION", relations.toString());
        }
    }

    void writePajekNetwork(StringList pajekBuffer, String title) throws PuckException {
        if (!title.contains("Parcours Similarity Tree") && !title.contains("Parcours Network Fused")) {
            Graph<Relation> network;
            if (title.contains("Parcours Network") && !title.contains("Fused")) {
                Graph<Cluster<Relation>> network2 = this.eventTypeNetworkProfiles.get(title).getGraph();
                if (network2.nodeCount() > 0) {
                    pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(network2, this.partitionLabels.get(title)));
                }
            } else if (title.contains("Network")) {
                Graph<Individual> network3 = this.networkProfiles.get(title).getGraph();
                this.makeAlterRelationPartition(network3);
                GraphUtils.addNodeLabelsFromPartition(network3, "EGO-RELATION");
                pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(network3, this.partitionLabels.get(title)));
            } else if (title.contains("Parcours") && (network = this.eventNetworkProfiles.get(title).getGraph()).nodeCount() > 0) {
                pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(network, this.partitionLabels.get(title)));
            }
        }
    }

    public Set<Individual> getAllAlters() {
        return this.altersByRoles.get("ALL");
    }

    public Map<Individual, List<String>> getRelationsByAlter() {
        return this.relationsByAlter;
    }

    private void setAlters() {
        this.altersByRoles = new HashMap<String, Set<Individual>>();
        this.altersByRoles.put("ALL", new HashSet());
        this.altersByRoles.put("SELECTED", new HashSet());
        for (String alterRoleName : this.roleNames) {
            this.altersByRoles.put(alterRoleName, new HashSet());
        }
        this.rolesByAlter = new HashMap<Individual, List<String>>();
        this.eventsByAlter = new HashMap<Individual, List<Relation>>();
        this.coverage = new TreeMap<Integer, List<Individual>>();
        for (Relation event : this.events) {
            if (!event.hasRole(this.ego, this.egoRoleName)) continue;
            if (SequenceCensus.isBirth(event)) {
                for (Individual parent : this.ego.getParents()) {
                    if (event.getIndividuals().contains(parent)) continue;
                    event.actors().add(new Actor(parent, new Role("OTHER")));
                }
            }
            for (Actor actor : event.actors()) {
                List<String> roleNameList;
                Individual alter = actor.getIndividual();
                String roleName = actor.getRole().getName();
                if (roleName.equals(this.egoRoleName) && alter == this.ego) continue;
                this.altersByRoles.get("ALL").add(alter);
                if (!this.altersByRoles.containsKey(roleName)) {
                    this.altersByRoles.put(roleName, new HashSet());
                }
                this.altersByRoles.get(actor.getRole().getName()).add(alter);
                if (this.roleNames.contains(roleName)) {
                    this.altersByRoles.get("SELECTED").add(alter);
                }
                if ((roleNameList = this.rolesByAlter.get(alter)) == null) {
                    roleNameList = new ArrayList<String>();
                    this.rolesByAlter.put(alter, roleNameList);
                }
                roleNameList.add(roleName);
                List<Relation> eventList = this.eventsByAlter.get(alter);
                if (eventList == null) {
                    eventList = new ArrayList<Relation>();
                    this.eventsByAlter.put(alter, eventList);
                }
                if (eventList.contains(event)) continue;
                eventList.add(event);
            }
        }
        for (Individual alter : this.eventsByAlter.keySet()) {
            Integer cov = this.eventsByAlter.get(alter).size();
            List<Individual> list = this.coverage.get(cov);
            if (list == null) {
                list = new ArrayList<Individual>();
                this.coverage.put(cov, list);
            }
            if (list.contains(alter)) continue;
            list.add(alter);
        }
    }

    private void setAlterRelations(String alterRoleName) {
        this.relationsByAlter = NetUtils.getAlterRelations1(this.ego, this.altersByRoles.get(alterRoleName), this.maxDepths, this.relationModelNames, this.chainClassification, null, null);
        this.relationsByRoles = new HashMap<String, List<String>>();
        for (String roleName : this.altersByRoles.keySet()) {
            ArrayList<String> relations = new ArrayList<String>();
            this.relationsByRoles.put(roleName, relations);
            for (Individual alter : this.altersByRoles.get(roleName)) {
                if (this.relationsByAlter.get(alter).size() == 0) {
                    relations.add("UNKNOWN");
                    continue;
                }
                for (String relation : this.relationsByAlter.get(alter)) {
                    if (relations.contains(relation)) continue;
                    relations.add(relation);
                }
            }
        }
        this.impersonalRelations = new ArrayList<String>();
        for (Relation event : this.events) {
            String impersonalRelation = this.impersonalRelation(event);
            if (impersonalRelation == null) continue;
            this.impersonalRelations.add(impersonalRelation);
        }
        KinType[] kinTypeArray = KinType.values();
        int n = kinTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KinType kinType = kinTypeArray[n2];
            for (Individual alter : this.ego.getKin(kinType)) {
                if (this.relationsByAlter.get(alter) != null) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add(kinType.toString());
                this.relationsByAlter.put(alter, list);
            }
            ++n2;
        }
    }

    private String impersonalRelation(Relation event) {
        String result = null;
        Actor egoActor = event.actors().get(this.ego.getId(), this.egoRoleName);
        if (egoActor != null && egoActor.attributes() != null) {
            result = egoActor.getAttributeValue(this.impersonalLabel);
        }
        return result;
    }

    private void setPlaceList() {
        this.placeList = new ArrayList<Place>();
        for (Relation relation : this.events) {
            Place place = this.geography.getPlace(relation.getAttributeValue("END_PLACE"), this.level);
            if (place == null) {
                place = new Place(this.level, "UNKNOWN");
            }
            this.placeList.add(place);
        }
    }

    private Relation getPreviousEvent(Relation event) {
        int index = this.events.indexOf(event) - 1;
        Relation result = index > -1 ? this.events.get(index) : null;
        return result;
    }

    private Double getTurnover(Relation event) {
        Double result = 0.0;
        Relation previousEvent = this.getPreviousEvent(event);
        if (previousEvent != null) {
            Individuals previousAlters = previousEvent.getIndividuals(this.roleNames);
            Individuals currentAlters = event.getIndividuals(this.roleNames);
            Double n = new Double(previousAlters.size());
            for (Individual individual : previousAlters) {
                if (!currentAlters.contains(individual)) continue;
                result = result + 1.0;
            }
            result = result / n;
        }
        return result;
    }

    private GeoLevel getMaxDistance() {
        GeoLevel result = null;
        for (Relation event : this.events) {
            String distance;
            if (SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event) || StringUtils.isNullOrEmpty((String)(distance = this.eventEvaluations.get((Object)SpaceTimeCriteria.RelationClassificationType.DISTANCE).get(event))) || distance.equals("UNDEFINED") || result != null && GeoLevel.valueOf(distance).compareTo(result) >= 0) continue;
            result = GeoLevel.valueOf(distance);
        }
        return result;
    }

    private List<String> getRelationTypes(Individuals alters, String roleName) {
        ArrayList<String> result = new ArrayList<String>();
        for (Individual alter : alters) {
            List<String> relations = this.relationsByAlter.get(alter);
            if (relations == null) continue;
            for (String relation : relations) {
                if (result.contains(relation)) continue;
                result.add(relation);
            }
        }
        Collections.sort(result);
        return result;
    }

    private List<String> getRelationTypes(Relation event, String roleName) {
        Individuals alters = event.getIndividuals(roleName);
        if (roleName.equals("MIG")) {
            alters.removeById(this.ego.getId());
        }
        List<String> result = this.getRelationTypes(alters, roleName);
        if (alters.size() == 0) {
            Actor egoActor = event.actors().get(this.ego.getId(), this.egoRoleName);
            if (egoActor.attributes() != null && egoActor.getAttributeValue(this.impersonalLabel) != null) {
                result.add(egoActor.getAttributeValue(this.impersonalLabel));
            } else {
                for (Actor alterActor : event.actors().getByRole(this.egoRoleName)) {
                    List<String> relations;
                    String relation;
                    if (alterActor == null || alterActor.equals(egoActor) || alterActor.attributes() == null || (relation = alterActor.getAttributeValue(this.impersonalLabel)) == null || (relations = this.relationsByAlter.get(alterActor.getIndividual())) == null) continue;
                    for (String egoRelation : relations) {
                        if (result.contains(egoRelation = String.valueOf(egoRelation) + "S_" + relation)) continue;
                        result.add(egoRelation);
                    }
                }
            }
        }
        return result;
    }

    private String getChildMigrationType(Relation event) {
        List<String> hosts = this.getRelationTypes(event, "HOST");
        List<String> migs = this.getRelationTypes(event, "MIG");
        String result = null;
        if (SequenceCensus.isBirth(event)) {
            result = "BIRTH";
        } else if (!(this.getAge(event) > this.threshold || hosts.contains("FATHER") || hosts.contains("MOTHER") || migs.contains("FATHER") || migs.contains("MOTHER"))) {
            result = "NOPARENTS";
        }
        return result;
    }

    private String getHostType(Relation event) {
        String result;
        ArrayList<String> hosts = new ArrayList<String>();
        List<String> allhosts = this.reduceRelations(this.getRelationTypes(event, "HOST"), "HOST");
        for (String host : allhosts) {
            boolean consider = true;
            if (host.contains("FRIEND")) {
                for (String otherhost : allhosts) {
                    if (otherhost.contains("FRIEND")) continue;
                    consider = false;
                    break;
                }
                if (!consider) continue;
            }
            hosts.add(host);
        }
        if (SequenceCensus.isBirth(event)) {
            result = "PARENTS";
        } else if (SequenceCensus.isDeath(event)) {
            result = "DEATH";
        } else if (hosts.size() == 0) {
            result = "UNKNOWN";
            System.err.println(String.valueOf(result) + " " + this.ego + " " + event);
        } else if (hosts.contains("TRANSITION")) {
            result = "TRANSITION";
        } else if (PuckUtils.containsStrings(hosts, "FATHER OR PATERNAL HOME;MOTHER OR MATERNAL HOME")) {
            result = "PARENTS";
        } else if (PuckUtils.containsStrings(hosts, "SIBLING OR FRATERNAL HOME")) {
            result = "RELATIVE";
        } else if (PuckUtils.containsStrings(hosts, "SPOUSE OR MARITAL HOME")) {
            result = "SPOUSE";
        } else if (PuckUtils.containsStrings(hosts, "CHILD OR FILIAL HOME")) {
            result = "CHILD";
        } else if (PuckUtils.containsStrings(hosts, "RELATIVE;RELATIVE_AGNATIC;RELATIVE_UTERINE;RELATIVE_COGNATIC;RELATIVE_OR_AFFINE")) {
            result = "RELATIVE";
        } else if (hosts.contains("AFFINE")) {
            result = "AFFINE";
        } else if (hosts.contains("LANDLORD")) {
            result = "RENT";
        } else if (hosts.contains("UNRELATED")) {
            result = "UNRELATED";
        } else if (hosts.contains("HOTEL-HOSTEL") || hosts.contains("WITHOUT FIXED DOMICILE")) {
            result = "PUBLIC";
        } else {
            result = "";
            for (String host : hosts) {
                if ((host = host.replaceAll("RELATIVE_OR_AFFINE", "RELATIVE").replaceAll("SIBLING", "RELATIVE").replaceAll("FATHER", "PARENTS").replaceAll("MOTHER", "PARENTS")).equals("RELATIVES_MARITAL HOME")) {
                    result = "AFFINE";
                } else if (host.equals("SPOUSES_PATERNAL HOME")) {
                    result = "SPOUSE";
                } else if (host.equals("SPOUSES_MARITAL HOME")) {
                    result = "PARENTS";
                } else {
                    String[] hostParts = host.split("S_");
                    if (hostParts.length > 1) {
                        host = "via " + hostParts[0];
                    }
                    result = String.valueOf(result) + host + " ";
                }
                if (result.contains("via PARENTS")) {
                    result = "via PARENTS";
                    continue;
                }
                if (result.contains("via SPOUSE")) {
                    result = "via SPOUSE";
                    continue;
                }
                if (result.contains("via RELATIVE")) {
                    result = "via RELATIVE";
                    continue;
                }
                if (result.contains("via MASTER")) {
                    result = "via MASTER";
                    continue;
                }
                if (result.lastIndexOf("via") <= 0) continue;
                System.err.println("double reference " + result);
            }
            if (result.contains("null")) {
                result = "UNKNOWN";
                System.err.println(String.valueOf(result) + " " + this.ego + " " + event);
            }
        }
        if (result.contains("LODGER")) {
            System.err.println("Inverted landlord-lodger relation for " + this.ego + " " + event);
        }
        result = result.trim();
        return result;
    }

    private String getMigrationType(Relation event) {
        String result;
        List<String> hosts = this.getRelationTypes(event, "HOST");
        List<String> migs = this.getRelationTypes(event, "MIG");
        if (SequenceCensus.isBirth(event)) {
            result = "BIRTH";
        } else if (SequenceCensus.isDeath(event)) {
            result = "DEATH";
        } else {
            int n;
            String hostType = "OTHER";
            if (hosts.size() == 0) {
                hostType = "NOBODY";
            } else {
                String[] types = new String[]{"EGO", "FATHER", "MOTHER", "SPOUSE", "CHILD", "SIBLING"};
                boolean end = false;
                String[] stringArray = types;
                n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    if (hosts.contains(type)) {
                        hostType = type;
                        end = true;
                        break;
                    }
                    ++n2;
                }
                if (!end && (hosts.contains("RELATIVE_AGNATIC") || hosts.contains("RELATIVE_UTERINE") || hosts.contains("RELATIVE_COGNATIC") || hosts.contains("RELATIVE"))) {
                    hostType = "KIN";
                } else if (!end && hosts.contains("AFFINE")) {
                    hostType = "AFFINE";
                }
            }
            String migType = "OTHER";
            if (migs.size() == 0) {
                migType = "NOBODY";
            } else {
                String[] types = new String[]{"EGO", "FATHER", "MOTHER", "SPOUSE", "CHILD", "SIBLING"};
                boolean end = false;
                String[] stringArray = types;
                int n3 = types.length;
                n = 0;
                while (n < n3) {
                    String type = stringArray[n];
                    if (migs.contains(type)) {
                        migType = type;
                        end = true;
                        break;
                    }
                    ++n;
                }
                if (!end && (migs.contains("RELATIVE_AGNATIC") || migs.contains("RELATIVE_UTERINE") || migs.contains("RELATIVE_COGNATIC") || migs.contains("RELATIVE"))) {
                    migType = "KIN";
                } else if (!end && migs.contains("AFFINE")) {
                    migType = "AFFINE";
                }
            }
            result = "WITH_" + migType + "_TO_" + hostType;
            result = result.replaceAll("WITH_NOBODY", "ALONE");
        }
        return result;
    }

    public static boolean isBirth(Relation event) {
        return event.getAttributeValue("END_PLACE") != null && event.getAttributeValue("START_PLACE") == null;
    }

    public static boolean isDeath(Relation event) {
        return event.getAttributeValue("END_PLACE") == null && event.getAttributeValue("START_PLACE") != null;
    }

    private Relation getFirstMigration() {
        Relation result = null;
        for (Relation event : this.events) {
            if (SequenceCensus.isBirth(event)) continue;
            if (SequenceCensus.isDeath(event)) break;
            result = event;
            break;
        }
        return result;
    }

    private Relation getFirstEvent(String label, String value) {
        Map<Relation, String> eventType = this.eventEvaluations.get((Object)SpaceTimeCriteria.RelationClassificationType.valueOf(label));
        Relation result = null;
        if (eventType != null) {
            for (Relation event : this.events) {
                if (!value.equals(eventType.get(event))) continue;
                result = event;
                break;
            }
        }
        return result;
    }

    private String getRelationTypesAsShortCutString(Relation event, String roleName) {
        String result = Trafo.asShortCutString(this.getRelationTypes(event, roleName), 2);
        if (result == null && roleName.equals("MIG")) {
            result = "SG";
        }
        return result;
    }

    private void evaluateEvents() {
        this.eventEvaluations = new HashMap<SpaceTimeCriteria.RelationClassificationType, Map<Relation, String>>();
        for (SpaceTimeCriteria.RelationClassificationType type : this.types) {
            this.eventEvaluations.put(type, new HashMap());
            if ((this.altersByRoles != null || type != SpaceTimeCriteria.RelationClassificationType.HOST && type != SpaceTimeCriteria.RelationClassificationType.MIG && type != SpaceTimeCriteria.RelationClassificationType.HOSTMIG && type != SpaceTimeCriteria.RelationClassificationType.MIGRATIONTYPE) && type == SpaceTimeCriteria.RelationClassificationType.MOVEMENT) {
                this.setPlaceList();
            }
            int i = 0;
            for (Relation event : this.events) {
                String eventType = null;
                switch (type) {
                    case TYPEDID: {
                        eventType = String.valueOf(event.getTypedId());
                        break;
                    }
                    case HOST: {
                        eventType = this.getHostType(event);
                        break;
                    }
                    case MIG: {
                        eventType = this.getRelationTypesAsShortCutString(event, "MIG");
                        break;
                    }
                    case HOSTMIG: {
                        eventType = String.valueOf(this.getRelationTypesAsShortCutString(event, "HOST")) + ":" + this.getRelationTypesAsShortCutString(event, "MIG");
                        break;
                    }
                    case MIGRATIONTYPE: {
                        eventType = this.getMigrationType(event);
                        break;
                    }
                    case CHILDMIGRATIONTYPE: {
                        eventType = this.getChildMigrationType(event);
                        break;
                    }
                    case TREES: {
                        eventType = RelationWorker.getLinkTrees(event, true, "GENDER", this.pattern);
                        break;
                    }
                    case DISTANCE: {
                        if (SequenceCensus.isBirth(event)) {
                            eventType = "BIRTH";
                            break;
                        }
                        if (SequenceCensus.isDeath(event)) {
                            eventType = "DEATH";
                            break;
                        }
                        GeoLevel distance = this.getDistance(event);
                        if (distance == null) break;
                        eventType = distance.dynamic().toString();
                        break;
                    }
                    case PLACE: {
                        if (SequenceCensus.isDeath(event)) {
                            eventType = "DEATH";
                            break;
                        }
                        Place place = this.geography.get(event.getAttributeValue("END_PLACE"), this.level);
                        if (place == null) break;
                        eventType = place.getToponym();
                        break;
                    }
                    case REGION: {
                        Place region = this.geography.getSup(event.getAttributeValue("END_PLACE"), this.placeNames);
                        if (region == null) break;
                        eventType = region.getName();
                        break;
                    }
                    case MOVEMENT: {
                        eventType = SequenceWorker.getMovement(this.placeList, i);
                        break;
                    }
                    case TURNOVER: {
                        eventType = String.valueOf(MathUtils.round(this.getTurnover(event), 2));
                        break;
                    }
                    default: {
                        eventType = null;
                    }
                }
                if (eventType == null) {
                    System.err.println("Event type " + (Object)((Object)type) + " is null for event " + event);
                    eventType = "UNDEFINED";
                }
                this.eventEvaluations.get((Object)type).put(event, eventType);
                ++i;
            }
        }
    }

    private GeoLevel getDistance(Relation event) {
        GeoLevel result = null;
        if (!SequenceCensus.isBirth(event) && !SequenceCensus.isDeath(event)) {
            Place commonAncestor;
            Place start = this.geography.getByHomonym(event.getAttributeValue("START_PLACE"));
            Place end = this.geography.getByHomonym(event.getAttributeValue("END_PLACE"));
            if (start != null && end != null && (commonAncestor = this.geography.getCommonAncestor(start, end)) != null) {
                result = commonAncestor.getLevel();
            }
        }
        return result;
    }

    public Map<GeoLevel, Integer> getDistanceProfile() {
        HashMap<GeoLevel, Integer> result = new HashMap<GeoLevel, Integer>();
        for (Relation event : this.events) {
            GeoLevel distance = this.getDistance(event);
            if (distance == null) continue;
            if (result.containsKey((Object)(distance = distance.dynamic()))) {
                result.put(distance, (Integer)result.get((Object)distance) + 1);
                continue;
            }
            result.put(distance, 1);
        }
        return result;
    }

    public Graph getExtendedParcoursGraph() {
        Graph<Numberable> result = new Graph<Numberable>();
        result.setLabel("Extended Parcours " + this.ego);
        Relation lastEvent = null;
        for (Relation event : this.events) {
            if (lastEvent != null) {
                Link<Relation> eventLink = result.addArc(lastEvent, event, 2.0);
                eventLink.setTag(String.valueOf(this.ego.getId()));
                for (String label : this.roleNames) {
                    for (Individual alter : event.getIndividuals(label)) {
                        if (label == this.egoRoleName && alter == this.ego) continue;
                        Link<Individual> alterLink = result.addArc(event, alter, 1.0);
                        alterLink.setTag(label);
                    }
                }
            }
            lastEvent = event;
        }
        if (this.events.size() == 1) {
            result.addNode(lastEvent);
        }
        for (String label : this.roleNames) {
            Set<Individual> cluster = this.altersByRoles.get(label);
            if (cluster == null) continue;
            for (Individual alter : cluster) {
                for (Relation event : alter.relations().getByModel(lastEvent.getModel())) {
                    if (this.events.contains(event) || SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event) || Sequence.getYear(event) == null || Sequence.getYear(lastEvent) == null || Sequence.getYear(event) > Sequence.getYear(lastEvent)) continue;
                    for (Individual tertius : event.getIndividuals()) {
                        if (tertius.getId() <= alter.getId() || result.getNode(tertius) == null) continue;
                        Link<Individual> link1 = result.addArc(event, tertius, 1.0);
                        link1.setTag(event.getRoleNamesAsString(tertius));
                        Link<Individual> link2 = result.addArc(event, alter, 1.0);
                        link2.setTag(event.getRoleNamesAsString(alter));
                    }
                }
            }
        }
        int order = 1;
        for (Node obj : result.getNodes()) {
            Node node = obj;
            if (node.getReferent() instanceof Individual) {
                node.setAttribute("TYPE", "INDIVIDUAL");
                for (SpaceTimeCriteria.RelationClassificationType type : this.types) {
                    List<String> list = null;
                    list = type == SpaceTimeCriteria.RelationClassificationType.HOST || type == SpaceTimeCriteria.RelationClassificationType.MIG || type == SpaceTimeCriteria.RelationClassificationType.HOSTMIG ? this.relationsByAlter.get((Individual)node.getReferent()) : this.rolesByAlter.get((Individual)node.getReferent());
                    if (list == null) continue;
                    node.setAttribute(type.toString(), list.toString());
                }
                node.setAttribute("ORDER", "0");
                continue;
            }
            if (!(node.getReferent() instanceof Relation)) continue;
            node.setAttribute("TYPE", "EVENT");
            for (SpaceTimeCriteria.RelationClassificationType type : this.types) {
                String value = this.eventEvaluations.get((Object)type).get((Relation)node.getReferent());
                if (value == null) continue;
                node.setAttribute(type.toString(), value);
            }
            node.setAttribute("ORDER", String.valueOf(order));
            ++order;
        }
        return result;
    }

    private List<String> reduceRelations(List<String> relations, String alterRole) {
        ArrayList<String> result = new ArrayList<String>();
        for (String relation : relations) {
            String reducedRelation = null;
            reducedRelation = relation.equals("EGO") ? "OWN HOME" : (alterRole.equals("HOST") && relation.equals("FATHER") || relation.equals("PATERNAL HOME") ? "FATHER OR PATERNAL HOME" : (alterRole.equals("HOST") && relation.equals("CHILD") || relation.equals("FILIAL HOME") ? "CHILD OR FILIAL HOME" : (alterRole.equals("HOST") && relation.equals("MOTHER") || relation.equals("MATERNAL HOME") ? "MOTHER OR MATERNAL HOME" : (alterRole.equals("HOST") && relation.equals("SIBLING") || relation.equals("FRATERNAL HOME") ? "SIBLING OR FRATERNAL HOME" : (alterRole.equals("HOST") && relation.equals("SPOUSE") || relation.equals("MARITAL HOME") ? "SPOUSE OR MARITAL HOME" : (relation.equals("STATE") || relation.equals("NGO") ? "STATE OR NGO" : (relation.equals("WORKPLACE") || relation.equals("HOMELESS") ? "WITHOUT FIXED DOMICILE" : (relation.equals("FRIEND") || relation.equals("EMPLOYERS_EMPLOYEE") || relation.equals("LANDLORDS_LODGER") || relation.equals("MASTERS_APPRENTICE") || relation.equals("FRIENDS_FRIEND") ? "FRIEND OR COLLEGUE" : (relation.contains("UNRELATEDS_") ? "UNRELATED" : (relation.contains("S_") ? relation.replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").replaceAll("RELATIVE", "RELATIVE_OR_AFFINE") : relation))))))))));
            if (result.contains(reducedRelation = this.reduceRelation(reducedRelation))) continue;
            result.add(reducedRelation);
        }
        return result;
    }

    private String reduceRelation(String relation) {
        String result = null;
        if (relation.equals("FATHER OR PATERNAL HOME") || relation.equals("MOTHER OR MATERNAL HOME")) {
            result = "PARENTS";
        } else if (relation.equals("SPOUSE OR MARITAL HOME")) {
            result = "SPOUSE";
        } else if (relation.equals("CHILD OR FILIAL HOME")) {
            result = "CHILD";
        } else if (relation.equals("LANDLORD")) {
            result = "RENT";
        } else if (relation.equals("HOTEL-HOSTEL") || relation.equals("WITHOUT FIXED DOMICILE")) {
            result = "PUBLIC";
        } else {
            result = relation.replaceAll("RELATIVE_OR_AFFINE", "RELATIVE").replaceAll("FATHER", "PARENTS").replaceAll("MOTHER", "PARENTS");
            if (result.equals("RELATIVES_MARITAL HOME")) {
                result = "AFFINE";
            } else if (result.equals("SIBLINGS_MARITAL HOME")) {
                result = "AFFINE";
            } else if (result.equals("SPOUSES_PATERNAL HOME")) {
                result = "SPOUSE";
            } else if (result.equals("SPOUSES_MARITAL HOME")) {
                result = "PARENTS";
            } else {
                String[] relationParts = result.split("S_");
                if (relationParts.length > 1) {
                    result = "via " + relationParts[0];
                    if (result.contains("via PARENTS")) {
                        result = "via PARENTS";
                    } else if (result.contains("via SPOUSE")) {
                        result = "via SPOUSE";
                    } else if (result.contains("via SIBLING")) {
                        result = "via SIBLING";
                    } else if (result.contains("via RELATIVE")) {
                        result = "via RELATIVE";
                    } else if (result.contains("via MASTER")) {
                        result = "via MASTER";
                    } else if (result.lastIndexOf("via") > 0) {
                        System.err.println("double reference " + result);
                    }
                }
            }
        }
        return result;
    }

    private static String parameter(String label) {
        String[] parts;
        String result = null;
        if (label.contains("_") && (parts = label.split("_")).length > 1) {
            result = parts[parts.length - 1];
        }
        return result;
    }

    private boolean isRelationClassificationType(String parameter) {
        boolean result = false;
        if (parameter != null) {
            try {
                if (SpaceTimeCriteria.RelationClassificationType.valueOf(parameter) != null) {
                    result = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Value getValue(String label) {
        Value result = null;
        GraphProfile<Comparable<Individual>> networkProfile = null;
        String parameter = SequenceCensus.parameter(label);
        if (this.isRelationClassificationType(parameter)) {
            if (this.eventTypeNetworkProfiles != null) {
                networkProfile = this.eventTypeNetworkProfiles.get("Parcours Network_" + parameter);
            }
            if (networkProfile == null && this.networkProfiles != null) {
                networkProfile = this.networkProfiles.get("Parcours Intersection Network_" + parameter);
            }
        } else if (this.networkProfiles != null) {
            networkProfile = this.networkProfiles.get("Nonmediated Ego Network");
        }
        if (this.length == 0) {
            result = null;
        } else if (label.contains("PROFILE")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getProfile());
        } else if (label.contains("SUPPORT")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getSupportAsList());
        } else if (label.contains("NRSTATIONS")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getNrStations());
        } else if (label.contains("NRCENTERSNOSTART")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getNrCentersWithoutStart());
        } else if (label.contains("NRCENTERS")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getNrCenters());
        } else if (label.contains("CENTERSNOSTART")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getCentersWithoutStartAsList());
        } else if (label.contains("CENTERS")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getCentersAsList());
        } else if (label.contains("NRINTERNALMOVES")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getNrLoops());
        } else if (label.contains("NREXTERNALMOVES")) {
            result = new Value(this.length - this.getValue("NRINTERNALMOVES_PLACE").intValue());
        } else if (label.contains("NRDIRECTRETURNS_NORM")) {
            result = Value.valueOf(MathUtils.percent(this.getValue("NRDIRECTRETURNS_" + parameter).intValue(), this.length - 1));
        } else if (label.contains("NRDIRECTRETURNS")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getNrDirectReturns());
        } else if (label.contains("NRCYCLES_NORM")) {
            result = Value.valueOf(MathUtils.percent(this.getValue("NRCYCLES_" + parameter).intValue(), this.length - 2));
        } else if (label.contains("NRCYCLES")) {
            SequenceProfile profile = this.getProfile(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getNrCycles());
        } else if (label.contains("NRALTERSPEREVENT")) {
            result = new Value(this.getMeanNr(parameter));
        } else if (label.contains("AGEFIRST")) {
            void var6_27;
            String[] subLabels = label.split("_");
            Object var6_24 = null;
            if (subLabels.length == 1) {
                Integer n = this.getAge(this.getFirstMigration());
            } else if (subLabels.length == 3) {
                Integer n = this.getAge(this.getFirstEvent(subLabels[1], subLabels[2]));
            }
            if (var6_27 != null) {
                result = new Value(var6_27);
            }
        } else if (label.equals("MAX_DISTANCE")) {
            GeoLevel maxDistance = this.getMaxDistance();
            if (maxDistance != null) {
                result = new Value(maxDistance);
            }
        } else if (label.equals("MEAN_NR_MOVES")) {
            Map<GeoLevel, Integer> distanceProfile = this.getDistanceProfile();
            if (distanceProfile != null) {
                result = new Value(distanceProfile);
            }
        } else if (label.equals("MEAN_COVERAGE")) {
            result = this.length == 0 ? null : new Value(this.getMeanCoverage());
        } else if (label.equals("MAX_COVERAGE")) {
            result = this.length == 0 ? null : new Value(this.getMaxCoverage());
        } else if (label.contains("MEAN_BETWEENNESS")) {
            result = new Value(networkProfile.getMeanBetweenness());
        } else if (label.contains("MAX_BETWEENNESS")) {
            result = new Value(networkProfile.getMaxNonEgoBetweenness());
        } else if (label.equals("MAIN_ALTERS")) {
            result = new Value(this.getMaxCoverageAlters());
        } else if (label.contains("CENTRAL_ALTERS")) {
            result = networkProfile.nodeCount() < 3.0 ? null : new Value(networkProfile.getCentralAlters());
        } else if (label.equals("MAIN_RELATIONS")) {
            ArrayList<String> relations = new ArrayList<String>();
            for (Individual individual : this.getMaxCoverageAlters()) {
                for (String relation : this.relationsByAlter.get(individual)) {
                    if (relations.contains(relation)) continue;
                    relations.add(relation);
                }
            }
            result = new Value(relations);
        } else if (label.contains("EVENTS_")) {
            String typeName = label.substring(label.indexOf("_") + 1);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Relation event : this.events) {
                String type = this.eventEvaluations.get((Object)SpaceTimeCriteria.RelationClassificationType.valueOf(typeName)).get(event);
                if (arrayList.contains(type)) continue;
                arrayList.add(type);
            }
            result = new Value(arrayList);
        } else if (label.contains("CENTRAL_RELATIONS")) {
            if (networkProfile.nodeCount() < 3.0) {
                result = null;
            } else {
                ArrayList<String> relations = new ArrayList<String>();
                for (Individual individual : networkProfile.getCentralAlters()) {
                    for (String relation : this.relationsByAlter.get(individual)) {
                        if (relations.contains(relation)) continue;
                        relations.add(relation);
                    }
                }
                result = new Value(relations);
            }
        } else if (label.contains("CONNECTED_NETWORK_RELATIONS")) {
            result = new Value(this.getConnectedRelations(networkProfile.getNonEgoComponents()));
        } else if (label.contains("NETWORK_RELATIONS")) {
            result = new Value(this.getNetworkRelations(networkProfile.getGraphWithoutEgo()));
        } else if (label.contains("RELATIONS")) {
            List<String> relations = this.relationsByRoles.get(parameter);
            if (parameter.equals("HOST")) {
                relations.addAll(this.impersonalRelations);
            }
            relations = this.reduceRelations(relations, parameter);
            result = new Value(relations);
        } else if (label.equals("NREVENTS")) {
            result = new Value(this.length);
        } else if (label.contains("NRALTERS")) {
            result = new Value(this.altersByRoles.get(parameter).size());
        } else if (label.contains("SAMESEXALTERS")) {
            int sameSexAlters = 0;
            for (Individual individual : this.altersByRoles.get(parameter)) {
                if (individual.getGender() != this.ego.getGender()) continue;
                ++sameSexAlters;
            }
            result = this.altersByRoles.get(parameter).size() == 0 ? null : new Value(MathUtils.percent(sameSexAlters, this.altersByRoles.get(parameter).size()));
        } else if (label.contains("SAMEPLACEALTERS")) {
            int samePlaceAlters = 0;
            Place place = this.geography.getPlace(this.ego.getAttributeValue("BIRT_PLAC"), this.level);
            for (Individual alter : this.altersByRoles.get(parameter)) {
                Place alterBirthPlace = this.geography.getPlace(alter.getAttributeValue("BIRT_PLAC"), this.level);
                if (place == null || !place.equals(alterBirthPlace)) continue;
                ++samePlaceAlters;
            }
            result = this.altersByRoles.get(parameter).size() == 0 ? null : new Value(MathUtils.percent(samePlaceAlters, this.altersByRoles.get(parameter).size()));
        } else if (label.contains("EGO-BETWEENNESS")) {
            result = new Value(networkProfile.getEgoBetweenness());
        } else if (label.contains("SIZE")) {
            result = new Value(networkProfile.nodeCount());
        } else if (label.contains("TIES")) {
            result = new Value(networkProfile.nonNullLineCount());
        } else if (label.contains("DENSITY")) {
            result = new Value(networkProfile.density());
        } else if (label.contains("DENSITY_NOLOOPS")) {
            result = new Value(networkProfile.densityWithoutLoops());
        } else if (label.contains("SDENSITY")) {
            result = this.specificDensities.get(parameter) == 0.0 ? null : new Value(this.specificDensities.get(parameter));
        } else if (label.contains("MEANDEGREE")) {
            result = new Value(networkProfile.meanDegree());
        } else if (label.contains("MEANDEGREE_NOLOOPS")) {
            result = new Value(networkProfile.meanDegreeWithoutLoops());
        } else if (label.contains("MEANDEGREE_NORM")) {
            result = new Value(networkProfile.meanDegreeNormalized());
        } else if (label.contains("MEANDEGREE_NOLOOPS_NORM")) {
            result = new Value(networkProfile.meanDegreeWithoutLoopsNormalized());
        } else if (label.contains("NRCOMPONENTS")) {
            result = new Value(networkProfile.getNonEgoComponents().size());
        } else if (label.contains("NRISOLATES")) {
            result = new Value(networkProfile.getNonEgoComponents().nrSingletons());
        } else if (label.contains("MAXCOMPONENT")) {
            result = new Value(networkProfile.getNonEgoComponents().maxClusterSize());
        } else if (label.contains("NRCOMPONENTS_NORM")) {
            result = networkProfile.getNonEgoComponents().size() == 0 ? null : new Value(networkProfile.getNonEgoComponents().meanShare());
        } else if (label.contains("MAXCOMPONENT_NORM")) {
            result = networkProfile.getNonEgoComponents().size() == 0 ? null : new Value(networkProfile.getNonEgoComponents().maxShare());
        } else if (label.contains("NRISOLATES_NORM")) {
            result = networkProfile.getNonEgoComponents().size() == 0 ? null : new Value(networkProfile.getNonEgoComponents().singletonShare());
        } else if (label.contains("BROKERAGE")) {
            result = new Value(networkProfile.brokerage());
        } else if (label.contains("EFFICIENT_SIZE")) {
            result = Value.valueOf(networkProfile.efficientSize());
        } else if (label.contains("EFFICIENCY")) {
            result = Value.valueOf(networkProfile.efficiency());
        } else if (label.contains("SIMILARITY")) {
            result = new Value(this.getParcoursSimilarities(SpaceTimeCriteria.RelationClassificationType.valueOf(parameter)));
        } else if (label.contains("ECCENTRICITY")) {
            result = new Value(networkProfile.getEccentricity());
        } else if (label.contains("CONCENTRATION")) {
            result = new Value(MathUtils.herfindahl(networkProfile.getNonEgoComponents().clusterSizes()));
        }
        return result;
    }

    private Integer getAge(Relation event) {
        Integer result = null;
        if (event != null) {
            int year = Sequence.getYear(event);
            result = IndividualValuator.ageAtYear(this.ego, year);
        }
        return result;
    }

    private double getMaxCoverage() {
        double result = this.coverage.size() > 0 ? MathUtils.percent((Integer)((TreeMap)this.coverage).lastKey(), this.length) : 0.0;
        return result;
    }

    private double getMeanCoverage() {
        double result = 0.0;
        if (this.coverage.size() > 0) {
            double sum = 0.0;
            for (int i : this.coverage.keySet()) {
                result += (double)i;
                sum += 1.0;
            }
            result = MathUtils.percent(result, sum * (double)this.length);
        }
        return result;
    }

    private void setSpecificDensities(String networkTitle) {
        Graph<Individual> network = this.networkProfiles.get(networkTitle).getGraph();
        this.specificDensities = new HashMap<String, Double>();
        this.specificDensities.put("PARENT-CHILD", 0.0);
        this.specificDensities.put("SPOUSE", 0.0);
        this.specificDensities.put("SIBLING", 0.0);
        this.specificDensities.put("RELATIVE", 0.0);
        this.specificDensities.put("AFFINE", 0.0);
        this.specificDensities.put("EMPLOYMENT", 0.0);
        this.specificDensities.put("RENT", 0.0);
        for (Link link : network.getLinks()) {
            String tag = link.getTag();
            tag = tag.substring(tag.indexOf("'") + 1, tag.lastIndexOf("'"));
            String key = null;
            if (tag.equals("FATHER") || tag.equals("MOTHER") || tag.equals("CHILD")) {
                key = "PARENT-CHILD";
            } else if (tag.equals("SPOUSE") || tag.equals("SIBLING") || tag.equals("AFFINE")) {
                key = tag;
            } else if (tag.contains("RELATIVE")) {
                key = "RELATIVE";
            } else if (tag.contains("EMPLOY")) {
                key = "EMPLOYMENT";
            } else if (tag.equals("LANDLORD") || tag.equals("LODGER")) {
                key = "RENT";
            }
            if (key == null) continue;
            this.specificDensities.put(key, this.specificDensities.get(key) + 1.0);
        }
        for (String string : this.specificDensities.keySet()) {
            this.specificDensities.put(string, MathUtils.percent(this.specificDensities.get(string), (double)network.lineCount()));
        }
    }

    private List<Individual> getMaxCoverageAlters() {
        List<Individual> result = this.coverage.size() > 1 ? this.coverage.get(((TreeMap)this.coverage).lastKey()) : new ArrayList<Individual>();
        return result;
    }

    private void setComponentTypes(String networkTitle) {
        Partition<Node<Individual>> nonEgoComponents = this.networkProfiles.get(networkTitle).getNonEgoComponents();
        if (nonEgoComponents.size() > 0) {
            for (Cluster<Node<Individual>> component : nonEgoComponents.getClusters().toList()) {
                String type = this.getComponentType(component);
                Value value = new Value(type);
                if (nonEgoComponents.getValues().contains(value)) {
                    int i = 1;
                    while (nonEgoComponents.getValues().contains(value)) {
                        value = new Value(String.valueOf(type) + " " + ++i);
                    }
                }
                nonEgoComponents.changeClusterValue(component, value);
            }
        }
    }

    private double getMeanNr(String roleName) {
        double result = MathUtils.percent(this.altersByRoles.get(roleName).size(), 100 * this.length);
        return result;
    }

    private Graph<Individual> getEgoNetwork() {
        Graph<Individual> result = new Graph<Individual>("Ego network " + this.ego + " " + this.relationModelName + " " + this.egoRoleName + "-" + this.getSelectedRolesAsString());
        HashMap<String, Integer> tagMap = new HashMap<String, Integer>();
        result.addNode(this.ego);
        for (Individual alter : this.altersByRoles.get("SELECTED")) {
            result.addNode(alter);
        }
        List referents = result.getReferents();
        int i = 0;
        while (i < referents.size()) {
            Individual ego = (Individual)referents.get(i);
            int j = 0;
            while (j < i) {
                Individual alter = (Individual)referents.get(j);
                for (String tag : NetUtils.getAlterRoles(ego, alter, this.maxDepths, this.relationModelNames, this.chainClassification)) {
                    Link<Individual> link = result.addArc(ego, alter, 1.0);
                    Integer tagNumber = (Integer)tagMap.get(tag);
                    if (tagNumber == null) {
                        tagNumber = tagMap.size() + 1;
                        tagMap.put(tag, tagNumber);
                    }
                    link.setTag(":" + tagNumber + " '" + tag + "'");
                }
                ++j;
            }
            ++i;
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    private Graph<Relation> getParcoursGraph() {
        Graph<Relation> result = new Graph<Relation>();
        result.setLabel("Parcours " + this.ego);
        Relation previousEvent = null;
        for (Relation event : this.events) {
            if (previousEvent != null) {
                Link<Relation> link = result.addArc(previousEvent, event, 1.0);
                link.setTag(String.valueOf(this.ego.getId()));
            }
            previousEvent = event;
        }
        if (this.events.size() == 1) {
            result.addNode(previousEvent);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Graph<Cluster<Relation>> getParcoursNetwork(SpaceTimeCriteria.RelationClassificationType relationClassificationType) {
        Graph<Cluster<Relation>> result = new Graph<Cluster<Relation>>();
        result.setLabel("Parcours Network_" + (Object)((Object)relationClassificationType) + " " + this.ego);
        Partition<Relation> partition = new Partition<Relation>();
        Map<Relation, String> valueMap = this.eventEvaluations.get((Object)relationClassificationType);
        HashMap<String, Individuals> hostsMap = new HashMap<String, Individuals>();
        hostsMap.put("SPOUSE", new Individuals());
        for (Relation event : this.events) {
            void var8_9;
            Individuals viaHosts;
            String string = valueMap.get(event);
            Individuals hosts = (Individuals)hostsMap.get(string);
            if (hosts != null) {
                for (Individual host : event.getIndividuals("HOST")) {
                    if (string.equals("SPOUSE") && !host.spouses().contains(this.ego)) {
                        System.err.println("Non-spouse as spouse for " + this.ego + ": " + host + " " + event);
                        continue;
                    }
                    hosts.put(host);
                }
                if (hosts.size() > 1) {
                    String string2 = String.valueOf(string) + "_" + hosts.size();
                }
            } else if (string.contains("via ") && (viaHosts = (Individuals)hostsMap.get(string.replace("via ", ""))) != null && viaHosts.size() > 1) {
                String string3 = String.valueOf(string) + viaHosts.size();
            }
            partition.put(event, new Value((String)var8_9));
        }
        Relation previousEvent = null;
        int t = 1;
        for (Relation relation : this.events) {
            if (previousEvent != null) {
                if (this.impersonalRelation(previousEvent) != null && this.impersonalRelation(previousEvent).equals("TRANSITION")) {
                    if (partition.getCluster(previousEvent).getValue().toString().equals("TRANSITION")) {
                        partition.getCluster(relation).put(previousEvent);
                        result.addNode(partition.getCluster(relation));
                        result.transferLinks(result.getNode(partition.getCluster(previousEvent)), result.getNode(partition.getCluster(relation)));
                    } else {
                        System.err.println("Ambiguous transition " + this.ego + " " + t + " " + previousEvent + " " + previousEvent.getIndividuals("HOST") + " *" + partition.getCluster(previousEvent).getValue() + "*");
                    }
                } else {
                    Link<Cluster<Relation>> link = result.getArc(partition.getCluster(previousEvent), partition.getCluster(relation));
                    if (link == null) {
                        link = result.addArc(partition.getCluster(previousEvent), partition.getCluster(relation), (double)t);
                        link.setTag(String.valueOf(this.ego.getId()) + " " + t);
                    } else {
                        String tag = link.getTag();
                        double weight = link.getWeight();
                        link.setTag(String.valueOf(tag) + " " + t);
                        link.setWeight(weight * 0.1 + (double)t);
                    }
                }
            }
            previousEvent = relation;
            ++t;
        }
        if (this.events.size() == 1) {
            result.addNode(partition.getCluster(previousEvent));
        }
        for (Node node : result.getNodes().toList()) {
            if (!((Cluster)node.getReferent()).getValue().toString().equals("TRANSITION")) continue;
            result.removeNode(node);
            break;
        }
        result.renumberNodes();
        if (result.getNodesByLabel("PARENTS").size() == 0) {
            System.err.println("No parents: " + result);
        }
        return result;
    }

    private Graph<Relation> getMultipleParcoursGraph() {
        ArrayList<Graph<Graph<Relation>>> graphs = new ArrayList<Graph<Graph<Relation>>>();
        SpaceTimeCriteria criteria = new SpaceTimeCriteria();
        criteria.setMaxAge(1000);
        criteria.setRelationModelNames(this.relationModelNames);
        criteria.setRelationModelName(this.relationModelName);
        for (Individual alter : this.altersByRoles.get("SELECTED")) {
            Sequence fullBiography = SequenceMaker.createPersonalSequence(alter, criteria);
            Sequence sortedBiography = (Sequence)SequenceWorker.split(fullBiography).getById(1);
            SequenceCensus census = new SequenceCensus(sortedBiography, criteria);
            if (sortedBiography.getNrEvents() <= 0) continue;
            Graph<Relation> alterGraph = census.getParcoursGraph();
            graphs.add(alterGraph);
        }
        Graph<Relation> result = GraphUtils.fuse(graphs);
        result.setLabel("Multiple parcours " + this.ego);
        return result;
    }

    public static Graph<String> getFlatParcoursNetworkNoLoops(Graph<Cluster<Relation>> parcoursNetwork) {
        Graph<String> result = new Graph<String>(parcoursNetwork.getLabel());
        for (Link link : parcoursNetwork.getLinks()) {
            if (link.isLoop()) continue;
            result.addArc(((Cluster)link.getSourceNode().getReferent()).getLabel(), ((Cluster)link.getTargetNode().getReferent()).getLabel());
        }
        return result;
    }

    private Relations getEvents(Individual indi) {
        Relations result = new Relations();
        for (Relation event : indi.relations().getByModelName(this.relationModelName)) {
            if (SequenceCensus.isBirth(event)) continue;
            result.add(event);
        }
        return result;
    }

    private Graph<Individual> getParcoursSimilarityNetwork(SpaceTimeCriteria.RelationClassificationType relationClassificationType) {
        Graph<Individual> result = new Graph<Individual>("Parcours Similarity Network_" + (Object)((Object)relationClassificationType) + " " + this.ego + " " + this.relationModelName + " " + this.egoRoleName + "-" + this.getSelectedRolesAsString());
        result.addNode(this.ego);
        for (Individual alter : this.altersByRoles.get("SELECTED")) {
            if (!alter.hasAttributeValue(this.alterAttributeLabel, this.alterAttributeValue)) continue;
            result.addNode(alter);
        }
        ArrayList<Graph<Graph<String>>> flatParcoursNetworksNoLoops = new ArrayList<Graph<Graph<String>>>();
        HashMap<Graph<String>, Individual> index = new HashMap<Graph<String>, Individual>();
        HashSet<Value> clusterValues = new HashSet<Value>();
        for (Node node : result.getNodes().toListSortedById()) {
            Individual referent = (Individual)node.getReferent();
            SpaceTimeCriteria criteria = new SpaceTimeCriteria();
            criteria.getRelationClassificationTypes().add(relationClassificationType);
            criteria.setEgoRoleName(this.egoRoleName);
            criteria.setRoleNames(this.roleNames);
            criteria.setRelationModelName(this.relationModelName);
            criteria.setRelationModelNames(this.relationModelNames);
            criteria.setPattern(this.pattern);
            Sequence sequence = SequenceMaker.createPersonalSequence(referent, criteria);
            SequenceCensus census = new SequenceCensus(sequence, criteria);
            Graph<Cluster<Relation>> parcoursNetwork = census.getParcoursNetwork(relationClassificationType);
            node.setAttribute("NRTRANSITIONS", String.valueOf(parcoursNetwork.arcCount()));
            Graph<String> flatParcoursNetworkNoLoops = SequenceCensus.getFlatParcoursNetworkNoLoops(parcoursNetwork);
            flatParcoursNetworksNoLoops.add(flatParcoursNetworkNoLoops);
            index.put(flatParcoursNetworkNoLoops, referent);
            for (Node<Cluster<Relation>> node2 : parcoursNetwork.getNodes()) {
                clusterValues.add(node2.getReferent().getValue());
            }
        }
        Collections.sort(flatParcoursNetworksNoLoops, new GraphComparatorByArcCount());
        Graph distanceGraph = GraphUtils.createDistanceGraph(flatParcoursNetworksNoLoops);
        for (Link link : distanceGraph.getEdges()) {
            Link<Individual> edge = result.addEdge((Individual)index.get(link.getSourceNode().getReferent()), (Individual)index.get(link.getTargetNode().getReferent()));
            ArrayList<Graph<Graph>> pair = new ArrayList<Graph<Graph>>();
            pair.add((Graph)link.getSourceNode().getReferent());
            pair.add((Graph)link.getTargetNode().getReferent());
            double maxArcs = new Double(GraphUtils.fuse(pair).arcCount());
            double weight = (maxArcs - link.getWeight()) / maxArcs;
            edge.setWeight(100.0 * weight);
            edge.setTag(String.valueOf(weight));
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    private Graph<Individual> getParcoursIntersectionNetwork() {
        Graph<Individual> result = new Graph<Individual>("Parcours Intersection Network " + this.ego + " " + this.relationModelName + " " + this.egoRoleName + "-" + this.getSelectedRolesAsString());
        HashMap eventMap = new HashMap();
        result.addNode(this.ego);
        result.getNode(this.ego).setAttribute("NREVENTS", String.valueOf(this.getEvents(this.ego).size()));
        HashSet<Relation> egoEvents = new HashSet<Relation>();
        eventMap.put(this.ego, egoEvents);
        for (Relation event : this.getEvents(this.ego)) {
            egoEvents.add(event);
        }
        for (Individual alter : this.altersByRoles.get("SELECTED")) {
            if (!alter.hasAttributeValue(this.alterAttributeLabel, this.alterAttributeValue)) continue;
            result.addNode(alter);
            result.getNode(alter).setAttribute("NREVENTS", String.valueOf(this.getEvents(alter).size()));
            HashSet<Relation> alterEvents = new HashSet<Relation>();
            eventMap.put(alter, alterEvents);
            for (Relation event : this.getEvents(alter)) {
                alterEvents.add(event);
            }
        }
        List referents = result.getReferents();
        int i = 0;
        while (i < referents.size()) {
            Individual first = (Individual)referents.get(i);
            int j = 0;
            while (j < i) {
                Link<Individual> link;
                Individual second = (Individual)referents.get(j);
                double[] shares = MathUtils.intersectionRates((Collection)eventMap.get(first), (Collection)eventMap.get(second));
                if (shares[0] > 0.0) {
                    link = result.addArc(first, second, shares[0]);
                }
                if (shares[1] > 0.0) {
                    link = result.addArc(second, first, shares[1]);
                }
                ++j;
            }
            ++i;
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    public Partition<Link<Individual>> getParcoursLinkPartition(SpaceTimeCriteria.RelationClassificationType relationClassificationType) {
        GraphProfile<Individual> parcoursNetworkProfile = this.networkProfiles.get("Parcours Intersection Network_" + (Object)((Object)relationClassificationType));
        Partition result = parcoursNetworkProfile.getLinkPartition();
        if (result == null) {
            result = GraphUtils.getLinkPartitionByKinship(parcoursNetworkProfile.getGraph());
            parcoursNetworkProfile.setLinkPartition(result);
        }
        return result;
    }

    public Map<Value, Double[]> getParcoursSimilarities(SpaceTimeCriteria.RelationClassificationType relationClassificationType) {
        GraphProfile<Individual> parcoursNetworkProfile = this.networkProfiles.get("Parcours Intersection Network_" + (Object)((Object)relationClassificationType));
        if (parcoursNetworkProfile.getLinkPartition() == null) {
            parcoursNetworkProfile.setLinkPartition(GraphUtils.getLinkPartitionByKinship(parcoursNetworkProfile.getGraph()));
        }
        Map<Value, Double[]> result = parcoursNetworkProfile.aggregateWeights();
        return result;
    }

    private String getSelectedRolesAsString() {
        String result = "";
        for (String roleName : this.roleNames) {
            if (result.length() > 0) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + roleName;
        }
        return result;
    }

    private Graph<Individual> getNonMediatedEgoNetwork() {
        Integer tagNumber;
        Link<Individual> link;
        List<String> alterRoles;
        Individual alter;
        int j;
        Individual ego;
        Graph<Individual> result = new Graph<Individual>("Nonmediated Ego Network " + this.ego + " " + this.relationModelName + " " + this.egoRoleName + "-" + this.getSelectedRolesAsString());
        HashMap<String, Integer> tagMap = new HashMap<String, Integer>();
        result.addNode(this.ego);
        for (Individual alter2 : this.altersByRoles.get("SELECTED")) {
            result.addNode(alter2);
        }
        HashSet<Individual> others = new HashSet<Individual>();
        for (Individual medius : this.altersByRoles.get("ALL")) {
            if (this.altersByRoles.get("SELECTED").contains(medius)) continue;
            others.add(medius);
        }
        List<Individual> referents = result.getReferents();
        Graph<Individual> barredEdges = new Graph<Individual>();
        int i = 0;
        while (i < referents.size()) {
            ego = (Individual)referents.get(i);
            j = 0;
            while (j < i) {
                alter = (Individual)referents.get(j);
                alterRoles = NetUtils.getAlterRoles(ego, alter, this.maxDepths, this.relationModelNames, this.chainClassification, referents, barredEdges);
                for (String tag : alterRoles) {
                    link = result.addEdge(ego, alter, 1.0);
                    tagNumber = (Integer)tagMap.get(tag);
                    if (tagNumber == null) {
                        tagNumber = tagMap.size() + 1;
                        tagMap.put(tag, tagNumber);
                    }
                    link.setTag(":" + tagNumber + " '" + tag + "'");
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < referents.size()) {
            ego = (Individual)referents.get(i);
            j = 0;
            while (j < i) {
                alter = (Individual)referents.get(j);
                if (result.getEdge(ego, alter) == null && barredEdges.getEdge(ego, alter) == null) {
                    alterRoles = new ArrayList<String>();
                    for (Individual medius : others) {
                        List<String> firstRoles;
                        if (medius == ego || (firstRoles = NetUtils.getAlterRoles(ego, medius, this.maxDepths, this.relationModelNames, this.chainClassification, referents, barredEdges)).size() <= 0) continue;
                        List<String> secondRoles = NetUtils.getAlterRoles(medius, alter, this.maxDepths, this.relationModelNames, this.chainClassification, referents, barredEdges);
                        for (String firstRole : firstRoles) {
                            for (String secondRole : secondRoles) {
                                if (firstRole.equals("CHILD") && secondRole.contains("RELATIVE")) continue;
                                String role = String.valueOf(firstRole) + "S_" + secondRole;
                                String reducedRole = NetUtils.reduced(role);
                                while (!reducedRole.equals(role)) {
                                    role = reducedRole;
                                    reducedRole = NetUtils.reduced(role);
                                }
                                alterRoles.add(reducedRole);
                            }
                        }
                    }
                    for (String tag : alterRoles) {
                        link = result.addEdge(ego, alter, 1.0);
                        tagNumber = (Integer)tagMap.get(tag);
                        if (tagNumber == null) {
                            tagNumber = tagMap.size() + 1;
                            tagMap.put(tag, tagNumber);
                        }
                        link.setTag(":" + tagNumber + " '" + tag + "'");
                    }
                }
                ++j;
            }
            ++i;
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    Partition<Node<Individual>> getComponents(String networkTitle) {
        return this.networkProfiles.get(networkTitle).getNonEgoComponents();
    }

    private SequenceProfile getProfile(SpaceTimeCriteria.RelationClassificationType relationClassificationType) {
        SequenceProfile result = this.sequenceProfiles.get((Object)relationClassificationType);
        if (result == null) {
            result = new SequenceProfile(this.events, this.eventEvaluations, relationClassificationType);
            this.sequenceProfiles.put(relationClassificationType, result);
        }
        return result;
    }

    public static String getEgoRolePartners(Relation event, SpaceTimeCriteria criteria, Individual ego) {
        String result = "";
        if (event.getModel().getName().equals(criteria.getRelationModelName())) {
            Individuals partners = new Individuals();
            for (Individual partner : event.getIndividuals(criteria.getEgoRoleName())) {
                if (partner == ego) continue;
                partners.put(partner);
            }
            result = partners.toStringAsNameList();
        }
        return result;
    }

    public Graph<Cluster<Relation>> getEventTypeNetwork(String title) {
        Graph<Cluster<Relation>> result = this.eventTypeNetworkProfiles.get(title) == null ? null : this.eventTypeNetworkProfiles.get(title).getGraph();
        return result;
    }
}

