/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

public class Role
implements Comparable<Role> {
    private String name;
    private int defaultCardinality;

    public Role(Role role) {
        if (role == null) {
            this.name = "";
            this.defaultCardinality = 0;
        } else {
            this.name = role.getName();
            this.defaultCardinality = role.getDefaultCardinality();
        }
    }

    public Role(String name) {
        this.name = name;
        this.defaultCardinality = 0;
    }

    public Role(String name, int defaultCardinality) {
        this.name = name;
        this.defaultCardinality = defaultCardinality;
    }

    public boolean equals(Object role) {
        boolean result = role != null && this.name.equals(((Role)role).name);
        return result;
    }

    public static boolean equalOrBothNull(Role alpha, Role beta) {
        return alpha == null && beta == null || alpha != null && alpha.equals(beta);
    }

    public int getDefaultCardinality() {
        return this.defaultCardinality;
    }

    public String getName() {
        return this.name;
    }

    public void setDefaultCardinality(int defaultCardinality) {
        this.defaultCardinality = defaultCardinality;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Role other) {
        int result = other == null || this.name == null || other.name == null ? 0 : this.name.compareTo(other.name);
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

