/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.kinsources;

import java.util.Comparator;
import org.tip.puck.io.kinsources.CatalogItem;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.PuckUtils;

public class CatalogItemComparator
implements Comparator<CatalogItem> {
    private Criteria criteria;

    public CatalogItemComparator(Criteria criteria) {
        this.criteria = criteria;
    }

    @Override
    public int compare(CatalogItem alpha, CatalogItem bravo) {
        int result = CatalogItemComparator.compare(alpha, bravo, this.criteria);
        return result;
    }

    public static int compare(CatalogItem alpha, CatalogItem bravo, Criteria criteria) {
        int result;
        switch (criteria) {
            case AUTHOR: {
                String alphaValue = alpha == null ? null : alpha.getAuthor();
                String bravoValue = bravo == null ? null : bravo.getAuthor();
                result = PuckUtils.compare(alphaValue, bravoValue);
                break;
            }
            case CONTRIBUTOR: {
                String alphaValue = alpha == null ? null : alpha.getContributor();
                String bravoValue = bravo == null ? null : bravo.getContributor();
                result = PuckUtils.compare(alphaValue, bravoValue);
                break;
            }
            case ID: {
                Long alphaValue = alpha == null ? null : Long.valueOf(alpha.getId());
                Long bravoValue = bravo == null ? null : Long.valueOf(bravo.getId());
                result = MathUtils.compare(alphaValue, bravoValue);
                break;
            }
            case NAME: {
                String alphaValue = alpha == null ? null : alpha.getName();
                String bravoValue = bravo == null ? null : bravo.getName();
                result = PuckUtils.compare(alphaValue, bravoValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown criteria [" + (Object)((Object)criteria) + "]");
            }
        }
        return result;
    }

    public static enum Criteria {
        AUTHOR,
        CONTRIBUTOR,
        DATASET_NAME,
        ID,
        INDIVIDUAL_COUNT,
        NAME;

    }
}

