/*
 * Decompiled with CFR 0.152.
 */
package oldcore.visualization;

import java.util.ArrayList;
import java.util.List;
import oldcore.visualization.PlotOptions;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeData;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.spi.LayoutData;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.force.Displacement;
import org.gephi.layout.plugin.force.ForceVector;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;

public class SimPaLayout
extends AbstractLayout
implements Layout {
    private float minY = Float.POSITIVE_INFINITY;
    private float maxY = Float.NEGATIVE_INFINITY;
    private float optimalDistance;
    private float convergenceThreshold;
    private HierarchicalGraph graph;
    private PlotOptions.HeritageType heritage = null;
    List<Edge> parentalLine;
    List<Edge> parentalNoLine;
    List<Edge> conjugal;
    List<Edge> remaining;

    public SimPaLayout(LayoutBuilder layoutBuilder, Displacement displacement) {
        super(layoutBuilder);
    }

    public void resetPropertiesValues() {
        this.setOptimalDistance(Float.valueOf(100.0f));
        this.setConvergenceThreshold(Float.valueOf(1.0E-4f));
    }

    public void initAlgo() {
        if (this.graphModel == null) {
            return;
        }
        this.graph = this.graphModel.getHierarchicalGraphVisible();
        for (Node n : this.graph.getNodes()) {
            NodeData data = n.getNodeData();
            data.setLayoutData((LayoutData)new ForceVector());
        }
        this.setConverged(false);
        this.parentalLine = new ArrayList<Edge>();
        this.parentalNoLine = new ArrayList<Edge>();
        this.conjugal = new ArrayList<Edge>();
        this.remaining = new ArrayList<Edge>();
        for (Edge e : this.graph.getEdges()) {
            TieType t = TieType.valueOf((String)e.getEdgeData().getAttributes().getValue("tie type"));
            if (t == TieType.parental) {
                Gender g1 = Gender.valueOf((String)e.getSource().getNodeData().getAttributes().getValue("gender"));
                Gender g2 = Gender.valueOf((String)e.getTarget().getNodeData().getAttributes().getValue("gender"));
                if (this.getHeritageType() == PlotOptions.HeritageType.agnatic) {
                    if (g1 == Gender.male) {
                        if (g2 == Gender.male) {
                            this.parentalLine.add(e);
                            this.paintLinearTie(e);
                            continue;
                        }
                        this.parentalNoLine.add(e);
                        this.paintNonLinearTie(e);
                        continue;
                    }
                    this.remaining.add(e);
                    this.paintInvisible(e);
                    continue;
                }
                if (this.getHeritageType() == PlotOptions.HeritageType.uterine) {
                    if (g1 == Gender.female) {
                        if (g2 == Gender.female) {
                            this.parentalLine.add(e);
                            this.paintLinearTie(e);
                            continue;
                        }
                        this.parentalNoLine.add(e);
                        this.paintNonLinearTie(e);
                        continue;
                    }
                    this.remaining.add(e);
                    this.paintInvisible(e);
                    continue;
                }
                if (this.getHeritageType() != PlotOptions.HeritageType.cognatic) continue;
                this.parentalLine.add(e);
                if (g2 == Gender.male) {
                    this.paintLinearTie(e);
                    continue;
                }
                this.paintNonLinearTie(e);
                continue;
            }
            this.conjugal.add(e);
            this.paintConjugalTie(e);
        }
    }

    public void goAlgo() {
        Node[] nodes;
        this.graph = this.graphModel.getHierarchicalGraphVisible();
        this.graph.readLock();
        Node[] nodeArray = nodes = this.graph.getNodes().toArray();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node n3 = nodeArray[n2];
            if (n3.getNodeData().getLayoutData() == null || !(n3.getNodeData().getLayoutData() instanceof ForceVector)) {
                n3.getNodeData().setLayoutData((LayoutData)new ForceVector());
            }
            ++n2;
        }
        this.verticalOrdering(nodes);
        this.horizontalOrdering(nodes);
        this.graph.readUnlock();
    }

    public void endAlgo() {
        for (Node n : this.graph.getNodes()) {
            n.getNodeData().setLayoutData(null);
        }
        this.parentalLine.clear();
        this.parentalNoLine.clear();
        this.conjugal.clear();
        this.parentalLine = null;
        this.parentalNoLine = null;
        this.conjugal = null;
    }

    private ForceVector getParentalVerticalForce(NodeData n1, NodeData n2) {
        return new ForceVector(0.0f, (n2.y() + this.optimalDistance - n1.y()) / 2.0f);
    }

    private ForceVector getConjugalVerticalForce(NodeData n1, NodeData n2) {
        return new ForceVector(0.0f, (n2.y() - n1.y()) / 2.0f);
    }

    private ForceVector getParentalHorizontalForce(NodeData n1, NodeData n2) {
        return new ForceVector((n2.x() - n1.x()) / 2.5f, 0.0f);
    }

    private ForceVector getConjugalHorizontalForce(NodeData n1, NodeData n2) {
        return new ForceVector((n2.x() + this.optimalDistance / 10.0f - n1.x()) / 2.5f, 0.0f);
    }

    private boolean moveNodes(Node[] nodes) {
        boolean result = false;
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node n3 = nodeArray[n2];
            NodeData data = n3.getNodeData();
            if (!data.isFixed()) {
                ForceVector force = (ForceVector)data.getLayoutData();
                float x = data.x() + force.x();
                float y = data.y() + force.y();
                if (!Float.isInfinite(x) && !Float.isNaN(x)) {
                    data.setX(x);
                }
                if (!Float.isInfinite(y) && !Float.isNaN(y)) {
                    data.setY(y);
                }
                if (!result && (Math.abs(force.x()) > 1.0f || Math.abs(force.y()) > 1.0f)) {
                    result = true;
                }
                force.setX(0.0f);
                force.setY(0.0f);
            }
            ++n2;
        }
        return result;
    }

    private boolean moveNodes(Edge e) {
        Node[] nodes;
        boolean result = false;
        Node[] nodeArray = nodes = new Node[]{e.getSource(), e.getTarget()};
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node n3 = nodeArray[n2];
            NodeData data = n3.getNodeData();
            if (!data.isFixed()) {
                ForceVector force = (ForceVector)data.getLayoutData();
                float x = data.x() + force.x();
                float y = data.y() + force.y();
                if (!Float.isInfinite(x) && !Float.isNaN(x)) {
                    data.setX(x);
                }
                if (!Float.isInfinite(y) && !Float.isNaN(y)) {
                    data.setY(y);
                }
                if (!result && (Math.abs(force.x()) > 1.0f || Math.abs(force.y()) > 1.0f)) {
                    result = true;
                }
                force.setX(0.0f);
                force.setY(0.0f);
            }
            ++n2;
        }
        return result;
    }

    private void verticalOrdering(Node[] nodes) {
        boolean keepMoving = true;
        int iter = 0;
        while (iter < PlotOptions.getInstance().getNbrIterVertOrdering() && keepMoving) {
            keepMoving = false;
            for (Edge e : this.graph.getEdges()) {
                NodeData n1 = e.getSource().getNodeData();
                NodeData n2 = e.getTarget().getNodeData();
                ForceVector f1 = (ForceVector)n1.getLayoutData();
                ForceVector f2 = (ForceVector)n2.getLayoutData();
                TieType t = TieType.valueOf((String)e.getEdgeData().getAttributes().getValue("tie type"));
                ForceVector f = null;
                f = t == TieType.parental ? this.getParentalVerticalForce(n1, n2) : this.getConjugalVerticalForce(n1, n2);
                f1.add(f);
                f2.subtract(f);
                boolean aux = this.moveNodes(e);
                boolean bl = keepMoving = keepMoving || aux;
            }
            ++iter;
        }
        System.out.println("Vertical ordering stopped after " + iter + " iterations.");
    }

    private void horizontalNormalization(Node[] nodes) {
        NodeData data;
        int nbr_gen = 20;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        ArrayList<Node> l = new ArrayList<Node>();
        for (Node node : this.graph.getNodes()) {
            if (this.graph.getDegree(node) > 0) {
                data = node.getNodeData();
                this.minY = Math.min(this.minY, data.y());
                this.maxY = Math.max(this.maxY, data.y());
                continue;
            }
            l.add(node);
        }
        for (Node n : l) {
            data = n.getNodeData();
            data.setY(this.minY);
        }
        l.clear();
        l = null;
        float sizeY = this.maxY - this.minY;
        System.out.println("minY " + this.minY + " maxY " + this.maxY + " sizeY " + sizeY);
        float stepY = sizeY / (float)nbr_gen;
        float[] borders = new float[nbr_gen + 1];
        borders[0] = Float.NEGATIVE_INFINITY;
        int i = 1;
        while (i < nbr_gen) {
            borders[i] = this.minY + (float)i * stepY;
            ++i;
        }
        borders[nbr_gen] = Float.POSITIVE_INFINITY;
        int[] total = new int[nbr_gen];
        int i2 = 0;
        while (i2 < nbr_gen) {
            total[i2] = 0;
            ++i2;
        }
        for (Node node : this.graph.getNodes()) {
            NodeData data2 = node.getNodeData();
            boolean aux = false;
            int i3 = 1;
            while (i3 <= nbr_gen) {
                if (data2.y() >= borders[i3 - 1] && data2.y() < borders[i3]) {
                    int n = i3 - 1;
                    total[n] = total[n] + 1;
                    data2.getAttributes().setValue("zoneY", (Object)new Integer(i3));
                    aux = true;
                    break;
                }
                ++i3;
            }
            if (aux) continue;
            System.out.println("ten nod nie ma przydzielonej zony : " + data2.y());
        }
        float[] stepX = new float[nbr_gen];
        int i4 = 0;
        while (i4 < nbr_gen) {
            stepX[i4] = total[i4] > 0 ? sizeY / (float)total[i4] : 0.0f;
            ++i4;
        }
        int[] actual = new int[nbr_gen];
        int i5 = 0;
        while (i5 < nbr_gen) {
            actual[i5] = 0;
            ++i5;
        }
        for (Node node : this.graph.getNodes()) {
            NodeData data3 = node.getNodeData();
            int zoneY = (Integer)data3.getAttributes().getValue("zoneY");
            float X = this.minY + (float)actual[zoneY - 1] * stepX[zoneY - 1];
            data3.setX(X);
            int n = zoneY - 1;
            actual[n] = actual[n] + 1;
        }
    }

    private void horizontalOrdering(Node[] nodes) {
        int iterOut = 0;
        while (iterOut < 5) {
            this.horizontalNormalization(nodes);
            int iterInt = 0;
            while (iterInt < 10) {
                ForceVector f;
                ForceVector f2;
                ForceVector f1;
                NodeData n2;
                NodeData n1;
                int i = 0;
                while (i < 1) {
                    ForceVector f3;
                    ForceVector f22;
                    ForceVector f12;
                    NodeData n22;
                    NodeData n12;
                    for (Edge e : this.conjugal) {
                        n12 = e.getSource().getNodeData();
                        n22 = e.getTarget().getNodeData();
                        f12 = (ForceVector)n12.getLayoutData();
                        f22 = (ForceVector)n22.getLayoutData();
                        f3 = this.getConjugalHorizontalForce(n12, n22);
                        f12.add(f3);
                        f22.subtract(f3);
                        this.moveNodes(e);
                    }
                    for (Edge e : this.parentalLine) {
                        n12 = e.getSource().getNodeData();
                        n22 = e.getTarget().getNodeData();
                        f12 = (ForceVector)n12.getLayoutData();
                        f22 = (ForceVector)n22.getLayoutData();
                        f3 = this.getParentalHorizontalForce(n12, n22);
                        f12.add(f3);
                        f22.subtract(f3);
                        this.moveNodes(e);
                    }
                    for (Edge e : this.conjugal) {
                        n12 = e.getSource().getNodeData();
                        n22 = e.getTarget().getNodeData();
                        f12 = (ForceVector)n12.getLayoutData();
                        f22 = (ForceVector)n22.getLayoutData();
                        f3 = this.getConjugalHorizontalForce(n12, n22);
                        f12.add(f3);
                        f22.subtract(f3);
                        this.moveNodes(e);
                    }
                    ++i;
                }
                for (Edge e : this.parentalNoLine) {
                    n1 = e.getSource().getNodeData();
                    n2 = e.getTarget().getNodeData();
                    f1 = (ForceVector)n1.getLayoutData();
                    f2 = (ForceVector)n2.getLayoutData();
                    f = this.getParentalHorizontalForce(n1, n2);
                    f1.add(f);
                    f2.subtract(f);
                    this.moveNodes(e);
                }
                for (Edge e : this.conjugal) {
                    n1 = e.getSource().getNodeData();
                    n2 = e.getTarget().getNodeData();
                    f1 = (ForceVector)n1.getLayoutData();
                    f2 = (ForceVector)n2.getLayoutData();
                    f = this.getConjugalHorizontalForce(n1, n2);
                    f1.add(f);
                    f2.subtract(f);
                    this.moveNodes(e);
                }
                ++iterInt;
            }
            ++iterOut;
        }
    }

    private void paintConjugalTie(Edge e) {
        EdgeData ed = e.getEdgeData();
        ed.setColor(0.0f, 0.0f, 0.0f);
    }

    private void paintLinearTie(Edge e) {
        EdgeData ed = e.getEdgeData();
        float r = 1.0f;
        float g = 0.0f;
        float b = 0.0f;
        ed.setColor(r, g, b);
    }

    private void paintNonLinearTie(Edge e) {
        EdgeData ed = e.getEdgeData();
        ed.setColor(0.3529412f, 0.3529412f, 0.3529412f);
    }

    private void paintInvisible(Edge e) {
        EdgeData ed = e.getEdgeData();
        ed.setColor(0.8627451f, 0.8627451f, 0.8627451f);
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String GL_CATEGORY = "Genealogical layout properties";
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, (String)"Optimal Distance", (String)"Genealogical layout properties", (String)"The natural length of the springs. Bigger values mean nodes will be farther apart.", (String)"getOptimalDistance", (String)"setOptimalDistance"));
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, (String)"Relative Strength", (String)"Genealogical layout properties", (String)"The relative strength between electrical force (repulsion) and spring force (attraction).", (String)"getRelativeStrength", (String)"setRelativeStrength"));
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, (String)"Initial Step size", (String)"Genealogical layout properties", (String)"The initial step size used in the integration phase. Set this value to a meaningful size compared to the optimal distance (10% is a good starting point).", (String)"getInitialStep", (String)"setInitialStep"));
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, (String)"Step ratio", (String)"Genealogical layout properties", (String)"The ratio used to update the step size across iterations.", (String)"getStepRatio", (String)"setStepRatio"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)"Adaptive Cooling", (String)"Genealogical layout properties", (String)"Controls the use of adaptive cooling. It is used help the layout algoritm to avoid energy local minima.", (String)"isAdaptiveCooling", (String)"setAdaptiveCooling"));
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, (String)"Convergence Threshold", (String)"Genealogical layout properties", (String)"Relative energy convergence threshold. Smaller values mean more accuracy.", (String)"getConvergenceThreshold", (String)"setConvergenceThreshold"));
            properties.add(LayoutProperty.createProperty((Layout)this, PlotOptions.HeritageType.class, (String)"Inheritance type", (String)"Genealogical layout properties", (String)"The way that children inherit from parents can influence the society structure.", (String)"getHeritageType", (String)"setHeritageType"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Float getOptimalDistance() {
        return Float.valueOf(this.optimalDistance);
    }

    public void setOptimalDistance(Float optimalDistance) {
        this.optimalDistance = optimalDistance.floatValue();
    }

    public Float getConvergenceThreshold() {
        return Float.valueOf(this.convergenceThreshold);
    }

    public void setConvergenceThreshold(Float convergenceThreshold) {
        this.convergenceThreshold = convergenceThreshold.floatValue();
    }

    public PlotOptions.HeritageType getHeritageType() {
        return this.heritage;
    }

    public void setHeritageType(PlotOptions.HeritageType s) {
        this.heritage = s;
    }

    public void equalizeGenerations(int depth) {
        ++depth;
        if (this.minY == Float.POSITIVE_INFINITY && this.maxY == Float.NEGATIVE_INFINITY) {
            for (Node node : this.graph.getNodes()) {
                NodeData data = node.getNodeData();
                this.minY = Math.min(this.minY, data.y());
                this.maxY = Math.max(this.maxY, data.y());
            }
        }
        float size = this.maxY - this.minY;
        float step = size / (float)(depth - 1);
        float halfStep = step / 2.0f;
        float[] borders = new float[depth + 1];
        borders[0] = this.minY - halfStep;
        int i = 1;
        while (i <= depth) {
            borders[i] = borders[i - 1] + step;
            ++i;
        }
        block2: for (Node node : this.graph.getNodes()) {
            NodeData data = node.getNodeData();
            int d = 1;
            while (d <= depth) {
                if (data.y() >= borders[d - 1] && data.y() < borders[d]) {
                    data.setY(borders[d] - halfStep);
                    continue block2;
                }
                ++d;
            }
        }
    }

    public static enum Gender {
        male,
        female;

    }

    public static enum TieType {
        parental,
        conjugal;

    }
}

