package org.tip.puckgui.views.geo;

import javax.swing.JPanel;

import java.awt.BorderLayout;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JTabbedPane;
import javax.swing.JSplitPane;
import javax.swing.JList;

import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.JMapPane;
import org.geotools.swing.event.MapMouseAdapter;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.styling.JSimpleStyleDialog;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;

import com.vividsolutions.jts.geom.Coordinate;

import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JToggleButton;
import javax.swing.JLabel;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class MapPanel extends JPanel {
	/**
	 * 
	 */
	private static final long serialVersionUID = -2451122245332109771L;

	private JTextField txtFile;

	StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
	FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();

	public MapContent mapContent = new MapContent();
	private JTable table;
	JList<String> listLayers = null;
	DefaultListModel<String> listModel = new DefaultListModel<String>();

	/**
	 * Create the panel.
	 */
	public MapPanel() {
		setLayout(new BorderLayout(0, 0));

		JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);
		add(tabbedPane, BorderLayout.CENTER);

		JPanel pMap = new JPanel();
		tabbedPane.addTab("Cartography", null, pMap, null);
		pMap.setLayout(new BorderLayout(0, 0));

		JSplitPane splitPane = new JSplitPane();
		pMap.add(splitPane);

		JPanel panelRightMap = new JPanel();
		splitPane.setRightComponent(panelRightMap);
		panelRightMap.setLayout(new BorderLayout(0, 0));

		JMenuBar menuBarMap = new JMenuBar();
		panelRightMap.add(menuBarMap, BorderLayout.NORTH);

		JToggleButton tglbtnDrag = new JToggleButton("");
		tglbtnDrag.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionPan.png")));
		menuBarMap.add(tglbtnDrag);

		JToggleButton tglbtnSelect = new JToggleButton("");
		tglbtnSelect.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionSelect.png")));
		menuBarMap.add(tglbtnSelect);

		JToggleButton tglbtnZoomIn = new JToggleButton("");
		tglbtnZoomIn.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionZoomIn.png")));
		menuBarMap.add(tglbtnZoomIn);

		JToggleButton tglbtnZoomOut = new JToggleButton("");
		tglbtnZoomOut.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionZoomOut.png")));
		menuBarMap.add(tglbtnZoomOut);

		JButton tglbtnCenterView = new JButton("");
		tglbtnCenterView.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionZoomFullExtent.png")));
		menuBarMap.add(tglbtnCenterView);

		JLabel statusBar = new JLabel("Status bar");
		panelRightMap.add(statusBar, BorderLayout.SOUTH);

		final JMapPane mapPane = new JMapPane();
		mapPane.addMouseListener(new MapMouseAdapter() {

			@Override
			public void onMouseClicked(MapMouseEvent ev) {
				// print the screen and world position of the mouse
				System.out.println("mouse click at egrdzefzefhe");
				System.out.printf("  screen: x=%d y=%d \n", ev.getX(), ev.getY());

				DirectPosition2D pos = ev.getWorldPos();
				System.out.printf("  world: x=%.2f y=%.2f \n", pos.x, pos.y);
				Coordinate coord = new Coordinate(pos.x, pos.y);

				ReferencedEnvelope env = mapPane.getDisplayArea();
				env.init(coord);
				double width = env.getWidth();
				double delta = width * 0.1 * -1;
				env.expandBy(delta, delta);
				mapPane.setDisplayArea(env);
				mapPane.repaint();

			}

			@Override
			public void onMouseEntered(MapMouseEvent ev) {
				//				System.out.println("mouse entered map pane");
			}

			@Override
			public void onMouseExited(MapMouseEvent ev) {
				//				System.out.println("mouse left map pane");
			}

		});

		mapPane.addMouseListener(new MouseAdapter() {
			// somewhere in your code...
			double clickToZoom = 0.1;  // 1 wheel click is 10% zoom

			// wheel event handler
			public void handleMouseWheelEvent(MouseWheelEvent ev) {
				int clicks = ev.getWheelRotation();
				// -ve means wheel moved up, +ve means down
				int sign = (clicks < 0 ? -1 : 1);

				ReferencedEnvelope env = mapPane.getDisplayArea();
				double width = env.getWidth();
				double delta = width * clickToZoom * sign;

				env.expandBy(delta, delta);
				mapPane.setDisplayArea(env);
				mapPane.repaint();
			}

		});

		panelRightMap.add(mapPane, BorderLayout.CENTER);

		JPanel panelLeftList = new JPanel();
		splitPane.setLeftComponent(panelLeftList);
		panelLeftList.setLayout(new BorderLayout(0, 0));

		JMenuBar menuBarLayers = new JMenuBar();
		panelLeftList.add(menuBarLayers, BorderLayout.SOUTH);

		JButton btnAddShapeLayer = new JButton("");
		btnAddShapeLayer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				JFileChooser inFileDlg = new JFileChooser("user.dir"); //$NON-NLS-1$
				
				inFileDlg.setFileFilter(new FileNameExtensionFilter("Shapefile (*.shp)", "shp")); //$NON-NLS-1$ //$NON-NLS-2$
				int returnVal = inFileDlg.showOpenDialog(MapPanel.this);
				
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					String browseDir = inFileDlg.getCurrentDirectory().toString();
					
					String inFile = null;
					inFile = inFileDlg.getSelectedFile().toString();
					inFileDlg.setCurrentDirectory(new File(inFile));

					try {
						
						displaysShapefile(new File(inFile));
						
					} catch (IOException e2) {
						// TODO Auto-generated catch block
						e2.printStackTrace();
					}

				}
				
			}
		});
		btnAddShapeLayer.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
		menuBarLayers.add(btnAddShapeLayer);

		JButton btnRemoveShapeLayer = new JButton("");
		btnRemoveShapeLayer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				String selectedLayerTitle = listLayers.getSelectedValue();
				
				Layer selectedLayer = null;
				//Get selected layer
				for (Layer iterLayer : mapContent.layers()) {
					if( iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
						selectedLayer = iterLayer;
						break;
					}
				}
				
				mapContent.removeLayer(selectedLayer);
				listModel.removeElement(selectedLayerTitle);
				
				mapPane.repaint();
			}
		});
		btnRemoveShapeLayer.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
		menuBarLayers.add(btnRemoveShapeLayer);
		
		JButton btnLayerProperties = new JButton("");
		btnLayerProperties.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				String selectedLayerTitle = listLayers.getSelectedValue();
				
				Layer selectedLayer = null;
				//Get selected layer
				for (Layer iterLayer : mapContent.layers()) {
					if( iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
						selectedLayer = iterLayer;
						break;
					}
				}
				
				if( selectedLayer != null ) {
					//Open style dialog
					Style newStyle = JSimpleStyleDialog.showDialog(null, (SimpleFeatureType)selectedLayer.getFeatureSource().getSchema());
			        ((FeatureLayer) selectedLayer).setStyle(newStyle);
			        mapPane.repaint();
					
				}
			}
		});
		btnLayerProperties.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/unknown-16x16.png")));
		menuBarLayers.add(btnLayerProperties);
		
		listLayers = new JList<String>(listModel);
		panelLeftList.add(listLayers, BorderLayout.CENTER);

		JPanel pConfig = new JPanel();
		tabbedPane.addTab("Parameters", null, pConfig, null);
		pConfig.setLayout(null);

		JCheckBox chckbxGeonames = new JCheckBox("Geonames");
		chckbxGeonames.setSelected(true);
		chckbxGeonames.setBounds(8, 8, 129, 23);
		pConfig.add(chckbxGeonames);

		JCheckBox chckbxPersonnalDatabase = new JCheckBox("Personnal Database");
		chckbxPersonnalDatabase.setBounds(8, 35, 175, 23);
		pConfig.add(chckbxPersonnalDatabase);

		txtFile = new JTextField();
		txtFile.setEnabled(false);
		txtFile.setText("File");
		txtFile.setBounds(23, 66, 114, 19);
		pConfig.add(txtFile);
		txtFile.setColumns(10);

		JButton btnNewButton = new JButton("Browse");
		btnNewButton.setEnabled(false);
		btnNewButton.setBounds(149, 63, 87, 25);
		pConfig.add(btnNewButton);

		JButton btnGeocode = new JButton("Geocode");
		btnGeocode.setBounds(316, 236, 117, 25);
		pConfig.add(btnGeocode);

		//Map content
		mapPane.setRenderer( new StreamingRenderer() );
		mapPane.setMapContent( this.mapContent );

		JPanel pTableGeoView = new JPanel();
		tabbedPane.addTab("Attributes table", null, pTableGeoView, null);
		pTableGeoView.setLayout(new BorderLayout(0, 0));

		JLabel lblStatus = new JLabel("Statusbar");
		pTableGeoView.add(lblStatus, BorderLayout.SOUTH);

		JMenuBar menuBar = new JMenuBar();
		pTableGeoView.add(menuBar, BorderLayout.NORTH);

		JButton btnAddPoint = new JButton("");
		btnAddPoint.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
		menuBar.add(btnAddPoint);

		JButton btnDelPoint = new JButton("");
		btnDelPoint.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
		menuBar.add(btnDelPoint);
		
		table = new JTable();
		pTableGeoView.add(table, BorderLayout.CENTER);

		try {
			displayWorldBorderShapefile();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

//		buildPointAndLinesGeometry(graph);

	}

	private void displayWorldBorderShapefile() throws IOException {

		File file = new File("./src/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.shp");

		displaysShapefile(file);

	}
	
	private void displaysShapefile(File file) throws IOException {

		FileDataStore store = FileDataStoreFinder.getDataStore(file);
		FeatureSource<?, ?> featureSource = store.getFeatureSource();

		// Create a basic Style to render the features
		Style style = createStyle(file, featureSource);

		// Add the features and the associated Style object to
		// the MapContext as a new MapLayer
		displayFeatureSourceLayer(file.getName(), featureSource, style);
		
	}

	/**
	 * Create a Style to display the features. If an SLD file is in the same
	 * directory as the shapefile then we will create the Style by processing
	 * this. Otherwise we display a JSimpleStyleDialog to prompt the user for
	 * preferences.
	 */
	private Style createStyle(File file, FeatureSource<?, ?> featureSource) {
		File sld = toSLDFile(file);
		if (sld != null) {
			return createFromSLD(sld);
		}

		SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
		return JSimpleStyleDialog.showDialog(null, schema);
	}

	/**
	 * Figure out if a valid SLD file is available.
	 */
	public File toSLDFile(File file)  {
		String path = file.getAbsolutePath();
		String base = path.substring(0,path.length()-4);
		String newPath = base + ".sld";
		File sld = new File( newPath );
		if( sld.exists() ){
			return sld;
		}
		newPath = base + ".SLD";
		sld = new File( newPath );
		if( sld.exists() ){
			return sld;
		}
		return null;
	}

	/**
	 * Create a Style object from a definition in a SLD document
	 */
	private Style createFromSLD(File sld) {
		try {
			SLDParser stylereader = new SLDParser(styleFactory, sld.toURI().toURL());
			Style[] style = stylereader.readXML();
			return style[0];

		} catch (Exception e) {
			//            ExceptionMonitor.show(null, e, "Problem creating style");
		}
		return null;
	}

	public void displayFeatureSourceLayer(String title, FeatureSource<?, ?> featureSource, Style style) {

		FeatureLayer layer = new FeatureLayer(featureSource, style);
		mapContent.addLayer(layer);
		layer.setTitle(title);
		listModel.addElement(title);

	}

	public void displayFeatureCollectionLayer(String title, FeatureCollection<?, ?> featureCollection, Style style) {

		FeatureLayer layer = new FeatureLayer(featureCollection, style);
		mapContent.addLayer(layer);
		layer.setTitle(title);
		listModel.addElement(title);
	}

	public void diplayCollectionsPointsAndLines(ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed) {
		
		//Display points
		FeatureSource<?, ?> featureSourcePoints = DataUtilities.source(collectionfeaturesReadyToBeDisplayed.get(0));
		SimpleFeatureType schemaPoints = (SimpleFeatureType)featureSourcePoints.getSchema();
		Style stylePoints = JSimpleStyleDialog.showDialog(null, schemaPoints);
		FeatureLayer layerPoints = new FeatureLayer(featureSourcePoints, stylePoints);

		ReferencedEnvelope bounds = layerPoints.getBounds();

		//Display points
		FeatureSource<?, ?> featureSourceLines = DataUtilities.source(collectionfeaturesReadyToBeDisplayed.get(1));
		SimpleFeatureType schemaLines = (SimpleFeatureType)featureSourceLines.getSchema();
		Style styleLines = JSimpleStyleDialog.showDialog(null, schemaLines);
		FeatureLayer layerLines = new FeatureLayer(featureSourceLines, styleLines);

		mapContent.addLayer(layerPoints);
		layerPoints.setTitle("Points Layer");
		listModel.addElement(layerPoints.getTitle());
		mapContent.addLayer(layerLines);
		layerLines.setTitle("Links Layer");
		listModel.addElement(layerLines.getTitle());
		
		mapContent.getViewport().setBounds(bounds);
	}
	
	public List<Layer> getLayers() {
		
		return mapContent.layers();
		
	}
}