package org.tip.puck.spaces;

import java.util.List;

import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.NumberablesHashMap;
import org.tip.puck.util.Value;

public class Spaces extends NumberablesHashMap<Space> {
	
/*	private static int getTime(Relation state){
		int result;
		
		if (state.getAttributeValue("TIME")!=null){
			try {
				result = Integer.parseInt(state.getAttributeValue("TIME"));
			} catch (NumberFormatException nfe){
				System.err.println("time value is not an integer");
				result = 0;
			}
		} else {
			result = 0;
		}
		//
		return result;
	}*/
	
	public Spaces (Segmentation segmentation, String relationModelName, String egoRoleName, List<Integer> times, String filterLabel){
		
		for (int time : times){
			put(new Space(time,relationModelName));
		}
		
		for (Individual ego : segmentation.getCurrentIndividuals()){
			for (Relation state: ego.relations().getByModelName(relationModelName)){
				if (state.getRoleNames(ego).contains(egoRoleName) && (filterLabel==null || state.getAttributeValue(filterLabel)!=null)){
					Value timeValue = RelationValuator.get(state, "TIME");
					if (timeValue!=null){
						int time = timeValue.intValue();
						if (times.contains(time)){
							getById(time).put(ego,state);
						}
					}
				}
			}
		}
	}

	

}
