package org.tip.puck.spaces;

import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;

public class SpaceMaker {
	
	public static Space createSpace (Individuals source, String relationModelName, String egoRoleName, String attributeLabel, Integer time){
		Space result;
		
		result = new Space(time,relationModelName);
		
		for (Individual ego : source){
			for (Relation state: ego.relations().getByModelName(relationModelName)){
				if (state.hasActor(ego,egoRoleName) && state.hasAttributeValue(attributeLabel) && state.hasTime(time)){
					result.put(ego,state);
				}
			}
		}
		
		//
		return result;
	}
	
}
	
