package org.tip.puck.sequences;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainFinder;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Partition;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.NumberablesHashMap;

/**
 * 
 * @author Klaus Hamberger
 *
 */
public class Sequences extends NumberablesHashMap<Sequence> {
	
	String label;
	
	public Sequences(){
	}
	
	public Sequences (Segmentation segmentation, String label, String modelLabel, String orderLabel){
		
		this.label = label;
		
		Relations relations = segmentation.getCurrentRelations().getByModelName(modelLabel);
		
		for (Relation relation : relations){
			
			Sequence sequence = null;
			
			String sequenceId = relation.getAttributeValue(label);
			
			if (StringUtils.isNumeric(sequenceId)){
				sequence = getById(Integer.parseInt(sequenceId));
				if (sequence == null){
					sequence = new Sequence(Integer.parseInt(sequenceId));
					put(sequence);
				}
			}
			
			sequence.put(relation.getAttributeValue(orderLabel),relation);
		}
		
	}
	
	public String getLabel() {
		return label;
	}

	public Sequence getByEgo(Individual ego){
		Sequence result;
		
		result = null;
		
		for (Sequence sequence : this){
			if (sequence.getEgo()==ego){
				result = sequence;
				break;
			}
		}
		//
		return result;
	}
	
	public static void addChildMigrantRoles (Relations events, int maxAge){
		
		for (Relation event : events){
			if (!SequenceCensus.isBirth(event) && !SequenceCensus.isDeath(event)){

				Integer eventYear = IndividualValuator.extractYearAsInt(event.getAttributeValue("DATE"));
				if (eventYear!=null){
					for (Actor actor : event.actors().toList()){
						if (actor.getRole().getName().equals("MIG")){
							Individual ego = actor.getIndividual();
							int age = IndividualValuator.ageAtYear(ego, eventYear);
							if (age>-1 && age<maxAge && event.getRoleNames(ego).contains("MIG") && !SequenceCensus.isBirth(event) && !SequenceCensus.isDeath(event) 
									&& !event.getIndividuals("MIG").contains(ego.getFather())
									&& !event.getIndividuals("MIG").contains(ego.getMother())
									&& !event.getIndividuals("HOST").contains(ego.getFather())
									&& !event.getIndividuals("HOST").contains(ego.getMother())) {
								event.actors().add(new Actor(ego,new Role("CHILDMIG")));
							}
						}
					}
				}
			}
		}
	}
	
	public Partition<Chain> getChildHostKinshipChains (int maxDepth, int maxOrder, String chainClassification){
		Partition<Chain> result;
		
		result = new Partition<Chain>();
		
		for (Sequence sequence : this){
			for (Relation event : sequence.childMigrationsWithoutParents()){
				for (Individual host : event.getIndividuals("HOST")){
					Partition<Chain> chains = ChainFinder.findChains(sequence.getEgo(), host, maxDepth, maxOrder, chainClassification);
					if (chains.size()==0){
						result.put(new Chain (sequence.getEgo(),host), null);
					} else {
						result.add(chains);
					}
				}
			}
		}
		//
		return result;
	}
	
	public void addRenumbered(Sequence sequence){
		sequence.setId(size());
		add(sequence);
	}
	
	public int getNrEvents(){
		int result;
		
		result = 0;
		for (Sequence sequence : this){
			result += sequence.getEvents().size();
		}
		
		//
		return result;
	}
	

	

}
