package org.tip.puck.sequences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.tip.puck.net.relations.Relation;
import org.tip.puck.sequences.SequenceCensusCriteria.RelationAttributeType;

/**
 * 
 * @author Klaus Hamberger
 *
 */
public class SequenceProfile {
	
	int nrLoops;
	int nrDirectReturns;
	int nrCycles;
	List<String> profile;
	Set<String> support;
	Set<String> centers;
	
	
	public SequenceProfile(List<Relation> events, Map<RelationAttributeType,Map<Relation,String>> map, RelationAttributeType type){
		
		profile = new ArrayList<String>();
		support = new HashSet<String>();
		centers = new HashSet<String>();
			
		int i=0;
		for (Relation event : events){
			if (!SequenceCensus.isBirth(event) || type == RelationAttributeType.PLACE){
				
				String place = map.get(type).get(event);
				profile.add(place);
				support.add(place);
				
				// Check return pattern
				String previousPlace = null;
				boolean closed = false;
				
				for (int  j=i-1;j>-1;j--){
					previousPlace = profile.get(j);
					closed = previousPlace!=null && previousPlace.equals(place);
					if (closed){
						centers.add(place);
						if (j == (i-1)){
							nrLoops++;
						} else if (j == (i-2)){
							nrDirectReturns++;
						} else {
							nrCycles++;
						}
						break;
					}
				}
			}
			i++;
		}
	}
	
	public List<String> getCentersAsList(){
		List<String> result;
		
		result = new ArrayList<String>(centers);
		Collections.sort(result);
		
		//
		return result;
	}

	public Set<String> getSupport() {
		return support;
	}

	public List<String> getSupportAsList(){
		List<String> result;
		
		result = new ArrayList<String>(support);
		Collections.sort(result);
		
		//
		return result;
	}

	public int getNrDirectReturns() {
		return nrDirectReturns;
	}

	public int getNrCycles() {
		return nrCycles;
	}

	public int getNrLoops() {
		return nrLoops;
	}

	public List<String> getProfile() {
		return profile;
	}
	
	

}
