package org.tip.puck.sequences;

import java.util.Calendar;

public class Ordinal implements Comparable<Ordinal> {
	
	String name;
	Integer year;
	Calendar calendar;
	Integer order;
	
	public Ordinal (String name, Integer order, Integer year){
		this.name = name;
		this.order = order;
		this.year = year;
	}
	
	public boolean equals (Object obj){
		boolean result;
		
		result = false;
		if (obj != null){
			Ordinal other = (Ordinal)obj;
			result = (name.equals(other.name) && year==other.year && order==other.order && calendar == other.calendar);
		}
		
		//
		return result;
	}
	
	public int hashCode(){
		return (name+" "+order+" "+year+" "+calendar).hashCode();
	}
	
	public int compareTo(Ordinal other){
		int result;
		
		result = 0;
		if (order != null && other.order != null){
			result = order.compareTo(other.order);
		}
		if (result == 0 && calendar != null && other.calendar != null){
				result = calendar.compareTo(other.calendar);
		}
		if (result == 0 && year != null && other.year != null){
			result = year.compareTo(other.year);
		}
		if (result == 0 && name != null && other.name != null){
			result = name.compareTo(other.name);
		}
		//
		return result;
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getYear() {
		return year;
	}
	public void setYear(int year) {
		this.year = year;
	}
	public Calendar getCalendar() {
		return calendar;
	}
	public void setCalendar(Calendar calendar) {
		this.calendar = calendar;
	}
	public Integer getOrder() {
		return order;
	}
	public void setOrder(int order) {
		this.order = order;
	}
	
	public String toString(){
		return name;
	}
	
	

}
