package org.tip.puck.net.relations;

import java.util.LinkedList;
import java.util.Queue;

import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.util.Numberable;

public class RoleDefinition implements Numberable {
	


	enum Primary {
		PARENT,
		SIBLING,
		SPOUSE;
	}
	
	enum AlterAge {
		ELDER,
		YOUNGER;
		
		public AlterAge invert(){
			AlterAge result;
			
			if (this == ELDER){
				result = YOUNGER;
			} else if (this == YOUNGER){
				result = ELDER;
			} else {
				result = null;
			}
			//
			return result;
		}
	}
	
	private int id;
	private Role role;
	private Primary primary;
	private Role inversion;
	private Roles composition;
	private AlterAge alterAge;
	private Gender alterGender;
	private Gender egoGender;
	
	public RoleDefinition (int id, Role role, Primary primary, Role inversion, Roles composition, Gender alterGender, AlterAge alterAge, Gender egoGender){
		
		this.id = id;
		this.role = role;
		this.primary = primary;
		this.inversion = inversion;
		if (composition!=null && composition.size()>0){
			this.composition = composition;
		}
		this.alterGender = alterGender;
		this.alterAge = alterAge;
		this.egoGender = egoGender;
							
		if (this.composition!=null && this.composition.get(1)==null){
			System.err.println("Composition error: "+id+" "+role+" "+this.composition.get(0));
		}
		
	}
	
	public RoleDefinition clone (){
		RoleDefinition result;
		
		result = new RoleDefinition(id,role,primary,inversion,composition,alterGender,alterAge,egoGender);
		
		//
		return result;
	}
	
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public Primary primary() {
		return primary;
	}

	public Gender alterGender() {
		return alterGender;
	}

	public AlterAge alterAge() {
		return alterAge;
	}

	public Gender egoGender() {
		return egoGender;
	}

	public Role inversion() {
		return inversion;
	}

	public Roles composition() {
		return composition;
	}

	public Role role() {
		return role;
	}
	
	/**
	 * 
	 */
	@Override
	public String hashKey() {
		String result;

		result = "" + this.id;

		//
		return result;
	}
	
	private String inversionAsString(){
		String result;
		
		if (inversion==null){
			result = "";
		} else {
			result = "-"+inversion.getName();
		}
		//
		return result;
	}
	
	private String compositionAsString(){
		String result;
		
		if (composition==null || composition.size()==0){
			result = "";
		} else {
			result = composition.get(0).getName()+"  "+composition.get(1).getName();
		}
		//
		return result;
	}
	
	String alterAgeAsString(){
		String result;
		
		if (alterAge==null){
			result = "";
		} else {
			result = alterAge.toString();
		}
		//
		return result;
	}
	
	String alterGenderAsSymbol(){
		String result;
		
		if (alterGender==null){
			result = "";
		} else {
			result = alterGender.toSymbol()+"";
		}
		//
		return result;
	}
	
	String alterGenderAsString(){
		String result;
		
		if (alterGender==null){
			result = "";
		} else {
			result = alterGender.toString();
		}
		//
		return result;
	}
	
	String egoGenderAsSpeakerString(){
		String result;
		
		if (egoGender==null){
			result = "";
		} else {
			result = egoGender.toSpeakerString();
		}
		//
		return result;
	}
	
	String egoGenderAsString(){
		String result;
		
		if (egoGender==null){
			result = "";
		} else {
			result = egoGender.toString();
		}
		//
		return result;
	}
	
	String primaryAsString(){
		String result;
		
		if (primary==null){
			result = "";
		} else {
			result = primary.toString();
		}
		//
		return result;
		
	}
	
	
	public String toString(){
		String result;
		
		result = role.getName()+"\t"+alterAgeAsString()+" "+alterGenderAsSymbol()+" "+primaryAsString()+" "+inversionAsString()+" "+compositionAsString()+" "+egoGenderAsSpeakerString();
		
		//
		return result;
	}
	
	public boolean equals (Object obj){
		boolean result;
		
		RoleDefinition other = (RoleDefinition)obj;
		
		result = (
			role.equals(other.role()) &&
			alterGender == other.alterGender &&
			egoGender == other.egoGender &&
			alterAge == other.alterAge &&
			primary == other.primary &&
			(inversion==null || inversion.equals(other.inversion)) &&
			(composition==null || composition.equals(other.composition))
		);
		
		//
		return result;
	}
	
	public void setAlterAge(AlterAge alterAge) {
		this.alterAge = alterAge;
	}

	public void setAlterGender(Gender alterGender) {
		this.alterGender = alterGender;
	}

	public void setEgoGender(Gender egoGender) {
		this.egoGender = egoGender;
	}
	
	public String getPrimaryAsString (){
		String result;
		
		result = "";
		
		if (primary !=null){
			switch (primary) {
			case PARENT:
				if (alterGender==null){
					result = "Pa";
				} else if (alterGender.isMale()){
					result = "F";
				} else if (alterGender.isFemale()){
					result = "M";
				}
				break;
			case SIBLING:
				if (alterGender==null){
					result = "Sb";
				} else if (alterGender.isMale()){
					result = "B";
				} else if (alterGender.isFemale()){
					result = "Z";
				}
				if (alterAge == AlterAge.ELDER){
					result = "e"+result;
				} else if (alterAge == AlterAge.YOUNGER){
					result = "y"+result;
				}
				break;
			case SPOUSE:
				if (alterGender==null){
					result = "Sp";
				} else if (alterGender.isMale()){
					result = "H";
				} else if (alterGender.isFemale()){
					result = "W";
				}
				break;
			}
		} 
		//
		return result;
	}
	
	public String getInversePrimaryAsString (RoleDefinitions roleDefinitions){
		String result;
		
		result = "";
		
		for (RoleDefinition roleDefinition : roleDefinitions){
			if (inversion.equals(roleDefinition.role()) && roleDefinition.primary() == Primary.PARENT){
				if (alterGender==null){
					result = "Ch";
				} else if (alterGender.isMale()){
					result = "S";
				} else if (alterGender.isFemale()){
					result = "D";
				}
			}
		}
		
		//
		return result;
	}


}
