package org.tip.puck.net.relations;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.Sequence;
import org.tip.puck.sequences.Sequences;

public class RelationCensus {
	
	private Map<Integer,Relations> slices;
	private String relationModelName;
	private Relations relations;
	private Relations allRelations;
	private Integer[] times;
	private String keyLabel;
	private Sequences sequences;
	
	public RelationCensus (Segmentation segmentation, String relationModelName, RelationCensusCriteria criteria){
		
		slices = new TreeMap<Integer,Relations>();
		this.relationModelName = relationModelName;
		
		times = criteria.getTimes();
		keyLabel = criteria.getKeyLabel();
		
		relations = segmentation.getCurrentRelations().getByModelName(relationModelName);
		allRelations = segmentation.getAllRelations().getByModelName(relationModelName);
		
		for (int time : times){
			slices.put(time, new Relations());
		}
		
		sequences = new Sequences();
		
		for (Relation relation : relations){
			Integer time = relation.getTime();
			if (time!=null && Arrays.asList(times).contains(time)){
				slices.get(time).put(relation);
				if (keyLabel!=null){
					String keyValue = relation.getAttributeValue(keyLabel);
					if (keyValue!=null && StringUtils.isNumeric(keyValue)){
						Integer id = Integer.parseInt(keyValue);
						Sequence sequence = sequences.getById(id);
						if (sequence==null){
							sequence = new Sequence(id);
							// Temporary method, since census methods are gender sensitive (separate index for genders necessary)
							sequence.setEgo(new Individual(id,id+"",Gender.UNKNOWN));
							sequences.put(sequence);
						}
						sequence.put(time+"", relation);
					}
				}
			}
		}
	}
	
	public Integer[] times(){
		Integer[] result;
		
		result = slices.keySet().toArray(new Integer[slices.size()]);
		Arrays.sort(result);
		
		return result;
	}
	
	public int size(){
		return slices.size();
	}
	
	public Relations getRelations(int time){
		return slices.get(time);
	}
	
	public Relations getAllRelations(int time){
		Relations result;
		
		result = new Relations();
		for (Relation relation : allRelations){
			result.put(relation);
		}
		
		//
		return result;
		
	}

	public String relationModelName() {
		return relationModelName;
	}

	public Sequences getSequences() {
		return sequences;
	}
	
	


	
	

}
