package org.tip.puck.io.gis;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureIterator;
import org.geotools.map.Layer;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.tip.puck.PuckException;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.views.geo.MapPanel;

import com.vividsolutions.jts.geom.Geometry;

public class SIGFile {

	public static <E> void exportToGIS(final Graph<Place> source, final String fileName) throws PuckException {

		//		PrintWriter out = null;
		//		try {
		//			//
		//			out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(fileName)), "UTF-8"));
		//
		//			//
		//			String gisString = PuckUtils.writeGISNetwork(source).toString();
		//
		//			//
		//			gisString =PAJFile.convertToMicrosoftEndOfLine(gisString);
		//
		//			//
		//			out.print(gisString);
		//
		//		} catch (UnsupportedEncodingException exception) {
		//			throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + fileName + "]");
		//		} catch (FileNotFoundException exception) {
		//			throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + fileName + "]");
		//		} finally {
		//			if (out != null) {
		//				out.close();
		//			}
		//		}
	}

	//	public static DataStore exportToShapefile(MemoryDataStore memory, String typeName, File directory) throws IOException {
	public static void exportToShapefile(GroupNetGUI gui, File file) {

		MapPanel mapPanel = (MapPanel)gui.getWindow().getSelectedTab();

		List<Layer> layersList = mapPanel.getLayers();

		Transaction t = null;

		try {

			for (Layer layer : layersList) {

				t = new DefaultTransaction();

				SimpleFeatureSource featureSource = (SimpleFeatureSource) layer.getFeatureSource();
				SimpleFeatureType ft = featureSource.getSchema();

				//				String fileName = file.getName() + "_" + ft.getTypeName();
				String name = file.toString() + "_" + ft.getTypeName();
				String schemaName = name.substring(name.lastIndexOf("/")+1, name.length());
				File shapeFile = new File(name + ".shp");

				//				File(f.toString() + ".shp");

				URL shapeURL = shapeFile.toURI().toURL();

				Map<String, java.io.Serializable> creationParams = new HashMap<String, java.io.Serializable>();
				creationParams.put("url", shapeURL);

				FileDataStoreFactorySpi factory = FileDataStoreFinder.getDataStoreFactory("shp");
				DataStore dataStore = factory.createNewDataStore(creationParams);

				dataStore.createSchema(ft);

				// The following workaround to write out the prj is no longer needed
				// ((ShapefileDataStore)dataStore).forceSchemaCRS(ft.getCoordinateReferenceSystem());

				SimpleFeatureStore featureStore = (SimpleFeatureStore) dataStore.getFeatureSource(schemaName);

				SimpleFeatureCollection collection = featureSource.getFeatures(); // grab all features
				featureStore.addFeatures(collection);


//				try ( FeatureIterator iterator = collection.features() ){
//					while( iterator.hasNext() ){
//						SimpleFeature feature = (SimpleFeature) iterator.next();
//						Geometry g = (Geometry) feature.getAttribute( "the_geom" );
//						System.out.println( g.toString() );
//					}
//				}

				t.commit(); // write it out
				t.close();
			}

		} catch (Exception eek) {
			eek.printStackTrace();
			try {
				t.rollback();
			} catch (IOException doubleEeek) {
				// rollback failed?
			}
		}
	}
	//		return dataStore;
}
