package org.tip.puck.geo;

import java.util.List;

import com.vividsolutions.jts.geom.Coordinate;

public class Place {

	String name;
	GeoLevel level;
	Place sup;
	Coordinate coordinate;

	public Place (String name) {
		this.name = name;
		coordinate = null;
	}
	
	public Place (GeoLevel level, String name){
		this(name);
		this.level = level;
	}
	
	public Place (String name, Coordinate coord){
		this(name);
		this.coordinate = coord;
	}

	public Place getSup() {
		return sup;
	}

	public void setSup(Place sup) {
		this.sup = sup;
	}
	
	public Place getSup(List<String> placenames){
		Place result;
		
		result = this;
		while (result != null && !placenames.contains(result.getShortName())){
			result = result.getSup();
		}
		//
		return result;
	}
	
	public Place atLevel(GeoLevel level) {
		Place result;
		
		result = this;
		while (result != null && result.level != level){
			result = result.getSup();
		}
		//
		return result;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getShortName(){
		String result;
		
		result = null;
		
		if (name!=null){
			result = name.split("\\/")[0].trim();
		}
		//
		return result;
	}

	public GeoLevel getLevel() {
		return level;
	}

	public void setLevel(GeoLevel level) {
		this.level = level;
	}
	
	public String toString(){
		return getId();
	}
	
	public int compareByLevel(Place place){
		int result;
		
		result = this.level.compareTo(place.level);
		
		//
		return result;
	}
	
	public String getId() {
		String result;
		
		if (this.sup == null){
			result = this.name;
		} else {
			result = this.name + " / " + this.sup.name;
		}
		//
		return result;
	}
	
	public Coordinate getCoordinate() {
		return coordinate;
	}

	public void setCoordinate(Coordinate coordinate) {
		this.coordinate = coordinate;
	}
	
}