package org.tip.puck.geo;

import java.util.ArrayList;

import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

import org.geotools.feature.DefaultFeatureCollection;
import org.tip.puck.geo.io.GeoNamesWebService;
import org.tip.puck.graphs.Graph;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.views.geo.ConfigGeocodingDialog;
import org.tip.puckgui.views.geo.MapPanel;

public class Geocode extends SwingWorker<ArrayList<DefaultFeatureCollection>, Object>{

	ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed;
	ConfigGeocodingDialog mainDialog;
	JProgressBar progressBar;
	String typeOfGeocodingSource;
	GroupNetGUI parentGUI;

	public Geocode(ConfigGeocodingDialog mainDialog, JProgressBar progressBar, String typeOfGeocodingSource, GroupNetGUI parentGUI) {
		this.mainDialog = mainDialog;
		this.progressBar = progressBar;
		this.typeOfGeocodingSource = typeOfGeocodingSource;
		this.parentGUI = parentGUI;

	}

	public ArrayList<DefaultFeatureCollection> buildPointAndLinesGeometry(JProgressBar progressBar, String typeOfGeocodingSource, Graph <?> graph) {

		//Choice geoname or file,etc.
		if(typeOfGeocodingSource.compareTo("geonames") == 0 ) {
			//Creating GeoNames WebService
			this.progressBar.setString("Processing ... ");
			GeoNamesWebService ws = new GeoNamesWebService(this.progressBar);

			collectionfeaturesReadyToBeDisplayed = ws.getCoordForNodesPlaces(graph);

		}
		if(typeOfGeocodingSource.compareTo("personnalSources") == 0 ) {
			System.out.println("TODO !");
		}
		if(typeOfGeocodingSource.compareTo("geonamesFile") == 0 ) {
			System.out.println("TODO !");
		}

		return collectionfeaturesReadyToBeDisplayed;

	}

	@Override
	protected ArrayList<DefaultFeatureCollection> doInBackground()
			throws Exception {
		//Choice geoname or file,etc.
		if(typeOfGeocodingSource.compareTo("geonames") == 0 ) {
			//Creating GeoNames WebService
			GeoNamesWebService ws = new GeoNamesWebService(this.progressBar);

			collectionfeaturesReadyToBeDisplayed = ws.getCoordForNodesPlaces(this.parentGUI.getGroupNet());

		}
		if(typeOfGeocodingSource.compareTo("personnalSources") == 0 ) {
			System.out.println("TODO !");
		}
		if(typeOfGeocodingSource.compareTo("geonamesFile") == 0 ) {
			System.out.println("TODO !");
		}

		return collectionfeaturesReadyToBeDisplayed;
	}

	@Override
	protected void done() {
		try {

			mainDialog.dispose();

			MapPanel geographyMap = new MapPanel();
			geographyMap.diplayCollectionsPointsAndLines(collectionfeaturesReadyToBeDisplayed);
			
			parentGUI.addTab("Geography", geographyMap);

			System.out.println("done");
			//can call other gui update code here
		} catch (Throwable t) {
			//do something with the exception
		}
	}
}
