package org.tip.puck.census.workers;


import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;

/**
 * 
 * @author TIP
 */
public class CensusCriteria {

	private String pattern;
	private String filter;
	private String classificatoryLinking;
	private String closingRelation;
	private String closingRelationEgoRole;
	private String closingRelationAlterRole;
	private String chainClassification;
	private boolean crossSexChainsOnly;
	private boolean markIndividuals;
	private boolean marriedOnly;
	private boolean openChainFrequencies;
	private CircuitType circuitType;
	private FiliationType filiationType;
	private RestrictionType restrictionType;
	private SiblingMode siblingMode;
	private SymmetryType symmetryType;
	private CensusDetails censusDetails;
	private Gender firstGender;
	private String individualPartitionLabel;
	private boolean circuitIntersectionNetwork;
	private boolean circuitInducedNetwork;
	private boolean circuitInducedFrameNetwork;
	private boolean circuitNetworks;
	private boolean circuitsAsRelations;
	private boolean withOutOfCircuitCouples;
	private boolean withAllPerspectives;
	private Integer relationTime;
	private String relationAttributeValue;

	/**
	 * 
	 */
	public CensusCriteria() {
		this.pattern = "";
		this.filter = "";
		this.classificatoryLinking = "";
		this.closingRelation = "SPOUSE";
		this.closingRelationEgoRole = "";
		this.closingRelationAlterRole = "";
		this.chainClassification = "SIMPLE";
		this.crossSexChainsOnly = false;
		this.markIndividuals = false;
		this.marriedOnly = false;
		this.openChainFrequencies = false;
		this.circuitType = CircuitType.CIRCUIT;
		this.filiationType = FiliationType.COGNATIC;
		this.restrictionType = RestrictionType.NONE;
		this.siblingMode = SiblingMode.FULL;
		this.symmetryType = SymmetryType.PERMUTABLE;
		this.censusDetails = new CensusDetails(10, 10);
		this.firstGender = Gender.MALE;
		this.individualPartitionLabel = "";
		this.circuitIntersectionNetwork = false;
		this.circuitInducedNetwork = false;
		this.circuitInducedFrameNetwork = false;
		this.circuitNetworks = false;
		this.withOutOfCircuitCouples = false;
	}

	public CensusDetails getCensusDetails() {
		return censusDetails;
	}

	public String getChainClassification() {
		return chainClassification;
	}

	public CircuitType getCircuitType() {
		return circuitType;
	}

	public String getClassificatoryLinking() {
		return classificatoryLinking;
	}

	public String getClosingRelation() {
		return closingRelation;
	}

	public String getClosingRelationAlterRole() {
		return closingRelationAlterRole;
	}

	public String getClosingRelationEgoRole() {
		return closingRelationEgoRole;
	}

	public FiliationType getFiliationType() {
		return filiationType;
	}

	public String getFilter() {
		return filter;
	}

	public Gender getFirstGender() {
		return firstGender;
	}

	public String getIndividualPartitionLabel() {
		return individualPartitionLabel;
	}

	public String getPattern() {
		return pattern;
	}

	public RestrictionType getRestrictionType() {
		return restrictionType;
	}

	public SiblingMode getSiblingMode() {
		return siblingMode;
	}

	public SymmetryType getSymmetryType() {
		return symmetryType;
	}

	public boolean isCircuitInducedFrameNetwork() {
		return circuitInducedFrameNetwork;
	}

	public boolean isCircuitInducedNetwork() {
		return circuitInducedNetwork;
	}

	public boolean isCircuitIntersectionNetwork() {
		return circuitIntersectionNetwork;
	}

	public boolean isCircuitNetworks() {
		return circuitNetworks;
	}

	public boolean isCrossSexChainsOnly() {
		return crossSexChainsOnly;
	}

	public boolean isMarkIndividuals() {
		return markIndividuals;
	}

	public boolean isCouplesOnly() {
		return marriedOnly;
	}

	public boolean isOpenChainFrequencies() {
		return openChainFrequencies;
	}

	public void setChainClassification(final String value) {
		this.chainClassification = value;
	}

	public void setCircuitInduceFrameNetwork(final boolean circuitInduceFrameNetwork) {
		this.circuitInducedFrameNetwork = circuitInduceFrameNetwork;
	}

	public void setCircuitInducedNetwork(final boolean circuitInduceNetwork) {
		this.circuitInducedNetwork = circuitInduceNetwork;
	}

	public void setCircuitIntersectionNetwork(final boolean circuitInterserctionNetwork) {
		this.circuitIntersectionNetwork = circuitInterserctionNetwork;
	}

	public void setCircuitNetworks(final boolean circuitNetworks) {
		this.circuitNetworks = circuitNetworks;
	}

	public void setCircuitType(final CircuitType value) {
		if (value == null) {
			this.circuitType = CircuitType.CIRCUIT;
		} else {
			this.circuitType = value;
		}
	}

	public void setClassificatoryLinking(final String value) {
		this.classificatoryLinking = value;
	}

	public void setClosingRelation(final String value) {
		this.closingRelation = value;
	}

	public void setClosingRelationAlterRole(final String value) {
		if (value == null) {
			this.closingRelationAlterRole = "";
		} else {
			this.closingRelationAlterRole = value;
		}
	}

	public void setClosingRelationEgoRole(final String value) {
		if (value == null) {
			this.closingRelationAlterRole = "";
		} else {
			this.closingRelationEgoRole = value;
		}
	}

	public void setCrossSexChainsOnly(final boolean value) {
		this.crossSexChainsOnly = value;
	}

	public void setFiliationType(final FiliationType value) {
		if (value == null) {
			this.filiationType = FiliationType.COGNATIC;
		} else {
			this.filiationType = value;
		}
	}

	public void setFilter(final String filter) {
		this.filter = filter;
	}

	public void setFirstGender(final Gender firstGender) {
		this.firstGender = firstGender;
	}

	public void setIndividualPartitionLabel(final String value) {
		this.individualPartitionLabel = value;
	}

	public void setMarkIndividuals(final boolean markIndividuals) {
		this.markIndividuals = markIndividuals;
	}

	public void setMarriedOnly(final boolean marriedOnly) {
		this.marriedOnly = marriedOnly;
	}

	public void setOpenChainFrequencies(final boolean openChainFrequencies) {
		this.openChainFrequencies = openChainFrequencies;
	}

	public void setPattern(final String pattern) {
		this.pattern = pattern;
	}

	public void setRestrictionType(final RestrictionType value) {
		if (value == null) {
			this.restrictionType = RestrictionType.NONE;
		} else {
			this.restrictionType = value;
		}
	}

	public void setSiblingMode(final SiblingMode value) {
		if (value == null) {
			this.siblingMode = SiblingMode.FULL;
		} else {
			this.siblingMode = value;
		}
	}

	public void setSymmetryType(final SymmetryType value) {
		if (value == null) {
			this.symmetryType = SymmetryType.PERMUTABLE;
		} else {
			this.symmetryType = value;
		}
	}

	public boolean isCircuitsAsRelations() {
		return circuitsAsRelations;
	}

	public void setCircuitsAsRelations(boolean circuitsAsRelations) {
		this.circuitsAsRelations = circuitsAsRelations;
	}

	public boolean isWithOutOfCircuitCouples() {
		return withOutOfCircuitCouples;
	}

	public void setWithOutOfCircuitCouples(boolean withOutOfCircuitCouples) {
		this.withOutOfCircuitCouples = withOutOfCircuitCouples;
	}

	public boolean isWithAllPerspectives() {
		return withAllPerspectives;
	}

	public void setWithAllPerspectives(boolean withAllPerspectives) {
		this.withAllPerspectives = withAllPerspectives;
	}

	public Integer getRelationTime() {
		return relationTime;
	}

	public void setRelationTime(Integer relationTime) {
		this.relationTime = relationTime;
	}

	public String getRelationAttributeValue() {
		return relationAttributeValue;
	}

	public void setRelationAttributeValue(String relationAttributeValue) {
		this.relationAttributeValue = relationAttributeValue;
	}
}
