/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tip.puck.util.Value;

public class Values
extends ArrayList<Value> {
    private static final long serialVersionUID = 562986261984871649L;

    public Values() {
    }

    public <E> Values(List<E> list) {
        for (E item : list) {
            if (item == null) {
                this.add(null);
                continue;
            }
            this.add(new Value(item));
        }
    }

    public Values(int initialCapacity) {
        super(initialCapacity);
    }

    public double average() {
        double sum = 0.0;
        int count = 0;
        for (Value value : this) {
            if (value == null || !value.isNumber()) continue;
            sum += (double)value.intValue();
            ++count;
        }
        double result = count == 0 ? 0.0 : sum * 1.0 / (double)count;
        return result;
    }

    public double averagePositives() {
        double sum = 0.0;
        int count = 0;
        for (Value value : this) {
            if (value == null || !value.isNumber() || !(value.doubleValue() > 0.0)) continue;
            sum += value.doubleValue();
            ++count;
        }
        double result = count == 0 ? 0.0 : sum * 1.0 / (double)count;
        return result;
    }

    public boolean isNumbers() {
        boolean ended = false;
        boolean result = false;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Value value = (Value)iterator.next();
                if (value != null && !value.isNotNumber()) continue;
                result = false;
                ended = true;
                continue;
            }
            result = true;
            ended = true;
        }
        return result;
    }

    public boolean isNumeric() {
        boolean ended = false;
        boolean result = false;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Value value = (Value)iterator.next();
                if (value != null && !value.isNotNumber()) continue;
                ended = true;
                result = false;
                continue;
            }
            ended = true;
            result = true;
        }
        return result;
    }

    public double max() {
        Double maxValue = null;
        for (Value value : this) {
            if (value == null || !value.isNumber()) continue;
            if (maxValue == null) {
                maxValue = value.doubleValue();
                continue;
            }
            if (!(value.doubleValue() > maxValue)) continue;
            maxValue = value.doubleValue();
        }
        double result = maxValue == null ? 0.0 : maxValue;
        return result;
    }

    public double min() {
        Double minValue = null;
        for (Value value : this) {
            if (value == null || !value.isNumber()) continue;
            if (minValue == null) {
                minValue = value.doubleValue();
                continue;
            }
            if (!(value.doubleValue() < minValue)) continue;
            minValue = value.doubleValue();
        }
        double result = minValue == null ? 0.0 : minValue;
        return result;
    }

    public boolean isNull() {
        boolean result = true;
        for (Value value : this) {
            if (value == null) continue;
            result = false;
            break;
        }
        return result;
    }

    public void nullToZero() {
        int i = 0;
        while (i < this.size()) {
            if (this.get(i) == null) {
                this.set(i, new Value(0));
            }
            ++i;
        }
    }
}

