/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.segmentation;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.segmentation.Segment;

public class IndividualSegment
implements Segment {
    private PartitionCriteria criteria;
    private Partition<Individual> partition;
    private Cluster<Individual> currentCluster;
    private int currentClusterIndex;
    private Individuals currentIndividuals;
    private Families currentFamilies;
    private Relations currentRelations;
    private Individuals outOfPartitionIndividuals;
    private Families outOfPartitionFamilies;
    private Relations outOfPartitionRelations;

    public IndividualSegment(Segment source, PartitionCriteria criteria) throws PuckException {
        this.criteria = criteria;
        this.refresh(source);
        if (this.currentClusterIndex != 0) {
            this.selectCluster(0);
        }
    }

    @Override
    public List<String> getClusterLabels() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.partition != null) {
            for (Cluster<Individual> cluster : this.partition.getClusters().toListSortedByValue()) {
                String label = cluster.getLabel();
                if (label == null) {
                    label = "[null]";
                }
                result.add(String.format("%s (%d)", cluster.getLabel(), cluster.size()));
            }
        }
        result.add("*");
        return result;
    }

    @Override
    public PartitionCriteria getCriteria() {
        PartitionCriteria result = this.criteria;
        return result;
    }

    public Cluster<Individual> getCurrentCluster() {
        Cluster<Individual> result = this.currentCluster;
        return result;
    }

    @Override
    public int getCurrentClusterIndex() {
        int result = this.currentClusterIndex;
        return result;
    }

    @Override
    public Families getCurrentFamilies() {
        Families result = this.currentFamilies;
        return result;
    }

    @Override
    public Individuals getCurrentIndividuals() {
        Individuals result = this.currentIndividuals;
        return result;
    }

    @Override
    public Relations getCurrentRelations() {
        Relations result = this.currentRelations;
        return result;
    }

    @Override
    public int getCurrentSize() {
        int result = this.currentCluster == null ? this.outOfPartitionIndividuals.size() : this.currentCluster.size();
        return result;
    }

    @Override
    public String getLabel() {
        String result = this.partition == null ? "ALL" : (this.currentCluster == null ? String.valueOf(this.partition.getCriteria().toShortString()) + " : *" : String.valueOf(this.partition.getCriteria().toShortString()) + " : " + this.currentCluster.getLabel());
        return result;
    }

    @Override
    public Families getOutOfCurrentClusterFamilies() {
        Families result = new Families();
        if (this.currentCluster == null) {
            for (Cluster<Individual> cluster : this.partition.getClusters()) {
                Families families = IndividualSegment.findFamiliesFromIndividuals(new Individuals(cluster.getItems()), this.partition.getCriteria().getFamilyScope(), this.outOfPartitionFamilies);
                for (Family family : families) {
                    result.add(family);
                }
            }
        } else {
            for (Cluster<Individual> cluster : this.partition.getClusters()) {
                if (cluster == this.currentCluster) continue;
                Families families = IndividualSegment.findFamiliesFromIndividuals(new Individuals(cluster.getItems()), this.partition.getCriteria().getFamilyScope(), this.outOfPartitionFamilies);
                for (Family family : families) {
                    if (this.currentFamilies.contains(family)) continue;
                    result.add(family);
                }
            }
            result.add(this.outOfPartitionFamilies);
        }
        return result;
    }

    @Override
    public Individuals getOutOfCurrentClusterIndividuals() {
        Individuals result = new Individuals();
        if (this.currentCluster == null) {
            for (Cluster<Individual> cluster : this.partition.getClusters()) {
                result.add(cluster.getItems());
            }
        } else {
            for (Cluster<Individual> cluster : this.partition.getClusters()) {
                if (cluster == this.currentCluster) continue;
                result.add(cluster.getItems());
            }
            result.add(this.outOfPartitionIndividuals);
        }
        return result;
    }

    @Override
    public Relations getOutOfCurrentClusterRelations() {
        Relations result = new Relations();
        if (this.currentCluster == null) {
            for (Cluster<Individual> cluster : this.partition.getClusters()) {
                Relations relations = IndividualSegment.findRelationsFromIndividuals(new Individuals(cluster.getItems()), this.outOfPartitionRelations);
                for (Relation relation : relations) {
                    result.add(relation);
                }
            }
        } else {
            for (Cluster<Individual> cluster : this.partition.getClusters()) {
                if (cluster == this.currentCluster) continue;
                Relations relations = IndividualSegment.findRelationsFromIndividuals(new Individuals(cluster.getItems()), this.outOfPartitionRelations);
                for (Relation relation : relations) {
                    if (this.currentRelations.contains(relation)) continue;
                    result.add(relation);
                }
            }
            result.add(this.outOfPartitionRelations);
        }
        return result;
    }

    public Partition<Individual> getPartition() {
        Partition<Individual> result = this.partition;
        return result;
    }

    @Override
    public String getShortLabel() {
        String result = this.partition.getCriteria().toShortString();
        return result;
    }

    @Override
    public String getShortShortLabel() {
        String result = this.currentCluster == null ? String.valueOf(this.partition.getCriteria().getLabel()) + " = *" : String.valueOf(this.partition.getCriteria().getLabel()) + " = " + this.currentCluster.getValue();
        return result;
    }

    @Override
    public void refresh(Segment source) throws PuckException {
        Cluster<Individual> previousCurrentCluster = this.currentCluster;
        this.partition = PartitionMaker.create(this.criteria.toShortString(), source.getCurrentIndividuals(), this.criteria);
        this.outOfPartitionIndividuals = source.getOutOfCurrentClusterIndividuals();
        this.outOfPartitionFamilies = source.getOutOfCurrentClusterFamilies();
        this.outOfPartitionRelations = source.getOutOfCurrentClusterRelations();
        if (previousCurrentCluster == null) {
            this.selectOutOfPartitionCluster();
        } else {
            this.currentCluster = (Cluster)this.partition.getClusters().get(previousCurrentCluster.getValue());
            if (this.currentCluster == null) {
                this.selectCluster(0);
            }
        }
    }

    @Override
    public void selectCluster(Family family) {
    }

    @Override
    public void selectCluster(Individual individual) throws PuckException {
        if (individual == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        this.currentCluster = this.partition.getCluster(individual);
        if (this.currentCluster == null) {
            this.selectOutOfPartitionCluster();
        } else {
            List<Cluster<Individual>> clusters = this.partition.getClusters().toListSortedByValue();
            boolean ended = false;
            int clusterIndex = 0;
            while (!ended) {
                if (clusters.get(clusterIndex) == this.currentCluster) {
                    ended = true;
                    continue;
                }
                ++clusterIndex;
            }
            this.selectCluster(clusterIndex);
        }
    }

    @Override
    public void selectCluster(int index) throws PuckException {
        if (index < 0) {
            throw PuckExceptions.INVALID_PARAMETER.create("Index out of bounds.", new Object[0]);
        }
        if (this.partition == null && index > 0) {
            throw PuckExceptions.INVALID_PARAMETER.create("Index out of bounds.", new Object[0]);
        }
        if (this.partition != null && index >= this.partition.getClusters().size() + 1) {
            throw PuckExceptions.INVALID_PARAMETER.create("Index out of bounds.", new Object[0]);
        }
        if (index < this.partition.size()) {
            this.currentCluster = this.partition.getClusters().toListSortedByValue().get(index);
            this.currentClusterIndex = index;
            this.currentIndividuals = new Individuals(this.currentCluster.getItems());
            this.currentFamilies = IndividualSegment.findFamiliesFromIndividuals(this.currentIndividuals, this.partition.getCriteria().getFamilyScope(), this.outOfPartitionFamilies);
            this.currentRelations = IndividualSegment.findRelationsFromIndividuals(this.currentIndividuals, this.outOfPartitionRelations);
        } else {
            this.currentCluster = null;
            this.currentClusterIndex = this.partition.getClusters().size();
            this.currentIndividuals = this.outOfPartitionIndividuals;
            this.currentFamilies = this.outOfPartitionFamilies;
            this.currentRelations = this.outOfPartitionRelations;
        }
    }

    @Override
    public void selectCluster(Relation relation) {
    }

    @Override
    public void selectOutOfPartitionCluster() throws PuckException {
        this.selectCluster(this.partition.size());
    }

    private static Families findFamiliesFromIndividuals(Individuals source, PartitionCriteria.FamilyScope familyScope, Families outs) {
        Families result = new Families();
        for (Individual individual : source) {
            for (Family family : individual.getPersonalFamilies()) {
                if (outs.contains(family)) continue;
                if (familyScope == PartitionCriteria.FamilyScope.SOME) {
                    result.add(family);
                    continue;
                }
                Individual spouse = family.getOtherParent(individual);
                if (spouse == null || !source.contains(spouse)) continue;
                result.add(family);
            }
        }
        return result;
    }

    private static Relations findRelationsFromIndividuals(Individuals source, Relations outs) {
        Relations result = new Relations();
        for (Individual individual : source) {
            for (Relation relation : individual.relations()) {
                if (outs.contains(relation)) continue;
                result.add(relation);
            }
        }
        return result;
    }
}

