/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.report;

import fr.devinsy.util.StringList;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.report.ReportAttribute;
import org.tip.puck.report.ReportAttributes;
import org.tip.puck.report.ReportOutputs;
import org.tip.puck.report.Reports;

public class Report {
    private String title;
    private Calendar date;
    private String target;
    private String origin;
    private long timeSpent;
    private int status;
    private String inputComment;
    private ReportAttributes inputs;
    private ReportOutputs outputs;

    public Report() {
        this.date = Calendar.getInstance();
        this.inputs = new ReportAttributes();
        this.outputs = new ReportOutputs();
        this.timeSpent = 0L;
    }

    public Report(String title) {
        this.title = title;
        this.date = Calendar.getInstance();
        this.inputs = new ReportAttributes();
        this.outputs = new ReportOutputs();
        this.timeSpent = 0L;
    }

    public boolean containsSubReport() {
        boolean result = this.outputs.containsSubReport();
        return result;
    }

    public Calendar date() {
        return this.date;
    }

    public boolean hasInput() {
        boolean result = this.inputs().size() != 0 || !StringUtils.isBlank((CharSequence)this.inputComment);
        return result;
    }

    public boolean hasOutput() {
        boolean result = !this.outputs.isEmpty();
        return result;
    }

    public String inputComment() {
        return this.inputComment;
    }

    public ReportAttributes inputs() {
        return this.inputs;
    }

    public String origin() {
        return this.origin;
    }

    public ReportOutputs outputs() {
        return this.outputs;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setInputComment(String inputComment) {
        this.inputComment = inputComment;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTimeSpent(long timeSpent) {
        this.timeSpent = timeSpent;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int status() {
        return this.status;
    }

    public Reports subReports() {
        Reports result = new Reports();
        for (Object item : this.outputs()) {
            if (!(item instanceof Report)) continue;
            result.add((Report)item);
        }
        return result;
    }

    public String target() {
        return this.target;
    }

    public long timeSpent() {
        return this.timeSpent;
    }

    public String title() {
        return this.title;
    }

    public String toString() {
        String result = this.toString(null);
        return result;
    }

    public String toString(ResourceBundle bundle) {
        StringList buffer = new StringList(1024);
        buffer.append(Report.translate(bundle, "     General information")).append("\n");
        buffer.append(Report.translate(bundle, "Title:")).append(" ").append(this.title).append("\n");
        buffer.append(Report.translate(bundle, "Origin:")).append(" ").append(this.origin).append("\n");
        buffer.append(Report.translate(bundle, "Date:")).append(" ").append(new SimpleDateFormat("dd/MM/yyyy HH':'mm").format(this.date.getTime())).append("\n");
        buffer.append(Report.translate(bundle, "Target:")).append(" ").append(this.target).append("\n");
        buffer.append(Report.translate(bundle, "Time spent:")).append(" ").append(this.timeSpent).append("\n");
        buffer.append("\n");
        buffer.append(Report.translate(bundle, "     Inputs")).append("\n");
        buffer.append(Report.translate(bundle, "Input comment:")).append(" ").append(this.inputComment).append("\n");
        buffer.append(Report.translate(bundle, "Input data:")).append("\n");
        for (ReportAttribute item : this.inputs) {
            buffer.append(Report.translate(bundle, item.label())).append("\t").append(item.value()).append("\n");
        }
        buffer.append("\n");
        buffer.append(Report.translate(bundle, "     Outputs")).append("\n");
        for (Object output : this.outputs) {
            buffer.append(output.toString());
        }
        String result = buffer.toString();
        return result;
    }

    public static String translate(ResourceBundle bundle, String key) {
        String result;
        if (key == null) {
            result = "";
        } else if (bundle == null) {
            result = key;
        } else if (key.contains(".")) {
            try {
                result = bundle.getString(key);
            }
            catch (MissingResourceException exception) {
                result = key;
            }
        } else {
            try {
                result = bundle.getString("report." + key);
            }
            catch (MissingResourceException exception) {
                result = key;
            }
        }
        return result;
    }
}

