/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.util.Numberable;

public class RoleDefinition
implements Numberable {
    private int id;
    private Role role;
    private Primary primary;
    private Role inversion;
    private Roles composition;
    private AlterAge alterAge;
    private Gender alterGender;
    private Gender egoGender;

    public RoleDefinition(int id, Role role, Primary primary, Role inversion, Roles composition, Gender alterGender, AlterAge alterAge, Gender egoGender) {
        this.id = id;
        this.role = role;
        this.primary = primary;
        this.inversion = inversion;
        if (composition != null && composition.size() > 0) {
            this.composition = composition;
        }
        this.alterGender = alterGender;
        this.alterAge = alterAge;
        this.egoGender = egoGender;
        if (this.composition != null && this.composition.get(1) == null) {
            System.err.println("Composition error: " + id + " " + role + " " + this.composition.get(0));
        }
    }

    public RoleDefinition clone() {
        RoleDefinition result = new RoleDefinition(this.id, this.role, this.primary, this.inversion, this.composition, this.alterGender, this.alterAge, this.egoGender);
        return result;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public Primary primary() {
        return this.primary;
    }

    public Gender alterGender() {
        return this.alterGender;
    }

    public AlterAge alterAge() {
        return this.alterAge;
    }

    public Gender egoGender() {
        return this.egoGender;
    }

    public Role inversion() {
        return this.inversion;
    }

    public Roles composition() {
        return this.composition;
    }

    public Role role() {
        return this.role;
    }

    @Override
    public String hashKey() {
        String result = "" + this.id;
        return result;
    }

    private String inversionAsString() {
        String result = this.inversion == null ? "" : "-" + this.inversion.getName();
        return result;
    }

    private String compositionAsString() {
        String result = this.composition == null || this.composition.size() == 0 ? "" : String.valueOf(((Role)this.composition.get(0)).getName()) + " \u221e " + ((Role)this.composition.get(1)).getName();
        return result;
    }

    String alterAgeAsString() {
        String result = this.alterAge == null ? "" : this.alterAge.toString();
        return result;
    }

    String alterGenderAsSymbol() {
        String result = this.alterGender == null ? "" : String.valueOf(this.alterGender.toSymbol());
        return result;
    }

    String alterGenderAsString() {
        String result = this.alterGender == null ? "" : this.alterGender.toString();
        return result;
    }

    String egoGenderAsSpeakerString() {
        String result = this.egoGender == null ? "" : this.egoGender.toSpeakerString();
        return result;
    }

    String egoGenderAsString() {
        String result = this.egoGender == null ? "" : this.egoGender.toString();
        return result;
    }

    String primaryAsString() {
        String result = this.primary == null ? "" : this.primary.toString();
        return result;
    }

    public String toString() {
        String result = String.valueOf(this.role.getName()) + "\t" + this.alterAgeAsString() + " " + this.alterGenderAsSymbol() + " " + this.primaryAsString() + " " + this.inversionAsString() + " " + this.compositionAsString() + " " + this.egoGenderAsSpeakerString();
        return result;
    }

    public boolean equals(Object obj) {
        RoleDefinition other = (RoleDefinition)obj;
        boolean result = !(!this.role.equals(other.role()) || this.alterGender != other.alterGender || this.egoGender != other.egoGender || this.alterAge != other.alterAge || this.primary != other.primary || this.inversion != null && !this.inversion.equals(other.inversion) || this.composition != null && !this.composition.equals(other.composition));
        return result;
    }

    public void setAlterAge(AlterAge alterAge) {
        this.alterAge = alterAge;
    }

    public void setAlterGender(Gender alterGender) {
        this.alterGender = alterGender;
    }

    public void setEgoGender(Gender egoGender) {
        this.egoGender = egoGender;
    }

    public String getPrimaryAsString() {
        String result = "";
        if (this.primary != null) {
            switch (this.primary) {
                case PARENT: {
                    if (this.alterGender == null) {
                        result = "Pa";
                        break;
                    }
                    if (this.alterGender.isMale()) {
                        result = "F";
                        break;
                    }
                    if (!this.alterGender.isFemale()) break;
                    result = "M";
                    break;
                }
                case SIBLING: {
                    if (this.alterGender == null) {
                        result = "Sb";
                    } else if (this.alterGender.isMale()) {
                        result = "B";
                    } else if (this.alterGender.isFemale()) {
                        result = "Z";
                    }
                    if (this.alterAge == AlterAge.ELDER) {
                        result = "e" + result;
                        break;
                    }
                    if (this.alterAge != AlterAge.YOUNGER) break;
                    result = "y" + result;
                    break;
                }
                case SPOUSE: {
                    if (this.alterGender == null) {
                        result = "Sp";
                        break;
                    }
                    if (this.alterGender.isMale()) {
                        result = "H";
                        break;
                    }
                    if (!this.alterGender.isFemale()) break;
                    result = "W";
                }
            }
        }
        return result;
    }

    public String getInversePrimaryAsString(RoleDefinitions roleDefinitions) {
        String result = "";
        for (RoleDefinition roleDefinition : roleDefinitions) {
            if (!this.inversion.equals(roleDefinition.role()) || roleDefinition.primary() != Primary.PARENT) continue;
            if (this.alterGender == null) {
                result = "Ch";
                continue;
            }
            if (this.alterGender.isMale()) {
                result = "S";
                continue;
            }
            if (!this.alterGender.isFemale()) continue;
            result = "D";
        }
        return result;
    }

    static enum AlterAge {
        ELDER,
        YOUNGER;


        public AlterAge invert() {
            AlterAge result = this == ELDER ? YOUNGER : (this == YOUNGER ? ELDER : null);
            return result;
        }
    }

    static enum Primary {
        PARENT,
        SIBLING,
        SPOUSE;

    }
}

