/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Collections;
import org.tip.puck.graphs.Graph;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.util.ToolBox;

public class RelationWorker {
    public static String getLinkTrees(Relation relation, boolean reduced, String treeType, String pattern) {
        String result = "";
        int[] maxDegrees = ToolBox.stringsToInts(pattern);
        ArrayList<String> list = new ArrayList<String>();
        for (Actor actor : relation.actors()) {
            Individual individual = actor.getIndividual();
            Individual referent = actor.getReferent();
            if (referent != null) continue;
            String item = RelationWorker.getLinkTree(actor, new Actors(), relation, reduced, treeType, maxDegrees);
            if (treeType.equals("GENDER")) {
                item = String.valueOf(individual.getGender().toChar()) + item;
            } else if (treeType.equals("ID")) {
                item = String.valueOf(individual.getId()) + " " + item;
            } else if (treeType.equals("KIN")) {
                item = String.valueOf(individual.getGender().toChar()) + " " + item;
            }
            if (reduced && list.contains(item)) continue;
            list.add(item);
        }
        Collections.sort(list);
        for (String item : list) {
            result = String.valueOf(result) + item + " ";
        }
        return result;
    }

    public static Graph<Individual> getReferentGraph(Relation relation) {
        Graph<Individual> result = new Graph<Individual>();
        for (Actor actor : relation.actors()) {
            Individual ego = actor.getIndividual();
            Individual alter = actor.getReferent();
            result.addArc(ego, alter);
        }
        return result;
    }

    private static String getLinkTree(Actor referent, Actors ascendants, Relation relation, boolean reduced, String treeType, int[] maxDegrees) {
        String result = "";
        Actors dependants = relation.getDependants(referent);
        ascendants.add(referent);
        if (dependants.size() > 0) {
            result = "[";
            ArrayList<String> list = new ArrayList<String>();
            for (Actor descendant : dependants) {
                if (ascendants.contains(descendant)) {
                    System.err.println("Cyclic referent structure : " + referent + " for " + descendant + " " + referent + " in " + relation);
                    continue;
                }
                String item = RelationWorker.getLinkTree(descendant, ascendants, relation, reduced, treeType, maxDegrees);
                if (treeType.equals("GENDER")) {
                    item = String.valueOf(descendant.getIndividual().getGender().toChar()) + item;
                } else if (treeType.equals("ID")) {
                    item = String.valueOf(descendant.getIndividual().getId()) + " " + item;
                } else if (treeType.equals("KIN")) {
                    item = String.valueOf(NetUtils.getAlterRole(descendant.getIndividual(), referent.getIndividual(), maxDegrees, null)) + " " + item;
                }
                if (reduced && list.contains(item)) continue;
                list.add(item);
            }
            Collections.sort(list);
            for (String item : list) {
                result = String.valueOf(result) + item;
            }
            result = String.valueOf(result) + "]";
        }
        return result;
    }
}

