/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;

public class RelationModelStatistics {
    Roles roles;
    RoleDefinitions roleDefinitions;

    public RelationModelStatistics(RelationModel model) {
        this.roles = model.roles();
        this.roleDefinitions = model.roleDefinitions().neutralize();
    }

    public List<Role> sortedRoles() {
        Roles result = this.roles;
        Collections.sort(result);
        return result;
    }

    public int termCount() {
        int result = this.roles.size();
        return result;
    }

    public List<Integer> generations(Role role) {
        return this.generations(role, new Roles());
    }

    public List<Gender> genders(Role role) {
        return this.genders(role, null);
    }

    public List<Gender> genders(Role role, Role preDefined) {
        ArrayList<Gender> result = new ArrayList<Gender>();
        RoleDefinitions definitions = this.roleDefinitions.getDefinitions(role);
        for (RoleDefinition definition : definitions) {
            if (definition.alterGender() != null) {
                if (result.contains((Object)definition.alterGender())) continue;
                result.add(definition.alterGender());
                continue;
            }
            if (definition.composition() == null || ((Role)definition.composition().get(1)).equals(preDefined)) continue;
            for (Gender gender : this.genders((Role)definition.composition().get(1), role)) {
                if (result.contains((Object)gender)) continue;
                result.add(gender);
            }
        }
        return result;
    }

    public List<Integer> generations(Role role, Roles preDefined) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        RoleDefinitions definitions = this.roleDefinitions.getDefinitions(role);
        for (RoleDefinition definition : definitions) {
            if (definition.primary() == RoleDefinition.Primary.PARENT) {
                if (!result.contains(1)) {
                    result.add(1);
                }
            } else if (!(definition.primary() != RoleDefinition.Primary.SIBLING && definition.primary() != RoleDefinition.Primary.SPOUSE || result.contains(0))) {
                result.add(0);
            }
            if (definition.inversion() != null) {
                for (int inverseGeneration : this.generations(definition.inversion())) {
                    if (result.contains(-inverseGeneration)) continue;
                    result.add(-inverseGeneration);
                }
            }
            if (definition.composition() == null || definition.composition().contains(role)) continue;
            boolean recursive = false;
            for (Role preRole : preDefined) {
                if (!definition.composition().contains(preRole)) continue;
                recursive = true;
                break;
            }
            if (recursive) continue;
            preDefined.add(role);
            Iterator<Object> iterator = this.generations((Role)definition.composition().get(0), preDefined).iterator();
            while (iterator.hasNext()) {
                int firstGeneration = (Integer)iterator.next();
                for (int secondGeneration : this.generations((Role)definition.composition().get(1), preDefined)) {
                    if (result.contains(firstGeneration + secondGeneration)) continue;
                    result.add(firstGeneration + secondGeneration);
                }
            }
            preDefined.remove(role);
        }
        Collections.sort(result);
        return result;
    }

    public List<String> links(Role role) {
        return this.links(role, 0);
    }

    public List<String> links(Role role, int iterations) {
        ArrayList<String> result = new ArrayList<String>();
        int maxIterations = 2;
        if (iterations > maxIterations) {
            return result;
        }
        RoleDefinitions definitions = this.roleDefinitions.getDefinitions(role);
        for (RoleDefinition definition : definitions) {
            String ps;
            if (definition.primary() != null && StringUtils.isNotBlank((CharSequence)(ps = definition.getPrimaryAsString())) && !result.contains(ps)) {
                result.add(ps);
            }
            if (definition.inversion() != null && StringUtils.isNotBlank((CharSequence)(ps = definition.getInversePrimaryAsString(this.roleDefinitions))) && !result.contains(ps)) {
                result.add(ps);
            }
            if (definition.composition() == null || definition.composition().contains(role)) continue;
            for (String firstLink : this.links((Role)definition.composition().get(0), iterations + 1)) {
                for (String secondLink : this.links((Role)definition.composition().get(1), iterations + 1)) {
                    String link = String.valueOf(firstLink) + secondLink;
                    if (result.contains(link)) continue;
                    result.add(link);
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    private boolean isParent(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.primary() != RoleDefinition.Primary.PARENT) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isChild(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || !this.isParent(definition.inversion())) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isSibling(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.primary() != RoleDefinition.Primary.SIBLING) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean hasSameGender(Role alpha, Role beta) {
        boolean result = false;
        for (Gender gender : this.genders(alpha)) {
            if (!this.genders(beta).contains((Object)gender)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isAscendingParallel(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.composition() == null) continue;
            Role first = (Role)definition.composition().get(0);
            Role second = (Role)definition.composition().get(1);
            if (!this.isParent(first) || !this.isSibling(second) || !this.hasSameGender(first, second)) break;
            result = true;
            break;
        }
        return result;
    }

    private boolean isAscendingCross(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.composition() == null) continue;
            Role first = (Role)definition.composition().get(0);
            Role second = (Role)definition.composition().get(1);
            if (!this.isParent(first) || !this.isSibling(second) || this.hasSameGender(first, second)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isCollateralParallel(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.composition() == null) continue;
            Role first = (Role)definition.composition().get(0);
            Role second = (Role)definition.composition().get(1);
            if (!this.isAscendingParallel(first) || !this.isChild(second)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isCollateralCross(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.composition() == null) continue;
            Role first = (Role)definition.composition().get(0);
            Role second = (Role)definition.composition().get(1);
            if (!this.isAscendingCross(first) || !this.isChild(second)) break;
            result = true;
            break;
        }
        return result;
    }

    public String cousinClassification() {
        String result = null;
        boolean lineal = false;
        boolean merging = false;
        for (Role role : this.roles) {
            if (this.isCollateralParallel(role) && this.isSibling(role)) {
                merging = true;
            }
            if (!this.isCollateralParallel(role) || !this.isCollateralCross(role)) continue;
            lineal = true;
        }
        result = lineal ? (merging ? "GENERATIONAL" : "LINEAL") : (merging ? "BIFURCATE-MERGING" : "BIFURCATE-COLLATERAL");
        return result;
    }

    public Roles undefinedRoles() {
        Roles result = new Roles();
        for (Role role : this.roles) {
            if (this.roleDefinitions.getDefinitions(role).size() != 0 || result.contains(role)) continue;
            result.add(role);
        }
        Collections.sort(result);
        return result;
    }

    public RoleDefinitions recursiveDefinitions() {
        return this.roleDefinitions.recursiveDefinitions();
    }
}

