/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;

public class Actors
extends ArrayList<Actor> {
    private static final long serialVersionUID = -1258074052306152168L;

    public Actors() {
    }

    public Actors(Actors source) {
        super(source);
    }

    public Actors getById(int id) {
        Actors result = new Actors();
        for (Actor actor : this) {
            if (actor.getId() != id) continue;
            result.add(actor);
        }
        return result;
    }

    public Actors getByRole(Role role) {
        Actors result = new Actors();
        for (Actor actor : this) {
            if (actor.getRole() != role) continue;
            result.add(actor);
        }
        return result;
    }

    public Actors getByRole(String role) {
        Actors result = new Actors();
        for (Actor actor : this) {
            if (!StringUtils.equals((CharSequence)actor.getRole().getName(), (CharSequence)role)) continue;
            result.add(actor);
        }
        return result;
    }

    public Actors getOthers(int id) {
        Actors result = new Actors();
        for (Actor actor : this) {
            if (actor.getId() == id) continue;
            result.add(actor);
        }
        return result;
    }

    public Roles getRoles(int id) {
        Roles result = new Roles();
        for (Actor actor : this) {
            if (actor.getId() != id) continue;
            result.add(actor.getRole());
        }
        return result;
    }

    public boolean hasActor(int id) {
        boolean ended = false;
        boolean result = false;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Actor actor = (Actor)iterator.next();
                if (actor.getId() != id) continue;
                ended = true;
                result = true;
                continue;
            }
            ended = true;
            result = false;
        }
        return result;
    }

    public boolean hasActor(int id, String role) {
        boolean ended = false;
        boolean result = false;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Actor actor = (Actor)iterator.next();
                if (actor.getId() != id || !StringUtils.equals((CharSequence)actor.getRole().getName(), (CharSequence)role)) continue;
                ended = true;
                result = true;
                continue;
            }
            ended = true;
            result = false;
        }
        return result;
    }

    public Actor[] toArray() {
        Actor[] result = new Actor[this.size()];
        int actorCount = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Actor actor;
            result[actorCount] = actor = (Actor)iterator.next();
            ++actorCount;
        }
        return result;
    }

    public List<Actor> toList() {
        ArrayList<Actor> result = new ArrayList<Actor>(this.size());
        for (Actor actor : this) {
            result.add(actor);
        }
        return result;
    }
}

