/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.matrix;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.util.MathUtils;

public class Matrix {
    int[][] matrix;
    int[] rows;
    int[] columns;
    int sum;
    protected TreeMap<Integer, Integer> index;
    TreeMap<Integer, int[]> map;
    double[] relinkings;
    boolean isSymmetric;

    public static double rd(double d) {
        return MathUtils.round(d, 2);
    }

    public Matrix(int n) {
        this.matrix = new int[n][n];
        this.rows = new int[n];
        this.columns = new int[n];
    }

    public Matrix(int m, int n) {
        this.matrix = new int[m][n];
        this.rows = new int[m];
        this.columns = new int[n];
    }

    public void augment(int i, int j, int v) {
        this.matrix[i][j] = this.matrix[i][j] + v;
        this.rows[i] = this.rows[i] + v;
        this.columns[j] = this.columns[j] + v;
        this.sum += v;
    }

    public int get(int i, int j) {
        return this.matrix[i][j];
    }

    public int getColDim() {
        return this.columns.length;
    }

    public int getColSum(int i) {
        return this.columns[i];
    }

    public double getColSumMeans() {
        return new Double(this.sum) / new Double(this.getColDim());
    }

    public int[] getColSums() {
        return this.columns;
    }

    public double getColSumVariance() {
        double means = this.getColSumMeans();
        double var = 0.0;
        int i = 0;
        while (i < this.getColDim()) {
            var += Math.pow((double)this.columns[i] - means, 2.0);
            ++i;
        }
        return var / new Double(this.getRowDim());
    }

    public int getRowDim() {
        return this.rows.length;
    }

    public int getRowSum(int i) {
        return this.rows[i];
    }

    public double getRowSumMeans() {
        return new Double(this.sum) / new Double(this.getRowDim());
    }

    public int[] getRowSums() {
        return this.rows;
    }

    public double getRowSumVariance() {
        double means = this.getRowSumMeans();
        double var = 0.0;
        int i = 0;
        while (i < this.getRowDim()) {
            var += Math.pow((double)this.rows[i] - means, 2.0);
            ++i;
        }
        return var / new Double(this.getRowDim());
    }

    public int getSum() {
        return this.sum;
    }

    public void set(int i, int j, int v) {
        this.matrix[i][j] = v;
        if (this.isSymmetric) {
            this.matrix[j][i] = v;
        }
    }

    public int[] getRow(int i) {
        return this.matrix[i];
    }

    @Deprecated
    public Map<Double, Double> getDistributionOfWeights(int interval) {
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        double inc = new Double(1.0 / (double)(this.getRowDim() * this.getColDim()));
        int i = 0;
        while (i < this.getRowDim()) {
            int j = 0;
            while (j < this.getColDim()) {
                double value = this.get(i, j);
                double next = value - value % (double)interval + (double)interval;
                Double frequency = (Double)result.get(next);
                frequency = frequency == null ? Double.valueOf(inc) : Double.valueOf(frequency + inc);
                result.put(next, frequency);
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Deprecated
    public Map<Double, Double> getDistributionOfForces(int interval) {
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        double inc = new Double(1.0 / (double)this.getRowDim());
        int i = 0;
        while (i < this.getRowDim()) {
            double value = this.getRowSum(i);
            double next = value - value % (double)interval + (double)interval;
            Double frequency = (Double)result.get(next);
            frequency = frequency == null ? Double.valueOf(inc) : Double.valueOf(frequency + inc);
            result.put(next, frequency);
            ++i;
        }
        return result;
    }
}

