/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.xls;

import fr.devinsy.util.StringList;
import java.io.File;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.BARIURDetector;
import org.tip.puck.io.bar.BARXLSFile;
import org.tip.puck.io.iur.IURXLSFile;
import org.tip.puck.io.xls.XLSBufferedReader;
import org.tip.puck.net.Net;
import org.tip.puck.util.PuckUtils;

public class XLSFile {
    private static final Logger logger = LoggerFactory.getLogger(XLSFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;

    public static Net load(File file) throws PuckException {
        Net result;
        BARIURDetector.Format format = BARIURDetector.detectFormat(file);
        switch (format) {
            case BAR: {
                result = BARXLSFile.load(file);
                break;
            }
            case IUR: {
                result = IURXLSFile.load(file);
                break;
            }
            case CONFLICTING: {
                throw PuckExceptions.FORMAT_CONFLICT.create("BAR/IUR conflict.", new Object[0]);
            }
            case UNKNOWN: {
                throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown format.", new Object[0]);
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static List<StringList> readLineBlocks(File file) {
        List<StringList> result;
        block5: {
            XLSBufferedReader in = null;
            try {
                try {
                    in = new XLSBufferedReader(file);
                    result = PuckUtils.readLineBlocks(in);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    result = null;
                    IOUtils.closeQuietly((Reader)in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
        }
        return result;
    }

    public static StringList readLines(File file) {
        StringList result;
        block5: {
            XLSBufferedReader in = null;
            try {
                try {
                    in = new XLSBufferedReader(file);
                    result = PuckUtils.readLines(in);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    result = null;
                    IOUtils.closeQuietly((Reader)in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
        }
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        IURXLSFile.save(file, source);
    }
}

