/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.iur;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckManager;
import org.tip.puck.io.iur.IURTXTFile;
import org.tip.puck.io.iur.IURTXTLabelsLine;
import org.tip.puck.io.ods.ODSBufferedReader;
import org.tip.puck.io.xls.XLSBufferedReader;
import org.tip.puck.net.Attributes;

public class IURDetector {
    private static final Logger logger = LoggerFactory.getLogger(IURDetector.class);

    public static boolean assertIsBlankOrChildIds(String source) {
        boolean result = StringUtils.isBlank((CharSequence)source) ? true : source.trim().matches("^\\d+[\\d .,;]*");
        return result;
    }

    public static boolean assertIsBlankOrID(String source) {
        boolean result = StringUtils.isBlank((CharSequence)source) || NumberUtils.isNumber((String)source);
        return result;
    }

    public static boolean assertIsFamilyLine(String source) {
        String[] tokens;
        boolean result = StringUtils.isBlank((CharSequence)source) ? false : ((tokens = source.split("\\t")).length == 0 ? false : (tokens.length > 0 && !NumberUtils.isNumber((String)tokens[0]) ? false : (tokens.length > 1 && !IURDetector.assertIsUnionStatus(tokens[1]) ? false : (tokens.length > 2 && !IURDetector.assertIsBlankOrID(tokens[2]) ? false : (tokens.length > 3 && !IURDetector.assertIsBlankOrID(tokens[3]) ? false : tokens.length <= 4 || IURDetector.assertIsBlankOrChildIds(tokens[4]))))));
        return result;
    }

    public static boolean assertIsGender(String source) {
        boolean result;
        if (StringUtils.isBlank((CharSequence)source)) {
            result = true;
        } else {
            String value = source.trim();
            if (value.length() != 1) {
                result = false;
            } else {
                char unionKey = value.charAt(0);
                switch (unionKey) {
                    case 'F': 
                    case 'H': 
                    case 'M': 
                    case 'X': 
                    case 'f': 
                    case 'h': 
                    case 'm': 
                    case 'x': {
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    public static boolean assertIsIndividualLine(String source, int labelCount) {
        String[] tokens;
        boolean result = StringUtils.isBlank((CharSequence)source) ? false : ((tokens = source.split("\\t")).length == 0 ? false : (tokens.length > labelCount ? false : (tokens.length > 0 && !NumberUtils.isNumber((String)tokens[0]) ? false : tokens.length <= 2 || IURDetector.assertIsGender(tokens[2]))));
        return result;
    }

    public static boolean assertIsUnionStatus(String source) {
        boolean result;
        if (StringUtils.isBlank((CharSequence)source)) {
            result = true;
        } else {
            String value = source.trim();
            if (value.length() != 1) {
                result = false;
            } else {
                char unionKey = value.charAt(0);
                switch (unionKey) {
                    case 'D': 
                    case 'M': 
                    case 'U': 
                    case 'd': 
                    case 'm': 
                    case 'u': {
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    public static boolean isIUR(BufferedReader in) throws Exception {
        boolean result;
        if (in == null) {
            result = false;
        } else {
            IURTXTFile.readCorpusAttributes(new Attributes(), in);
            IURTXTLabelsLine labelsLine = IURTXTFile.readLabelsLine(in);
            int individualLabelCount = labelsLine == null ? 3 : labelsLine.size();
            boolean ended = false;
            result = false;
            while (!ended) {
                in.mark(2048);
                String line = in.readLine();
                if (StringUtils.isBlank((CharSequence)line)) {
                    ended = true;
                    result = true;
                    continue;
                }
                if (line.matches("^\\D.*$")) {
                    ended = true;
                    in.reset();
                    result = true;
                    continue;
                }
                if (IURDetector.assertIsIndividualLine(line, individualLabelCount)) continue;
                ended = true;
                logger.debug("Detected not individual line => NOT IUR");
                logger.debug("line=" + line);
                result = false;
            }
            if (result) {
                IURTXTLabelsLine familyLabels = IURTXTFile.readLabelsLine(in);
                if (familyLabels == null) {
                    result = false;
                } else {
                    boolean ended2 = false;
                    while (!ended2) {
                        in.mark(2048);
                        String line = in.readLine();
                        if (StringUtils.isBlank((CharSequence)line)) {
                            ended2 = true;
                            result = true;
                            continue;
                        }
                        if (line.matches("^\\D.*$")) {
                            ended2 = true;
                            in.reset();
                            result = true;
                            continue;
                        }
                        if (IURDetector.assertIsFamilyLine(line)) continue;
                        ended2 = true;
                        logger.debug("Detected not family line => NOT IUR");
                        logger.debug("line=" + line);
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    public static boolean isIUR(File source) {
        boolean result = IURDetector.isIUR(source, PuckManager.DEFAULT_CHARSET_NAME);
        return result;
    }

    public static boolean isIUR(File source, String charsetName) {
        boolean result;
        block7: {
            if (source == null) {
                result = false;
            } else {
                BufferedReader in = null;
                try {
                    try {
                        String fileName = source.getName().toLowerCase();
                        in = fileName.endsWith(".ods") ? new ODSBufferedReader(source) : (fileName.endsWith(".txt") ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), charsetName)) : (fileName.endsWith(".xls") ? new XLSBufferedReader(source) : null));
                        result = IURDetector.isIUR(in);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        result = false;
                        IOUtils.closeQuietly(in);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)in);
            }
        }
        return result;
    }
}

