/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.filetype;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFormat {
    private static final Logger logger = LoggerFactory.getLogger(FileFormat.class);
    private List<Format> formats = new ArrayList<Format>();

    public void addFormat(Format format) {
        if (format != null && !this.formats.contains((Object)format)) {
            this.formats.add(format);
        }
    }

    public Format format() {
        Format result;
        switch (this.formats.size()) {
            case 0: {
                result = Format.UNKNOWN;
                break;
            }
            case 1: {
                result = this.formats.get(0);
                break;
            }
            default: {
                throw new IllegalAccessError("Format is multiple.");
            }
        }
        return result;
    }

    public List<Format> formats() {
        List<Format> result = this.formats;
        return result;
    }

    public boolean isSingle() {
        boolean result = this.formats.size() == 1;
        return result;
    }

    public boolean isUnknown() {
        boolean result = this.formats.isEmpty();
        return result;
    }

    public void setFormat(Format format) {
        this.formats.clear();
        if (format != null || format != Format.UNKNOWN) {
            this.formats.add(format);
        }
    }

    public static enum Format {
        DAT,
        BAR_ODS,
        BAR_TXT,
        BAR_XLS,
        IUR_ODS,
        IUR_TXT,
        IUR_XLS,
        GEDCOM,
        PAJEK,
        PROLOG,
        PUC,
        SELZ_ODS,
        SELZ_TXT,
        SELZ_XLS,
        TIP,
        UNKNOWN;

    }
}

