/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.alliancenets;

import java.util.Vector;
import org.tip.puck.alliancenets.Alliance;
import org.tip.puck.alliancenets.AllianceNet;
import org.tip.puck.alliancenets.DistMatrix;
import org.tip.puck.alliancenets.Group;
import org.tip.puck.alliancenets.TopologicalIndices;
import org.tip.puck.evo.Generator;
import org.tip.puck.evo.GenericFunSet;
import org.tip.puck.evo.ProgSet;
import org.tip.puck.util.RandomGenerator;

public class AllianceGen
extends Generator {
    private AllianceNet allianceNet;
    private TopologicalIndices indices;
    private TopologicalIndices targetIndices;

    public AllianceGen(int nodeCount, int edgeCount, TopologicalIndices targetIndices) {
        super(nodeCount, edgeCount);
        this.targetIndices = targetIndices;
        this.indices = null;
    }

    @Override
    public void createProgSet() {
        this.progcount = 1;
        Vector<String> variableNames = new Vector<String>();
        variableNames.add("origId");
        variableNames.add("targId");
        variableNames.add("origInDeg");
        variableNames.add("origOutDeg");
        variableNames.add("targInDeg");
        variableNames.add("targOutDeg");
        variableNames.add("origInStren");
        variableNames.add("origOutStren");
        variableNames.add("targInStren");
        variableNames.add("targOutStren");
        variableNames.add("undirDist");
        variableNames.add("dirDist");
        variableNames.add("revDist");
        variableNames.add("dirStren");
        variableNames.add("revStren");
        this.progset = new ProgSet(this.progcount, variableNames);
        this.progset.varcounts.set(0, 15);
        this.progset.funsets.set(0, GenericFunSet.instance().getFunset());
        this.progset.prognames.set(0, "Prog\n");
    }

    @Override
    public void run() {
        this.progset.clearEvalStats();
        DistMatrix.instance().setNodes(this.nodeCount);
        this.allianceNet = new AllianceNet(true);
        Group[] nodeArray = new Group[this.nodeCount];
        double[][] weightArray = new double[this.nodeCount][this.nodeCount];
        int i = 0;
        while (i < this.nodeCount) {
            nodeArray[i] = this.allianceNet.addNodeWithId(i);
            ++i;
        }
        i = 0;
        while ((double)i < this.targetIndices.getN()) {
            double totalWeight = 0.0;
            int origIndex = 0;
            while (origIndex < this.nodeCount) {
                int targIndex = 0;
                while (targIndex < this.nodeCount) {
                    Group origNode = nodeArray[origIndex];
                    Group targNode = nodeArray[targIndex];
                    double undirectedDistance = DistMatrix.instance().getUDist(origNode.getId(), targNode.getId());
                    double directDistance = DistMatrix.instance().getDDist(origNode.getId(), targNode.getId());
                    double reverseDistance = DistMatrix.instance().getDDist(targNode.getId(), origNode.getId());
                    double directStrength = 0.0;
                    Alliance alliance = this.allianceNet.getEdge(origNode, targNode);
                    if (alliance != null) {
                        directStrength = alliance.getWeight();
                    }
                    double reverseStrength = 0.0;
                    alliance = this.allianceNet.getEdge(targNode, origNode);
                    if (alliance != null) {
                        reverseStrength = alliance.getWeight();
                    }
                    this.progset.progs[0].vars[0] = origIndex;
                    this.progset.progs[0].vars[1] = targIndex;
                    this.progset.progs[0].vars[2] = origNode.getInDegree();
                    this.progset.progs[0].vars[3] = origNode.getOutDegree();
                    this.progset.progs[0].vars[4] = targNode.getInDegree();
                    this.progset.progs[0].vars[5] = targNode.getOutDegree();
                    this.progset.progs[0].vars[6] = origNode.getTotalInputWeight();
                    this.progset.progs[0].vars[7] = origNode.getTotalOutputWeight();
                    this.progset.progs[0].vars[8] = targNode.getTotalInputWeight();
                    this.progset.progs[0].vars[9] = targNode.getTotalOutputWeight();
                    this.progset.progs[0].vars[10] = undirectedDistance;
                    this.progset.progs[0].vars[11] = directDistance;
                    this.progset.progs[0].vars[12] = reverseDistance;
                    this.progset.progs[0].vars[13] = directStrength;
                    this.progset.progs[0].vars[14] = reverseStrength;
                    double weight = this.progset.progs[0].eval(i);
                    if (weight < 0.0) {
                        weight = 0.0;
                    }
                    weightArray[origIndex][targIndex] = weight;
                    totalWeight += weight;
                    ++targIndex;
                }
                ++origIndex;
            }
            if (totalWeight == 0.0) {
                int x = 0;
                while (x < this.nodeCount) {
                    int y = 0;
                    while (y < this.nodeCount) {
                        weightArray[x][y] = 1.0;
                        totalWeight += 1.0;
                        ++y;
                    }
                    ++x;
                }
            }
            double weight = RandomGenerator.instance().random.nextDouble() * totalWeight;
            int origIndex2 = 0;
            int targIndex = 0;
            totalWeight = weightArray[origIndex2][targIndex];
            while (totalWeight < weight) {
                if (++origIndex2 >= this.nodeCount) {
                    ++targIndex;
                    origIndex2 = 0;
                }
                totalWeight += weightArray[origIndex2][targIndex];
            }
            Group origNode = nodeArray[origIndex2];
            Group targNode = nodeArray[targIndex];
            Alliance alliance = this.allianceNet.getEdge(origNode, targNode);
            if (alliance == null) {
                this.allianceNet.addEdge(origNode, targNode, i);
                alliance = this.allianceNet.getEdge(origNode, targNode);
            }
            alliance.setWeight(alliance.getWeight() + 1.0);
            DistMatrix.instance().updateDistances(origIndex2, targIndex);
            ++i;
        }
    }

    @Override
    public double distance(Generator generator) {
        return 0.0;
    }

    @Override
    public Generator clone() {
        return new AllianceGen(this.nodeCount, this.edgeCount, this.targetIndices);
    }

    public TopologicalIndices getIndices() {
        return this.indices;
    }

    public void setIndices(TopologicalIndices indices) {
        this.indices = indices;
    }

    public TopologicalIndices getTargetIndices() {
        return this.targetIndices;
    }

    public void setTargetIndices(TopologicalIndices targetIndices) {
        this.targetIndices = targetIndices;
    }

    public AllianceNet getNet() {
        return this.allianceNet;
    }
}

