/*
 * Decompiled with CFR 0.152.
 */
package oldcore.calc.partitions;

import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import oldcore.calc.partitions.Partition;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;

public class PartitionMaker {
    Net net;
    Map<Individual, Object> values;

    public PartitionMaker(Net net) {
        this.net = net;
        this.values = new TreeMap<Individual, Object>();
    }

    public Partition<Individual> makeGenerations() {
        Partition<Individual> result = new Partition<Individual>(this.values);
        int n = this.net.size() / 2;
        int[] m = new int[]{n};
        for (Individual v : this.net.individuals()) {
            if ((Integer)this.values.get(v) != 0) continue;
            this.setGeneration(this.values, v, m, n);
        }
        n = m[0];
        for (Individual v : this.net.individuals()) {
            int d = (Integer)this.values.get(v);
            if (d <= 0) continue;
            this.values.put(v, d - n + 1);
        }
        return result;
    }

    public Partition<Individual> makeDepths(FiliationType type) {
        Partition<Individual> result = new Partition<Individual>(this.values);
        for (Individual individual : this.net.individuals()) {
            if (this.values.get(individual.getId()) != null) continue;
            this.depth(individual, type);
        }
        return result;
    }

    public Partition<Individual> makeAncestors(FiliationType type) {
        Partition<Individual> result = new Partition<Individual>(this.values);
        for (Individual individual : this.net.individuals()) {
            if (this.values.get(individual.getId()) != null) continue;
            this.ancestor(individual, type);
        }
        return result;
    }

    public Individual ancestor(Individual ego, FiliationType type) {
        Individual result;
        if (ego.getOriginFamily() == null) {
            result = ego;
        } else {
            switch (type) {
                case AGNATIC: {
                    Individual father = ego.getFather();
                    result = father == null ? ego : this.ancestor(father, type);
                }
                case UTERINE: {
                    Individual mother = ego.getMother();
                    result = mother == null ? ego : this.ancestor(mother, type);
                }
            }
            result = ego;
        }
        return result;
    }

    public int depth(Individual ego, FiliationType type) {
        int result;
        if (ego.getOriginFamily() == null) {
            result = 0;
        } else {
            switch (type) {
                case AGNATIC: {
                    Individual father = ego.getFather();
                    result = father == null ? 0 : this.depth(father, type) + 1;
                }
                case UTERINE: {
                    Individual mother = ego.getMother();
                    result = mother == null ? 0 : this.depth(mother, type) + 1;
                }
                case COGNATIC: {
                    Individual father = ego.getFather();
                    Individual mother = ego.getMother();
                    result = father == null && mother == null ? 0 : (father == null ? this.depth(mother, type) + 1 : (mother == null ? this.depth(father, type) + 1 : Math.max(this.depth(mother, type), this.depth(father, type)) + 1));
                }
            }
            result = 0;
        }
        this.values.put(ego, result);
        return result;
    }

    public void setGeneration(Map<Individual, Object> generations, Individual ego, int[] m, int n) {
        Stack<Individual> stack = new Stack<Individual>();
        generations.put(ego, n);
        stack.push(ego);
        while (!stack.isEmpty()) {
            this.setGeneration(generations, (Individual)stack.pop(), m, stack);
        }
    }

    public void setGeneration(Map<Individual, Object> generations, Individual ego, int[] m, Stack<Individual> stack) {
        int[] kn;
        int d = (Integer)generations.get(ego);
        int[] nArray = new int[3];
        nArray[1] = -1;
        nArray[2] = 1;
        int[] nArray2 = kn = nArray;
        int n = kn.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray2[n2];
            if (ego.getKin(k) != null) {
                for (Individual alter : ego.getKin(k)) {
                    if (alter == null || (Integer)generations.get(alter) != 0) continue;
                    int e = d - k;
                    generations.put(alter, e);
                    if (m[0] > e) {
                        m[0] = e;
                    }
                    stack.push(alter);
                }
            }
            ++n2;
        }
    }
}

