/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.PuckManager;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportAttributes;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.util.Chronometer;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.models.ReportItemsModel;
import org.tip.puckgui.models.ReportTableModel;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.ReportChartMaker;
import org.tip.puckgui.views.SaveReportRawDataButton;

public class ReportPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(ReportPanel.class);
    private static final long serialVersionUID = -8229975159547539454L;
    private File file;
    private JTable tableInputs;
    private Report report;
    private JLabel lblTitleValue;
    private JLabel lblOriginValue;
    private JLabel lblDateValue;
    private JLabel lblTargetValue;
    private JTextPane txtpnInputcomment;

    public ReportPanel(final WindowGUI parent, final Report report) {
        this.report = report;
        this.file = new File("report-" + new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime()) + ".txt");
        this.setLayout(new BoxLayout(this, 1));
        JScrollPane scrollPaneContent = new JScrollPane();
        this.add(scrollPaneContent);
        JPanel panel_2 = new JPanel();
        scrollPaneContent.setViewportView(panel_2);
        panel_2.setLayout(new BoxLayout(panel_2, 1));
        JPanel panelPanelGeneral = new JPanel();
        panelPanelGeneral.setAlignmentX(0.0f);
        panelPanelGeneral.setMaximumSize(new Dimension(Short.MAX_VALUE, 175));
        panel_2.add(panelPanelGeneral);
        panelPanelGeneral.setLayout(new BoxLayout(panelPanelGeneral, 1));
        JPanel panelGeneral = new JPanel();
        panelGeneral.setPreferredSize(new Dimension(10, 150));
        panelPanelGeneral.add(panelGeneral);
        panelGeneral.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229), 1, true), "General", 4, 2, null, new Color(51, 51, 51)));
        panelGeneral.setAlignmentX(0.0f);
        panelGeneral.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblTitle = new JLabel("Title:");
        panelGeneral.add((Component)lblTitle, "2, 2");
        this.lblTitleValue = new JLabel(this.report.title());
        panelGeneral.add((Component)this.lblTitleValue, "4, 2");
        JLabel lblOrigin = new JLabel("Origin:");
        panelGeneral.add((Component)lblOrigin, "2, 4");
        this.lblOriginValue = new JLabel(this.report.origin());
        panelGeneral.add((Component)this.lblOriginValue, "4, 4");
        JLabel lblDate = new JLabel("Date:");
        panelGeneral.add((Component)lblDate, "2, 6");
        this.lblDateValue = new JLabel(new SimpleDateFormat("dd/MM/yyyy HH':'mm").format(this.report.date().getTime()));
        panelGeneral.add((Component)this.lblDateValue, "4, 6");
        JLabel lblTarget = new JLabel("Target:");
        panelGeneral.add((Component)lblTarget, "2, 8");
        this.lblTargetValue = new JLabel(this.report.target());
        panelGeneral.add((Component)this.lblTargetValue, "4, 8");
        JLabel lblTimeSpent = new JLabel("Time spent:");
        panelGeneral.add((Component)lblTimeSpent, "2, 10");
        JLabel lblTimeSpentValue = new JLabel(Chronometer.toHumanString(this.report.timeSpent()));
        panelGeneral.add((Component)lblTimeSpentValue, "4, 10");
        Component verticalStrut = Box.createVerticalStrut(10);
        panelPanelGeneral.add(verticalStrut);
        JSeparator separator = new JSeparator();
        panelPanelGeneral.add(separator);
        Component verticalStrut_5 = Box.createVerticalStrut(10);
        panelPanelGeneral.add(verticalStrut_5);
        JPanel panelInputs = new JPanel();
        panelInputs.setAlignmentX(0.0f);
        panel_2.add(panelInputs);
        panelInputs.setBorder(new TitledBorder(null, "Inputs", 4, 2, null, null));
        panelInputs.setLayout(new BoxLayout(panelInputs, 1));
        this.txtpnInputcomment = new JTextPane();
        panelInputs.add(this.txtpnInputcomment);
        this.txtpnInputcomment.setText(this.report.inputComment());
        this.txtpnInputcomment.setToolTipText("Input comment");
        this.txtpnInputcomment.setAlignmentX(0.0f);
        Component verticalStrut_1 = Box.createVerticalStrut(10);
        panelInputs.add(verticalStrut_1);
        JScrollPane scrollPaneTableInputs = new JScrollPane();
        scrollPaneTableInputs.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        scrollPaneTableInputs.setVerticalScrollBarPolicy(21);
        scrollPaneTableInputs.setHorizontalScrollBarPolicy(31);
        panelInputs.add(scrollPaneTableInputs);
        scrollPaneTableInputs.setAlignmentX(0.0f);
        this.tableInputs = new JTable();
        this.tableInputs.setSelectionMode(2);
        scrollPaneTableInputs.setViewportView(this.tableInputs);
        this.tableInputs.setModel(new ReportItemsModel(null));
        ((ReportItemsModel)this.tableInputs.getModel()).setSource(report.inputs());
        Component verticalStrut_2 = Box.createVerticalStrut(10);
        panelInputs.add(verticalStrut_2);
        JPanel panelOutputs = new JPanel();
        panelOutputs.setAlignmentX(0.0f);
        panel_2.add(panelOutputs);
        panelOutputs.setBorder(new TitledBorder(null, "Outputs", 4, 2, null, null));
        panelOutputs.setLayout(new BoxLayout(panelOutputs, 1));
        Component verticalStrut_6 = Box.createVerticalStrut(10);
        panelOutputs.add(verticalStrut_6);
        if (report != null) {
            int outputIndex = 0;
            while (outputIndex < report.outputs().getCount()) {
                Object output = report.outputs().get(outputIndex);
                if (output != null) {
                    JTable tableOutputs;
                    if (output instanceof ReportAttributes) {
                        JScrollPane scrollPaneTableOutputs = new JScrollPane();
                        scrollPaneTableOutputs.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
                        scrollPaneTableOutputs.setHorizontalScrollBarPolicy(31);
                        panelOutputs.add(scrollPaneTableOutputs);
                        scrollPaneTableOutputs.setAlignmentX(0.0f);
                        tableOutputs = new JTable();
                        tableOutputs.setSelectionMode(2);
                        scrollPaneTableOutputs.setViewportView(tableOutputs);
                        tableOutputs.setModel(new ReportItemsModel((ReportAttributes)output));
                    } else if (output instanceof ReportChart) {
                        int screenWidth = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth();
                        int screenHeight = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getHeight();
                        JPanel chartPanel = ReportChartMaker.createSimplePanel((ReportChart)output, screenWidth / 5, screenHeight / 5);
                        chartPanel.setAlignmentX(0.0f);
                        if (outputIndex != 0 && report.outputs().get(outputIndex - 1) instanceof ReportChart) {
                            JPanel chartsPanel = (JPanel)panelOutputs.getComponent(panelOutputs.getComponentCount() - 1);
                            chartsPanel.add(chartPanel);
                        } else if (outputIndex + 1 < report.outputs().getCount() && report.outputs().get(outputIndex + 1) instanceof ReportChart) {
                            JPanel graphsPanel = new JPanel();
                            graphsPanel.setLayout(new BoxLayout(graphsPanel, 0));
                            graphsPanel.setAlignmentX(0.0f);
                            graphsPanel.add(chartPanel);
                            panelOutputs.add(graphsPanel);
                        } else {
                            panelOutputs.add(chartPanel);
                        }
                    } else if (output instanceof ReportTable) {
                        ReportTable table = (ReportTable)output;
                        tableOutputs = new JTable(new ReportTableModel(table));
                        tableOutputs.setSelectionMode(2);
                        panelOutputs.add(tableOutputs);
                        tableOutputs.setAlignmentX(0.0f);
                        Dimension size = tableOutputs.getMaximumSize();
                        tableOutputs.setMaximumSize(new Dimension(tableOutputs.getColumnCount() * 150, (int)size.getHeight()));
                    } else if (output instanceof ReportRawData) {
                        ReportRawData rawData = (ReportRawData)output;
                        SaveReportRawDataButton btnSaveRawData = new SaveReportRawDataButton(parent.getJFrame(), rawData);
                        panelOutputs.add(btnSaveRawData);
                    } else if (!(output instanceof Report)) {
                        JTextPane txtpnOutputcomment = new JTextPane();
                        panelOutputs.add(txtpnOutputcomment);
                        txtpnOutputcomment.setText(output.toString());
                        txtpnOutputcomment.setAlignmentX(0.0f);
                        txtpnOutputcomment.setEditable(false);
                    }
                }
                ++outputIndex;
            }
        }
        Component verticalStrut_3 = Box.createVerticalStrut(10);
        panelOutputs.add(verticalStrut_3);
        Component verticalGlue = Box.createVerticalGlue();
        panelOutputs.add(verticalGlue);
        Component verticalStrut_4 = Box.createVerticalStrut(5);
        this.add(verticalStrut_4);
        JPanel panel = new JPanel();
        this.add(panel);
        panel.setLayout(new BoxLayout(panel, 0));
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                parent.closeCurrentTab();
            }
        });
        panel.add(btnClose);
        Component horizontalGlue = Box.createHorizontalGlue();
        panel.add(horizontalGlue);
        JButton btnSaveButton = new JButton("Save");
        btnSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File targetFile = new File("report-" + report.target() + "-" + new SimpleDateFormat("yyyyMMddhhmmss").format(Calendar.getInstance().getTime()) + ".txt");
                    boolean ended = false;
                    while (!ended) {
                        boolean doSave;
                        JFileChooser chooser = new JFileChooser();
                        chooser.setSelectedFile(targetFile);
                        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
                        chooser.setFileSelectionMode(0);
                        chooser.setAcceptAllFileFilterUsed(false);
                        GenericFileFilter defaultFileFilter = new GenericFileFilter("Report Formats (*.txt, *.xls)", "txt", "xls");
                        chooser.addChoosableFileFilter(defaultFileFilter);
                        chooser.addChoosableFileFilter(new GenericFileFilter("Text (*.txt)", "txt"));
                        chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
                        chooser.setFileFilter(defaultFileFilter);
                        if (chooser.showSaveDialog(parent.getJFrame()) == 0) {
                            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
                            targetFile = chooser.getSelectedFile();
                        } else {
                            System.out.println("No Selection ");
                            ended = true;
                        }
                        if (ended) continue;
                        if (targetFile.exists()) {
                            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                            int response = JOptionPane.showConfirmDialog(parent.getJFrame(), message, title, 1);
                            if (response == 0) {
                                doSave = true;
                                ended = true;
                            } else if (response == 1) {
                                doSave = false;
                                ended = false;
                            } else {
                                doSave = false;
                                ended = true;
                            }
                        } else {
                            doSave = true;
                            ended = true;
                        }
                        if (!doSave) continue;
                        PuckManager.saveReport(targetFile, report);
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(parent.getJFrame(), message, title, 0);
                }
            }
        });
        panel.add(btnSaveButton);
        if (!this.report.hasInput()) {
            panelInputs.setVisible(false);
        } else {
            if (StringUtils.isBlank((CharSequence)this.report.inputComment())) {
                this.txtpnInputcomment.setVisible(false);
            }
            if (this.report.inputs().size() == 0) {
                scrollPaneTableInputs.setVisible(false);
            }
        }
        scrollPaneContent.getVerticalScrollBar().setValue(1);
        scrollPaneContent.getVerticalScrollBar().setUnitIncrement(20);
        scrollPaneContent.getHorizontalScrollBar().setUnitIncrement(20);
    }
}

