/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionReporter;
import org.tip.puck.report.Report;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.FooReporterInputWindow;
import org.tip.puckgui.views.PartitionCriteriaShortPanel;

public class PartitionStatisticsInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(PartitionStatisticsInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private PartitionCriteriaShortPanel partitionCriteriaShortPanel_1;
    private PartitionCriteriaShortPanel partitionCriteriaShortPanel_2;
    private PartitionCriteriaShortPanel partitionCriteriaShortPanel_3;
    private PartitionCriteriaShortPanel partitionCriteriaShortPanel_4;
    private PartitionCriteriaShortPanel partitionCriteriaShortPanel_5;
    private PartitionCriteriaShortPanel partitionCriteriaShortPanel_6;
    private PartitionCriteriaShortPanel partitionCriteriaShortPanel_7;
    private PartitionCriteriaShortPanel splitCriteriaShortPanel;
    private static StatisticsCriteria defaultCriteria;

    public PartitionStatisticsInputWindow(final NetGUI netGUI) {
        if (defaultCriteria == null) {
            defaultCriteria = new StatisticsCriteria();
        }
        List<String> availableLabels = IndividualValuator.getAttributeLabelSample(netGUI.getNet().individuals());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("Statistics Inputs");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 980, 605);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        this.contentPane.add((Component)panel_1, "North");
        panel_1.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "General", 4, 2, null, new Color(51, 51, 51)));
        panel_1.setLayout(new BoxLayout(panel_1, 0));
        JPanel panel = new JPanel();
        panel_1.add(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel panel_2 = new JPanel();
        panel_1.add(panel_2);
        panel_2.setLayout(new BoxLayout(panel_2, 1));
        JPanel panel_3 = new JPanel();
        panel_1.add(panel_3);
        panel_3.setLayout(new BoxLayout(panel_3, 1));
        Component verticalGlue = Box.createVerticalGlue();
        panel_3.add(verticalGlue);
        JPanel panel_6 = new JPanel();
        panel_1.add(panel_6);
        panel_6.setLayout(new BoxLayout(panel_6, 1));
        JPanel panel_4 = new JPanel();
        panel_4.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Partition Diagrams Criteria", 4, 2, null, new Color(51, 51, 51)));
        this.contentPane.add((Component)panel_4, "Center");
        panel_4.setLayout(new BoxLayout(panel_4, 1));
        JPanel panel_5 = new JPanel();
        panel_5.setAlignmentX(0.0f);
        panel_4.add(panel_5);
        panel_5.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"center:default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"center:default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"center:default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"center:170dlu:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"center:35dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"center:25dlu"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblLabel = new JLabel("Label");
        panel_5.add((Component)lblLabel, "2, 2");
        JLabel lblParameter = new JLabel("Parameter");
        panel_5.add((Component)lblParameter, "4, 2");
        JLabel lblType = new JLabel("Type");
        panel_5.add((Component)lblType, "6, 2");
        JLabel lblSpecificData = new JLabel("Specific Data");
        panel_5.add((Component)lblSpecificData, "8, 2");
        JLabel lblCumul = new JLabel("Cumulation");
        panel_5.add((Component)lblCumul, "10, 2");
        JLabel lblFilter = new JLabel("Filter Value");
        panel_5.add((Component)lblFilter, "12, 2");
        JLabel lblSizeFilter = new JLabel("Filter Size");
        panel_5.add((Component)lblSizeFilter, "14, 2");
        JLabel lblClear = new JLabel("Clear");
        panel_5.add((Component)lblClear, "16, 2");
        this.partitionCriteriaShortPanel_1 = new PartitionCriteriaShortPanel(availableLabels, this.getPartitionCriteria(defaultCriteria, 0));
        this.partitionCriteriaShortPanel_1.setAlignmentX(0.0f);
        panel_4.add(this.partitionCriteriaShortPanel_1);
        this.partitionCriteriaShortPanel_2 = new PartitionCriteriaShortPanel(availableLabels, this.getPartitionCriteria(defaultCriteria, 1));
        this.partitionCriteriaShortPanel_2.setAlignmentX(0.0f);
        panel_4.add(this.partitionCriteriaShortPanel_2);
        this.partitionCriteriaShortPanel_3 = new PartitionCriteriaShortPanel(availableLabels, this.getPartitionCriteria(defaultCriteria, 2));
        this.partitionCriteriaShortPanel_3.setAlignmentX(0.0f);
        panel_4.add(this.partitionCriteriaShortPanel_3);
        this.partitionCriteriaShortPanel_4 = new PartitionCriteriaShortPanel(availableLabels, this.getPartitionCriteria(defaultCriteria, 3));
        this.partitionCriteriaShortPanel_4.setAlignmentX(0.0f);
        panel_4.add(this.partitionCriteriaShortPanel_4);
        this.partitionCriteriaShortPanel_5 = new PartitionCriteriaShortPanel(availableLabels, this.getPartitionCriteria(defaultCriteria, 4));
        this.partitionCriteriaShortPanel_5.setAlignmentX(0.0f);
        panel_4.add(this.partitionCriteriaShortPanel_5);
        this.partitionCriteriaShortPanel_6 = new PartitionCriteriaShortPanel(availableLabels, this.getPartitionCriteria(defaultCriteria, 5));
        this.partitionCriteriaShortPanel_6.setAlignmentX(0.0f);
        panel_4.add(this.partitionCriteriaShortPanel_6);
        this.partitionCriteriaShortPanel_7 = new PartitionCriteriaShortPanel(availableLabels, this.getPartitionCriteria(defaultCriteria, 6));
        this.partitionCriteriaShortPanel_7.setAlignmentX(0.0f);
        panel_4.add(this.partitionCriteriaShortPanel_7);
        JPanel panel_7 = new JPanel();
        panel_7.setBorder(new TitledBorder(null, "Split Partition Criteria", 4, 2, null, null));
        panel_4.add(panel_7);
        panel_7.setLayout(new BoxLayout(panel_7, 1));
        this.splitCriteriaShortPanel = new PartitionCriteriaShortPanel(availableLabels, this.getSplitCriteria(defaultCriteria));
        panel_7.add(this.splitCriteriaShortPanel);
        this.splitCriteriaShortPanel.setAlignmentX(0.0f);
        this.splitCriteriaShortPanel.setBorder(null);
        Component verticalGlue_1 = Box.createVerticalGlue();
        panel_4.add(verticalGlue_1);
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionStatisticsInputWindow.this.dispose();
            }
        });
        JButton buttonClear = new JButton("Clear");
        buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionStatisticsInputWindow.this.clear();
            }
        });
        buttonPanel.add(buttonClear);
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StatisticsCriteria criteria = PartitionStatisticsInputWindow.this.getCriteria();
                    defaultCriteria = criteria;
                    Report report = PartitionReporter.reportPartitionStatistics(netGUI.getSegmentation(), criteria);
                    netGUI.addReportTab(report);
                    PartitionStatisticsInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(PartitionStatisticsInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
    }

    public void clear() {
        this.partitionCriteriaShortPanel_1.clear();
        this.partitionCriteriaShortPanel_2.clear();
        this.partitionCriteriaShortPanel_3.clear();
        this.partitionCriteriaShortPanel_4.clear();
        this.partitionCriteriaShortPanel_5.clear();
        this.partitionCriteriaShortPanel_6.clear();
        this.partitionCriteriaShortPanel_7.clear();
        this.splitCriteriaShortPanel.clear();
    }

    public StatisticsCriteria getCriteria() {
        StatisticsCriteria result = new StatisticsCriteria();
        result.getPartitionCriterias().clear();
        result.getPartitionCriterias().add(this.partitionCriteriaShortPanel_1.getCriteria());
        result.getPartitionCriterias().add(this.partitionCriteriaShortPanel_2.getCriteria());
        result.getPartitionCriterias().add(this.partitionCriteriaShortPanel_3.getCriteria());
        result.getPartitionCriterias().add(this.partitionCriteriaShortPanel_4.getCriteria());
        result.getPartitionCriterias().add(this.partitionCriteriaShortPanel_5.getCriteria());
        result.getPartitionCriterias().add(this.partitionCriteriaShortPanel_6.getCriteria());
        result.getPartitionCriterias().add(this.partitionCriteriaShortPanel_7.getCriteria());
        result.setSplitCriteria(this.splitCriteriaShortPanel.getCriteria());
        return result;
    }

    private PartitionCriteria getPartitionCriteria(StatisticsCriteria source, int index) {
        PartitionCriteria result = source == null || index >= source.getPartitionCriterias().size() ? null : source.getPartitionCriterias().get(index);
        return result;
    }

    private PartitionCriteria getSplitCriteria(StatisticsCriteria source) {
        PartitionCriteria result = source == null ? null : source.getSplitCriteria();
        return result;
    }
}

